PEP: 8014 Title: The Commons Governance Model Author: Jack Jansen
Status: Rejected Type: Informational Content-Type: text/x-rst Created:
2018-09-16

Abstract
========

This PEP proposes a governance model with as few procedures, defined
terms and percentages as possible. It may also be called *The Anarchist
Governance Model* but uses *Commons* for now because of possible
negative connotations of the term *Anarchist* to some audiences.

The basic idea is that all decisions are in principle voted on by the
whole community, but in practice voted on by a only subset of the
community. A subset, because although the whole community is entitled to
vote in practice it will always be only a small subset that vote on a
specific decision. The vote is overseen by an impartial council that
judges whether the decision has passed or not. The intention is that
this council bases its decision not only on the ratio of yes and no
votes but also on the total number of votes, on the gravity of the
proposal being voted on and possibly the individual voters and how they
voted. Thereby this council becomes responsible for ensuring that each
individual decision is carried by a sufficient majority.

PEP Rejection
=============

PEP 8014 was rejected [by a core developer
vote](https://discuss.python.org/t/python-governance-vote-december-2018-results/546/)
described in PEP 8001 on Monday, December 17, 2018.

PEP 8016 and the governance model it describes were chosen instead.

Introduction
============

The Commons Governance Model tries to ensure that all decisions are
endorsed by, or at least is acceptable to, a sufficient majority of the
Python community.

Unfortunately the previous paragraph has two terms that are very hard to
quantify in the general case: *sufficient majority* and *Python
community*. This is because both terms in reality depend on the
*specific* case that is being decided. To give an example of this
difficulty: for a PEP that proposes a backward-compatible change to some
API a simple majority of the core developers that were interested in
voting on the PEP in the first place is probably sufficient. But for a
change that has more farreaching consequences such as a Python3 to
Python4 transition a real majority may be wanted, and a demonstration
that at least there seems to be sufficient support in the user base. And
for a change that transcends the Python-the-language, such as decisions
on abolishing non-inclusive language, it becomes very vague.

The Commons Governance Model attempts to sidestep this issue by *not*
defining what the terms *sufficient majority* and *Python community*
mean in the general case, by proposing a body that will decide so in
*specific* cases.

The model proposes creating a *Council of Elders* that oversees the
decision process, determining whether a specific proposal has enough
support on a case by case basis. There will be a vote on every
individual PEP, and the Council of Elders will declare whether the
outcome of the vote is sufficient to carry the decision *in this
specific case*.

The model addresses only the roles traditionally held by the BDFL in the
decision process, not other roles.

The term [Commons](https://en.wikipedia.org/wiki/Commons) in the model
name is loosely based on its historic use as a shared resource to be
used by all and cared for by all. The picture you should have in mind
with this model is a sizeable group of peasants discussing some plan for
the future on the village green on a warm summer evening, after which
the vote is taken and the village elders pronounce the outcome. Then the
banquet begins.

The Commons Governance Model is different from most of the other
governance proposals (with the possible exception of 8012), because it
explicitly places supreme power with the whole community.

Rationale
=========

The rationale for the model is that a model that casts everything in
concrete will have unintended negative side effects. For example, a
governance model that assigns voting rights to Python committers may
cause an individual not to be accepted as a committer because there are
already a lot of committers from the company the new candidate works
for.

As another example, setting a fixed percentage for PEP acceptance may
lead to party-formation amongst the voters and individual PEPs no longer
be being judged on individual merit but along party lines (if you
support my PEP I will support yours).

There is also the issue that one-person-one-vote is not the best model
for something like Python. Again an example: in case of a split vote (or
a vote sufficiently close to being split) the opinion of core developer
Guido van Rossum should probably outweigh the opinion of core developer
Jack Jansen. Trying to formalize this in a voting model is going to lead
to a very complex model, that is going to be wrong on boundary cases
anyway. The model presented here leaves deciding on such issues to the
(hopefully sensible) council of elders.

Decision Process
================

All important decisions go through a PEP process. Each PEP has someone
responsible for it, called the *author* here, but that does not have to
be a single person, and it does not have to be the person that actually
wrote the text. So for author you could also read *champion* or
*shepherd* or something like that.

The PEP author is responsible for organizing a vote on the PEP. This
vote is public, i.e. the voters are identified and the results are known
to all. Voting may be simple +1/0/-1, but might also be extended with
+2/-2 with a very terse explanation why the voter feels very strong
about the issue. Such an annotation would serve as an explanation to the
Council of Elders. Voters are annotated with their community status
(core developer, etc).

The vote is clearly separated from the discussion, by using a
well-defined Discourse category or tag, a special mailing list or a
similar technical method (such as a website vote.python.org where people
have to log in so their community status can be automatically added, and
their identity can be somewhat confirmed).

The PEP author presents the PEP and the vote results to the Council of
Elders. The council ponders two things:

-   the PEP gravity and its implications,
-   the measureable vote results (how many people voted, which
    individuals voted, what they voted).

They pronounce a tentative decision on whether the vote passed and this
decision is published.

If the decision is that the vote results do not demonstrate enough
support from the community for the decision the burden is on the author
to try and gather more support and resubmit the vote at a later date.
Alternatively the author can retract the proposal. The period for
gathering more support is time-limited, a month seems a reasonable time,
if no vote has been resubmitted after that period the proposal is
rejected.

If the tentative decision is that the results *do* demonstrate enough
support a fairly short waiting period starts (in the order of weeks).
During this period anyone can appeal to the Council of Elders, but
*only* on the grounds that the vote does not reflect a sufficient
majority of the community. After the waiting period the council
pronounces a final decision. The PEP is either accepted or, if the
council is swayed by an appeal, goes back to the state where more
support has to be demonstrated.

Council of Elders
=================

The intention of the Council of Elders is that they, together, are
capable of judging whether the will of the Python community is upheld in
a specific vote.

The Council of Elders is *not* a replacement of the BDFL by a group of
people with the same power as the BDFL: it will not provide guidance on
the direction of Python, it only attempts to ensure the outcome of a
vote represents the will of the community.

The Council of Elders is *not* like the US Supreme Court, which has
actual decision power, the council only oversees the voting process to
ensure that the community is represented in the vote. And the Council of
Elders is most definitely not like the Spanish Inquisition, because
fear, surprise and ruthless efficiency are things we can do without (but
there is some merit in using the cute scarlet regalia).

The council is somewhat like the dutch [Hoge
Raad](https://en.wikipedia.org/wiki/Supreme_Court_of_the_Netherlands)
(which is unfortunately often translated as Supreme Court in English) in
that they judge the process and the procedures followed and can only
send cases back for a renewed judgement.

It is also somewhat like the *election commission* that many countries
have (under different names) in that it oversees elections.

Council operation
-----------------

The council members are volunteers, and most likely have other roles
within the Python community as well (not to mention a life outside
Python). This means that the workload on the members should be kept to a
minimum. It also means that it should be clear when an individual
council members speak as council member and when they speak as
themselves. And we should care about the emotional load: council members
should not be held accountable for decisions by random flamers on the
Python mailing list.

The proposal attempts to minimize the workload through two methods:

-   Most of the actual work is to be done by the PEP author and the
    community, the Council of Elders does not organize the vote and
    tally the results.
-   The idea behind the first tentative decision is mistakes by the
    Council of elders (misjudging how far-reaching a PEP is, most
    likely) are not fatal, because the community has a chance to point
    out these mistakes.

    Practically speaking this means that the tentative decision can be
    taken by a subset of the council, depending on the community to
    correct them. Getting seven hard-working professionals together
    every two weeks, even by email, may be a bit much to ask.

Clarifying when an individual Elder speaks on behalf of the Council is
probably best done by using a special email address, or some Discourse
topic into which only Elders can post. There is an analogy here with the
Pope speaking [Ex
Cathedra](https://en.wikipedia.org/wiki/Papal_infallibility) or just as
himself (in which case he is not infallible). The elders are most likely
respected members of the community and it would be a bad idea if they
feel they cannot voice their personal opinion on a PEP because they are
on the council.

Discussion of community members *with* the Council of Elders, i.e. when
appealing a decision, should be done in a different forum (Discourse
topic, mailing list).

The decisions of the Council of Elders should be seen as decisions of
the council as a whole, not as decisions of the individual members. In a
first implementation Elders should post under their own name (with the
fact that they speak as a council member conferred by the topic they
post to, or possibly a special badge). If it turns out that Elders
become individual targets for ad-hominem attacks we should revisit this
and come up with some method of anonymity.

Limitation of freedom
---------------------

If a specific vote has a true majority (for or against) of core team
members (more than 50% + 1 of all core team members) that outcome
passes. If a specific vote has a true majority (for or against) of PSF
voting members (more than 50% + 1) that outcome passes. And, for
completeness, if both of the previous statements are true but with
opposite outcomes the core team members win.

The main reason for having this limitation is that it allows decisions
to be made (albeit with effort) if there is no functioning Council of
Elders at any particular moment.

Council composition
-------------------

The council should not be too big nor too small, probably somewhere
between 5 and 10 members. There is no reason to fix this number. The
members should be knowledgeable about Python and the Python community,
and willing to be impartial *while operating as part of the council*.
Council members may be core developers but this is not a requirement.

Everyone in the community should feel represented by the council so it
would be good if the council is diverse:

-   scientists and technologists,
-   progressives and conservatives (with respect to the Python
    language),
-   people with different cultural backgrounds, genders, age,
-   etc

But: this should hold for the council as a whole. Individual council
members should not be seen as representing a specific interest group.

Council membership
------------------

Because the powers of the council are purely procedural it is probably
good if members serve for a fairly long time. However, it would still be
good if the council was reinstated regularly. Therefore the suggestion
is to have the council operate under the PSF umbrella and be subject of
a yearly vote of confidence. This vote is for the council as a whole:
people who vote against the council should be aware that they are
basically saying \"Python is better off without a Council of Elders than
with you lot\".

The council normally co-opts new Elders, probably because an individual
is seen to have knowledge about a specific part of the Python community
(or language) in which the council is lacking. Everyone is free to
suggest new Elders to the council (including themselves) but the council
is free to ignore the suggestion. Council members should be free to
retire at any time. An individual council member can be retired by a
unanimous vote by the rest of the council.

There is an emergency brake procedure to get rid of a non-functioning
council. A single Elder or a group of 10 core developers or PSF voting
members can ask for an immediate reinstating vote of the council as a
whole (presumably with the intention that the council lose their
mandate). If this vote has been requested by an Elder that individual
immediately lose their council position, independent of the outcome of
the vote. If the vote has been requested by community members and the
council is reinstated this procedure cannot be invoked again for a year.

If there is no functioning council (the current initial situation, or
after the council have lost their mandate after a vote of no confidence)
an initial council must be selected. Through the normal communication
channels (discourse, mailing lists) members can be suggested by anyone
(including themselves). After discussion amongst the nominees and in the
whole community a group of at least three individuals should emerge that
ask for an initial vote to instate them as Council of Elders. The
intention of this procedure is that by the time such a group of
individuals emerges and asks for a vote of confidence they expect an
overwhelming mandate.

Discussion
==========

This PEP does not handle other roles of the BDFL, only the voting
process. Most importantly, the direction of Python in the long term is
not expected to be handled by the Council of Elders. This falls to the
community as a whole (or to individual members of the community, most
likely).

There is also the role of figurehead or spokesperson to represent Python
and the Python community to the outside world. Again, this is *not* a
role that should be handled by the Council of Elders, in my opinion, but
by some other person or body.

Note that this proposal most likely favors conservatism over
progression. Or, at least, the danger of it leading to stagnation is
bigger than the danger of it leading to reckless blazing ahead into
unknown territories. So: we should realise that it is unlikely that a
PEP like PEP 572 will pass if this model is in place.

Copyright
=========

This document has been placed in the public domain.

### 

> Local Variables: mode: indented-text indent-tabs-mode: nil
> sentence-end-double-space: t fill-column: 70 coding: utf-8 End:
