import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [route53-recovery-readiness](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53recoveryreadiness.html).
 *
 * @experimental
 */
export declare class Route53RecoveryReadiness extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [route53-recovery-readiness](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53recoveryreadiness.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to Create a new Cell.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/cells.html
     *
     * @experimental
     */
    toCreateCell(): this;
    /**
     * (experimental) Grants permission to Create a new Cross Account Authorization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/crossaccountauthorizations.html
     *
     * @experimental
     */
    toCreateCrossAccountAuthorization(): this;
    /**
     * (experimental) Grants permission to Create a new Readiness Check.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/readinesschecks.html
     *
     * @experimental
     */
    toCreateReadinessCheck(): this;
    /**
     * (experimental) Grants permission to Create a Recovery Group.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/recoverygroups.html
     *
     * @experimental
     */
    toCreateRecoveryGroup(): this;
    /**
     * (experimental) Grants permission to Create a new Resource Set.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/resourcesets.html
     *
     * @experimental
     */
    toCreateResourceSet(): this;
    /**
     * (experimental) Grants permission to Delete an existing Cell.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/cells-cellname.html
     *
     * @experimental
     */
    toDeleteCell(): this;
    /**
     * (experimental) Grants permission to Delete a Cross Account Authorization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/crossaccountauthorizations-crossaccountauthorization.html
     *
     * @experimental
     */
    toDeleteCrossAccountAuthorization(): this;
    /**
     * (experimental) Grants permission to Delete an existing Readiness Check.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/readinesschecks-readinesscheckname.html
     *
     * @experimental
     */
    toDeleteReadinessCheck(): this;
    /**
     * (experimental) Grants permission to Delete an existing Recovery Group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/recoverygroups-recoverygroupname.html
     *
     * @experimental
     */
    toDeleteRecoveryGroup(): this;
    /**
     * (experimental) Grants permission to Delete an existing Readiness Check.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/resourcesets-resourcesetname.html
     *
     * @experimental
     */
    toDeleteResourceSet(): this;
    /**
     * (experimental) Grants permission to Get Architecture Recommendations for a Recovery Group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/recoverygroups-recoverygroupname-architecturerecommendations.html
     *
     * @experimental
     */
    toGetArchitectureRecommendations(): this;
    /**
     * (experimental) Grants permission to Get an existing Cell.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/cells-cellname.html
     *
     * @experimental
     */
    toGetCell(): this;
    /**
     * (experimental) Grants permission to Get Readiness Summary for Cell.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/cellreadiness-cellname.html
     *
     * @experimental
     */
    toGetCellReadinessSummary(): this;
    /**
     * (experimental) Grants permission to Get a Readiness Check.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/readinesschecks-readinesscheckname.html
     *
     * @experimental
     */
    toGetReadinessCheck(): this;
    /**
     * (experimental) Grants permission to Get the Readiness Summary for a Resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/readinesschecks-readinesscheckname-resource-resourceidentifier-status.html
     *
     * @experimental
     */
    toGetReadinessCheckResourceStatus(): this;
    /**
     * (experimental) Grants permission to Get the status of a Readiness Check.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/readinesschecks-readinesscheckname-status.html
     *
     * @experimental
     */
    toGetReadinessCheckStatus(): this;
    /**
     * (experimental) Grants permission to Get a Recovery Group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/recoverygroups-recoverygroupname.html
     *
     * @experimental
     */
    toGetRecoveryGroup(): this;
    /**
     * (experimental) Grants permission to Get the Readiness Summary of a Recovery Group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/recoverygroupreadiness-recoverygroupname.html
     *
     * @experimental
     */
    toGetRecoveryGroupReadinessSummary(): this;
    /**
     * (experimental) Grants permission to Get a Resource Set.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/resourcesets-resourcesetname.html
     *
     * @experimental
     */
    toGetResourceSet(): this;
    /**
     * (experimental) Grants permission to List existing Cells.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/cells.html
     *
     * @experimental
     */
    toListCells(): this;
    /**
     * (experimental) Grants permission to List existing Cross Account Authorizations.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/readinesschecks.html
     *
     * @experimental
     */
    toListCrossAccountAuthorizations(): this;
    /**
     * (experimental) Grants permission to List existing Readiness Checks.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/readinesschecks.html
     *
     * @experimental
     */
    toListReadinessChecks(): this;
    /**
     * (experimental) Grants permission to List existing Recovery Groups.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/recoverygroups.html
     *
     * @experimental
     */
    toListRecoveryGroups(): this;
    /**
     * (experimental) Grants permission to List existing Resource Sets.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/resourcesets.html
     *
     * @experimental
     */
    toListResourceSets(): this;
    /**
     * (experimental) Grants permission to List Readiness Rules.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/rules.html
     *
     * @experimental
     */
    toListRules(): this;
    /**
     * (experimental) Grants permission to List Tags for a Resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/tags-resource-arn.html
     *
     * @experimental
     */
    toListTagsForResources(): this;
    /**
     * (experimental) Grants permission to Add a Tag to a Resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/tags-resource-arn.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to Remove a Tag from a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/tags-resource-arn.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to Update an existing Cell.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/cells-cellname.html
     *
     * @experimental
     */
    toUpdateCell(): this;
    /**
     * (experimental) Grants permission to Update an existing Readiness Check.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/readinesschecks-readinesscheckname.html
     *
     * @experimental
     */
    toUpdateReadinessCheck(): this;
    /**
     * (experimental) Grants permission to Update an existing Recovery Group.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/recoverygroups-recoverygroupname.html
     *
     * @experimental
     */
    toUpdateRecoveryGroup(): this;
    /**
     * (experimental) Grants permission to Update an existing Resource Set.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/recovery-readiness/latest/api/resourcesets-resourcesetname.html
     *
     * @experimental
     */
    toUpdateResourceSet(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type readinesscheck to the statement.
     *
     * https://docs.aws.amazon.com/r53recovery/latest/dg/recovery-readiness.readiness-checks.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onReadinesscheck(resourceId: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type resourceset to the statement.
     *
     * https://docs.aws.amazon.com/r53recovery/latest/dg/recovery-readiness.readiness-checks.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onResourceset(resourceId: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type cell to the statement.
     *
     * https://docs.aws.amazon.com/r53recovery/latest/dg/recovery-readiness.recovery-groups.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onCell(resourceId: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type recoverygroup to the statement.
     *
     * https://docs.aws.amazon.com/r53recovery/latest/dg/recovery-readiness.recovery-groups.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onRecoverygroup(resourceId: string, account?: string, partition?: string): this;
}
