# AMICO

Implementation of the linear framework for Accelerated Microstructure Imaging via Convex Optimization (AMICO) described here:

> **Accelerated Microstructure Imaging via Convex Optimization (AMICO) from diffusion MRI data**  
> *Alessandro Daducci, Erick Canales-Rodriguez, Hui Zhang, Tim Dyrby, Daniel Alexander, Jean-Philippe Thiran*  
> NeuroImage 105, pp. 32-44 (2015)

## Code implementation

AMICO is written in **python** and **does not require** the [NODDI MATLAB toolbox](http://mig.cs.ucl.ac.uk/index.php?n=Download.NODDI) to be present on your system; all the necessary MATLAB functions for generating the response functions of the NODDI model have in fact been ported to Python.

# Documentation

The documentation, including the [installation guide](https://github.com/daducci/AMICO/wiki/Installation) as well as a series of demos/tutorials to show how to use AMICO to fit different models to the data, can be found in the [wiki pages](https://github.com/daducci/AMICO/wiki/Home).

For questions, requesting assistance, suggesting enhancements or new ideas as well as for reporting bugs, please open an [issue](https://github.com/daducci/AMICO/issues).