"""Add authenticated_at column to AuthorizationCode and RefreshToken

Revision ID: 0e7f8edd4e21
Revises: d3cb52370070
Create Date: 2022-03-26 13:46:48.102981

"""
import sqlalchemy as sa
from alembic import op

import fief

# revision identifiers, used by Alembic.
revision = "0e7f8edd4e21"
down_revision = "d3cb52370070"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "fief_authorization_codes",
        sa.Column("authenticated_at", sa.TIMESTAMP(timezone=True), nullable=False),
    )
    op.add_column(
        "fief_refresh_tokens",
        sa.Column("authenticated_at", sa.TIMESTAMP(timezone=True), nullable=False),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("fief_refresh_tokens", "authenticated_at")
    op.drop_column("fief_authorization_codes", "authenticated_at")
    # ### end Alembic commands ###
