[Glean](README.md)

- [Using the Glean SDK](user/index.md)
    - [Adding Glean to your project](user/adding-glean-to-your-project.md)
    - [The General API](user/general-api.md)
    - [Adding new metrics](user/adding-new-metrics.md)
    - [Metric parameters](user/metric-parameters.md)
    - [Testing metrics](user/testing-metrics.md)
    - [Debugging products using Glean](user/debugging/index.md)
        - [Glean Debug Ping View](user/debugging/debug-ping-view.md)
        - [Android](user/debugging/android.md)
        - [iOS](user/debugging/ios.md)
        - [Python](user/debugging/python.md)
    - [Error reporting](user/error-reporting.md)
    - [Using the experiments API](user/experiments-api.md)
- [Metric types](user/metrics/index.md)
    - [Boolean](user/metrics/boolean.md)
    - [Labeled Booleans](user/metrics/labeled_booleans.md)
    - [Counter](user/metrics/counter.md)
    - [Labeled Counters](user/metrics/labeled_counters.md)
    - [JWE](user/metrics/jwe.md)
    - [String](user/metrics/string.md)
    - [Labeled Strings](user/metrics/labeled_strings.md)
    - [String List](user/metrics/string_list.md)
    - [Timespan](user/metrics/timespan.md)
    - [Timing Distribution](user/metrics/timing_distribution.md)
    - [Memory Distribution](user/metrics/memory_distribution.md)
    - [UUID](user/metrics/uuid.md)
    - [Datetime](user/metrics/datetime.md)
    - [Event](user/metrics/event.md)
    - [Custom Distribution](user/metrics/custom_distribution.md)
    - [Quantity](user/metrics/quantity.md)
- [Pings](user/pings/index.md)
    - [Ping schedules and timings overview](user/pings/ping-schedules-and-timings.md)
    - [Baseline Ping](user/pings/baseline.md)
    - [Deletion Request Ping](user/pings/deletion_request.md)
    - [Metrics Ping](user/pings/metrics.md)
    - [Events Ping](user/pings/events.md)
    - [Custom Pings](user/pings/custom.md)
    - [Testing custom pings](user/pings/testing-custom-pings.md)
- [Android-specific information](user/android/index.md)
    - [Android build configuration options](user/android/android-build-configuration-options.md)
    - [Android offline builds](user/android/android-offline-builds.md)
- [Focused Use Cases](user/focused-use-cases.md)
    - [Instrumenting Android crashes with the Glean SDK](user/instrument-android-crashes-example.md)
- [Metrics collected by the Glean SDK](user/collected-metrics/metrics.md)

# Developing the Glean SDK

- [Testing](dev/testing.md)
- [Continuous Integration](dev/ci.md)
- [Release process](dev/cut-a-new-release.md)
- [Contributing](contributing.md)
    - [Code coverage](code_coverage.md)
- [Developing documentation](dev/docs.md)
- [Upgrading glean_parser](dev/upgrading-glean-parser.md)
- [Android bindings](dev/android/index.md)
    - [Setup Build Environment](dev/android/setup-android-build-environment.md)
    - [Android SDK/NDK versions](dev/android/sdk-ndk-versions.md)
    - [Development with android-components](dev/android/development-with-android-components.md)
    - [Locally-published components in Fenix](dev/android/locally-published-components-in-fenix.md)
- [iOS bindings](dev/ios/index.md)
    - [Setup Build Environment](dev/ios/setup-ios-build-environment.md)
    - [Debugging Different Versions of Glean](dev/ios/debug-glean-on-ios.md)
- [Python bindings](dev/python/index.md)
    - [Setup Build Environment](dev/python/setting-up-python-build-environment.md)
- [Rust Component](dev/core/index.md)
    - [Documentation guidelines](dev/core/documentation-guidelines.md)
    - [Dependency Management](dev/core/dependency-management.md)
    - [Adding a new metric type](dev/core/new-metric-type.md)
        - [FFI](dev/core/new-metric-type/ffi.md)
        - [Kotlin](dev/core/new-metric-type/kotlin.md)
        - [Swift](dev/core/new-metric-type/swift.md)
        - [Python](dev/core/new-metric-type/python.md)
- [FFI Layer](dev/ffi/index.md)
    - [When/How FFI](dev/ffi/when-to-use-what-in-the-ffi.md)
- [Internal implementation details](dev/core/internal/index.md)
    - [Reserved ping names](dev/core/internal/reserved-ping-names.md).
    - [Clearing metrics when disabling/enabling Glean](dev/core/internal/clearing.md).
    - [Payload format](dev/core/internal/payload.md).
    - [Directory & file structure](dev/core/internal/directory-structure.md)
    - [Debug Pings](dev/core/internal/debug-pings.md)
    - [Upload mechanism](dev/core/internal/upload.md)
    - [Implementations](dev/core/internal/implementations.md)
- [API Documentation](api/index.md)

# Appendix

- [Glossary](appendix/glossary.md)
- [Changelog](appendix/changelog.md)
- [This Week in Glean](appendix/twig.md)
