<!-- AUTOGENERATED BY glean_parser.  DO NOT EDIT. -->

# Metrics
This document enumerates the metrics collected by this project using the [Glean SDK](https://mozilla.github.io/glean/book/index.html).
This project may depend on other projects which also collect metrics.
This means you might have to go searching through the dependency tree to get a full picture of everything collected by this project.

# Pings

 - [all-pings](#all-pings)
 - [baseline](#baseline)
 - [deletion-request](#deletion-request)
 - [metrics](#metrics)


## all-pings

These metrics are sent in every ping.

The following metrics are added to the ping:

| Name | Type | Description | Data reviews | Extras | Expiration | [Data Sensitivity](https://wiki.mozilla.org/Firefox/Data_Collection) |
| --- | --- | --- | --- | --- | --- | --- |
| glean.error.invalid_label |[labeled_counter](https://mozilla.github.io/glean/book/user/metrics/labeled_counters.html) |Counts the number of times a metric was set with an invalid label. The labels are the `category.name` identifier of the metric.  |[1](https://bugzilla.mozilla.org/show_bug.cgi?id=1499761#c5)||never |1 |
| glean.error.invalid_overflow |[labeled_counter](https://mozilla.github.io/glean/book/user/metrics/labeled_counters.html) |Counts the number of times a metric was set a value that overflowed. The labels are the `category.name` identifier of the metric.  |[1](https://bugzilla.mozilla.org/show_bug.cgi?id=1591912#c3)||never |1 |
| glean.error.invalid_state |[labeled_counter](https://mozilla.github.io/glean/book/user/metrics/labeled_counters.html) |Counts the number of times a timing metric was used incorrectly. The labels are the `category.name` identifier of the metric.  |[1](https://bugzilla.mozilla.org/show_bug.cgi?id=1499761#c5)||never |1 |
| glean.error.invalid_value |[labeled_counter](https://mozilla.github.io/glean/book/user/metrics/labeled_counters.html) |Counts the number of times a metric was set to an invalid value. The labels are the `category.name` identifier of the metric.  |[1](https://bugzilla.mozilla.org/show_bug.cgi?id=1499761#c5)||never |1 |

## baseline

This is a built-in ping that is assembled out of the box by the Glean SDK.

See the Glean SDK documentation for the [`baseline` ping](https://mozilla.github.io/glean/book/user/pings/baseline.html).

This ping is sent if empty.

This ping includes the [client id](https://mozilla.github.io/glean/book/user/pings/index.html#the-client_info-section).

**Data reviews for this ping:**

- <https://bugzilla.mozilla.org/show_bug.cgi?id=1512938#c3>
- <https://bugzilla.mozilla.org/show_bug.cgi?id=1599877#c25>

**Bugs related to this ping:**

- <https://bugzilla.mozilla.org/1512938>
- <https://bugzilla.mozilla.org/1599877>

**Reasons this ping may be sent:**

- `active`: The ping was submitted when the application became active again, which
      includes when the application starts. In earlier versions, this was called
      `foreground`.

      *Note*: this ping will not contain the `glean.baseline.duration` metric.

- `dirty_startup`: The ping was submitted at startup, because the application process was
      killed before the Glean SDK had the chance to generate this ping, before
      becoming inactive, in the last session.

      *Note*: this ping will not contain the `glean.baseline.duration` metric.

- `inactive`: The ping was submitted when becoming inactive. In earlier versions, this
      was called `background`.


The following metrics are added to the ping:

| Name | Type | Description | Data reviews | Extras | Expiration | [Data Sensitivity](https://wiki.mozilla.org/Firefox/Data_Collection) |
| --- | --- | --- | --- | --- | --- | --- |
| glean.baseline.duration |[timespan](https://mozilla.github.io/glean/book/user/metrics/timespan.html) |The duration of the last foreground session.  |[1](https://bugzilla.mozilla.org/show_bug.cgi?id=1512938#c3)||never |1, 2 |
| glean.validation.first_run_hour |[datetime](https://mozilla.github.io/glean/book/user/metrics/datetime.html) |The hour of the first run of the application.  |[1](https://bugzilla.mozilla.org/show_bug.cgi?id=1680783#c5)||never |1 |

## deletion-request

This is a built-in ping that is assembled out of the box by the Glean SDK.

See the Glean SDK documentation for the [`deletion-request` ping](https://mozilla.github.io/glean/book/user/pings/deletion-request.html).

This ping is sent if empty.

This ping includes the [client id](https://mozilla.github.io/glean/book/user/pings/index.html#the-client_info-section).

**Data reviews for this ping:**

- <https://bugzilla.mozilla.org/show_bug.cgi?id=1587095#c6>

**Bugs related to this ping:**

- <https://bugzilla.mozilla.org/1587095>

This ping contains no metrics.

## metrics

This is a built-in ping that is assembled out of the box by the Glean SDK.

See the Glean SDK documentation for the [`metrics` ping](https://mozilla.github.io/glean/book/user/pings/metrics.html).

This ping includes the [client id](https://mozilla.github.io/glean/book/user/pings/index.html#the-client_info-section).

**Data reviews for this ping:**

- <https://bugzilla.mozilla.org/show_bug.cgi?id=1512938#c3>
- <https://bugzilla.mozilla.org/show_bug.cgi?id=1557048#c13>

**Bugs related to this ping:**

- <https://bugzilla.mozilla.org/1512938>

**Reasons this ping may be sent:**

- `overdue`: The last ping wasn't submitted on the current calendar day, but it's after
      4am, so this ping submitted immediately

- `reschedule`: A ping was just submitted. This ping was rescheduled for the next calendar
      day at 4am.

- `today`: The last ping wasn't submitted on the current calendar day, but it is
      still before 4am, so schedule to send this ping on the current calendar
      day at 4am.

- `tomorrow`: The last ping was already submitted on the current calendar day, so
      schedule this ping for the next calendar day at 4am.

- `upgrade`: This ping was submitted at startup because the application was just
      upgraded.


The following metrics are added to the ping:

| Name | Type | Description | Data reviews | Extras | Expiration | [Data Sensitivity](https://wiki.mozilla.org/Firefox/Data_Collection) |
| --- | --- | --- | --- | --- | --- | --- |
| glean.database.size |[memory_distribution](https://mozilla.github.io/glean/book/user/metrics/memory_distribution.html) |The size of the database file at startup.  |[1](https://bugzilla.mozilla.org/show_bug.cgi?id=1656589#c7)||never |1 |
| glean.error.io |[counter](https://mozilla.github.io/glean/book/user/metrics/counter.html) |The number of times we encountered an IO error when writing a pending ping to disk.  |[1](https://bugzilla.mozilla.org/show_bug.cgi?id=1686233#c2)||never |1 |
| glean.error.preinit_tasks_overflow |[counter](https://mozilla.github.io/glean/book/user/metrics/counter.html) |The number of tasks queued in the pre-initialization buffer. Only sent if the buffer overflows.  |[1](https://bugzilla.mozilla.org/show_bug.cgi?id=1609482#c3)||never |1 |
| glean.upload.deleted_pings_after_quota_hit |[counter](https://mozilla.github.io/glean/book/user/metrics/counter.html) |The number of pings deleted after the quota for the size of the pending pings directory or number of files is hit. Since quota is only calculated for the pending pings directory, and deletion request ping live in a different directory, deletion request pings are never deleted.  |[1](https://bugzilla.mozilla.org/show_bug.cgi?id=1601550#c3)||never |1 |
| glean.upload.discarded_exceeding_pings_size |[memory_distribution](https://mozilla.github.io/glean/book/user/metrics/memory_distribution.html) |The size of pings that exceeded the maximum ping size allowed for upload.  |[1](https://bugzilla.mozilla.org/show_bug.cgi?id=1597761#c10)||never |1 |
| glean.upload.pending_pings |[counter](https://mozilla.github.io/glean/book/user/metrics/counter.html) |The total number of pending pings at startup. This does not include deletion-request pings.  |[1](https://bugzilla.mozilla.org/show_bug.cgi?id=1665041#c23)||never |1 |
| glean.upload.pending_pings_directory_size |[memory_distribution](https://mozilla.github.io/glean/book/user/metrics/memory_distribution.html) |The size of the pending pings directory upon initialization of Glean. This does not include the size of the deletion request pings directory.  |[1](https://bugzilla.mozilla.org/show_bug.cgi?id=1601550#c3)||never |1 |
| glean.upload.ping_upload_failure |[labeled_counter](https://mozilla.github.io/glean/book/user/metrics/labeled_counters.html) |Counts the number of ping upload failures, by type of failure. This includes failures for all ping types, though the counts appear in the next successfully sent `metrics` ping.  |[1](https://bugzilla.mozilla.org/show_bug.cgi?id=1589124#c1)|<ul><li>status_code_4xx</li><li>status_code_5xx</li><li>status_code_unknown</li><li>unrecoverable</li><li>recoverable</li></ul>|never |1 |
| glean.validation.first_run_hour |[datetime](https://mozilla.github.io/glean/book/user/metrics/datetime.html) |The hour of the first run of the application.  |[1](https://bugzilla.mozilla.org/show_bug.cgi?id=1680783#c5)||never |1 |
| glean.validation.foreground_count |[counter](https://mozilla.github.io/glean/book/user/metrics/counter.html) |On mobile, the number of times the application went to foreground.  |[1](https://bugzilla.mozilla.org/show_bug.cgi?id=1683707#c2)||never |1 |


Data categories are [defined here](https://wiki.mozilla.org/Firefox/Data_Collection).

<!-- AUTOGENERATED BY glean_parser.  DO NOT EDIT. -->

