"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnHelm = exports.toJson_CfnHelmPropsVpcConfiguration = exports.toJson_CfnHelmPropsRepositoryOptions = exports.toJson_CfnHelmProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnHelmProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnHelmProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ClusterID': obj.clusterId,
        'KubeConfig': obj.kubeConfig,
        'RoleArn': obj.roleArn,
        'Repository': obj.repository,
        'RepositoryOptions': toJson_CfnHelmPropsRepositoryOptions(obj.repositoryOptions),
        'Chart': obj.chart,
        'Namespace': obj.namespace,
        'Name': obj.name,
        'Values': obj.values,
        'ValueYaml': obj.valueYaml,
        'Version': obj.version,
        'ValueOverrideURL': obj.valueOverrideUrl,
        'Resources': obj.resources,
        'TimeOut': obj.timeOut,
        'VPCConfiguration': toJson_CfnHelmPropsVpcConfiguration(obj.vpcConfiguration),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnHelmProps = toJson_CfnHelmProps;
/**
 * Converts an object of type 'CfnHelmPropsRepositoryOptions' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnHelmPropsRepositoryOptions(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Username': obj.username,
        'Password': obj.password,
        'CAFile': obj.caFile,
        'InsecureSkipTLSVerify': obj.insecureSkipTlsVerify,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnHelmPropsRepositoryOptions = toJson_CfnHelmPropsRepositoryOptions;
/**
 * Converts an object of type 'CfnHelmPropsVpcConfiguration' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnHelmPropsVpcConfiguration(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'SecurityGroupIds': obj.securityGroupIds?.map(y => y),
        'SubnetIds': obj.subnetIds?.map(y => y),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnHelmPropsVpcConfiguration = toJson_CfnHelmPropsVpcConfiguration;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `AWSQS::Kubernetes::Helm`
 *
 * @cloudformationResource AWSQS::Kubernetes::Helm
 * @stability external
 * @link https://github.com/aws-quickstart/quickstart-helm-resource-provider.git
 */
class CfnHelm extends cdk.CfnResource {
    /**
     * Create a new `AWSQS::Kubernetes::Helm`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnHelm.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnHelmProps(props) });
        this.props = props;
        this.attrId = cdk.Token.asString(this.getAtt('ID'));
    }
}
exports.CfnHelm = CfnHelm;
_a = JSII_RTTI_SYMBOL_1;
CfnHelm[_a] = { fqn: "@cdk-cloudformation/awsqs-kubernetes-helm.CfnHelm", version: "1.16.0-alpha.5" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnHelm.CFN_RESOURCE_TYPE_NAME = "AWSQS::Kubernetes::Helm";
//# sourceMappingURL=data:application/json;base64,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