# This file is generated by Xeda
# © 2020 [Kamyar Mohajerani](mailto:kamyar@ieee.org)

# Area/Balanced/Timing
set strategy            {{settings.strategy}}

set implementation_name "{{settings.impl_name}}"
set impl_dir            "{{settings.impl_folder}}"

file delete -force ${impl_dir}
# Workaround for old TCL on NFS bug
# while {[catch {file delete -force -- ${impl_dir} }] != 0} {
#   after 2000 puts "delete failed. retrying..."
# }

prj_project new -name {{design.name}} -dev "{{settings.fpga_part}}" -impl ${implementation_name} -impl_dir ${impl_dir}

prj_impl option synthesis {{settings.synthesis_engine}}

##strategy
eval prj_strgy copy -from {{settings.strategy}} -name custom_strategy -file diamond_strategy.sty

{% for src in design.rtl.sources %}
eval prj_src add {% if src.type.name == "Vhdl" -%} -format VHDL {%- elif src.type.name == "Verilog" -%} -format Verilog {%- elif src.type.name == "SystemVerilog" -%} -format SystemVerilog {%- endif %} {{src.file}}
{% endfor %}


{% if settings.synthesis_engine == "synplify" %}
# non-timing
eval prj_src add constraints.fdc

# timing
eval prj_src add constraints.sdc
{% endif %}

{% if settings.synthesis_engine == "lse" %}
eval prj_src add constraints.ldc
{% endif %}



{% if design.language.vhdl.standard == "08" %}
prj_strgy set_value -strategy custom_strategy syn_vhdl2008=True
prj_strgy set_value -strategy custom_strategy lse_vhdl2008=True
{% endif %}


## ???
prj_strgy set_value -strategy custom_strategy map_overmap_device=False

# prj_strgy set_value -strategy custom_strategy {maptrce_analysis_option=Standard Setup With Hold Analysis on IOs}
# prj_strgy set_value -strategy custom_strategy {partrce_analysis_option=Standard Setup With Hold Analysis on IOs}

{% if settings.strategy == "Timing" %}
prj_strgy set_value -strategy custom_strategy {syn_pipelining_retiming=Pipelining and Retiming}
# prj_strgy set_value -strategy custom_strategy {syn_use_clk_for_uncons_io=True}
prj_strgy set_value -strategy custom_strategy map_timing_driven=True
{% endif %}


# prj_strgy set_value -strategy custom_strategy par_create_delay_statistic_file=True


# NBR (default)/CDR
# From Lattice "Timing Closure" documentation:
# The PAR router has two main algorithms: the NBR algorithm (default) and the
# CDR algorithm. In the default router, the NBR algorithm assumes that all of
# the critical nets can be routed, and the tool will then work backwards to clean
# up the legality of the nets. On the other hand, CDR routing is done based on
# the legality of the nets.
# For designs with timing issues, you want to keep the default routing method
# (NBR) in the PAR strategy settings.
# prj_strgy set_value -strategy custom_strategy par_routing_method=CDR




{% if settings.syn_cmdline_args %}
prj_strgy set_value -strategy custom_strategy {syn_cmdline_args={{settings.syn_cmdline_args|join(" ")}}}
{% endif %}

{% if settings.strategy == "Area" %}
prj_strgy set_value -strategy custom_strategy syn_area=True
{% endif %}

prj_strgy set_value -strategy custom_strategy par_routing_res_opt=1


# 0-1000 default:0
# setting to 1 seems to help timing
prj_strgy set_value -strategy custom_strategy par_route_delay_reduction_pass=1


# 1-5 default:5
prj_strgy set_value -strategy custom_strategy par_place_effort_level=5



# LSE options
# lse_disable_distram=False ?
{% if not settings.allow_brams %}
prj_strgy set_value -strategy custom_strategy lse_dsp_style=Logic lse_dsp_util=0 lse_ebr_util=0 lse_rom_style=Logic
{% endif %}
#lse_ram_style=Distributed

{% if not settings.allow_dsps %}
eval prj_strgy set_value -strategy custom_strategy lse_dsp_style=Logic lse_dsp_util=0
{% endif %}

prj_strgy set_value -strategy custom_strategy {par_cmdline_args=-exp nbrMaxRunTime=200}

prj_strgy set custom_strategy

{% if design.rtl.top -%} prj_impl option top {{design.rtl.top}} {%- endif %}

prj_syn set {{settings.synthesis_engine}}

prj_project save
###################

puts "\n====================( Synthesize Design )===================="
eval prj_run Synthesis -impl ${implementation_name} -forceAll

puts "\n====================( Translate Design )===================="
eval prj_run Translate -impl ${implementation_name}
puts "\n====================( Map Design )===================="
eval prj_run Map -impl ${implementation_name} -forceAll

puts "\n====================( Place & Route Design )===================="
eval prj_run PAR -impl ${implementation_name} -forceAll
# eval prj_run PAR -impl ${implementation_name} -task IOTiming -forceOne

if {false} {
  puts "\n====================( Export Files )===================="
  eval prj_run Export -impl ${implementation_name}
}

prj_project close
