
## Automatically generated by Xeda
## ISE 14.7

puts "\n==============================( Creating Project )================================"
if { [catch  { project new {{design.name}} }] } {
    project open {{design.name}}
}

project set family {{settings.fpga.family}}
project set device {{settings.fpga.device}}
project set package {{settings.fpga.package}}
project set speed {{settings.fpga.speed}}
project set "Generate Detailed MAP Report" TRUE

project set "Auto Implementation Top" true

puts "\n==============================( Adding RTL Sources )================================"
{% for src in design.rtl.sources %}
xfile add {{src.file}} -copy
{%- endfor %}

project set top {{design.rtl.top}}

puts "\n==============================( Adding Constraint Files )================================"
if { [catch  { xfile add {{ucf_file}} -copy }] } {
    puts "unable to add {{ucf_file}}"
}

project set "Use Synthesis Constraints File" TRUE
project set "Synthesis Constraints File" "{{xcf_file}}"


puts "\n==============================( Setting Options )================================"
project set "Enable Multi-Threading" {{2 if settings.nthreads and settings.nthreads > 1 else "Off"}} -process "MAP"
project set "Enable Multi-Threading" {{[settings.nthreads, 4]|min if settings.nthreads and settings.nthreads > 1 else "Off"}} -process "Place & Route"

{% for k, v in settings.synthesis_options.items() %}
project set "{{k}}" {{v|quote_str}} -process "Synthesize - XST"
{% endfor %}
{% for k, v in settings.map_options.items() %}
project set "{{k}}" {{v|quote_str}} -process "MAP"
{% endfor %}
{% for k, v in settings.pnr_options.items() %}
project set "{{k}}" {{v|quote_str}} -process "Place & Route"
{% endfor %}
{% for k, v in settings.trace_options.items() %}
project set "{{k}}" {{v|quote_str}} -process "Generate Post-Place & Route Static Timing"
{% endfor %}


puts "\n==============================( Implementing Design )================================"

process run "Implement Design"

# project close

