
module axi_channel_bonding #(
    parameter AXI_ID_WIDTH = 0,
    parameter AXI_MASTER_DATA_WIDTH = 0,
    parameter AXI_ADDR_WIDTH = 0,
    parameter WIDE_BANK_BITS = 0,
    parameter NARROW_BANK_CAPACITY = 0
) (
    input clk,
    input rstn,
    
    input wire [AXI_ID_WIDTH-1:0] s_axi_awid,
    input wire [AXI_ADDR_WIDTH-1:0] s_axi_awaddr,
    input wire [7:0] s_axi_awlen,
    input wire [2:0] s_axi_awsize,
    input wire [1:0] s_axi_awburst,
    input wire s_axi_awlock,
    input wire [3:0] s_axi_awcache,
    input wire [2:0] s_axi_awprot,
    input wire [3:0] s_axi_awqos,
    input wire [3:0] s_axi_awregion,
    input wire s_axi_awvalid,
    output wire s_axi_awready,
    input wire [AXI_MASTER_DATA_WIDTH*2-1:0] s_axi_wdata,
    input wire [((AXI_MASTER_DATA_WIDTH*2)/8)-1:0] s_axi_wstrb,
    input wire s_axi_wlast,
    input wire s_axi_wvalid,
    output wire s_axi_wready,
    output wire [AXI_ID_WIDTH-1:0] s_axi_bid,
    output wire [1:0] s_axi_bresp,
    output wire s_axi_bvalid,
    input wire s_axi_bready,
    input wire [AXI_ID_WIDTH-1:0] s_axi_arid,
    input wire [AXI_ADDR_WIDTH-1:0] s_axi_araddr,
    input wire [7:0] s_axi_arlen,
    input wire [2:0] s_axi_arsize,
    input wire [1:0] s_axi_arburst,
    input wire s_axi_arlock,
    input wire [3:0] s_axi_arcache,
    input wire [2:0] s_axi_arprot,
    input wire [3:0] s_axi_arqos,
    input wire [3:0] s_axi_arregion,
    input wire s_axi_arvalid,
    output wire s_axi_arready,
    output wire [AXI_ID_WIDTH-1:0] s_axi_rid,
    output wire [AXI_MASTER_DATA_WIDTH*2-1:0] s_axi_rdata,
    output wire [1:0] s_axi_rresp,
    output wire s_axi_rlast,
    output wire s_axi_rvalid,
    input wire s_axi_rready,
    
    output wire [AXI_ID_WIDTH-1:0] m0_axi_awid,
    output wire [AXI_ADDR_WIDTH-1:0] m0_axi_awaddr,
    output wire [7:0] m0_axi_awlen,
    output wire [2:0] m0_axi_awsize,
    output wire [1:0] m0_axi_awburst,
    output wire m0_axi_awlock,
    output wire [3:0] m0_axi_awcache,
    output wire [2:0] m0_axi_awprot,
    output wire [3:0] m0_axi_awqos,
    output wire [3:0] m0_axi_awregion,
    output wire m0_axi_awvalid,
    input wire m0_axi_awready,
    output wire [AXI_MASTER_DATA_WIDTH-1:0] m0_axi_wdata,
    output wire [(AXI_MASTER_DATA_WIDTH/8)-1:0] m0_axi_wstrb,
    output wire m0_axi_wlast,
    output wire m0_axi_wvalid,
    input wire m0_axi_wready,
    input wire [AXI_ID_WIDTH-1:0] m0_axi_bid,
    input wire [1:0] m0_axi_bresp,
    input wire m0_axi_bvalid,
    output wire m0_axi_bready,
    output wire [AXI_ID_WIDTH-1:0] m0_axi_arid,
    output wire [AXI_ADDR_WIDTH-1:0] m0_axi_araddr,
    output wire [7:0] m0_axi_arlen,
    output wire [2:0] m0_axi_arsize,
    output wire [1:0] m0_axi_arburst,
    output wire m0_axi_arlock,
    output wire [3:0] m0_axi_arcache,
    output wire [2:0] m0_axi_arprot,
    output wire [3:0] m0_axi_arqos,
    output wire [3:0] m0_axi_arregion,
    output wire m0_axi_arvalid,
    input wire m0_axi_arready,
    input wire [AXI_ID_WIDTH-1:0] m0_axi_rid,
    input wire [AXI_MASTER_DATA_WIDTH-1:0] m0_axi_rdata,
    input wire [1:0] m0_axi_rresp,
    input wire m0_axi_rlast,
    input wire m0_axi_rvalid,
    output wire m0_axi_rready,
    
    output wire [AXI_ID_WIDTH-1:0] m1_axi_awid,
    output wire [AXI_ADDR_WIDTH-1:0] m1_axi_awaddr,
    output wire [7:0] m1_axi_awlen,
    output wire [2:0] m1_axi_awsize,
    output wire [1:0] m1_axi_awburst,
    output wire m1_axi_awlock,
    output wire [3:0] m1_axi_awcache,
    output wire [2:0] m1_axi_awprot,
    output wire [3:0] m1_axi_awqos,
    output wire [3:0] m1_axi_awregion,
    output wire m1_axi_awvalid,
    input wire m1_axi_awready,
    output wire [AXI_MASTER_DATA_WIDTH-1:0] m1_axi_wdata,
    output wire [(AXI_MASTER_DATA_WIDTH/8)-1:0] m1_axi_wstrb,
    output wire m1_axi_wlast,
    output wire m1_axi_wvalid,
    input wire m1_axi_wready,
    input wire [AXI_ID_WIDTH-1:0] m1_axi_bid,
    input wire [1:0] m1_axi_bresp,
    input wire m1_axi_bvalid,
    output wire m1_axi_bready,
    output wire [AXI_ID_WIDTH-1:0] m1_axi_arid,
    output wire [AXI_ADDR_WIDTH-1:0] m1_axi_araddr,
    output wire [7:0] m1_axi_arlen,
    output wire [2:0] m1_axi_arsize,
    output wire [1:0] m1_axi_arburst,
    output wire m1_axi_arlock,
    output wire [3:0] m1_axi_arcache,
    output wire [2:0] m1_axi_arprot,
    output wire [3:0] m1_axi_arqos,
    output wire [3:0] m1_axi_arregion,
    output wire m1_axi_arvalid,
    input wire m1_axi_arready,
    input wire [AXI_ID_WIDTH-1:0] m1_axi_rid,
    input wire [AXI_MASTER_DATA_WIDTH-1:0] m1_axi_rdata,
    input wire [1:0] m1_axi_rresp,
    input wire m1_axi_rlast,
    input wire m1_axi_rvalid,
    output wire m1_axi_rready
);

    typedef struct packed {
        logic [AXI_ADDR_WIDTH-1:0] addr;
        logic [AXI_ID_WIDTH-1:0] id;
        logic [7:0] len;
        logic [2:0] size;
        logic [1:0] burst;
        logic [0:0] lock;
        logic [3:0] cache;
        logic [2:0] prot;
        logic [3:0] qos;
        logic [3:0] region;
    } AddrBeat_t;

    typedef struct packed {
        logic [AXI_MASTER_DATA_WIDTH-1:0] wdata;
        logic [AXI_MASTER_DATA_WIDTH/8-1:0] wstrb;
        logic wlast;
    } WBeat_t;
    
    typedef struct packed {
        logic [AXI_MASTER_DATA_WIDTH-1:0] rdata;
        logic [AXI_ID_WIDTH-1:0] rid;
        logic [1:0] rresp;
        logic rlast;
    } RBeat_t;

    typedef struct packed {
        logic [1:0] bresp;
        logic [AXI_ID_WIDTH-1:0] bid;
    } BBeat_t;
    
    AddrBeat_t s_ar_beat;
    AddrBeat_t m0_ar_beat;
    AddrBeat_t m1_ar_beat;
    
    assign s_ar_beat.addr   = s_axi_araddr;
    assign s_ar_beat.len    = s_axi_arlen;
    assign s_ar_beat.size   = s_axi_arsize;
    assign s_ar_beat.burst  = s_axi_arburst;
    assign s_ar_beat.lock   = s_axi_arlock;
    assign s_ar_beat.cache  = s_axi_arcache;
    assign s_ar_beat.prot   = s_axi_arprot;
    assign s_ar_beat.qos    = s_axi_arqos;
    assign s_ar_beat.region = s_axi_arregion;
    assign s_ar_beat.id     = s_axi_arid;
    
    //assign m0_axi_araddr   = (m0_ar_beat.addr>>1)+AXI_CHANNEL_CAPACITY;
    assign m0_axi_araddr   = ((m0_ar_beat.addr>>WIDE_BANK_BITS)<<WIDE_BANK_BITS) + ((m0_ar_beat.addr-((m0_ar_beat.addr>>WIDE_BANK_BITS)<<WIDE_BANK_BITS))>>1) + NARROW_BANK_CAPACITY;
    assign m0_axi_arlen    = m0_ar_beat.len;
    assign m0_axi_arsize   = m0_ar_beat.size-1;
    assign m0_axi_arburst  = m0_ar_beat.burst;
    assign m0_axi_arlock   = m0_ar_beat.lock;
    assign m0_axi_arcache  = m0_ar_beat.cache;
    assign m0_axi_arprot   = m0_ar_beat.prot;
    assign m0_axi_arqos    = m0_ar_beat.qos;
    assign m0_axi_arregion = m0_ar_beat.region;
    assign m0_axi_arid     = m0_ar_beat.id;
    
    //assign m1_axi_araddr   = m1_ar_beat.addr>>1;
    assign m1_axi_araddr   = ((m1_ar_beat.addr>>WIDE_BANK_BITS)<<WIDE_BANK_BITS) + ((m1_ar_beat.addr-((m1_ar_beat.addr>>WIDE_BANK_BITS)<<WIDE_BANK_BITS))>>1);
    assign m1_axi_arlen    = m1_ar_beat.len;
    assign m1_axi_arsize   = m1_ar_beat.size-1;
    assign m1_axi_arburst  = m1_ar_beat.burst;
    assign m1_axi_arlock   = m1_ar_beat.lock;
    assign m1_axi_arcache  = m1_ar_beat.cache;
    assign m1_axi_arprot   = m1_ar_beat.prot;
    assign m1_axi_arqos    = m1_ar_beat.qos;
    assign m1_axi_arregion = m1_ar_beat.region;
    assign m1_axi_arid     = m1_ar_beat.id;
    
    AddrBeat_t s_aw_beat;
    AddrBeat_t m0_aw_beat;
    AddrBeat_t m1_aw_beat;
    
    assign s_aw_beat.addr   = s_axi_awaddr;
    assign s_aw_beat.len    = s_axi_awlen;
    assign s_aw_beat.size   = s_axi_awsize;
    assign s_aw_beat.burst  = s_axi_awburst;
    assign s_aw_beat.lock   = s_axi_awlock;
    assign s_aw_beat.cache  = s_axi_awcache;
    assign s_aw_beat.prot   = s_axi_awprot;
    assign s_aw_beat.qos    = s_axi_awqos;
    assign s_aw_beat.region = s_axi_awregion;
    assign s_aw_beat.id     = s_axi_awid;
    
    //assign m0_axi_awaddr   = (m0_aw_beat.addr>>1)+AXI_CHANNEL_CAPACITY;
    assign m0_axi_awaddr   = ((m0_aw_beat.addr>>WIDE_BANK_BITS)<<WIDE_BANK_BITS) + ((m0_aw_beat.addr-((m0_aw_beat.addr>>WIDE_BANK_BITS)<<WIDE_BANK_BITS))>>1) + NARROW_BANK_CAPACITY;
    assign m0_axi_awlen    = m0_aw_beat.len;
    assign m0_axi_awsize   = m0_aw_beat.size-1;
    assign m0_axi_awburst  = m0_aw_beat.burst;
    assign m0_axi_awlock   = m0_aw_beat.lock;
    assign m0_axi_awcache  = m0_aw_beat.cache;
    assign m0_axi_awprot   = m0_aw_beat.prot;
    assign m0_axi_awqos    = m0_aw_beat.qos;
    assign m0_axi_awregion = m0_aw_beat.region;
    assign m0_axi_awid     = m0_aw_beat.id;
    
    //assign m1_axi_awaddr   = m1_aw_beat.addr>>1;
    assign m1_axi_awaddr   = ((m1_aw_beat.addr>>WIDE_BANK_BITS)<<WIDE_BANK_BITS) + ((m1_aw_beat.addr-((m1_aw_beat.addr>>WIDE_BANK_BITS)<<WIDE_BANK_BITS))>>1);
    assign m1_axi_awlen    = m1_aw_beat.len;
    assign m1_axi_awsize   = m1_aw_beat.size-1;
    assign m1_axi_awburst  = m1_aw_beat.burst;
    assign m1_axi_awlock   = m1_aw_beat.lock;
    assign m1_axi_awcache  = m1_aw_beat.cache;
    assign m1_axi_awprot   = m1_aw_beat.prot;
    assign m1_axi_awqos    = m1_aw_beat.qos;
    assign m1_axi_awregion = m1_aw_beat.region;
    assign m1_axi_awid     = m1_aw_beat.id;
    
    WBeat_t s_low_w_beat;
    WBeat_t s_high_w_beat;
    WBeat_t m0_w_beat;
    WBeat_t m1_w_beat;
    
    assign s_low_w_beat.wdata = s_axi_wdata[0 +: AXI_MASTER_DATA_WIDTH];
    assign s_low_w_beat.wstrb = s_axi_wstrb[0 +: AXI_MASTER_DATA_WIDTH/8];
    assign s_low_w_beat.wlast = s_axi_wlast;
    
    assign s_high_w_beat.wdata = s_axi_wdata[AXI_MASTER_DATA_WIDTH +: AXI_MASTER_DATA_WIDTH];
    assign s_high_w_beat.wstrb = s_axi_wstrb[AXI_MASTER_DATA_WIDTH/8 +: AXI_MASTER_DATA_WIDTH/8];
    assign s_high_w_beat.wlast = s_axi_wlast;
    
    assign m0_axi_wdata = m0_w_beat.wdata;
    assign m0_axi_wstrb = m0_w_beat.wstrb;
    assign m0_axi_wlast = m0_w_beat.wlast;
    
    assign m1_axi_wdata = m1_w_beat.wdata;
    assign m1_axi_wstrb = m1_w_beat.wstrb;
    assign m1_axi_wlast = m1_w_beat.wlast;
    
    RBeat_t s_low_r_beat;
    RBeat_t s_high_r_beat;
    RBeat_t m0_r_beat;
    RBeat_t m1_r_beat;
    
    assign s_axi_rdata[0 +: AXI_MASTER_DATA_WIDTH] = s_low_r_beat.rdata;
    assign s_axi_rdata[AXI_MASTER_DATA_WIDTH +: AXI_MASTER_DATA_WIDTH] = s_high_r_beat.rdata;
    assign s_axi_rlast = s_low_r_beat.rlast;
    assign s_axi_rid = s_low_r_beat.rid;
    assign s_axi_rresp = s_high_r_beat.rresp != 0 ? s_high_r_beat.rresp : s_low_r_beat.rresp;
    
    assign m0_r_beat.rdata = m0_axi_rdata;
    assign m0_r_beat.rid = m0_axi_rid;
    assign m0_r_beat.rresp = m0_axi_rresp;
    assign m0_r_beat.rlast = m0_axi_rlast;
    
    assign m1_r_beat.rdata = m1_axi_rdata;
    assign m1_r_beat.rid = m1_axi_rid;
    assign m1_r_beat.rresp = m1_axi_rresp;
    assign m1_r_beat.rlast = m1_axi_rlast;
    
    BBeat_t s_low_b_beat;
    BBeat_t s_high_b_beat;
    BBeat_t m0_b_beat;
    BBeat_t m1_b_beat;
    
    assign s_axi_bid = s_low_b_beat.bid;
    assign s_axi_bresp = s_high_b_beat.bresp != 0 ? s_high_b_beat.bresp : s_low_b_beat.bresp;
    
    assign m0_b_beat.bid = m0_axi_bid;
    assign m0_b_beat.bresp = m0_axi_bresp;
    
    assign m1_b_beat.bid = m1_axi_bid;
    assign m1_b_beat.bresp = m1_axi_bresp;
    
    wire m0_ar_fifo_i_valid;
    wire m0_ar_fifo_i_ready;
    wire m0_ar_fifo_o_valid;
    wire m0_ar_fifo_o_ready;
    
    wire m1_ar_fifo_i_valid;
    wire m1_ar_fifo_i_ready;
    wire m1_ar_fifo_o_valid;
    wire m1_ar_fifo_o_ready;
    
    channel_demux_logic channel_ar_demux_logic (
        .m0_fifo_i_valid(m0_ar_fifo_i_valid),
        .m0_fifo_i_ready(m0_ar_fifo_i_ready),
        .m0_fifo_o_valid(m0_ar_fifo_o_valid),
        .m0_fifo_o_ready(m0_ar_fifo_o_ready),
        .m1_fifo_i_valid(m1_ar_fifo_i_valid),
        .m1_fifo_i_ready(m1_ar_fifo_i_ready),
        .m1_fifo_o_valid(m1_ar_fifo_o_valid),
        .m1_fifo_o_ready(m1_ar_fifo_o_ready),
        .s_axi_valid(s_axi_arvalid),
        .s_axi_ready(s_axi_arready),
        .m0_axi_valid(m0_axi_arvalid),
        .m0_axi_ready(m0_axi_arready),
        .m1_axi_valid(m1_axi_arvalid),
        .m1_axi_ready(m1_axi_arready)
    );

    wire m0_aw_fifo_i_valid;
    wire m0_aw_fifo_i_ready;
    wire m0_aw_fifo_o_valid;
    wire m0_aw_fifo_o_ready;
    
    wire m1_aw_fifo_i_valid;
    wire m1_aw_fifo_i_ready;
    wire m1_aw_fifo_o_valid;
    wire m1_aw_fifo_o_ready;
    
    channel_demux_logic channel_aw_demux_logic (
        .m0_fifo_i_valid(m0_aw_fifo_i_valid),
        .m0_fifo_i_ready(m0_aw_fifo_i_ready),
        .m0_fifo_o_valid(m0_aw_fifo_o_valid),
        .m0_fifo_o_ready(m0_aw_fifo_o_ready),
        .m1_fifo_i_valid(m1_aw_fifo_i_valid),
        .m1_fifo_i_ready(m1_aw_fifo_i_ready),
        .m1_fifo_o_valid(m1_aw_fifo_o_valid),
        .m1_fifo_o_ready(m1_aw_fifo_o_ready),
        .s_axi_valid(s_axi_awvalid),
        .s_axi_ready(s_axi_awready),
        .m0_axi_valid(m0_axi_awvalid),
        .m0_axi_ready(m0_axi_awready),
        .m1_axi_valid(m1_axi_awvalid),
        .m1_axi_ready(m1_axi_awready)
    );
    wire m0_w_fifo_i_valid;
    wire m0_w_fifo_i_ready;
    wire m0_w_fifo_o_valid;
    wire m0_w_fifo_o_ready;

    wire m1_w_fifo_i_valid;
    wire m1_w_fifo_i_ready;
    wire m1_w_fifo_o_valid;
    wire m1_w_fifo_o_ready;
    
    channel_demux_logic channel_w_demux_logic (
        .m0_fifo_i_valid(m0_w_fifo_i_valid),
        .m0_fifo_i_ready(m0_w_fifo_i_ready),
        .m0_fifo_o_valid(m0_w_fifo_o_valid),
        .m0_fifo_o_ready(m0_w_fifo_o_ready),
        .m1_fifo_i_valid(m1_w_fifo_i_valid),
        .m1_fifo_i_ready(m1_w_fifo_i_ready),
        .m1_fifo_o_valid(m1_w_fifo_o_valid),
        .m1_fifo_o_ready(m1_w_fifo_o_ready),
        .s_axi_valid(s_axi_wvalid),
        .s_axi_ready(s_axi_wready),
        .m0_axi_valid(m0_axi_wvalid),
        .m0_axi_ready(m0_axi_wready),
        .m1_axi_valid(m1_axi_wvalid),
        .m1_axi_ready(m1_axi_wready)
    );
    
    wire m0_r_fifo_i_valid;
    wire m0_r_fifo_i_ready;
    wire m0_r_fifo_o_valid;
    wire m0_r_fifo_o_ready;

    wire m1_r_fifo_i_valid;
    wire m1_r_fifo_i_ready;
    wire m1_r_fifo_o_valid;
    wire m1_r_fifo_o_ready;
    
    channel_mux_logic channel_r_mux_logic (
        .m0_fifo_i_valid(m0_r_fifo_i_valid),
        .m0_fifo_i_ready(m0_r_fifo_i_ready),
        .m0_fifo_o_valid(m0_r_fifo_o_valid),
        .m0_fifo_o_ready(m0_r_fifo_o_ready),
        .m1_fifo_i_valid(m1_r_fifo_i_valid),
        .m1_fifo_i_ready(m1_r_fifo_i_ready),
        .m1_fifo_o_valid(m1_r_fifo_o_valid),
        .m1_fifo_o_ready(m1_r_fifo_o_ready),
        .s_axi_valid(s_axi_rvalid),
        .s_axi_ready(s_axi_rready),
        .m0_axi_valid(m0_axi_rvalid),
        .m0_axi_ready(m0_axi_rready),
        .m1_axi_valid(m1_axi_rvalid),
        .m1_axi_ready(m1_axi_rready)
    );
    
    wire m0_b_fifo_i_valid;
    wire m0_b_fifo_i_ready;
    wire m0_b_fifo_o_valid;
    wire m0_b_fifo_o_ready;

    wire m1_b_fifo_i_valid;
    wire m1_b_fifo_i_ready;
    wire m1_b_fifo_o_valid;
    wire m1_b_fifo_o_ready;
    
    channel_mux_logic channel_b_mux_logic (
        .m0_fifo_i_valid(m0_b_fifo_i_valid),
        .m0_fifo_i_ready(m0_b_fifo_i_ready),
        .m0_fifo_o_valid(m0_b_fifo_o_valid),
        .m0_fifo_o_ready(m0_b_fifo_o_ready),
        .m1_fifo_i_valid(m1_b_fifo_i_valid),
        .m1_fifo_i_ready(m1_b_fifo_i_ready),
        .m1_fifo_o_valid(m1_b_fifo_o_valid),
        .m1_fifo_o_ready(m1_b_fifo_o_ready),
        .s_axi_valid(s_axi_bvalid),
        .s_axi_ready(s_axi_bready),
        .m0_axi_valid(m0_axi_bvalid),
        .m0_axi_ready(m0_axi_bready),
        .m1_axi_valid(m1_axi_bvalid),
        .m1_axi_ready(m1_axi_bready)
    );
    
    fifo_1slot #(
        .WIDTH($bits(AddrBeat_t))
    ) m0_ar_fifo (
        .clk(clk),
        .rstn(rstn),
        .i_valid(m0_ar_fifo_i_valid),
        .i_ready(m0_ar_fifo_i_ready),
        .o_valid(m0_ar_fifo_o_valid),
        .o_ready(m0_ar_fifo_o_ready),
        .din(s_ar_beat),
        .dout(m0_ar_beat)
    );
    
    fifo_1slot #(
        .WIDTH($bits(AddrBeat_t))
    ) m1_ar_fifo (
        .clk(clk),
        .rstn(rstn),
        .i_valid(m1_ar_fifo_i_valid),
        .i_ready(m1_ar_fifo_i_ready),
        .o_valid(m1_ar_fifo_o_valid),
        .o_ready(m1_ar_fifo_o_ready),
        .din(s_ar_beat),
        .dout(m1_ar_beat)
    );
    
    fifo_1slot #(
        .WIDTH($bits(AddrBeat_t))
    ) m0_aw_fifo (
        .clk(clk),
        .rstn(rstn),
        .i_valid(m0_aw_fifo_i_valid),
        .i_ready(m0_aw_fifo_i_ready),
        .o_valid(m0_aw_fifo_o_valid),
        .o_ready(m0_aw_fifo_o_ready),
        .din(s_aw_beat),
        .dout(m0_aw_beat)
    );
    
    fifo_1slot #(
        .WIDTH($bits(AddrBeat_t))
    ) m1_aw_fifo (
        .clk(clk),
        .rstn(rstn),
        .i_valid(m1_aw_fifo_i_valid),
        .i_ready(m1_aw_fifo_i_ready),
        .o_valid(m1_aw_fifo_o_valid),
        .o_ready(m1_aw_fifo_o_ready),
        .din(s_aw_beat),
        .dout(m1_aw_beat)
    );
    
    fifo_1slot #(
        .WIDTH($bits(WBeat_t))
    ) m0_w_fifo (
        .clk(clk),
        .rstn(rstn),
        .i_valid(m0_w_fifo_i_valid),
        .i_ready(m0_w_fifo_i_ready),
        .o_valid(m0_w_fifo_o_valid),
        .o_ready(m0_w_fifo_o_ready),
        .din(s_low_w_beat),
        .dout(m0_w_beat)
    );
    
    fifo_1slot #(
        .WIDTH($bits(WBeat_t))
    ) m1_w_fifo (
        .clk(clk),
        .rstn(rstn),
        .i_valid(m1_w_fifo_i_valid),
        .i_ready(m1_w_fifo_i_ready),
        .o_valid(m1_w_fifo_o_valid),
        .o_ready(m1_w_fifo_o_ready),
        .din(s_high_w_beat),
        .dout(m1_w_beat)
    );
    
    fifo_1slot #(
        .WIDTH($bits(RBeat_t))
    ) m0_r_fifo (
        .clk(clk),
        .rstn(rstn),
        .i_valid(m0_r_fifo_i_valid),
        .i_ready(m0_r_fifo_i_ready),
        .o_valid(m0_r_fifo_o_valid),
        .o_ready(m0_r_fifo_o_ready),
        .din(m0_r_beat),
        .dout(s_low_r_beat)
    );
    
    fifo_1slot #(
        .WIDTH($bits(RBeat_t))
    ) m1_r_fifo (
        .clk(clk),
        .rstn(rstn),
        .i_valid(m1_r_fifo_i_valid),
        .i_ready(m1_r_fifo_i_ready),
        .o_valid(m1_r_fifo_o_valid),
        .o_ready(m1_r_fifo_o_ready),
        .din(m1_r_beat),
        .dout(s_high_r_beat)
    );
    
    fifo_1slot #(
        .WIDTH($bits(BBeat_t))
    ) m0_b_fifo (
        .clk(clk),
        .rstn(rstn),
        .i_valid(m0_b_fifo_i_valid),
        .i_ready(m0_b_fifo_i_ready),
        .o_valid(m0_b_fifo_o_valid),
        .o_ready(m0_b_fifo_o_ready),
        .din(m0_b_beat),
        .dout(s_low_b_beat)
    );
    
    fifo_1slot #(
        .WIDTH($bits(BBeat_t))
    ) m1_b_fifo (
        .clk(clk),
        .rstn(rstn),
        .i_valid(m1_b_fifo_i_valid),
        .i_ready(m1_b_fifo_i_ready),
        .o_valid(m1_b_fifo_o_valid),
        .o_ready(m1_b_fifo_o_ready),
        .din(m1_b_beat),
        .dout(s_high_b_beat)
    );
    
endmodule
