
module channel_mux_logic (
    output m0_fifo_i_valid,
    input  m0_fifo_i_ready,
    input  m0_fifo_o_valid,
    output m0_fifo_o_ready,
    
    output m1_fifo_i_valid,
    input  m1_fifo_i_ready,
    input  m1_fifo_o_valid,
    output m1_fifo_o_ready,
    
    output s_axi_valid,
    input  s_axi_ready,
    
    input  m0_axi_valid,
    output m0_axi_ready,
    
    input  m1_axi_valid,
    output m1_axi_ready
);

    assign m0_fifo_i_valid = m0_axi_valid;
    assign m1_fifo_i_valid = m1_axi_valid;
    assign m0_axi_ready = m0_fifo_i_ready;
    assign m1_axi_ready = m1_fifo_i_ready;
    assign s_axi_valid = m0_fifo_o_valid && m1_fifo_o_valid;
    assign m0_fifo_o_ready = s_axi_ready && m0_fifo_o_valid && m1_fifo_o_valid;
    assign m1_fifo_o_ready = s_axi_ready && m0_fifo_o_valid && m1_fifo_o_valid;
    
endmodule
