"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MigrationhubOrchestrator = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [migrationhub-orchestrator](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmigrationhuborchestrator.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class MigrationhubOrchestrator extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [migrationhub-orchestrator](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmigrationhuborchestrator.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'migrationhub-orchestrator';
        this.accessLevelList = {
            Write: [
                'CreateWorkflow',
                'CreateWorkflowStep',
                'CreateWorkflowStepGroup',
                'DeleteWorkflow',
                'DeleteWorkflowStep',
                'DeleteWorkflowStepGroup',
                'RegisterPlugin',
                'RetryWorkflowStep',
                'SendMessage',
                'StartWorkflow',
                'StopWorkflow',
                'UpdateWorkflow',
                'UpdateWorkflowStep',
                'UpdateWorkflowStepGroup'
            ],
            Read: [
                'GetMessage',
                'GetTemplate',
                'GetTemplateStep',
                'GetTemplateStepGroup',
                'GetWorkflow',
                'GetWorkflowStep',
                'GetWorkflowStepGroup'
            ],
            List: [
                'ListPlugins',
                'ListTemplateStepGroups',
                'ListTemplateSteps',
                'ListTemplates',
                'ListWorkflowStepGroups',
                'ListWorkflowSteps',
                'ListWorkflows'
            ]
        };
    }
    /**
     * Grants permission to create a workflow based on the selected template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_CreateWorkflow.html
     */
    toCreateWorkflow() {
        return this.to('CreateWorkflow');
    }
    /**
     * Grants permission to create a step under a workflow and a specific step group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_CreateWorkflowStep.html
     */
    toCreateWorkflowStep() {
        return this.to('CreateWorkflowStep');
    }
    /**
     * Grants permission to to create a custom step group for a given workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_CreateWorkflowStepGroup.html
     */
    toCreateWorkflowStepGroup() {
        return this.to('CreateWorkflowStepGroup');
    }
    /**
     * Grants permission to a workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_DeleteWorkflow.html
     */
    toDeleteWorkflow() {
        return this.to('DeleteWorkflow');
    }
    /**
     * Grants permission to delete a step from a specific step group under a workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_DeleteWorkflowStep.html
     */
    toDeleteWorkflowStep() {
        return this.to('DeleteWorkflowStep');
    }
    /**
     * Grants permission to delete a step group associated with a workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_DeleteWorkflowStepGroup.html
     */
    toDeleteWorkflowStepGroup() {
        return this.to('DeleteWorkflowStepGroup');
    }
    /**
     * Grants permission to the plugin to receive information from the service
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_GetMessage.html
     */
    toGetMessage() {
        return this.to('GetMessage');
    }
    /**
     * Grants permission to get retrieve metadata for a Template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_GetTemplate.html
     */
    toGetTemplate() {
        return this.to('GetTemplate');
    }
    /**
     * Grants permission to retrieve details of a step associated with a template and a step group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_GetTemplateStep.html
     */
    toGetTemplateStep() {
        return this.to('GetTemplateStep');
    }
    /**
     * Grants permission to retrieve metadata of a step group under a template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_GetTemplateStepGroup.html
     */
    toGetTemplateStepGroup() {
        return this.to('GetTemplateStepGroup');
    }
    /**
     * Grants permission to retrieve metadata asscociated with a workflow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_GetWorkflow.html
     */
    toGetWorkflow() {
        return this.to('GetWorkflow');
    }
    /**
     * Grants permission to get details of step associated with a workflow and a step group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_GetWorkflowStep.html
     */
    toGetWorkflowStep() {
        return this.to('GetWorkflowStep');
    }
    /**
     * Grants permission to get details of a step group associated with a workflow
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_GetWorkflowStepGroup.html
     */
    toGetWorkflowStepGroup() {
        return this.to('GetWorkflowStepGroup');
    }
    /**
     * Grants permission to get a list all registered Plugins
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_ListPlugins.html
     */
    toListPlugins() {
        return this.to('ListPlugins');
    }
    /**
     * Grants permission to lists step groups of a template
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_ListTemplateStepGroups.html
     */
    toListTemplateStepGroups() {
        return this.to('ListTemplateStepGroups');
    }
    /**
     * Grants permission to get a list of steps in a step group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_ListServers.html
     */
    toListTemplateSteps() {
        return this.to('ListTemplateSteps');
    }
    /**
     * Grants permission to get a list of all Templates available to customer
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_ListTemplates.html
     */
    toListTemplates() {
        return this.to('ListTemplates');
    }
    /**
     * Grants permission to get list of step groups associated with a workflow
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_ListWorkflowStepGroups.html
     */
    toListWorkflowStepGroups() {
        return this.to('ListWorkflowStepGroups');
    }
    /**
     * Grants permission to get a list of steps within step group associated with a workflow
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_ListAntiPatterns.html
     */
    toListWorkflowSteps() {
        return this.to('ListWorkflowSteps');
    }
    /**
     * Grants permission to list all workflows
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_ListWorkflows.html
     */
    toListWorkflows() {
        return this.to('ListWorkflows');
    }
    /**
     * Grants permission to register the plugin to receive an ID and to start receiving messages from the service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_RegisterPlugin.html
     */
    toRegisterPlugin() {
        return this.to('RegisterPlugin');
    }
    /**
     * Grants permission to retry a failed step within a workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_RetryWorkflowStep.html
     */
    toRetryWorkflowStep() {
        return this.to('RetryWorkflowStep');
    }
    /**
     * Grants permission to the plugin to send information to the service
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_SendMessage.html
     */
    toSendMessage() {
        return this.to('SendMessage');
    }
    /**
     * Grants permission to start a workflow or resume a stopped workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_StartWorkflow.html
     */
    toStartWorkflow() {
        return this.to('StartWorkflow');
    }
    /**
     * Grants permission to stop a workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_StopWorkflow.html
     */
    toStopWorkflow() {
        return this.to('StopWorkflow');
    }
    /**
     * Grants permission to update the metadata associated with the workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_UpdateWorkflow.html
     */
    toUpdateWorkflow() {
        return this.to('UpdateWorkflow');
    }
    /**
     * Grants permission to update metadata and status of a custom step within a workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_UpdateWorkflowStep.html
     */
    toUpdateWorkflowStep() {
        return this.to('UpdateWorkflowStep');
    }
    /**
     * Grants permission to update metadata associated with a step group in a given workflow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/APIReference/API_UpdateWorkflowStepGroup.html
     */
    toUpdateWorkflowStepGroup() {
        return this.to('UpdateWorkflowStepGroup');
    }
    /**
     * Adds a resource of type workflow-template to the statement
     *
     * https://docs.aws.amazon.com/migrationhub-orchestrator/latest/userguide/workflow-template.html
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     */
    onWorkflowTemplate(resourceId, account, region, partition) {
        return this.on(`arn:${partition || MigrationhubOrchestrator.defaultPartition}:migrationhub-orchestrator:${region || '*'}:${account || '*'}:workflow-template/${resourceId}`);
    }
}
exports.MigrationhubOrchestrator = MigrationhubOrchestrator;
_a = JSII_RTTI_SYMBOL_1;
MigrationhubOrchestrator[_a] = { fqn: "iam-floyd.MigrationhubOrchestrator", version: "0.355.0" };
//# sourceMappingURL=data:application/json;base64,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