"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Snowball = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [snowball](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssnowball.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Snowball extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [snowball](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssnowball.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'snowball';
        this.accessLevelList = {
            Write: [
                'CancelCluster',
                'CancelJob',
                'CreateAddress',
                'CreateCluster',
                'CreateJob',
                'CreateLongTermPricing',
                'CreateReturnShippingLabel',
                'UpdateCluster',
                'UpdateJob',
                'UpdateJobShipmentState',
                'UpdateLongTermPricing'
            ],
            Read: [
                'DescribeAddress',
                'DescribeCluster',
                'DescribeJob',
                'DescribeReturnShippingLabel',
                'GetJobManifest',
                'GetJobUnlockCode',
                'GetSnowballUsage',
                'GetSoftwareUpdates',
                'ListLongTermPricing'
            ],
            List: [
                'DescribeAddresses',
                'ListClusterJobs',
                'ListClusters',
                'ListCompatibleImages',
                'ListJobs'
            ]
        };
    }
    /**
     * Cancels a cluster job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CancelCluster.html
     */
    toCancelCluster() {
        return this.to('CancelCluster');
    }
    /**
     * Cancels the specified job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CancelJob.html
     */
    toCancelJob() {
        return this.to('CancelJob');
    }
    /**
     * Creates an address for a Snowball to be shipped to.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateAddress.html
     */
    toCreateAddress() {
        return this.to('CreateAddress');
    }
    /**
     * Creates an empty cluster.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateCluster.html
     */
    toCreateCluster() {
        return this.to('CreateCluster');
    }
    /**
     * Creates a job to import or export data between Amazon S3 and your on-premises data center.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateJob.html
     */
    toCreateJob() {
        return this.to('CreateJob');
    }
    /**
     * Grants permission to creates a LongTermPricingListEntry for allowing customers to add an upfront billing contract for a job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateLongTermPricing.html
     */
    toCreateLongTermPricing() {
        return this.to('CreateLongTermPricing');
    }
    /**
     * Creates a shipping label that will be used to return the Snow device to AWS.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_CreateReturnShippingLabel.html
     */
    toCreateReturnShippingLabel() {
        return this.to('CreateReturnShippingLabel');
    }
    /**
     * Takes an AddressId and returns specific details about that address in the form of an Address object.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeAddress.html
     */
    toDescribeAddress() {
        return this.to('DescribeAddress');
    }
    /**
     * Returns a specified number of ADDRESS objects.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeAddresses.html
     */
    toDescribeAddresses() {
        return this.to('DescribeAddresses');
    }
    /**
     * Returns information about a specific cluster including shipping information, cluster status, and other important metadata.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeCluster.html
     */
    toDescribeCluster() {
        return this.to('DescribeCluster');
    }
    /**
     * Returns information about a specific job including shipping information, job status, and other important metadata.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeJob.html
     */
    toDescribeJob() {
        return this.to('DescribeJob');
    }
    /**
     * Information on the shipping label of a Snow device that is being returned to AWS.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_DescribeReturnShippingLabel.html
     */
    toDescribeReturnShippingLabel() {
        return this.to('DescribeReturnShippingLabel');
    }
    /**
     * Returns a link to an Amazon S3 presigned URL for the manifest file associated with the specified JobId value.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_GetJobManifest.html
     */
    toGetJobManifest() {
        return this.to('GetJobManifest');
    }
    /**
     * Returns the UnlockCode code value for the specified job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_GetJobUnlockCode.html
     */
    toGetJobUnlockCode() {
        return this.to('GetJobUnlockCode');
    }
    /**
     * Returns information about the Snowball service limit for your account, and also the number of Snowballs your account has in use.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_GetSnowballUsage.html
     */
    toGetSnowballUsage() {
        return this.to('GetSnowballUsage');
    }
    /**
     * Returns an Amazon S3 presigned URL for an update file associated with a specified JobId.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_GetSoftwareUpdates.html
     */
    toGetSoftwareUpdates() {
        return this.to('GetSoftwareUpdates');
    }
    /**
     * Returns an array of JobListEntry objects of the specified length.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListClusterJobs.html
     */
    toListClusterJobs() {
        return this.to('ListClusterJobs');
    }
    /**
     * Returns an array of ClusterListEntry objects of the specified length.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListClusters.html
     */
    toListClusters() {
        return this.to('ListClusters');
    }
    /**
     * This action returns a list of the different Amazon EC2 Amazon Machine Images (AMIs) that are owned by your AWS account that would be supported for use on a Snow device.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListCompatibleImages.html
     */
    toListCompatibleImages() {
        return this.to('ListCompatibleImages');
    }
    /**
     * Returns an array of JobListEntry objects of the specified length.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListJobs.html
     */
    toListJobs() {
        return this.to('ListJobs');
    }
    /**
     * Grants permission to list LongTermPricingListEntry objects for the account making the request
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_ListLongTermPricing.html
     */
    toListLongTermPricing() {
        return this.to('ListLongTermPricing');
    }
    /**
     * While a cluster's ClusterState value is in the AwaitingQuorum state, you can update some of the information associated with a cluster.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_UpdateCluster.html
     */
    toUpdateCluster() {
        return this.to('UpdateCluster');
    }
    /**
     * While a job's JobState value is New, you can update some of the information associated with a job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_UpdateJob.html
     */
    toUpdateJob() {
        return this.to('UpdateJob');
    }
    /**
     * Updates the state when a the shipment states changes to a different state.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_UpdateJobShipmentState.html
     */
    toUpdateJobShipmentState() {
        return this.to('UpdateJobShipmentState');
    }
    /**
     * Grants permission to update a specific upfront billing contract for a job
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/snowball/latest/api-reference/API_UpdateLongTermPricing.html
     */
    toUpdateLongTermPricing() {
        return this.to('UpdateLongTermPricing');
    }
}
exports.Snowball = Snowball;
_a = JSII_RTTI_SYMBOL_1;
Snowball[_a] = { fqn: "iam-floyd.Snowball", version: "0.355.0" };
//# sourceMappingURL=data:application/json;base64,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