/* $Id: SdifFile.h,v 3.18 2004-01-09 11:29:23 schwarz Exp $
 *
 * IRCAM SDIF Library (http://www.ircam.fr/sdif)
 *
 * Copyright (C) 1998, 1999, 2000 by IRCAM-Centre Georges Pompidou, Paris, France.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * See file COPYING for further informations on licensing terms.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *  For any information regarding this and other IRCAM software, please
 *  send email to:
 *                            sdif@ircam.fr

LIBRARY
 * SdifFile.h
 *
 * Sdif Files management
 * High Level.
 *
 * author: Dominique Virolle 1997

LOG
 * $Log: not supported by cvs2svn $
 * Revision 3.17  2003/11/07 21:47:18  roebel
 * removed XpGuiCalls.h and replaced preinclude.h  by local files
 *
 * Revision 3.16  2002/11/28 19:57:11  roebel
 * Removed redunant declarations that are already in sdif.h.
 *
 * Revision 3.15  2001/05/02 09:34:43  tisseran
 * Change License from GNU Public License to GNU Lesser Public License.
 *
 * Revision 3.14  2001/04/20 14:04:07  tisseran
 * SDIF VERSION 3.3
 * Create function: SdifTakeCodedPredefinedTypesfromString (SdifFile.[hc])
 * This function is use to read types from the define string SDIFTYPES_STRING
 * This string is generated by perl script xmltostyp.pl
 * Types definition are in the sdiftypes.xml file.
 * Change in sdif_portability.h to NOT INCLUDE host_architecture.h when using configure
 * script.
 * project_preinclude.h and configure.in have been changed according to new version number.
 *
 * Revision 3.13  2000/12/06 13:43:42  lefevre
 * Mix HostArchiteture and AutoConfigure mechanisms
 *
 * Revision 3.12  2000/11/21  14:51:49  schwarz
 * - sdif.h is now included by all sdif/Sdif*.c files.
 * - Removed all public typedefs, enums, structs, and defines from the
 *   individual sdif/Sdif*.h files, because they were duplicated in sdif.h.
 * - Todo: Do the same for the function prototypes, decide which types and
 *   prototypes really need to be exported.
 * - Removed SdifFileStruct.h.
 * - Preliminary new version of SdiffGetPos, SdiffSetPos.  They used the
 *   type fpos_t, which is no longer a long on RedHat 7 Linux.
 *
 * Revision 3.11  2000/11/15 14:53:29  lefevre
 * no message
 *
 * Revision 3.10  2000/10/27  20:03:31  roebel
 * autoconf merged back to main trunk
 *
 * Revision 3.9  2000/08/22  13:17:24  schwarz
 * Centralised error report function SdifFError, called from _SdifFError
 * macro.  Error level names (gSdifErrorLevel) are printed, so that users
 * can tell warnings from errors.  Errors are counted by level in
 * SdifFileT.ErrorCount[].  Error counts can be queried with SdifFNumErrors.
 *
 * Revision 3.8.2.2  2000/08/21  21:35:16  tisseran
 * *** empty log message ***
 *
 * Revision 3.8.2.1  2000/08/21  14:04:15  tisseran
 * *** empty log message ***
 *
 * Revision 3.8  2000/05/22  15:23:15  schwarz
 * Added functions to retrieve and inspect the stream ID table of a file.
 *
 * Revision 3.7  2000/05/04  15:05:48  schwarz
 * SDIF Selection is now parsed automatically on opening a file,
 * and placed in file->Selection.
 * Moved SdifCheckFileFormat and SdifSignatureTab functions into
 * separate files SdifCheck and SdifSignatureTab.
 *
 * Revision 3.6  2000/04/26  15:31:24  schwarz
 * Added SdifGenInitCond for conditional initialisation.
 *
 * Revision 3.5  2000/03/01  11:19:37  schwarz
 * Tough check for pipe on open.
 * Added SdifFCurrDataType.
 *
 * Revision 3.4  1999/09/28  10:37:00  schwarz
 * Added SdifCheckFileFormat to test if a file is in SDIF.
 *
 * Revision 3.3  1999/09/20  13:21:58  schwarz
 * Introduced user data and access functions SdifFAddUserData/GetUserData.
 *
 * Revision 3.2  1999/08/25  18:32:35  schwarz
 * Added cocoon-able comments with sentinel "DOC:" (on a single line).
 *
 * Revision 3.1  1999/03/14  10:56:51  virolle
 * SdifStdErr add
 *
 * Revision 2.3  1999/02/28  12:16:42  virolle
 * memory report
 *
 * Revision 2.2  1999/01/23  13:57:33  virolle
 * General Lists, and special chunk preparation to become frames
 *
 * Revision 2.1  1998/12/21  18:27:16  schwarz
 * Inserted copyright message.
 *
 * Revision 2.0  1998/11/29  11:41:41  virolle
 * - New management of interpretation errors.
 * - Alignement of frames with CNMAT (execpt specials Chunk 1NVT, 1TYP, 1IDS).
 * _ Sdif Header File has a Sdif format version.
 * - Matrices order in frames is not important now. (only one occurence of
 *   a Matrix Type in a Frame Type declaration )
 * - Hard coded predefined types more dynamic management.
 * - Standart streams (stdin, stdout, stderr) set as binary for Windows32 to
 *   have exactly the same result on each plateforme.
 *
 * Revision 1.6  1998/11/10  15:31:45  schwarz
 * Removed all 'extern' keywords for prototypes, since this is redundant
 * (function prototypes are automatically linked extern), and it
 * prohibits cocoon from generating an entry in the HTML documentation
 * for this function.
 *
 * Revision 1.5  1998/07/23  17:02:49  virolle
 * *** empty log message ***
 *
 * Revision 1.4  1998/05/14  09:50:35  schwarz
 * Added SdifCurrOneRowData to return a pointer to the raw data.
 * This can subsequently be used for SdifSetCurrOneRow.
 */

#ifndef _SDIFFILE_H
#define _SDIFFILE_H

#include "SdifGlobals.h"


/**
 * Get the matrix type definition defined in an SDIF file.  You have to have
 * loaded the ASCII chunks before to catch types defined in the file
 * itself.
 *
 * @ingroup types
 */
SdifMatrixTypeT *SdifFGetMatrixType(SdifFileT *file, SdifSignature sig);

/**
 * Get a frame type definition defined in an SDIF file.  You have to have
 * loaded the ASCII chunks before to catch types defined in the file
 * itself.
 *
 * @ingroup types
 */
SdifFrameTypeT* SdifFGetFrameType(SdifFileT *file, SdifSignature sig);


/*
// FUNCTION GROUP:	Error flag for file
*/

/*DOC: 
  Return number of errors present for file of level upto or more
  severe.  Example: SdifFNumErrors(f, eError) is true if an error or a
  fatal error occurred since opening the file, false if there were
  only warnings or remarks. */
int SdifFNumErrors (SdifFileT *SdifF, SdifErrorLevelET upto);


#endif /* _SdifFile_ */
