# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['samsung_galaxy_store']

package_data = \
{'': ['*']}

install_requires = \
['requests>=2.27.1,<3.0.0']

setup_kwargs = {
    'name': 'samsung-galaxy-store',
    'version': '0.1.3',
    'description': 'Samsung Galaxy Store analysis tools',
    'long_description': '# Samsung Galaxy Store\nPython module to scrape application data from the Samsung Galaxy Store.\n\n# Installation\n```\npip install samsung-galaxy-store\n```\n\n# Usage\nAvailable methods:\n- `get_categories()`: Retrieves the list of store categories.\n- `get_category_apps(...)`: Retrieves a list of apps for a specific category.\n- `get_app_details(...)`: Retrieves expanded metadata for a specific app using the app guid (i.e sku).\n- `get_app_reviews(...)`: Retrieves reviews for a specific app using the product id (i.e Samsung auto-generated numeric).\n\n## Get Categories\nRetrieves the list of store categories.\n\n### Example\n```\nstore = SamsungGalaxyStore()\ncategories: List[Category] = list(store.get_categories())\nfor category in categories:\n    print(category.__dict__)\n```\n\n### Results\n```\n{\'id\': \'G000046957\', \'translation_id\': \'MIDS_SAPPS_BUTTON_LEISURE_PUZZLES\', \'name\': \'Puzzle\', \'icon_url\': \'http://img.samsungapps.com/content/2019/0212/0134/uploadfile_20190212013457076.png\', \'watch_face\': False, \'content_id\': \'0000005171\'}\n{\'id\': \'G000046960\', \'translation_id\': \'MIDS_SAPPS_BUTTON_ONLINE_GAMES\', \'name\': \'Online Game\', \'icon_url\': \'http://img.samsungapps.com/content/2019/0212/0135/uploadfile_20190212013557731.png\', \'watch_face\': False, \'content_id\': \'0000005172\'}\n{\'id\': \'G000046961\', \'translation_id\': \'MIDS_SAPPS_BUTTON_ACTION_ADVENTURE\', \'name\': \'Action/Adventure\', \'icon_url\': \'http://img.samsungapps.com/content/2019/0212/0136/uploadfile_20190212013636628.png\', \'watch_face\': False, \'content_id\': \'0000005173\'}\n```\n\n## Get Category Apps\nRetrieves a list of apps for a specific category. Options:\n- `category: Category` = The Samsung category with the id, format is "G0000XXXXX".\n- `start: int` = The starting offset in the category list, default is 1.\n- `end: int` = The ending offset in the category list, default is 500.\n\n### Example\n```\nstore = SamsungGalaxyStore()\ncategory: Category = Category("G000060951", None, None, None, False, None)\napps: List[AppSummary] = list(store.get_category_apps(category, end=3))\nfor app in apps:\n    print(app.__dict__)\n```\n\n### Results\n```\n{\'category_id\': \'G000060951\', \'category_name\': \'Music\', \'category_class\': \'G\', \'id\': \'000006109280\', \'name\': \'Tiles Hop - EDM Rush Ball & Endless Music Magic\', \'icon_url\': \'http://img.samsungapps.com/productNew/000006109280/IconImage_20220321044524279_NEW_WEB_ICON_135_135.png\', \'currency_symbol\': \'$\', \'price\': \'0.00\', \'discount_price\': \'0.00\', \'is_discount\': False, \'average_rating\': 3.0, \'release_date\': \'2022;01;13;\', \'content_type\': \'game\', \'guid\': \'com.GamesStore3D.TilesHopEndlessMusicMagic\', \'version\': \'2.1.1\', \'version_code\': \'1\', \'size\': 52878366, \'install_size\': 52878366, \'restricted_age\': \'0\', \'developer\': \'Poppy Challenge Games\', \'iap_support\': True}\n{\'category_id\': \'G000060951\', \'category_name\': \'Music\', \'category_class\': \'G\', \'id\': \'000005751609\', \'name\': \'Tiles Hop: EDM Rush!\', \'icon_url\': \'http://img.samsungapps.com/productNew/000005751609/IconImage_20210625042847048_NEW_WEB_ICON_135_135.png\', \'currency_symbol\': \'$\', \'price\': \'0.00\', \'discount_price\': \'0.00\', \'is_discount\': False, \'average_rating\': 4.0, \'release_date\': \'2021;06;14;\', \'content_type\': \'game\', \'guid\': \'Music.tiles.hop.hot\', \'version\': \'1.0\', \'version_code\': \'1\', \'size\': 51295176, \'install_size\': 51295176, \'restricted_age\': \'0\', \'developer\': \'VODOO GAMES\', \'iap_support\': False}\n{\'category_id\': \'G000060951\', \'category_name\': \'Music\', \'category_class\': \'G\', \'id\': \'000005250051\', \'name\': \'Drum Pad\', \'icon_url\': \'http://img.samsungapps.com/productNew/000005250051/IconImage_20210121025114863_NEW_WEB_ICON_135_135.png\', \'currency_symbol\': \'$\', \'price\': \'0.00\', \'discount_price\': \'0.00\', \'is_discount\': False, \'average_rating\': 4.5, \'release_date\': \'2020;09;24;\', \'content_type\': \'game\', \'guid\': \'cos.appofun_samfree.drumpad\', \'version\': \'Drum Pad Galaxy\', \'version_code\': \'1\', \'size\': 21914755, \'install_size\': 21914755, \'restricted_age\': \'4\', \'developer\': \'Free Beat Maker Machine\', \'iap_support\': False}\n```\n\n## Get App Details\nRetrieves expanded metadata for a specific app using the app guid (i.e sku). Options:\n- `guid: str` = The Samsung guid (i.e sku) for an app. The guid is set by the developer, but a common format is "com.company.app".\n\n### Example\n```\nstore = SamsungGalaxyStore()\napp: App = store.get_category_apps(guid="com.playrix.homescapes.samsung")\nprint(app)\n```\n\n### Results\n```\n{\'id\': \'000005514733\', \'name\': \'Homescapes\', \'icon_url\': \'http://img.samsungapps.com/productNew/000005514733/IconImage_20220505092438492_NEW_WEB_ICON.png\', \'currency_symbol\': \'$\', \'price\': 0.0, \'is_discount\': False, \'average_rating\': 4.5, \'content_type\': \'A\', \'guid\': \'com.playrix.homescapes.samsung\', \'version\': \'5.3.3\', \'restricted_age\': \'4\', \'iap_support\': True, \'developer\': {\'name\': \'Playrix\', \'url\': \'https://www.playrix.com\', \'phone\': \'896034189\', \'address\': \'RED OAK NORTH, SOUTH COUNTY BUSINESS PARK\', \'representative\': \'Mikhail Smachev\', \'contact_first_name\': \'PLR Worldwide Sales Limited\'}, \'description\': "Welcome to Homescapes, ...", \'release_notes\': "What\'s new:\\n- Bug fixes and improvements\\n\\nPlease update the game to the latest version.\\n\\nWEDDING MAKEOVER\\n• Save Emma\'s wedding!\\n• Change the character\'s style!\\n• Decorate the wedding venue!\\n\\nKNIGHT\'S TALE\\n• Help William join the Knight Club and decorate the yard with medieval decorations!\\n• Get the Knight\'s Castle decoration.\\n\\nALSO\\n• Woolly Season! Use the Golden Ticket to get a cute little lamb!\\n• Help Betty improve her smart home and meet a robot butler!", \'customer_support_email\': \'homescapes@playrix.com\', \'deeplink\': \'samsungapps://ProductDetail/com.playrix.homescapes.samsung?session_id=W_8EE1FEC49C2C61700D7D11650B83BDEC\', \'update_date\': \'2022.05.05\', \'permissions\': [\'storage\'], \'privacy_policy_url\': \'https://www.playrix.com/privacy/index.html\', \'youtube_url\': \'https://www.youtube.com/embed/9FlvCL8_4r8?hd=1&rel=0&autohide=1&showinfo=0&wmode=transparent\'}\n```\n\n\n\n## Get App Reviews\nRetrieves reviews for a specific app using the product id (i.e Samsung auto-generated numeric). Reviews are sorted by most recent. Options:\n- `product_id: str` = The Samsung generated numeric product id for an app.\n- `max_reviews: Optional[int]` = The max number of reviews to return, `None` of `0` for all reviews.\n\n### Example\n```\nstore = SamsungGalaxyStore()\nreviews: List[Review] = list(store.get_app_reviews(product_id="000005514733", max_reviews=3))\nfor review in reviews:\n    print(review)\n```\n\n### Results\n```\n{\'text\': \'3vj93\', \'user\': \'brad**\', \'updated_date\': \'2022.05.13\', \'stars\': 5.0, \'developer_responded\': False}\n{\'text\': \'I LOVE THIS GAME ❤\', \'user\': \'ruby**\', \'updated_date\': \'2022.05.12\', \'stars\': 5.0, \'developer_responded\': False}\n{\'text\': "Ex s d3 se rex wz ee\'s eeeed,,\\nxz\\nsix zzz x", \'user\': \'coya**\', \'updated_date\': \'2022.05.12\', \'stars\': 5.0, \'developer_responded\': False}\n```\n\n# CLI Usage\n```\nusage: store.py [-h] {categories,apps,app,reviews} ...\n\nLookup Samsung Galaxy Store information.\n\npositional arguments:\n  {categories,apps,app,reviews}\n    categories          Get store category information\n    apps                Get bestselling apps in a specific category.\n    app                 Get a specific app details using the guid (i.e sku)\n    reviews             Get reviews for a specific app using the product id (i.e number)\n\noptions:\n  -h, --help            show this help message and exit\n```\n\n### Get Categories\n```\n>>> python store.py categories\n\n{\'id\': \'G000046957\', \'translation_id\': \'MIDS_SAPPS_BUTTON_LEISURE_PUZZLES\', \'name\': \'Puzzle\', \'icon_url\': \'http://img.samsungapps.com/content/2019/0212/0134/uploadfile_20190212013457076.png\', \'watch_face\': False, \'content_id\': \'0000005171\'}\n{\'id\': \'G000046960\', \'translation_id\': \'MIDS_SAPPS_BUTTON_ONLINE_GAMES\', \'name\': \'Online Game\', \'icon_url\': \'http://img.samsungapps.com/content/2019/0212/0135/uploadfile_20190212013557731.png\', \'watch_face\': False, \'content_id\': \'0000005172\'}\n{\'id\': \'G000046961\', \'translation_id\': \'MIDS_SAPPS_BUTTON_ACTION_ADVENTURE\', \'name\': \'Action/Adventure\', \'icon_url\': \'http://img.samsungapps.com/content/2019/0212/0136/uploadfile_20190212013636628.png\', \'watch_face\': False, \'content_id\': \'0000005173\'}\n```\n\n### Get Category Apps\n```\n>>> python store.py apps G000060951 --max_apps 3\n\n{\'category_id\': \'G000060951\', \'category_name\': \'Music\', \'category_class\': \'G\', \'id\': \'000006109280\', \'name\': \'Tiles Hop - EDM Rush Ball & Endless Music Magic\', \'icon_url\': \'http://img.samsungapps.com/productNew/000006109280/IconImage_20220321044524279_NEW_WEB_ICON_135_135.png\', \'currency_symbol\': \'$\', \'price\': \'0.00\', \'discount_price\': \'0.00\', \'is_discount\': False, \'average_rating\': 3.0, \'release_date\': \'2022;01;13;\', \'content_type\': \'game\', \'guid\': \'com.GamesStore3D.TilesHopEndlessMusicMagic\', \'version\': \'2.1.1\', \'version_code\': \'1\', \'size\': 52878366, \'install_size\': 52878366, \'restricted_age\': \'0\', \'developer\': \'Poppy Challenge Games\', \'iap_support\': True}\n{\'category_id\': \'G000060951\', \'category_name\': \'Music\', \'category_class\': \'G\', \'id\': \'000005751609\', \'name\': \'Tiles Hop: EDM Rush!\', \'icon_url\': \'http://img.samsungapps.com/productNew/000005751609/IconImage_20210625042847048_NEW_WEB_ICON_135_135.png\', \'currency_symbol\': \'$\', \'price\': \'0.00\', \'discount_price\': \'0.00\', \'is_discount\': False, \'average_rating\': 4.0, \'release_date\': \'2021;06;14;\', \'content_type\': \'game\', \'guid\': \'Music.tiles.hop.hot\', \'version\': \'1.0\', \'version_code\': \'1\', \'size\': 51295176, \'install_size\': 51295176, \'restricted_age\': \'0\', \'developer\': \'VODOO GAMES\', \'iap_support\': False}\n{\'category_id\': \'G000060951\', \'category_name\': \'Music\', \'category_class\': \'G\', \'id\': \'000005250051\', \'name\': \'Drum Pad\', \'icon_url\': \'http://img.samsungapps.com/productNew/000005250051/IconImage_20210121025114863_NEW_WEB_ICON_135_135.png\', \'currency_symbol\': \'$\', \'price\': \'0.00\', \'discount_price\': \'0.00\', \'is_discount\': False, \'average_rating\': 4.5, \'release_date\': \'2020;09;24;\', \'content_type\': \'game\', \'guid\': \'cos.appofun_samfree.drumpad\', \'version\': \'Drum Pad Galaxy\', \'version_code\': \'1\', \'size\': 21914755, \'install_size\': 21914755, \'restricted_age\': \'4\', \'developer\': \'Free Beat Maker Machine\', \'iap_support\': False}\n```\n\n### Get App Details\n```\n>>> python store.py app \'com.playrix.homescapes.samsung\'\n\n{\'id\': \'000005514733\', \'name\': \'Homescapes\', \'icon_url\': \'http://img.samsungapps.com/productNew/000005514733/IconImage_20220505092438492_NEW_WEB_ICON.png\', \'currency_symbol\': \'$\', \'price\': 0.0, \'is_discount\': False, \'average_rating\': 4.5, \'content_type\': \'A\', \'guid\': \'com.playrix.homescapes.samsung\', \'version\': \'5.3.3\', \'restricted_age\': \'4\', \'iap_support\': True, \'developer\': {\'name\': \'Playrix\', \'url\': \'https://www.playrix.com\', \'phone\': \'896034189\', \'address\': \'RED OAK NORTH, SOUTH COUNTY BUSINESS PARK\', \'representative\': \'Mikhail Smachev\', \'contact_first_name\': \'PLR Worldwide Sales Limited\'}, \'description\': "Welcome to Homescapes, ...", \'release_notes\': "What\'s new:\\n- Bug fixes and improvements\\n\\nPlease update the game to the latest version.\\n\\nWEDDING MAKEOVER\\n• Save Emma\'s wedding!\\n• Change the character\'s style!\\n• Decorate the wedding venue!\\n\\nKNIGHT\'S TALE\\n• Help William join the Knight Club and decorate the yard with medieval decorations!\\n• Get the Knight\'s Castle decoration.\\n\\nALSO\\n• Woolly Season! Use the Golden Ticket to get a cute little lamb!\\n• Help Betty improve her smart home and meet a robot butler!", \'customer_support_email\': \'homescapes@playrix.com\', \'deeplink\': \'samsungapps://ProductDetail/com.playrix.homescapes.samsung?session_id=W_8EE1FEC49C2C61700D7D11650B83BDEC\', \'update_date\': \'2022.05.05\', \'permissions\': [\'storage\'], \'privacy_policy_url\': \'https://www.playrix.com/privacy/index.html\', \'youtube_url\': \'https://www.youtube.com/embed/9FlvCL8_4r8?hd=1&rel=0&autohide=1&showinfo=0&wmode=transparent\'}\n```\n\n### Get App Reviews\n```\n>>> python store.py reviews 000005514733 --max_reviews 3\n\n{\'text\': \'3vj93\', \'user\': \'brad**\', \'updated_date\': \'2022.05.13\', \'stars\': 5.0, \'developer_responded\': False}\n{\'text\': \'I LOVE THIS GAME ❤\', \'user\': \'ruby**\', \'updated_date\': \'2022.05.12\', \'stars\': 5.0, \'developer_responded\': False}\n{\'text\': "Ex s d3 se rex wz ee\'s eeeed,,\\nxz\\nsix zzz x", \'user\': \'coya**\', \'updated_date\': \'2022.05.12\', \'stars\': 5.0, \'developer_responded\': False}\n```',
    'author': 'Kevin Ramdath',
    'author_email': 'krpent@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/minormending/samsung-galaxy-store',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
