# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['ServiceWafConfiguration']


class ServiceWafConfiguration(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_http_versions: Optional[pulumi.Input[str]] = None,
                 allowed_methods: Optional[pulumi.Input[str]] = None,
                 allowed_request_content_type: Optional[pulumi.Input[str]] = None,
                 allowed_request_content_type_charset: Optional[pulumi.Input[str]] = None,
                 arg_length: Optional[pulumi.Input[int]] = None,
                 arg_name_length: Optional[pulumi.Input[int]] = None,
                 combined_file_sizes: Optional[pulumi.Input[int]] = None,
                 critical_anomaly_score: Optional[pulumi.Input[int]] = None,
                 crs_validate_utf8_encoding: Optional[pulumi.Input[bool]] = None,
                 error_anomaly_score: Optional[pulumi.Input[int]] = None,
                 high_risk_country_codes: Optional[pulumi.Input[str]] = None,
                 http_violation_score_threshold: Optional[pulumi.Input[int]] = None,
                 inbound_anomaly_score_threshold: Optional[pulumi.Input[int]] = None,
                 lfi_score_threshold: Optional[pulumi.Input[int]] = None,
                 max_file_size: Optional[pulumi.Input[int]] = None,
                 max_num_args: Optional[pulumi.Input[int]] = None,
                 notice_anomaly_score: Optional[pulumi.Input[int]] = None,
                 paranoia_level: Optional[pulumi.Input[int]] = None,
                 php_injection_score_threshold: Optional[pulumi.Input[int]] = None,
                 rce_score_threshold: Optional[pulumi.Input[int]] = None,
                 restricted_extensions: Optional[pulumi.Input[str]] = None,
                 restricted_headers: Optional[pulumi.Input[str]] = None,
                 rfi_score_threshold: Optional[pulumi.Input[int]] = None,
                 rule_exclusions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceWafConfigurationRuleExclusionArgs']]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceWafConfigurationRuleArgs']]]]] = None,
                 session_fixation_score_threshold: Optional[pulumi.Input[int]] = None,
                 sql_injection_score_threshold: Optional[pulumi.Input[int]] = None,
                 total_arg_length: Optional[pulumi.Input[int]] = None,
                 waf_id: Optional[pulumi.Input[str]] = None,
                 warning_anomaly_score: Optional[pulumi.Input[int]] = None,
                 xss_score_threshold: Optional[pulumi.Input[int]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## Import

        This is an example of the import command being applied to the resource named `fastly_service_waf_configuration.waf` The resource ID should be the WAF ID.

        ```sh
         $ pulumi import fastly:index/serviceWafConfiguration:ServiceWafConfiguration waf xxxxxxxxxxxxxxxxxxxx
        ```

         If Terraform is already managing a remote WAF configurations against a resource being imported then the user will be asked to remove it from the existing Terraform state. The following is an example of the Terraform state command to remove the resource named `fastly_service_waf_configuration.waf` from the Terraform state file. $ terraform state rm fastly_service_waf_configuration.waf

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] allowed_http_versions: Allowed HTTP versions.
        :param pulumi.Input[str] allowed_methods: A space-separated list of HTTP method names.
        :param pulumi.Input[str] allowed_request_content_type: Allowed request content types.
        :param pulumi.Input[str] allowed_request_content_type_charset: Allowed request content type charset.
        :param pulumi.Input[int] arg_length: The maximum number of arguments allowed.
        :param pulumi.Input[int] arg_name_length: The maximum allowed argument name length.
        :param pulumi.Input[int] combined_file_sizes: The maximum allowed size of all files.
        :param pulumi.Input[int] critical_anomaly_score: Score value to add for critical anomalies.
        :param pulumi.Input[bool] crs_validate_utf8_encoding: CRS validate UTF8 encoding.
        :param pulumi.Input[int] error_anomaly_score: Score value to add for error anomalies.
        :param pulumi.Input[str] high_risk_country_codes: A space-separated list of country codes in ISO 3166-1 (two-letter) format.
        :param pulumi.Input[int] http_violation_score_threshold: HTTP violation threshold.
        :param pulumi.Input[int] inbound_anomaly_score_threshold: Inbound anomaly threshold.
        :param pulumi.Input[int] lfi_score_threshold: Local file inclusion attack threshold.
        :param pulumi.Input[int] max_file_size: The maximum allowed file size, in bytes.
        :param pulumi.Input[int] max_num_args: The maximum number of arguments allowed.
        :param pulumi.Input[int] notice_anomaly_score: Score value to add for notice anomalies.
        :param pulumi.Input[int] paranoia_level: The configured paranoia level.
        :param pulumi.Input[int] php_injection_score_threshold: PHP injection threshold.
        :param pulumi.Input[int] rce_score_threshold: Remote code execution threshold.
        :param pulumi.Input[str] restricted_extensions: A space-separated list of allowed file extensions.
        :param pulumi.Input[str] restricted_headers: A space-separated list of allowed header names.
        :param pulumi.Input[int] rfi_score_threshold: Remote file inclusion attack threshold.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceWafConfigurationRuleExclusionArgs']]]] rule_exclusions: The Web Application Firewall's rule exclusions. Defined below
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceWafConfigurationRuleArgs']]]] rules: The Web Application Firewall's active rules. Defined below
        :param pulumi.Input[int] session_fixation_score_threshold: Session fixation attack threshold.
        :param pulumi.Input[int] sql_injection_score_threshold: SQL injection attack threshold.
        :param pulumi.Input[int] total_arg_length: The maximum size of argument names and values.
        :param pulumi.Input[str] waf_id: The ID of the Web Application Firewall that the configuration belongs to.
        :param pulumi.Input[int] warning_anomaly_score: Score value to add for warning anomalies.
        :param pulumi.Input[int] xss_score_threshold: XSS attack threshold.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['allowed_http_versions'] = allowed_http_versions
            __props__['allowed_methods'] = allowed_methods
            __props__['allowed_request_content_type'] = allowed_request_content_type
            __props__['allowed_request_content_type_charset'] = allowed_request_content_type_charset
            __props__['arg_length'] = arg_length
            __props__['arg_name_length'] = arg_name_length
            __props__['combined_file_sizes'] = combined_file_sizes
            __props__['critical_anomaly_score'] = critical_anomaly_score
            __props__['crs_validate_utf8_encoding'] = crs_validate_utf8_encoding
            __props__['error_anomaly_score'] = error_anomaly_score
            __props__['high_risk_country_codes'] = high_risk_country_codes
            __props__['http_violation_score_threshold'] = http_violation_score_threshold
            __props__['inbound_anomaly_score_threshold'] = inbound_anomaly_score_threshold
            __props__['lfi_score_threshold'] = lfi_score_threshold
            __props__['max_file_size'] = max_file_size
            __props__['max_num_args'] = max_num_args
            __props__['notice_anomaly_score'] = notice_anomaly_score
            __props__['paranoia_level'] = paranoia_level
            __props__['php_injection_score_threshold'] = php_injection_score_threshold
            __props__['rce_score_threshold'] = rce_score_threshold
            __props__['restricted_extensions'] = restricted_extensions
            __props__['restricted_headers'] = restricted_headers
            __props__['rfi_score_threshold'] = rfi_score_threshold
            __props__['rule_exclusions'] = rule_exclusions
            __props__['rules'] = rules
            __props__['session_fixation_score_threshold'] = session_fixation_score_threshold
            __props__['sql_injection_score_threshold'] = sql_injection_score_threshold
            __props__['total_arg_length'] = total_arg_length
            if waf_id is None:
                raise TypeError("Missing required property 'waf_id'")
            __props__['waf_id'] = waf_id
            __props__['warning_anomaly_score'] = warning_anomaly_score
            __props__['xss_score_threshold'] = xss_score_threshold
        super(ServiceWafConfiguration, __self__).__init__(
            'fastly:index/serviceWafConfiguration:ServiceWafConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_http_versions: Optional[pulumi.Input[str]] = None,
            allowed_methods: Optional[pulumi.Input[str]] = None,
            allowed_request_content_type: Optional[pulumi.Input[str]] = None,
            allowed_request_content_type_charset: Optional[pulumi.Input[str]] = None,
            arg_length: Optional[pulumi.Input[int]] = None,
            arg_name_length: Optional[pulumi.Input[int]] = None,
            combined_file_sizes: Optional[pulumi.Input[int]] = None,
            critical_anomaly_score: Optional[pulumi.Input[int]] = None,
            crs_validate_utf8_encoding: Optional[pulumi.Input[bool]] = None,
            error_anomaly_score: Optional[pulumi.Input[int]] = None,
            high_risk_country_codes: Optional[pulumi.Input[str]] = None,
            http_violation_score_threshold: Optional[pulumi.Input[int]] = None,
            inbound_anomaly_score_threshold: Optional[pulumi.Input[int]] = None,
            lfi_score_threshold: Optional[pulumi.Input[int]] = None,
            max_file_size: Optional[pulumi.Input[int]] = None,
            max_num_args: Optional[pulumi.Input[int]] = None,
            notice_anomaly_score: Optional[pulumi.Input[int]] = None,
            paranoia_level: Optional[pulumi.Input[int]] = None,
            php_injection_score_threshold: Optional[pulumi.Input[int]] = None,
            rce_score_threshold: Optional[pulumi.Input[int]] = None,
            restricted_extensions: Optional[pulumi.Input[str]] = None,
            restricted_headers: Optional[pulumi.Input[str]] = None,
            rfi_score_threshold: Optional[pulumi.Input[int]] = None,
            rule_exclusions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceWafConfigurationRuleExclusionArgs']]]]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceWafConfigurationRuleArgs']]]]] = None,
            session_fixation_score_threshold: Optional[pulumi.Input[int]] = None,
            sql_injection_score_threshold: Optional[pulumi.Input[int]] = None,
            total_arg_length: Optional[pulumi.Input[int]] = None,
            waf_id: Optional[pulumi.Input[str]] = None,
            warning_anomaly_score: Optional[pulumi.Input[int]] = None,
            xss_score_threshold: Optional[pulumi.Input[int]] = None) -> 'ServiceWafConfiguration':
        """
        Get an existing ServiceWafConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] allowed_http_versions: Allowed HTTP versions.
        :param pulumi.Input[str] allowed_methods: A space-separated list of HTTP method names.
        :param pulumi.Input[str] allowed_request_content_type: Allowed request content types.
        :param pulumi.Input[str] allowed_request_content_type_charset: Allowed request content type charset.
        :param pulumi.Input[int] arg_length: The maximum number of arguments allowed.
        :param pulumi.Input[int] arg_name_length: The maximum allowed argument name length.
        :param pulumi.Input[int] combined_file_sizes: The maximum allowed size of all files.
        :param pulumi.Input[int] critical_anomaly_score: Score value to add for critical anomalies.
        :param pulumi.Input[bool] crs_validate_utf8_encoding: CRS validate UTF8 encoding.
        :param pulumi.Input[int] error_anomaly_score: Score value to add for error anomalies.
        :param pulumi.Input[str] high_risk_country_codes: A space-separated list of country codes in ISO 3166-1 (two-letter) format.
        :param pulumi.Input[int] http_violation_score_threshold: HTTP violation threshold.
        :param pulumi.Input[int] inbound_anomaly_score_threshold: Inbound anomaly threshold.
        :param pulumi.Input[int] lfi_score_threshold: Local file inclusion attack threshold.
        :param pulumi.Input[int] max_file_size: The maximum allowed file size, in bytes.
        :param pulumi.Input[int] max_num_args: The maximum number of arguments allowed.
        :param pulumi.Input[int] notice_anomaly_score: Score value to add for notice anomalies.
        :param pulumi.Input[int] paranoia_level: The configured paranoia level.
        :param pulumi.Input[int] php_injection_score_threshold: PHP injection threshold.
        :param pulumi.Input[int] rce_score_threshold: Remote code execution threshold.
        :param pulumi.Input[str] restricted_extensions: A space-separated list of allowed file extensions.
        :param pulumi.Input[str] restricted_headers: A space-separated list of allowed header names.
        :param pulumi.Input[int] rfi_score_threshold: Remote file inclusion attack threshold.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceWafConfigurationRuleExclusionArgs']]]] rule_exclusions: The Web Application Firewall's rule exclusions. Defined below
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceWafConfigurationRuleArgs']]]] rules: The Web Application Firewall's active rules. Defined below
        :param pulumi.Input[int] session_fixation_score_threshold: Session fixation attack threshold.
        :param pulumi.Input[int] sql_injection_score_threshold: SQL injection attack threshold.
        :param pulumi.Input[int] total_arg_length: The maximum size of argument names and values.
        :param pulumi.Input[str] waf_id: The ID of the Web Application Firewall that the configuration belongs to.
        :param pulumi.Input[int] warning_anomaly_score: Score value to add for warning anomalies.
        :param pulumi.Input[int] xss_score_threshold: XSS attack threshold.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["allowed_http_versions"] = allowed_http_versions
        __props__["allowed_methods"] = allowed_methods
        __props__["allowed_request_content_type"] = allowed_request_content_type
        __props__["allowed_request_content_type_charset"] = allowed_request_content_type_charset
        __props__["arg_length"] = arg_length
        __props__["arg_name_length"] = arg_name_length
        __props__["combined_file_sizes"] = combined_file_sizes
        __props__["critical_anomaly_score"] = critical_anomaly_score
        __props__["crs_validate_utf8_encoding"] = crs_validate_utf8_encoding
        __props__["error_anomaly_score"] = error_anomaly_score
        __props__["high_risk_country_codes"] = high_risk_country_codes
        __props__["http_violation_score_threshold"] = http_violation_score_threshold
        __props__["inbound_anomaly_score_threshold"] = inbound_anomaly_score_threshold
        __props__["lfi_score_threshold"] = lfi_score_threshold
        __props__["max_file_size"] = max_file_size
        __props__["max_num_args"] = max_num_args
        __props__["notice_anomaly_score"] = notice_anomaly_score
        __props__["paranoia_level"] = paranoia_level
        __props__["php_injection_score_threshold"] = php_injection_score_threshold
        __props__["rce_score_threshold"] = rce_score_threshold
        __props__["restricted_extensions"] = restricted_extensions
        __props__["restricted_headers"] = restricted_headers
        __props__["rfi_score_threshold"] = rfi_score_threshold
        __props__["rule_exclusions"] = rule_exclusions
        __props__["rules"] = rules
        __props__["session_fixation_score_threshold"] = session_fixation_score_threshold
        __props__["sql_injection_score_threshold"] = sql_injection_score_threshold
        __props__["total_arg_length"] = total_arg_length
        __props__["waf_id"] = waf_id
        __props__["warning_anomaly_score"] = warning_anomaly_score
        __props__["xss_score_threshold"] = xss_score_threshold
        return ServiceWafConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedHttpVersions")
    def allowed_http_versions(self) -> pulumi.Output[str]:
        """
        Allowed HTTP versions.
        """
        return pulumi.get(self, "allowed_http_versions")

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> pulumi.Output[str]:
        """
        A space-separated list of HTTP method names.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedRequestContentType")
    def allowed_request_content_type(self) -> pulumi.Output[str]:
        """
        Allowed request content types.
        """
        return pulumi.get(self, "allowed_request_content_type")

    @property
    @pulumi.getter(name="allowedRequestContentTypeCharset")
    def allowed_request_content_type_charset(self) -> pulumi.Output[str]:
        """
        Allowed request content type charset.
        """
        return pulumi.get(self, "allowed_request_content_type_charset")

    @property
    @pulumi.getter(name="argLength")
    def arg_length(self) -> pulumi.Output[int]:
        """
        The maximum number of arguments allowed.
        """
        return pulumi.get(self, "arg_length")

    @property
    @pulumi.getter(name="argNameLength")
    def arg_name_length(self) -> pulumi.Output[int]:
        """
        The maximum allowed argument name length.
        """
        return pulumi.get(self, "arg_name_length")

    @property
    @pulumi.getter(name="combinedFileSizes")
    def combined_file_sizes(self) -> pulumi.Output[int]:
        """
        The maximum allowed size of all files.
        """
        return pulumi.get(self, "combined_file_sizes")

    @property
    @pulumi.getter(name="criticalAnomalyScore")
    def critical_anomaly_score(self) -> pulumi.Output[int]:
        """
        Score value to add for critical anomalies.
        """
        return pulumi.get(self, "critical_anomaly_score")

    @property
    @pulumi.getter(name="crsValidateUtf8Encoding")
    def crs_validate_utf8_encoding(self) -> pulumi.Output[bool]:
        """
        CRS validate UTF8 encoding.
        """
        return pulumi.get(self, "crs_validate_utf8_encoding")

    @property
    @pulumi.getter(name="errorAnomalyScore")
    def error_anomaly_score(self) -> pulumi.Output[int]:
        """
        Score value to add for error anomalies.
        """
        return pulumi.get(self, "error_anomaly_score")

    @property
    @pulumi.getter(name="highRiskCountryCodes")
    def high_risk_country_codes(self) -> pulumi.Output[str]:
        """
        A space-separated list of country codes in ISO 3166-1 (two-letter) format.
        """
        return pulumi.get(self, "high_risk_country_codes")

    @property
    @pulumi.getter(name="httpViolationScoreThreshold")
    def http_violation_score_threshold(self) -> pulumi.Output[int]:
        """
        HTTP violation threshold.
        """
        return pulumi.get(self, "http_violation_score_threshold")

    @property
    @pulumi.getter(name="inboundAnomalyScoreThreshold")
    def inbound_anomaly_score_threshold(self) -> pulumi.Output[int]:
        """
        Inbound anomaly threshold.
        """
        return pulumi.get(self, "inbound_anomaly_score_threshold")

    @property
    @pulumi.getter(name="lfiScoreThreshold")
    def lfi_score_threshold(self) -> pulumi.Output[int]:
        """
        Local file inclusion attack threshold.
        """
        return pulumi.get(self, "lfi_score_threshold")

    @property
    @pulumi.getter(name="maxFileSize")
    def max_file_size(self) -> pulumi.Output[int]:
        """
        The maximum allowed file size, in bytes.
        """
        return pulumi.get(self, "max_file_size")

    @property
    @pulumi.getter(name="maxNumArgs")
    def max_num_args(self) -> pulumi.Output[int]:
        """
        The maximum number of arguments allowed.
        """
        return pulumi.get(self, "max_num_args")

    @property
    @pulumi.getter(name="noticeAnomalyScore")
    def notice_anomaly_score(self) -> pulumi.Output[int]:
        """
        Score value to add for notice anomalies.
        """
        return pulumi.get(self, "notice_anomaly_score")

    @property
    @pulumi.getter(name="paranoiaLevel")
    def paranoia_level(self) -> pulumi.Output[int]:
        """
        The configured paranoia level.
        """
        return pulumi.get(self, "paranoia_level")

    @property
    @pulumi.getter(name="phpInjectionScoreThreshold")
    def php_injection_score_threshold(self) -> pulumi.Output[int]:
        """
        PHP injection threshold.
        """
        return pulumi.get(self, "php_injection_score_threshold")

    @property
    @pulumi.getter(name="rceScoreThreshold")
    def rce_score_threshold(self) -> pulumi.Output[int]:
        """
        Remote code execution threshold.
        """
        return pulumi.get(self, "rce_score_threshold")

    @property
    @pulumi.getter(name="restrictedExtensions")
    def restricted_extensions(self) -> pulumi.Output[str]:
        """
        A space-separated list of allowed file extensions.
        """
        return pulumi.get(self, "restricted_extensions")

    @property
    @pulumi.getter(name="restrictedHeaders")
    def restricted_headers(self) -> pulumi.Output[str]:
        """
        A space-separated list of allowed header names.
        """
        return pulumi.get(self, "restricted_headers")

    @property
    @pulumi.getter(name="rfiScoreThreshold")
    def rfi_score_threshold(self) -> pulumi.Output[int]:
        """
        Remote file inclusion attack threshold.
        """
        return pulumi.get(self, "rfi_score_threshold")

    @property
    @pulumi.getter(name="ruleExclusions")
    def rule_exclusions(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceWafConfigurationRuleExclusion']]]:
        """
        The Web Application Firewall's rule exclusions. Defined below
        """
        return pulumi.get(self, "rule_exclusions")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceWafConfigurationRule']]]:
        """
        The Web Application Firewall's active rules. Defined below
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="sessionFixationScoreThreshold")
    def session_fixation_score_threshold(self) -> pulumi.Output[int]:
        """
        Session fixation attack threshold.
        """
        return pulumi.get(self, "session_fixation_score_threshold")

    @property
    @pulumi.getter(name="sqlInjectionScoreThreshold")
    def sql_injection_score_threshold(self) -> pulumi.Output[int]:
        """
        SQL injection attack threshold.
        """
        return pulumi.get(self, "sql_injection_score_threshold")

    @property
    @pulumi.getter(name="totalArgLength")
    def total_arg_length(self) -> pulumi.Output[int]:
        """
        The maximum size of argument names and values.
        """
        return pulumi.get(self, "total_arg_length")

    @property
    @pulumi.getter(name="wafId")
    def waf_id(self) -> pulumi.Output[str]:
        """
        The ID of the Web Application Firewall that the configuration belongs to.
        """
        return pulumi.get(self, "waf_id")

    @property
    @pulumi.getter(name="warningAnomalyScore")
    def warning_anomaly_score(self) -> pulumi.Output[int]:
        """
        Score value to add for warning anomalies.
        """
        return pulumi.get(self, "warning_anomaly_score")

    @property
    @pulumi.getter(name="xssScoreThreshold")
    def xss_score_threshold(self) -> pulumi.Output[int]:
        """
        XSS attack threshold.
        """
        return pulumi.get(self, "xss_score_threshold")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

