window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = {"version": "0.9.5", "fields": ["qualname", "fullname", "annotation", "default_value", "signature", "bases", "doc"], "ref": "fullname", "documentStore": {"docs": {"lilit": {"fullname": "lilit", "modulename": "lilit", "kind": "module", "doc": "<h1 id=\"welcome-to-lilit\">Welcome to LiLit!</h1>\n\n<p>A Python package encoding the likelihood for LiteBIRD.</p>\n\n<p>In this repository I provide some basic examples of forecasting likelihoods for LiteBIRD. These are implemented to be used a <a href=\"https://github.com/CobayaSampler/cobaya\">Cobaya</a> context (<a href=\"https://arxiv.org/abs/2005.05290\">J. Torrado and A. Lewis, 2020</a>), which encapsulates <a href=\"https://github.com/cmbant/CosmoMC\">CosmoMC</a> in a Python framework. The idea of this repository is to ease the creation of common framework among different  LiteBIRDers, trying to homogenize the post-PTEP works as we recently discussed among the collaboration. The main product of this repository is the Likelihood for LiteBIRD (LiLit), which you can find <a href=\"lilit/likelihood.py\">here</a>. Within LiLit, the most relevant study cases of LiteBIRD (T, E, B) are already tested and working. So, if you need to work with those, you should not need to look into the actual definition of the likelihood function, since you can proptly start running your MCMCs. Despite this, you should provide to the likelihood some file where to find the proper LiteBIRD noise power spectra, given that LiLit is implementing a simple inverse noise weighting just as a place-holder for something more realistic. As regards lensing, LiLit will need you to pass the reconstruction noise, since its computation is not coded, thus there is no place-holder for lensing.</p>\n\n<p>This repository should also give to new Cobaya-users a good starting point to build upon (see <a href=\"examples/other_simple_likelihood.py\">this</a>). </p>\n\n<p>The repository can be found at <a href=\"https://github.com/ggalloni/LiLit\">https://github.com/ggalloni/LiLit</a>.</p>\n\n<h2 id=\"some-further-details-on-lilit\">Some further details on LiLit</h2>\n\n<p>If you want to start using LiLit, here are some further details on what you can do with it. Firstly, LiLit is independent of the number of fields considered and can be dynamically modified at declaration. Thus, it makes no difference if you want to use B-modes alone, or if you want to use CMB temperature, E-modes, lensing, etc. The only constraint is that the Boltzmann code you are using to provide the spectra should understand the fields you are asking to LiLit. Each of these fields may have their own $\\ell_{\nm min}$, $\\ell_{\nm max}$ and $f_{\nm sky}$. So, I implemented the possibility to pass all these quantities as lists to LiLit, which will then take case of the proper multipoles cuts and so on. The only requirement is that you should pass these lists following the order in which you passes the requested fields. For example:</p>\n\n<pre><code>fields = [\"t\", \"e\", \"b\"]\n\n# lmax = [lmaxTT, lmaxEE, lmaxBB]\nlmax = [1500, 1200, 900]\n\n# lmin = [lminTT, lminEE, lminBB]\nlmin = [20, 2, 2]\n\n# fsky = [fskyTT, fskyEE, fskyBB]\nfsky = [1.0, 0.8, 0.6]\n</code></pre>\n\n<p>If you do not want to pass custom fiducial power spectra for the fields you requested, you can exploit the fact that LiLit will internally compute every spectra according to _Planck_ 2018 best-fit values of the cosmological parameters. Note that if you requested B-modes, you must provide the value you want to assign to the tensor-to-scalar ratio $r$ (be careful on what pivot scale you are using here). If you do not pass the spectral index $n_t$, it will follow the standard consistency relation. </p>\n\n<p>As regards noise, as mentioned above you should pass realistic power spectra according to what you are working on. Just as a mere place-holder, LiLit will compute the inverse-weighted noise (<a href=\"https://arxiv.org/abs/2007.04241\">P. Campeti et al., 2020</a>) over each channel of LiteBIRD (<a href=\"https://arxiv.org/abs/2202.02773\">E. Allys et al., 2022</a>).</p>\n\n<p>Once you have fixed all these quantities, you are ready to define your likelihood. The only remaining things to decide are what approximation you want to use to compute the $\\chi^2$ and the actual name of the likelihood. LiLit implements the exact likelihood (<a href=\"https://arxiv.org/abs/0801.0554\">S. Hamimeche and A. Lewis, 2008</a>) and the Gaussian one. Thus, you can define your likelihood with:</p>\n\n<pre><code>name = exampleTEB\n\n# using the exact likelihood approximation\nexampleTEB = LiLit(name=name, fields=fields, like=\"exact\", nl_file=\"/path/to/noise.pkl\", lmax=lmax, fsky=fsky, debug=False)\n\n# using the Gaussian likelihood approximation\nexampleTEB = LiLit(name=name, fields=fields, like=\"gaussian\", nl_file=\"/path/to/noise.pkl\", lmax=lmax, fsky=fsky, debug=False)\n</code></pre>\n\n<p>Note that you may want to set debug to True in order to check that everything is OK.</p>\n\n<p>I tried to be as modular as possible so that you can plug whatever existing function you have. Also, this should make parallelization easier if you need it.</p>\n\n<h2 id=\"other-simple-likelihood\">Other simple likelihood</h2>\n\n<p><a href=\"examples/other_simple_likelihood.py\">Here</a>, you can find two very simple examples of the skeleton of a single-field likelihood and a two-field one. If you are new to Cobaya, you may want to have a look at these before jumping to LiLit. </p>\n\n<p>As regards the single-field likelihood, what you can find there is a very basic example of how to run Cobaya on a generic field X. Some parts of this may require additional attention before running, however this should give you an idea of how to work with this package. For instance, here I am considering a very simple case in which I do not need to pass anything to the likelihood class but the spectra, and in which the likelihood does not provide any derived parameters.</p>\n\n<h2 id=\"examples\">Examples</h2>\n\n<p>I provide also few working examples of the usage of LiLit. Some particular attention should be given to the dictionaries defined in the sampling scripts. If you are not familiar with their structure, have a look at Cobaya's <a href=\"https://cobaya.readthedocs.io/en/latest/\">documentation</a>. Then, I customized these to maximize accordance with the fiducial _Planck_ 2018 spectra. These also assume that you will be using <a href=\"https://github.com/cmbant/CAMB\">CAMB</a> (<a href=\"https://arxiv.org/abs/astro-ph/9911177\">A. Lewis et al., 2000</a>); for the <a href=\"https://github.com/lesgourg/class_public\">CLASS</a> (<a href=\"https://arxiv.org/abs/1104.2933\">D. Blas et al., 2011</a>) equivalent of this, refer again to documentiation, since some of the parameters are renamed. Note that Cobaya will understand whatever newly defined parameter you added to the Boltzmann code.</p>\n\n<p>In the parameters block of the sampling dictionary, parameters with a prior will be interpreted as open parameters, while all the others are essentially derived ones. Cobaya will figure out by itself whether it has to ask for some of them to the theory code (CAMB) or to other parameters. Also, it will figure out what parts of the routines need certain parameters. For example, you can pass $A_s$ to the likelihood function and do something with it, but at the same time it will pass it also to CAMB to compute the spectra.</p>\n\n<p>Once you have finished preparing your sampling.py file, you can run it simply by using: </p>\n\n<p><code>python sampling.py &gt; log.txt</code></p>\n\n<p>Sending the inline output to a text file might help in recovering information on how the run is going. If you want to run it parallely, you may want to use something like:</p>\n\n<p><code>mpirun -np 4 --cpus-per-proc 4 python sampling.py &gt; log.txt</code></p>\n\n<p>The number of processess translates on the number of chains that will be runned simultaneously.</p>\n\n<h2 id=\"dependencies\">Dependencies</h2>\n\n<ul>\n<li>cobaya</li>\n<li>numpy</li>\n<li>healpy</li>\n<li>pyyaml</li>\n<li>pickle</li>\n<li>matplotlib</li>\n<li>camb, or classy</li>\n</ul>\n\n<h2 id=\"documentation\">Documentation</h2>\n\n<p>The documentation can be found at <a href=\"https://ggalloni.github.io/LiLit\">https://ggalloni.github.io/LiLit</a>.</p>\n\n<h2 id=\"developing-the-code\">Developing the code</h2>\n\n<p>If you want to help developing the code, feel free to send a pull request. Also, feel free to write me so that we can discuss on eventual major developments.</p>\n\n<h2 id=\"support\">Support</h2>\n\n<p>For additional details on how Cobaya works, I suggest to see the <a href=\"https://cobaya.readthedocs.io/en/latest/\">documentation</a>, which is very good to find whatever is not working in you case. If you cannot find the problem there, feel free to open an issue.</p>\n"}, "lilit.likelihood": {"fullname": "lilit.likelihood", "modulename": "lilit.likelihood", "kind": "module", "doc": "<p></p>\n"}, "lilit.likelihood.LiLit": {"fullname": "lilit.likelihood.LiLit", "modulename": "lilit.likelihood", "qualname": "LiLit", "kind": "class", "doc": "<p>Class defining the Likelihood for LiteBIRD (LiLit).</p>\n\n<p>Within LiLit, the most relevant study cases of LiteBIRD (T, E, B) are already tested and working. So, if you need to work with those, you should not need to look into the actual definition of the likelihood function, since you can proptly start running your MCMCs. Despite this, you should provide to the likelihood some file where to find the proper LiteBIRD noise power spectra, given that LiLit is implementing a simple inverse noise weighting just as a place-holder for something more realistic. As regards lensing, LiLit will need you to pass the reconstruction noise, since its computation is not coded, thus there is no place-holder for lensing.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>name (str):</strong>  The name for the likelihood, used in the output. It is necessary to pass it to LiLit. (default: None).</li>\n<li><strong>fields (list):</strong>  List of fields in the data file (default: None).</li>\n<li><strong>lmax (int or list):</strong>  Maximum multipole to consider (default: None).</li>\n<li><strong>like (str, optional):</strong>  Type of likelihood to use (default: \"exact\"). Currently supports \"exact\" and \"gaussian\".</li>\n<li><strong>lmin (int or list):</strong>  Minimum multipole to consider (default: 2).</li>\n<li><strong>cl_file (str, optional):</strong>  Path to Cl file (default: None).</li>\n<li><strong>nl_file (str, optional):</strong>  Path to noise file (default: None).</li>\n<li><strong>experiment (str, optional):</strong>  Name of experiment (default: None).</li>\n<li><strong>nside (int, optional):</strong>  Nside of the map (default: None).</li>\n<li><strong>r (float, optional):</strong>  Tensor-to-scalar ratio (default: None).</li>\n<li><strong>nt (float, optional):</strong>  Tensor spectral tilt (default: None).</li>\n<li><strong>pivot_t (float, optional):</strong>  Pivot scale of the tensor primordial power spectrum (default: 0.01).</li>\n<li><strong>fsky (float or list):</strong>  Sky fraction (default: 1).</li>\n<li><strong>sep (str, optional):</strong>  Separator used in the data file (default: \"\").</li>\n<li><strong>debug (bool, optional):</strong>  If True, produces more verbose output (default: None).</li>\n</ul>\n\n<h6 id=\"attributes\">Attributes:</h6>\n\n<ul>\n<li><strong>fields (list):</strong>  List of fields in the data file.</li>\n<li><strong>n_fields (int):</strong>  Number of fields.</li>\n<li><strong>keys (list):</strong>  List of keywords for the dictionaries.</li>\n<li><strong>gauss_keys (list):</strong>  List of keywords for the Gaussian likelihood (4-points).</li>\n<li><strong>sigma2 (np.ndarray):</strong>  Array of covariances for the Gaussian likelihood case.</li>\n<li><strong>lmax (int or list):</strong>  List of lmax values.</li>\n<li><strong>lmaxes (dict):</strong>  Dictionary of lmax values.</li>\n<li><strong>fsky (int or list):</strong>  List of fsky values.</li>\n<li><strong>fskies (dict):</strong>  Dictionary of fsky values.</li>\n<li><strong>lmin (int or list):</strong>  Minimum multipole to consider.</li>\n<li><strong>lmins (dict):</strong>  Dictionary of lmin values.</li>\n<li><strong>like (str):</strong>  Type of likelihood to use.</li>\n<li><strong>cl_file (str):</strong>  Path to Cl file.</li>\n<li><strong>fiduCLS (dict):</strong>  Dictionary of fiducial Cls.</li>\n<li><strong>noiseCLS (dict):</strong>  Dictionary of noise Cls.</li>\n<li><strong>fiduCOV (np.ndarray):</strong>  Fiducial covariance matrix obtained from the corresponding dictionary.</li>\n<li><strong>noiseCOV (np.ndarray):</strong>  Noise covariance matrix obtained from the corresponding dictionary.</li>\n<li><strong>data (np.ndarray):</strong>  Data vector obtained by summing fiduCOV + noiseCOV.</li>\n<li><strong>cobaCLS (dict):</strong>  Dictionary of Cobaya Cls.</li>\n<li><strong>cobaCOV (np.ndarray):</strong>  Cobaya covariance matrix obtained from the corresponding dictionary.</li>\n<li><strong>coba (np.ndarray):</strong>  Cobaya vector obtained by summing cobaCOV + noiseCOV.</li>\n<li><strong>nl_file (str):</strong>  Path to noise file.</li>\n<li><strong>experiment (str):</strong>  Name of experiment.</li>\n<li><strong>nside (int):</strong>  Nside of the map.</li>\n<li><strong>r (float):</strong>  Tensor-to-scalar ratio.</li>\n<li><strong>nt (float):</strong>  Tensor spectral tilt.</li>\n<li><strong>pivot_t (float):</strong>  Pivot scale of the tensor primordial power spectrum.</li>\n<li><strong>sep (str):</strong>  Separator used in the data file.</li>\n<li><strong>debug (bool):</strong>  If True, produces more output.</li>\n</ul>\n", "bases": "cobaya.likelihood.Likelihood"}, "lilit.likelihood.LiLit.__init__": {"fullname": "lilit.likelihood.LiLit.__init__", "modulename": "lilit.likelihood", "qualname": "LiLit.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">name</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">fields</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">lmax</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">like</span><span class=\"o\">=</span><span class=\"s1\">&#39;exact&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">lmin</span><span class=\"o\">=</span><span class=\"mi\">2</span>,</span><span class=\"param\">\t<span class=\"n\">cl_file</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">nl_file</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">experiment</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">nside</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">r</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">nt</span><span class=\"o\">=</span><span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">pivot_t</span><span class=\"o\">=</span><span class=\"mf\">0.01</span>,</span><span class=\"param\">\t<span class=\"n\">fsky</span><span class=\"o\">=</span><span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">sep</span><span class=\"o\">=</span><span class=\"s1\">&#39;&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">debug</span><span class=\"o\">=</span><span class=\"kc\">None</span></span>)</span>"}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"fullname": "lilit.likelihood.LiLit.set_lmin_lmax_fsky", "modulename": "lilit.likelihood", "qualname": "LiLit.set_lmin_lmax_fsky", "kind": "function", "doc": "<p>Take lmin, lmax and fsky parameters and set the corresponding attributes.</p>\n\n<p>Sets the minimum multipole, the maximum multipole and the sky fraction. This handles automatically the case of a single value or a list of values. Note that the lmin, lmax and fsky for the cross-correlations are set to the geometrical mean of the lmin, lmax and fsky of the two fields. This approximation has been tested and found to be accurate, at least assuming that the two masks of the two considered multipoles are very overlapped.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>lmin (int or list):</strong>  Value or list of values of lmin.</li>\n<li><strong>lmax (int or list):</strong>  Value or list of values of lmax.</li>\n<li><strong>fsky (float or list):</strong>  Value or list of values of fsky.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">lmin</span>, </span><span class=\"param\"><span class=\"n\">lmax</span>, </span><span class=\"param\"><span class=\"n\">fsky</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "lilit.likelihood.LiLit.cov_filling": {"fullname": "lilit.likelihood.LiLit.cov_filling", "modulename": "lilit.likelihood", "qualname": "LiLit.cov_filling", "kind": "function", "doc": "<p>Fill covariance matrix with appropriate spectra.</p>\n\n<p>Computes the covariance matrix once given a dictionary. Returns the covariance matrix of the considered fields, in a shape equal to (num_fields x num_fields x lmax). Note that if more than one lmax, or lmin, is specified, there will be null values in the matrices, making them singular. This will be handled in another method.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>cov_dict (dict):</strong>  The input dictionary of spectra.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">cov_dict</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "lilit.likelihood.LiLit.get_keys": {"fullname": "lilit.likelihood.LiLit.get_keys", "modulename": "lilit.likelihood", "qualname": "LiLit.get_keys", "kind": "function", "doc": "<p>Extracts the keys that has to be used as a function of the requested fields. These will be the usual 2-points, e.g., tt, te, ee, etc.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "lilit.likelihood.LiLit.get_Gauss_keys": {"fullname": "lilit.likelihood.LiLit.get_Gauss_keys", "modulename": "lilit.likelihood", "qualname": "LiLit.get_Gauss_keys", "kind": "function", "doc": "<p>Find the proper dictionary keys for the requested fields.</p>\n\n<p>Extracts the keys that has to be used as a function of the requested fields for the Gaussian likelihood. Indeed, the Gaussian likelihood is computed using 4-points, so the keys are different. E.g., there will be keys such as tttt, ttee, tete, etc.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "lilit.likelihood.LiLit.find_spectrum": {"fullname": "lilit.likelihood.LiLit.find_spectrum", "modulename": "lilit.likelihood", "qualname": "LiLit.find_spectrum", "kind": "function", "doc": "<p>Find a spectrum in a given dictionary.</p>\n\n<p>Returns the corresponding power sepctrum for a given key. If the key is not found, it will try to find the reverse key. Otherwise it will fill the array with zeros.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>input_dict (dict):</strong>  Dictionary where you want to search for keys.</li>\n<li><strong>key (str):</strong>  Key to search for.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">input_dict</span>, </span><span class=\"param\"><span class=\"n\">key</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "lilit.likelihood.LiLit.sigma": {"fullname": "lilit.likelihood.LiLit.sigma", "modulename": "lilit.likelihood", "qualname": "LiLit.sigma", "kind": "function", "doc": "<p>Define the covariance matrix for the Gaussian case.</p>\n\n<p>In case of Gaussian likelihood, this returns the covariance matrix needed for the computation of the chi2. Note that the inversion is done in a separate funciton.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>keys (dict):</strong>  Keys for the covariance elements.</li>\n<li><strong>fiduDICT (dict):</strong>  Dictionary with the fiducial spectra.</li>\n<li><strong>noiseDICT (dict):</strong>  Dictionary with the noise spectra.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">keys</span>, </span><span class=\"param\"><span class=\"n\">fiduDICT</span>, </span><span class=\"param\"><span class=\"n\">noiseDICT</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "lilit.likelihood.LiLit.inv_sigma": {"fullname": "lilit.likelihood.LiLit.inv_sigma", "modulename": "lilit.likelihood", "qualname": "LiLit.inv_sigma", "kind": "function", "doc": "<p>Invert the covariance matrix of the Gaussian case.</p>\n\n<p>Inverts the previously calculated sigma ndarray. Note that some elements may be null, thus the covariance may be singular. If so, this also reduces the dimension of the matrix by deleting the corresponding row and column.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>ndarray (np.ndarray):</strong>  (self.n x self.n x self.lmax+1) ndarray with the previously computed sigma (not inverted).</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">sigma</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "lilit.likelihood.LiLit.get_reduced_data": {"fullname": "lilit.likelihood.LiLit.get_reduced_data", "modulename": "lilit.likelihood", "qualname": "LiLit.get_reduced_data", "kind": "function", "doc": "<p>Find the reduced data eliminating the singularity of the matrix.</p>\n\n<p>Cuts the row and column corresponding to a zero diagonal value. Indeed, in case of different lmax, or lmin, for the fields, you will have singular marices.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>ndarray (np.ndarray):</strong>  A ndarray containing the covariance matrices, with some singular ones.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">mat</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "lilit.likelihood.LiLit.CAMBres2dict": {"fullname": "lilit.likelihood.LiLit.CAMBres2dict", "modulename": "lilit.likelihood", "qualname": "LiLit.CAMBres2dict", "kind": "function", "doc": "<p>Takes the CAMB result product from get_cmb_power_spectra and convert it to a dictionary with the proper keys.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>camb_results (CAMBdata):</strong>  CAMB result product from the method get_cmb_power_spectra.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">camb_results</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "lilit.likelihood.LiLit.txt2dict": {"fullname": "lilit.likelihood.LiLit.txt2dict", "modulename": "lilit.likelihood", "qualname": "LiLit.txt2dict", "kind": "function", "doc": "<p>Takes a txt file and convert it to a dictionary. This requires a way to map the columns to the keys. Also, it is possible to apply an ell factor to the Cls.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>txt (str):</strong>  Path to txt file containing the spectra as columns.</li>\n<li><strong>mapping (dict):</strong>  Dictionary containing the mapping. Keywords will become the new keywords and values represent the index of the corresponding column.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">txt</span>, </span><span class=\"param\"><span class=\"n\">mapping</span><span class=\"o\">=</span><span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">apply_ellfactor</span><span class=\"o\">=</span><span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "lilit.likelihood.LiLit.prod_fidu": {"fullname": "lilit.likelihood.LiLit.prod_fidu", "modulename": "lilit.likelihood", "qualname": "LiLit.prod_fidu", "kind": "function", "doc": "<p>Produce fiducial spectra or read the input ones.</p>\n\n<p>If the user has not provided a Cl file, this function will produce the fiducial power spectra starting from the CAMB inifile for Planck2018. The extra keywords defined will maximize the accordance between the fiducial Cls and the ones obtained from Cobaya. If B-modes are requested, the tensor-to-scalar ratio and the spectral tilt will be set to the requested values. Note that if you do not provide a tilt, this will follow the standard single-field consistency relation. If instead you provide a custom file, stores that.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "lilit.likelihood.LiLit.prod_noise": {"fullname": "lilit.likelihood.LiLit.prod_noise", "modulename": "lilit.likelihood", "qualname": "LiLit.prod_noise", "kind": "function", "doc": "<p>Produce noise power spectra or read the input ones.</p>\n\n<p>If the user has not provided a noise file, this function will produce the noise power spectra for a given experiment with inverse noise weighting of white noise in each channel (TT, EE, BB). Note that you may want to have a look at the procedure since it is merely a place-holder. Indeed, you should provide a more realistic file from which to read the noise spectra, given that inverse noise weighting severely underestimates the amount of noise. If instead you provide the proper custom file, this method stores that.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "lilit.likelihood.LiLit.initialize": {"fullname": "lilit.likelihood.LiLit.initialize", "modulename": "lilit.likelihood", "qualname": "LiLit.initialize", "kind": "function", "doc": "<p>Initializes the fiducial spectra and the noise power spectra.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "lilit.likelihood.LiLit.get_requirements": {"fullname": "lilit.likelihood.LiLit.get_requirements", "modulename": "lilit.likelihood", "qualname": "LiLit.get_requirements", "kind": "function", "doc": "<p>Defines requirements of the likelihood, specifying quantities calculated by a theory code are needed. Note that you may want to change the overall keyword from 'Cl' to 'unlensed_Cl' if you want to work without considering lensing.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "lilit.likelihood.LiLit.data_vector": {"fullname": "lilit.likelihood.LiLit.data_vector", "modulename": "lilit.likelihood", "qualname": "LiLit.data_vector", "kind": "function", "doc": "<p>Get data vector from the covariance matrix.</p>\n\n<p>Extracts the data vector necessary for the Gaussian case. Note that this will cut the null value since some may be null when the fields have different values for lmax.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>cov (np.ndarray):</strong>  A ndarray containing the covariance matrices, with some null ones.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">cov</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "lilit.likelihood.LiLit.chi_exact": {"fullname": "lilit.likelihood.LiLit.chi_exact", "modulename": "lilit.likelihood", "qualname": "LiLit.chi_exact", "kind": "function", "doc": "<p>Computes proper chi-square term for the exact likelihood case.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>i (int, optional):</strong>  ell index if needed. Defaults to 0.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">i</span><span class=\"o\">=</span><span class=\"mi\">0</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "lilit.likelihood.LiLit.chi_gaussian": {"fullname": "lilit.likelihood.LiLit.chi_gaussian", "modulename": "lilit.likelihood", "qualname": "LiLit.chi_gaussian", "kind": "function", "doc": "<p>Computes proper chi-square term for the Gaussian likelihood case.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>i (int, optional):</strong>  ell index if needed. Defaults to 0.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">i</span><span class=\"o\">=</span><span class=\"mi\">0</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "lilit.likelihood.LiLit.compute_chi_part": {"fullname": "lilit.likelihood.LiLit.compute_chi_part", "modulename": "lilit.likelihood", "qualname": "LiLit.compute_chi_part", "kind": "function", "doc": "<p>Chooses which chi-square term to compute.</p>\n\n<h6 id=\"arguments\">Arguments:</h6>\n\n<ul>\n<li><strong>i (int, optional):</strong>  ell index if needed. Defaults to 0.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">i</span><span class=\"o\">=</span><span class=\"mi\">0</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "lilit.likelihood.LiLit.log_likelihood": {"fullname": "lilit.likelihood.LiLit.log_likelihood", "modulename": "lilit.likelihood", "qualname": "LiLit.log_likelihood", "kind": "function", "doc": "<p>Computes the log likelihood.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, "lilit.likelihood.LiLit.logp": {"fullname": "lilit.likelihood.LiLit.logp", "modulename": "lilit.likelihood", "qualname": "LiLit.logp", "kind": "function", "doc": "<p>Gets the log likelihood and pass it to Cobaya to carry on the MCMC process.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"o\">**</span><span class=\"n\">params_values</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}}, "docInfo": {"lilit": {"qualname": 0, "fullname": 1, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 1367}, "lilit.likelihood": {"qualname": 0, "fullname": 2, "annotation": 0, "default_value": 0, "signature": 0, "bases": 0, "doc": 3}, "lilit.likelihood.LiLit": {"qualname": 1, "fullname": 3, "annotation": 0, "default_value": 0, "signature": 0, "bases": 3, "doc": 797}, "lilit.likelihood.LiLit.__init__": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 180, "bases": 0, "doc": 3}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"qualname": 5, "fullname": 7, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 152}, "lilit.likelihood.LiLit.cov_filling": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 17, "bases": 0, "doc": 90}, "lilit.likelihood.LiLit.get_keys": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 31}, "lilit.likelihood.LiLit.get_Gauss_keys": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 60}, "lilit.likelihood.LiLit.find_spectrum": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 22, "bases": 0, "doc": 80}, "lilit.likelihood.LiLit.sigma": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 26, "bases": 0, "doc": 87}, "lilit.likelihood.LiLit.inv_sigma": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 82}, "lilit.likelihood.LiLit.get_reduced_data": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 69}, "lilit.likelihood.LiLit.CAMBres2dict": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 17, "bases": 0, "doc": 49}, "lilit.likelihood.LiLit.txt2dict": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 37, "bases": 0, "doc": 87}, "lilit.likelihood.LiLit.prod_fidu": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 104}, "lilit.likelihood.LiLit.prod_noise": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 106}, "lilit.likelihood.LiLit.initialize": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 12}, "lilit.likelihood.LiLit.get_requirements": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 40}, "lilit.likelihood.LiLit.data_vector": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 16, "bases": 0, "doc": 69}, "lilit.likelihood.LiLit.chi_exact": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 36}, "lilit.likelihood.LiLit.chi_gaussian": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 36}, "lilit.likelihood.LiLit.compute_chi_part": {"qualname": 4, "fullname": 6, "annotation": 0, "default_value": 0, "signature": 21, "bases": 0, "doc": 33}, "lilit.likelihood.LiLit.log_likelihood": {"qualname": 3, "fullname": 5, "annotation": 0, "default_value": 0, "signature": 11, "bases": 0, "doc": 7}, "lilit.likelihood.LiLit.logp": {"qualname": 2, "fullname": 4, "annotation": 0, "default_value": 0, "signature": 19, "bases": 0, "doc": 18}}, "length": 24, "save": true}, "index": {"qualname": {"root": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.__init__": {"tf": 1}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1}, "lilit.likelihood.LiLit.sigma": {"tf": 1}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}, "lilit.likelihood.LiLit.initialize": {"tf": 1}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}, "lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}, "lilit.likelihood.LiLit.log_likelihood": {"tf": 1}, "lilit.likelihood.LiLit.logp": {"tf": 1}}, "df": 22}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"lilit.likelihood.LiLit.log_likelihood": {"tf": 1}}, "df": 1}}}}}}}}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "x": {"docs": {"lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "g": {"docs": {"lilit.likelihood.LiLit.log_likelihood": {"tf": 1}}, "df": 1, "p": {"docs": {"lilit.likelihood.LiLit.logp": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit.initialize": {"tf": 1}}, "df": 1}}}}}}}}, "v": {"docs": {"lilit.likelihood.LiLit.inv_sigma": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 1}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"lilit.likelihood.LiLit.find_spectrum": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"lilit.likelihood.LiLit.sigma": {"tf": 1}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}}, "df": 2}}}}}, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "y": {"docs": {"lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit.likelihood.LiLit.cov_filling": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"lilit.likelihood.LiLit.find_spectrum": {"tf": 1}}, "df": 1}}, "d": {"docs": {}, "df": 0, "u": {"docs": {"lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {"lilit.likelihood.LiLit.cov_filling": {"tf": 1}}, "df": 1}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"2": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1}}, "df": 1}}}}}, "docs": {}, "df": 0}}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {"lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}}, "df": 3}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1}}, "df": 4}}, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}}, "df": 1}}}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}}, "df": 1}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit.get_requirements": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"2": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 1}}}}}, "docs": {}, "df": 0}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"lilit.likelihood.LiLit.prod_fidu": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 1}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.chi_exact": {"tf": 1}}, "df": 1}}}}}}}, "fullname": {"root": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.__init__": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_keys": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.sigma": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.initialize": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.data_vector": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.chi_exact": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.log_likelihood": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.logp": {"tf": 1.4142135623730951}}, "df": 24}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"lilit.likelihood": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.__init__": {"tf": 1}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1}, "lilit.likelihood.LiLit.sigma": {"tf": 1}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}, "lilit.likelihood.LiLit.initialize": {"tf": 1}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}, "lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}, "lilit.likelihood.LiLit.log_likelihood": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.logp": {"tf": 1}}, "df": 23}}}}}}}}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "x": {"docs": {"lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "g": {"docs": {"lilit.likelihood.LiLit.log_likelihood": {"tf": 1}}, "df": 1, "p": {"docs": {"lilit.likelihood.LiLit.logp": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit.initialize": {"tf": 1}}, "df": 1}}}}}}}}, "v": {"docs": {"lilit.likelihood.LiLit.inv_sigma": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 1}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"lilit.likelihood.LiLit.find_spectrum": {"tf": 1}}, "df": 1}}}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"lilit.likelihood.LiLit.sigma": {"tf": 1}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}}, "df": 2}}}}}, "f": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "y": {"docs": {"lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit.likelihood.LiLit.cov_filling": {"tf": 1}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"lilit.likelihood.LiLit.find_spectrum": {"tf": 1}}, "df": 1}}, "d": {"docs": {}, "df": 0, "u": {"docs": {"lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {"lilit.likelihood.LiLit.cov_filling": {"tf": 1}}, "df": 1}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"2": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1}}, "df": 1}}}}}, "docs": {}, "df": 0}}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {"lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}}, "df": 3}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1}}, "df": 4}}, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}}, "df": 1}}}}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}}, "df": 2}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}}, "df": 1}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit.get_requirements": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 2}}}}, "t": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"2": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 1}}}}}, "docs": {}, "df": 0}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"lilit.likelihood.LiLit.prod_fidu": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 1}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.chi_exact": {"tf": 1}}, "df": 1}}}}}}}, "annotation": {"root": {"docs": {}, "df": 0}}, "default_value": {"root": {"docs": {}, "df": 0}}, "signature": {"root": {"0": {"1": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1}}, "df": 1}, "docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1}, "lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}}, "df": 4}, "1": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1}}, "df": 1}, "2": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1}}, "df": 1}, "3": {"9": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 2}}, "df": 1}, "docs": {}, "df": 0}, "docs": {"lilit.likelihood.LiLit.__init__": {"tf": 11.958260743101398}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 4.69041575982343}, "lilit.likelihood.LiLit.cov_filling": {"tf": 3.7416573867739413}, "lilit.likelihood.LiLit.get_keys": {"tf": 3.1622776601683795}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 3.1622776601683795}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 4.242640687119285}, "lilit.likelihood.LiLit.sigma": {"tf": 4.69041575982343}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 3.7416573867739413}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 3.7416573867739413}, "lilit.likelihood.LiLit.CAMBres2dict": {"tf": 3.7416573867739413}, "lilit.likelihood.LiLit.txt2dict": {"tf": 5.477225575051661}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 3.1622776601683795}, "lilit.likelihood.LiLit.prod_noise": {"tf": 3.1622776601683795}, "lilit.likelihood.LiLit.initialize": {"tf": 3.1622776601683795}, "lilit.likelihood.LiLit.get_requirements": {"tf": 3.1622776601683795}, "lilit.likelihood.LiLit.data_vector": {"tf": 3.7416573867739413}, "lilit.likelihood.LiLit.chi_exact": {"tf": 4.242640687119285}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 4.242640687119285}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 4.242640687119285}, "lilit.likelihood.LiLit.log_likelihood": {"tf": 3.1622776601683795}, "lilit.likelihood.LiLit.logp": {"tf": 4}}, "df": 21, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 3.1622776601683795}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1.4142135623730951}}, "df": 2}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.sigma": {"tf": 1}}, "df": 1}}}}}}}}, "l": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1}}, "df": 1}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1}}, "df": 1}}, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1.4142135623730951}}, "df": 1}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.sigma": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "y": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 2}}}}, "l": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "x": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 2}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 2}}}, "i": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1}}, "df": 1}}}}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 1}}}}}}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1}}, "df": 1}, "o": {"docs": {}, "df": 0, "v": {"docs": {"lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 2}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "b": {"docs": {"lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1}}, "df": 1}}}}}}}, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit.logp": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1}}, "df": 1, "x": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 1}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1}}, "df": 1}, "l": {"docs": {}, "df": 0, "f": {"docs": {"lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1}, "lilit.likelihood.LiLit.sigma": {"tf": 1}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}, "lilit.likelihood.LiLit.initialize": {"tf": 1}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}, "lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}, "lilit.likelihood.LiLit.log_likelihood": {"tf": 1}, "lilit.likelihood.LiLit.logp": {"tf": 1}}, "df": 20}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {"lilit.likelihood.LiLit.inv_sigma": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {"lilit.likelihood.LiLit.__init__": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {"lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}}, "df": 3, "n": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.find_spectrum": {"tf": 1}}, "df": 1}}}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {"lilit.likelihood.LiLit.find_spectrum": {"tf": 1}}, "df": 1, "s": {"docs": {"lilit.likelihood.LiLit.sigma": {"tf": 1}}, "df": 1}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}}, "df": 1}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 1}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit.logp": {"tf": 1}}, "df": 1}}}}}}}}, "bases": {"root": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {}, "df": 0, "a": {"docs": {"lilit.likelihood.LiLit": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}, "doc": {"root": {"0": {"1": {"docs": {"lilit.likelihood.LiLit": {"tf": 1}}, "df": 1}, "docs": {"lilit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}}, "df": 5}, "1": {"2": {"0": {"0": {"docs": {"lilit": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "5": {"0": {"0": {"docs": {"lilit": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}, "2": {"0": {"0": {"0": {"docs": {"lilit": {"tf": 1}}, "df": 1}, "8": {"docs": {"lilit": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "1": {"1": {"docs": {"lilit": {"tf": 1}}, "df": 1}, "8": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}, "docs": {}, "df": 0}, "2": {"0": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}, "2": {"docs": {"lilit": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {"lilit": {"tf": 1}}, "df": 1}, "docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.get_keys": {"tf": 1}}, "df": 3}, "4": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}}, "df": 3}, "6": {"docs": {"lilit": {"tf": 1}}, "df": 1}, "8": {"docs": {"lilit": {"tf": 1}}, "df": 1}, "9": {"0": {"0": {"docs": {"lilit": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"lilit": {"tf": 12.36931687685298}, "lilit.likelihood": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit": {"tf": 16.852299546352718}, "lilit.likelihood.LiLit.__init__": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 5.477225575051661}, "lilit.likelihood.LiLit.cov_filling": {"tf": 4.242640687119285}, "lilit.likelihood.LiLit.get_keys": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 2.449489742783178}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 4.898979485566356}, "lilit.likelihood.LiLit.sigma": {"tf": 5.477225575051661}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 4.242640687119285}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 4.242640687119285}, "lilit.likelihood.LiLit.CAMBres2dict": {"tf": 3.872983346207417}, "lilit.likelihood.LiLit.txt2dict": {"tf": 4.58257569495584}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 2.449489742783178}, "lilit.likelihood.LiLit.prod_noise": {"tf": 2.449489742783178}, "lilit.likelihood.LiLit.initialize": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.data_vector": {"tf": 4.242640687119285}, "lilit.likelihood.LiLit.chi_exact": {"tf": 3.872983346207417}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 3.872983346207417}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 3.872983346207417}, "lilit.likelihood.LiLit.log_likelihood": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.logp": {"tf": 1.7320508075688772}}, "df": 24, "w": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1, "l": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1.4142135623730951}}, "df": 3}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"lilit": {"tf": 2.6457513110645907}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}}, "df": 3}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 1}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1}}, "df": 3}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}, "n": {"docs": {"lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 1}}, "a": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 2.449489742783178}}, "df": 1, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lilit": {"tf": 1.7320508075688772}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1}}, "df": 3, "s": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 2}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}}}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {"lilit": {"tf": 2.8284271247461903}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1}, "lilit.likelihood.LiLit.sigma": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 10, "i": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.get_requirements": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"lilit": {"tf": 3.4641016151377544}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 2}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 11}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 3.3166247903554}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1.4142135623730951}}, "df": 4}}, "y": {"docs": {"lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {"lilit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit": {"tf": 1.7320508075688772}}, "df": 2, "o": {"docs": {"lilit": {"tf": 7.615773105863909}, "lilit.likelihood.LiLit": {"tf": 4.242640687119285}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1}, "lilit.likelihood.LiLit.txt2dict": {"tf": 2.449489742783178}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.logp": {"tf": 1.4142135623730951}}, "df": 17, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "o": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}, "h": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 8.306623862918075}, "lilit.likelihood.LiLit": {"tf": 4.898979485566356}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 3.4641016151377544}, "lilit.likelihood.LiLit.cov_filling": {"tf": 2.23606797749979}, "lilit.likelihood.LiLit.get_keys": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 2.6457513110645907}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 2}, "lilit.likelihood.LiLit.sigma": {"tf": 3}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 2.8284271247461903}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 2.449489742783178}, "lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.txt2dict": {"tf": 2.8284271247461903}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 3.4641016151377544}, "lilit.likelihood.LiLit.prod_noise": {"tf": 2.6457513110645907}, "lilit.likelihood.LiLit.initialize": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.data_vector": {"tf": 2.449489742783178}, "lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}, "lilit.likelihood.LiLit.log_likelihood": {"tf": 1}, "lilit.likelihood.LiLit.logp": {"tf": 1.4142135623730951}}, "df": 21, "s": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 2.8284271247461903}, "lilit.likelihood.LiLit.get_keys": {"tf": 1}}, "df": 2}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}}, "df": 4}}, "i": {"docs": {}, "df": 0, "r": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}, "n": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}, "m": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1}}, "df": 2}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 3.3166247903554}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.sigma": {"tf": 1}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 10}, "n": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 3.4641016151377544}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}, "lilit.likelihood.LiLit.sigma": {"tf": 1}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 12}, "n": {"docs": {"lilit.likelihood.LiLit.cov_filling": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}}, "df": 3}}}, "r": {"docs": {}, "df": 0, "y": {"docs": {"lilit.likelihood.LiLit.find_spectrum": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1.4142135623730951}}, "df": 2}}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}}, "e": {"docs": {"lilit.likelihood.LiLit.get_keys": {"tf": 1}}, "df": 1, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 3}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 2.449489742783178}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 3}}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}}, "df": 1}}, "r": {"docs": {}, "df": 0, "m": {"docs": {"lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}}, "df": 3}}}, "a": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 2, "s": {"docs": {"lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 2}}}}, "w": {"docs": {}, "df": 0, "o": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1.7320508075688772}}, "df": 2}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1.4142135623730951}}, "df": 2}}}, "x": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1.7320508075688772}}, "df": 2}}, "y": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.4142135623730951}}, "df": 1}}}, "t": {"docs": {"lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 2, "t": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 4.123105625617661}, "lilit.likelihood.LiLit": {"tf": 2.23606797749979}}, "df": 2}}}, "k": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit": {"tf": 1.4142135623730951}}, "df": 2, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 4}, "lilit.likelihood.LiLit": {"tf": 2.8284271247461903}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.sigma": {"tf": 1}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1}, "lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}, "lilit.likelihood.LiLit.log_likelihood": {"tf": 1}, "lilit.likelihood.LiLit.logp": {"tf": 1}}, "df": 9, "s": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 2.449489742783178}, "lilit.likelihood.LiLit": {"tf": 1.7320508075688772}}, "df": 2, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit": {"tf": 4}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 2.6457513110645907}}, "df": 2, "s": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 1.7320508075688772}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1}}, "df": 3}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 1}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "k": {"docs": {"lilit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 3}}, "g": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.log_likelihood": {"tf": 1}, "lilit.likelihood.LiLit.logp": {"tf": 1}}, "df": 3}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "x": {"docs": {"lilit": {"tf": 2.449489742783178}, "lilit.likelihood.LiLit": {"tf": 2}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 2.23606797749979}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 6, "t": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1}, "s": {"docs": {"lilit.likelihood.LiLit": {"tf": 1}}, "df": 1}}, "b": {"docs": {}, "df": 0, "b": {"docs": {"lilit": {"tf": 1}}, "df": 1}}, "+": {"1": {"docs": {"lilit.likelihood.LiLit.inv_sigma": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 2.23606797749979}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}}, "df": 5, "t": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1}}, "b": {"docs": {}, "df": 0, "b": {"docs": {"lilit": {"tf": 1}}, "df": 1}}, "s": {"docs": {"lilit.likelihood.LiLit": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {"lilit": {"tf": 4.58257569495584}, "lilit.likelihood.LiLit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.sigma": {"tf": 1}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.prod_noise": {"tf": 2.23606797749979}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 15, "r": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 3.605551275463989}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1}}, "df": 6}, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1}, "lilit.likelihood.LiLit.sigma": {"tf": 1}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}, "lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}}, "df": 13}}}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1}}, "df": 2}}}}, "n": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 2, "d": {"docs": {"lilit": {"tf": 3.3166247903554}, "lilit.likelihood.LiLit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 2.449489742783178}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.initialize": {"tf": 1}, "lilit.likelihood.LiLit.logp": {"tf": 1}}, "df": 10}, "y": {"docs": {"lilit": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lilit.likelihood.LiLit.cov_filling": {"tf": 1}}, "df": 1}}}}}}, "m": {"docs": {"lilit": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {"lilit": {"tf": 3.3166247903554}, "lilit.likelihood.LiLit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 5, "k": {"docs": {"lilit": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 1}}}}}}}, "l": {"docs": {"lilit": {"tf": 2}}, "df": 1, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "y": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}}}}}, "s": {"docs": {}, "df": 0, "o": {"docs": {"lilit": {"tf": 2.6457513110645907}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 3}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}, "l": {"docs": {"lilit": {"tf": 1.7320508075688772}}, "df": 1, "y": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 2}}}}}}}, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 1}}}}}}}, "t": {"docs": {"lilit": {"tf": 2.449489742783178}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 3, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 2}}}}}}}}}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 2}}}}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit.cov_filling": {"tf": 1}}, "df": 1}}}}}}}}, "l": {"docs": {}, "df": 0, "y": {"docs": {"lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 1}}}}, "d": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 1}}}}}}}}}}}}}, "p": {"docs": {"lilit": {"tf": 1}}, "df": 1, "y": {"docs": {"lilit": {"tf": 1.7320508075688772}}, "df": 1, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 2}}, "df": 1}}}}, "y": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "l": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 3}, "lilit.likelihood.LiLit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.logp": {"tf": 1}}, "df": 3, "e": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lilit": {"tf": 1}}, "df": 1, "s": {"docs": {"lilit": {"tf": 2.8284271247461903}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 2}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}, "y": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {"lilit.likelihood.LiLit": {"tf": 2}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 2, "/": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 2.449489742783178}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1.4142135623730951}}, "df": 4, "d": {"docs": {"lilit.likelihood.LiLit.prod_fidu": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 2}}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1.4142135623730951}}, "df": 2}, "e": {"docs": {"lilit.likelihood.LiLit.prod_fidu": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1.4142135623730951}}, "df": 2, "s": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}, "lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}, "lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}}, "df": 7}}}, "c": {"docs": {"lilit": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit.logp": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 1}}}}}}, "b": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"lilit": {"tf": 1}}, "df": 1}}, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}, "v": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"lilit.likelihood.LiLit.inv_sigma": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}}, "df": 1}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 2}}}}}}, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lilit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1}, "lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.initialize": {"tf": 1}}, "df": 7}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}}, "df": 1, "s": {"docs": {"lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}}, "df": 3}}}}}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 3}}, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"2": {"0": {"1": {"8": {"docs": {"lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {}, "df": 0}, "docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 2}}, "df": 2}}}, "c": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}, "k": {"docs": {}, "df": 0, "l": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}, "e": {"docs": {}, "df": 0, "r": {"docs": {"lilit": {"tf": 1}}, "df": 1}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {"lilit": {"tf": 2}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}}, "df": 4, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}}}}, "x": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1.7320508075688772}}, "df": 1, "s": {"docs": {"lilit": {"tf": 2}}, "df": 1}, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "b": {"docs": {"lilit": {"tf": 1.7320508075688772}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.chi_exact": {"tf": 1}}, "df": 3}}}, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit": {"tf": 2}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 2}}}}}}}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {"lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 1, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 3}}}}}}}, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 2}}}, "t": {"docs": {"lilit": {"tf": 2}}, "df": 1, "c": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}}, "df": 3}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}, "lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}}, "df": 5}, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit.sigma": {"tf": 1}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}}, "df": 2}}}}}}, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}}, "df": 1}}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"lilit": {"tf": 1}}, "df": 1, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {"lilit.likelihood.LiLit.cov_filling": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}}}, "e": {"docs": {"lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 2}}, "f": {"docs": {"lilit": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "r": {"docs": {"lilit": {"tf": 3.4641016151377544}, "lilit.likelihood.LiLit": {"tf": 2.6457513110645907}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.sigma": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}}, "df": 12, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1}}, "df": 3}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "w": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "k": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 2}}}}}}, "e": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1.7320508075688772}}, "df": 1}}, "o": {"docs": {}, "df": 0, "m": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 6}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 2.449489742783178}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}}, "df": 5}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 2.23606797749979}, "lilit.likelihood.LiLit": {"tf": 3.605551275463989}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1.7320508075688772}}, "df": 5}, "l": {"docs": {"lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1}}, "df": 2}}, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 2}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 2, "s": {"docs": {"lilit": {"tf": 3.1622776601683795}, "lilit.likelihood.LiLit": {"tf": 2.449489742783178}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 8}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.sigma": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.initialize": {"tf": 1}}, "df": 5}}}, "l": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "v": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.4142135623730951}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.sigma": {"tf": 1}}, "df": 1}}}}}}, "t": {"docs": {"lilit": {"tf": 1}}, "df": 1}, "x": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}, "g": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 6}}}}, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lilit.likelihood.LiLit.sigma": {"tf": 1}}, "df": 1}}}}}}, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}}}}}, "s": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "y": {"docs": {"lilit": {"tf": 2.449489742783178}, "lilit.likelihood.LiLit": {"tf": 2}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 2.23606797749979}}, "df": 3, "t": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}}, "df": 1}}, "e": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1}}, "b": {"docs": {}, "df": 0, "b": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}}, "df": 1, "o": {"docs": {}, "df": 0, "r": {"docs": {"lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "w": {"docs": {"lilit": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "l": {"docs": {"lilit": {"tf": 1.7320508075688772}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit": {"tf": 2.6457513110645907}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 2}}}}}, "i": {"docs": {"lilit": {"tf": 2.8284271247461903}, "lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}}, "df": 4, "n": {"docs": {"lilit": {"tf": 3.1622776601683795}, "lilit.likelihood.LiLit": {"tf": 2.23606797749979}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1}, "lilit.likelihood.LiLit.sigma": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 7, "t": {"docs": {"lilit.likelihood.LiLit": {"tf": 2.8284271247461903}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}}, "df": 5, "o": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1.4142135623730951}}, "df": 3}, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lilit.likelihood.LiLit.sigma": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {"lilit.likelihood.LiLit.inv_sigma": {"tf": 1}}, "df": 1, "s": {"docs": {"lilit.likelihood.LiLit.inv_sigma": {"tf": 1}}, "df": 1}, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit.likelihood.LiLit.inv_sigma": {"tf": 1}}, "df": 1}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}, "x": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}, "lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}}, "df": 5}, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 3}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "d": {"docs": {"lilit.likelihood.LiLit.prod_fidu": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 2}}}}}, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}}, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 4}}}, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit.initialize": {"tf": 1}}, "df": 1}}}}}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}}}, "s": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}}, "s": {"docs": {"lilit": {"tf": 3.605551275463989}, "lilit.likelihood.LiLit": {"tf": 2}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1}, "lilit.likelihood.LiLit.sigma": {"tf": 1}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 8, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}, "f": {"docs": {"lilit": {"tf": 3.605551275463989}, "lilit.likelihood.LiLit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 2}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1}, "lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}}, "df": 11}, "t": {"docs": {"lilit": {"tf": 3.3166247903554}, "lilit.likelihood.LiLit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}, "lilit.likelihood.LiLit.logp": {"tf": 1}}, "df": 7, "s": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "f": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}, "r": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1.4142135623730951}}, "df": 2, "e": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"lilit": {"tf": 2.23606797749979}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 2}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 3}}}}}}, "d": {"docs": {"lilit.likelihood.LiLit.prod_fidu": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1.4142135623730951}}, "df": 2, "y": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}}}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}}, "df": 1, "s": {"docs": {"lilit.likelihood.LiLit.get_requirements": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {"lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1.4142135623730951}}, "df": 4}}}}}}}, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1}, "lilit.likelihood.LiLit.sigma": {"tf": 1}}, "df": 3}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit.find_spectrum": {"tf": 1}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit.inv_sigma": {"tf": 1}}, "df": 1}, "d": {"docs": {"lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {"lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 2}}, "df": 1, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}}}, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 3}}}}, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}, "w": {"docs": {"lilit.likelihood.LiLit.inv_sigma": {"tf": 1}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}}, "df": 2}}}, "s": {"docs": {"lilit": {"tf": 1.7320508075688772}}, "df": 1, "o": {"docs": {"lilit": {"tf": 2.23606797749979}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}}, "df": 4, "m": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 2.8284271247461903}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1.4142135623730951}}, "df": 5, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}}}}}}}}, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "y": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 2}}}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 2}}}}}}, "r": {"docs": {"lilit.likelihood.LiLit": {"tf": 3.3166247903554}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 3, "u": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit.prod_fidu": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 2}}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 3}, "lilit.likelihood.LiLit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 3}}}}, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit.cov_filling": {"tf": 1}}, "df": 1}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 4}}, "g": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 3}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1.4142135623730951}}, "df": 3, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "y": {"docs": {"lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}}, "df": 1}}}}}}}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 2}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}, "y": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "g": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"2": {"docs": {"lilit.likelihood.LiLit": {"tf": 1}}, "df": 1}, "docs": {"lilit.likelihood.LiLit.inv_sigma": {"tf": 1.4142135623730951}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {"lilit": {"tf": 2.8284271247461903}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.sigma": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.initialize": {"tf": 1.4142135623730951}}, "df": 9, "l": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 3}}, "u": {"docs": {}, "df": 0, "m": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit.likelihood.LiLit.cov_filling": {"tf": 1}}, "df": 1}}}, "y": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit.likelihood.LiLit.get_requirements": {"tf": 1}}, "df": 1}}}}}}}}}, "e": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}, "t": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 3, "s": {"docs": {"lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 1}}, "n": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}, "p": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.4142135623730951}}, "df": 1, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.4142135623730951}}, "df": 1}}, "e": {"docs": {"lilit.likelihood.LiLit.sigma": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"lilit.likelihood.LiLit.find_spectrum": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {"lilit.likelihood.LiLit.find_spectrum": {"tf": 1.4142135623730951}}, "df": 1}}}}, "l": {"docs": {}, "df": 0, "f": {"docs": {"lilit.likelihood.LiLit.inv_sigma": {"tf": 1.7320508075688772}}, "df": 1}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 1}}}}}}}, "k": {"docs": {}, "df": 0, "y": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 3}, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 3}}, "e": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1.4142135623730951}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 2.23606797749979}}, "df": 1}}}}}, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}}, "df": 1, "s": {"docs": {"lilit.likelihood.LiLit": {"tf": 1}}, "df": 1}}}}}}, "g": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "h": {"docs": {"lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}}, "df": 1}}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}}, "df": 3}}}}}}, "b": {"docs": {"lilit": {"tf": 2}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 3, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}}}, "e": {"docs": {"lilit": {"tf": 3.1622776601683795}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_keys": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 8, "s": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}}, "df": 1}}, "f": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {"lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 1}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 1}}}}, "t": {"docs": {}, "df": 0, "w": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 1}}}}}}, "u": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}, "t": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}}}}}}, "o": {"docs": {}, "df": 0, "l": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.4142135623730951}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}, "y": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1}}, "df": 4}, "b": {"docs": {"lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "f": {"docs": {"lilit": {"tf": 5.196152422706632}, "lilit.likelihood.LiLit": {"tf": 4.898979485566356}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 3.3166247903554}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}, "lilit.likelihood.LiLit.sigma": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1}}, "df": 12}, "n": {"docs": {"lilit": {"tf": 3.1622776601683795}, "lilit.likelihood.LiLit.logp": {"tf": 1}}, "df": 2, "l": {"docs": {}, "df": 0, "y": {"docs": {"lilit": {"tf": 1.7320508075688772}}, "df": 1}}, "c": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1}}, "df": 2}}, "e": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1}}, "df": 2, "s": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 5}}}, "r": {"docs": {"lilit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit": {"tf": 2.449489742783178}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 2.6457513110645907}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 7, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}}}, "w": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1}}, "df": 1}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lilit": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 1}}}}}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {"lilit.likelihood.LiLit.get_requirements": {"tf": 1}}, "df": 1}}}}}}, "k": {"docs": {"lilit": {"tf": 1}}, "df": 1}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1, "s": {"docs": {"lilit": {"tf": 1}}, "df": 1}, "w": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit.find_spectrum": {"tf": 1}}, "df": 1}}}}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"lilit.likelihood.LiLit": {"tf": 3.1622776601683795}, "lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}}, "df": 4}}}}}}}, "u": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1.7320508075688772}}, "df": 2}}}}}, "b": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit.likelihood.LiLit": {"tf": 2.23606797749979}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 2}}}}}}}}, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 2}, "lilit.likelihood.LiLit": {"tf": 1.4142135623730951}}, "df": 2, "d": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}}, "df": 4}, "r": {"docs": {"lilit.likelihood.LiLit.prod_fidu": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 2, "s": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 2.6457513110645907}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}}, "df": 2}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"lilit.likelihood.LiLit.get_keys": {"tf": 1}}, "df": 1}}}}, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit.likelihood.LiLit.get_requirements": {"tf": 1}}, "df": 1}}}}}}}}, "c": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "a": {"docs": {"lilit.likelihood.LiLit": {"tf": 1}}, "df": 1, "y": {"docs": {}, "df": 0, "a": {"docs": {"lilit": {"tf": 3}, "lilit.likelihood.LiLit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}, "lilit.likelihood.LiLit.logp": {"tf": 1}}, "df": 4}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "v": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "x": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 3}}}}}}}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.7320508075688772}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1}}, "df": 3}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1}}, "df": 2}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "y": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 2}}}}}}}, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 2}}}}}, "s": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "c": {"docs": {"lilit": {"tf": 1}}, "df": 1}}, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}}}, "m": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.sigma": {"tf": 1}}, "df": 3}}}}}, "e": {"docs": {"lilit": {"tf": 2}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}}, "df": 2, "s": {"docs": {"lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}, "lilit.likelihood.LiLit.log_likelihood": {"tf": 1}}, "df": 4}, "d": {"docs": {"lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}}, "df": 2}}}}}, "/": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "n": {"docs": {"lilit.likelihood.LiLit.inv_sigma": {"tf": 1}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 3, "s": {"docs": {"lilit.likelihood.LiLit.txt2dict": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "d": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 2.23606797749979}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1}}, "df": 2, "d": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}}}, "v": {"docs": {"lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 2, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.sigma": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1.4142135623730951}}, "df": 6, "s": {"docs": {"lilit.likelihood.LiLit": {"tf": 1}}, "df": 1}}}}}}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 6}}}}}}}}, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 1}}}}}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 3.7416573867739413}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2, "n": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}, "lilit.likelihood.LiLit.sigma": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}, "lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}}, "df": 9, "s": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}, "r": {"docs": {}, "df": 0, "y": {"docs": {"lilit.likelihood.LiLit.logp": {"tf": 1}}, "df": 1}}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}, "b": {"docs": {"lilit": {"tf": 2}, "lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 3, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit.likelihood.LiLit.inv_sigma": {"tf": 1}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1}}, "df": 2}}}}}}}}}, "m": {"docs": {}, "df": 0, "b": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1.4142135623730951}}, "df": 2}}, "u": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 1, "s": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}}, "df": 2}}, "s": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 3, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"lilit.likelihood.LiLit": {"tf": 1}}, "df": 1}}}}}}}}, "h": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 2}}}, "g": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit.get_requirements": {"tf": 1}}, "df": 1}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}, "i": {"2": {"docs": {"lilit.likelihood.LiLit.sigma": {"tf": 1}}, "df": 1}, "docs": {"lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}}, "df": 3, "^": {"2": {"docs": {"lilit": {"tf": 1}}, "df": 1}, "docs": {}, "df": 0}}, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "k": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}}, "df": 1}}}}}}, "l": {"docs": {"lilit.likelihood.LiLit": {"tf": 2}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1.4142135623730951}}, "df": 3, "a": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2, "y": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}, "s": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 3}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}, "p": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}, "j": {"docs": {"lilit": {"tf": 1}}, "df": 1, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}}, "m": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}, "d": {"docs": {"lilit": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 4}, "c": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}, "s": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 1}}, "df": 1, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit": {"tf": 2.449489742783178}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.sigma": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 5, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}}}, "y": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 3}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.sigma": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1.4142135623730951}}, "df": 8}}}}}}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lilit.likelihood.LiLit.inv_sigma": {"tf": 1}}, "df": 1}}}}}}}, "a": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}}, "df": 1}}}}}}}, "e": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}}}}, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit.likelihood.LiLit": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.sigma": {"tf": 1}}, "df": 2, "d": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 2}, "s": {"docs": {"lilit.likelihood.LiLit.get_requirements": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit": {"tf": 3.872983346207417}}, "df": 1, "s": {"docs": {"lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}}, "df": 3}}}}}}, "s": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}}}}}, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 1.7320508075688772}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}, "b": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit": {"tf": 1.4142135623730951}}, "df": 2}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "p": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}}}, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}}, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}}}, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit.likelihood.LiLit.inv_sigma": {"tf": 1}}, "df": 1}}}}}}}, "o": {"docs": {"lilit": {"tf": 2.23606797749979}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 2, "e": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 1}}, "df": 1}}, "c": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 2}}, "df": 1}}}}}, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit.sigma": {"tf": 1}}, "df": 1}}}, "y": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "y": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}}}, "a": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "a": {"docs": {"lilit.likelihood.LiLit": {"tf": 2.449489742783178}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1.4142135623730951}}, "df": 3}}}}, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}, "l": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lilit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 3}}}}, "w": {"docs": {"lilit": {"tf": 2}}, "df": 1, "e": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 2.23606797749979}}, "df": 1}}, "l": {"docs": {}, "df": 0, "p": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "y": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}, "t": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, ":": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "/": {"docs": {}, "df": 0, "g": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}, "g": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "i": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}}}}}}}}}, "a": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 2.449489742783178}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 4}}, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}, "s": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}, "lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 6}, "n": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 1}, "d": {"docs": {"lilit.likelihood.LiLit.cov_filling": {"tf": 1}}, "df": 1}}}}}}}, "m": {"docs": {"lilit": {"tf": 1.7320508075688772}}, "df": 1, "a": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1}}, "df": 1}}, "k": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1, "s": {"docs": {"lilit": {"tf": 1}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit.likelihood.LiLit.cov_filling": {"tf": 1}}, "df": 1}}}}, "y": {"docs": {"lilit": {"tf": 2.23606797749979}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 5}, "x": {"docs": {"lilit": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "z": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 2}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {"lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 2}}}}}, "t": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "b": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "x": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.sigma": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 6}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 3}}}}}}, "j": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}, "p": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 2, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit.likelihood.LiLit.txt2dict": {"tf": 1.4142135623730951}}, "df": 1}}}}}, "s": {"docs": {}, "df": 0, "k": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 1}}}, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}}, "df": 1}}}}}}, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 4}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "f": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}, "e": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 2}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}, "c": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "c": {"docs": {"lilit.likelihood.LiLit.logp": {"tf": 1}}, "df": 1, "s": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}}}}, "i": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "m": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 2}}}}}, "g": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}, "u": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "p": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1.4142135623730951}}, "df": 2, "s": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 2}}}}}}}}, "s": {"docs": {}, "df": 0, "t": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}}, "r": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}}, "df": 1, "l": {"docs": {}, "df": 0, "y": {"docs": {"lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "n": {"docs": {"lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 1}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 3}}}}}, "p": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}}, "y": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "u": {"docs": {"lilit": {"tf": 6.928203230275509}, "lilit.likelihood.LiLit": {"tf": 2.23606797749979}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1.4142135623730951}}, "df": 7, "r": {"docs": {"lilit": {"tf": 2}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}}}}, "n": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1.4142135623730951}}, "df": 3, "e": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 2.449489742783178}, "lilit.likelihood.LiLit": {"tf": 1.7320508075688772}}, "df": 2, "e": {"docs": {}, "df": 0, "d": {"docs": {"lilit.likelihood.LiLit.sigma": {"tf": 1}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1}, "lilit.likelihood.LiLit.chi_exact": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}, "lilit.likelihood.LiLit.compute_chi_part": {"tf": 1}}, "df": 5}}}}, "w": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 2, "l": {"docs": {}, "df": 0, "y": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}, "c": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 2}}}}}}}}, "o": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2, "t": {"docs": {"lilit": {"tf": 2.8284271247461903}, "lilit.likelihood.LiLit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}}, "df": 6, "e": {"docs": {"lilit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.sigma": {"tf": 1}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 9}}, "i": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 2.23606797749979}, "lilit.likelihood.LiLit": {"tf": 2.6457513110645907}, "lilit.likelihood.LiLit.sigma": {"tf": 1}, "lilit.likelihood.LiLit.prod_noise": {"tf": 2.8284271247461903}, "lilit.likelihood.LiLit.initialize": {"tf": 1}}, "df": 5, "c": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit": {"tf": 1}}, "df": 1}}, "o": {"docs": {}, "df": 0, "v": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.7320508075688772}}, "df": 1}}}, "d": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "t": {"docs": {"lilit.likelihood.LiLit.sigma": {"tf": 1}}, "df": 1}}}}}}}, "n": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit": {"tf": 3.1622776601683795}}, "df": 1}}}, "u": {"docs": {}, "df": 0, "m": {"docs": {"lilit.likelihood.LiLit.cov_filling": {"tf": 1.4142135623730951}}, "df": 1, "b": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {"lilit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit": {"tf": 1}}, "df": 2}}}, "p": {"docs": {}, "df": 0, "y": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}, "l": {"docs": {}, "df": 0, "l": {"docs": {"lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1.7320508075688772}}, "df": 3}}}, "a": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 2.449489742783178}, "lilit.likelihood.LiLit": {"tf": 2}}, "df": 2}}}, "l": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit": {"tf": 1.4142135623730951}}, "df": 2}, "p": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 2.449489742783178}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 5}, "s": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "d": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit": {"tf": 2}}, "df": 1}}}}, "t": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.4142135623730951}}, "df": 1}, "d": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "y": {"docs": {"lilit.likelihood.LiLit": {"tf": 2.449489742783178}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 2}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.data_vector": {"tf": 1.4142135623730951}}, "df": 4}}}}}}}, "g": {"docs": {"lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1}}, "df": 2, "i": {"docs": {}, "df": 0, "v": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1, "n": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit": {"tf": 1}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_noise": {"tf": 1.4142135623730951}}, "df": 5}}}, "t": {"docs": {}, "df": 0, "h": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "b": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "d": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}, "i": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "g": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}, "a": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "s": {"docs": {"lilit.likelihood.LiLit": {"tf": 1}}, "df": 1, "i": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {"lilit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit": {"tf": 1.7320508075688772}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.sigma": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}, "lilit.likelihood.LiLit.chi_gaussian": {"tf": 1}}, "df": 7}}}}}}}, "e": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {"lilit": {"tf": 1}}, "df": 1}}}}}, "o": {"docs": {}, "df": 0, "m": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "c": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {"lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 1}}}}}}}}}, "t": {"docs": {"lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 2, "s": {"docs": {"lilit.likelihood.LiLit.logp": {"tf": 1}}, "df": 1}}}, "t": {"docs": {"lilit": {"tf": 1.4142135623730951}}, "df": 1}}, "q": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "n": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "i": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "s": {"docs": {"lilit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_requirements": {"tf": 1}}, "df": 2}}}}}}}}}}, "v": {"docs": {}, "df": 0, "a": {"docs": {}, "df": 0, "l": {"docs": {}, "df": 0, "u": {"docs": {}, "df": 0, "e": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 2}, "lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 4, "s": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit": {"tf": 2.23606797749979}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 2}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}, "lilit.likelihood.LiLit.data_vector": {"tf": 1}}, "df": 7}}}}}, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "y": {"docs": {"lilit": {"tf": 2}, "lilit.likelihood.LiLit.set_lmin_lmax_fsky": {"tf": 1}}, "df": 2}, "b": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "s": {"docs": {}, "df": 0, "e": {"docs": {"lilit.likelihood.LiLit": {"tf": 1}}, "df": 1}}}}}, "c": {"docs": {}, "df": 0, "t": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.data_vector": {"tf": 1.4142135623730951}}, "df": 2}}}}}}, "x": {"docs": {"lilit": {"tf": 1}, "lilit.likelihood.LiLit.cov_filling": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.inv_sigma": {"tf": 1.4142135623730951}}, "df": 3}, "k": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "y": {"docs": {"lilit.likelihood.LiLit.find_spectrum": {"tf": 2.23606797749979}}, "df": 1, "s": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.get_keys": {"tf": 1}, "lilit.likelihood.LiLit.get_Gauss_keys": {"tf": 2}, "lilit.likelihood.LiLit.find_spectrum": {"tf": 1}, "lilit.likelihood.LiLit.sigma": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.CAMBres2dict": {"tf": 1}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1}}, "df": 7}, "w": {"docs": {}, "df": 0, "o": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "d": {"docs": {"lilit.likelihood.LiLit.get_requirements": {"tf": 1}}, "df": 1, "s": {"docs": {"lilit.likelihood.LiLit": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.txt2dict": {"tf": 1.4142135623730951}, "lilit.likelihood.LiLit.prod_fidu": {"tf": 1}}, "df": 3}}}}}}}}, "z": {"docs": {}, "df": 0, "e": {"docs": {}, "df": 0, "r": {"docs": {}, "df": 0, "o": {"docs": {"lilit.likelihood.LiLit.get_reduced_data": {"tf": 1}}, "df": 1, "s": {"docs": {"lilit.likelihood.LiLit.find_spectrum": {"tf": 1}}, "df": 1}}}}}}}}, "pipeline": ["trimmer"], "_isPrebuiltIndex": true};

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();