# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ClusterAgentArgs', 'ClusterAgent']

@pulumi.input_type
class ClusterAgentArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ClusterAgent resource.
        :param pulumi.Input[builtins.str] project: ID or full path of the project maintained by the authenticated user.
        :param pulumi.Input[builtins.str] name: The Name of the agent.
        """
        pulumi.set(__self__, "project", project)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[builtins.str]:
        """
        ID or full path of the project maintained by the authenticated user.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Name of the agent.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ClusterAgentState:
    def __init__(__self__, *,
                 agent_id: Optional[pulumi.Input[builtins.int]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 created_by_user_id: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ClusterAgent resources.
        :param pulumi.Input[builtins.int] agent_id: The ID of the agent.
        :param pulumi.Input[builtins.str] created_at: The ISO8601 datetime when the agent was created.
        :param pulumi.Input[builtins.int] created_by_user_id: The ID of the user who created the agent.
        :param pulumi.Input[builtins.str] name: The Name of the agent.
        :param pulumi.Input[builtins.str] project: ID or full path of the project maintained by the authenticated user.
        """
        if agent_id is not None:
            pulumi.set(__self__, "agent_id", agent_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by_user_id is not None:
            pulumi.set(__self__, "created_by_user_id", created_by_user_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The ID of the agent.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "agent_id", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ISO8601 datetime when the agent was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="createdByUserId")
    def created_by_user_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The ID of the user who created the agent.
        """
        return pulumi.get(self, "created_by_user_id")

    @created_by_user_id.setter
    def created_by_user_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "created_by_user_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Name of the agent.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID or full path of the project maintained by the authenticated user.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.type_token("gitlab:index/clusterAgent:ClusterAgent")
class ClusterAgent(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The `ClusterAgent` resource allows to manage the lifecycle of a GitLab Agent for Kubernetes.

        > Note that this resource only registers the agent, but doesn't configure it.
           The configuration needs to be manually added as described in
           [the docs](https://docs.gitlab.com/user/clusters/agent/install/index/#create-an-agent-configuration-file).
           However, a `RepositoryFile` resource may be used to achieve that.

        > Requires at least maintainer permissions on the project.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/cluster_agents/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab
        import pulumi_std as std

        example = gitlab.ClusterAgent("example",
            project="12345",
            name="agent-1")
        # Optionally, configure the agent as described in
        # https://docs.gitlab.com/user/clusters/agent/install/index/#create-an-agent-configuration-file
        example_agent_config = gitlab.RepositoryFile("example_agent_config",
            project=example.project,
            branch="main",
            file_path=example.name.apply(lambda name: f".gitlab/agents/{name}/config.yaml"),
            encoding="base64",
            content=std.base64encode(input="# the GitLab Agent for Kubernetes configuration goes here ...\\n").result,
            author_email="terraform@example.com",
            author_name="Terraform",
            commit_message=example.name.apply(lambda name: f"feature: add agent config for {name} [skip ci]"))
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_cluster_agent`. For example:

        terraform

        import {

          to = gitlab_cluster_agent.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        GitLab Agent for Kubernetes can be imported with the following command and the id pattern `<project>:<agent-id>`

        ```sh
        $ pulumi import gitlab:index/clusterAgent:ClusterAgent example '12345:42'
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The Name of the agent.
        :param pulumi.Input[builtins.str] project: ID or full path of the project maintained by the authenticated user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterAgentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `ClusterAgent` resource allows to manage the lifecycle of a GitLab Agent for Kubernetes.

        > Note that this resource only registers the agent, but doesn't configure it.
           The configuration needs to be manually added as described in
           [the docs](https://docs.gitlab.com/user/clusters/agent/install/index/#create-an-agent-configuration-file).
           However, a `RepositoryFile` resource may be used to achieve that.

        > Requires at least maintainer permissions on the project.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/cluster_agents/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab
        import pulumi_std as std

        example = gitlab.ClusterAgent("example",
            project="12345",
            name="agent-1")
        # Optionally, configure the agent as described in
        # https://docs.gitlab.com/user/clusters/agent/install/index/#create-an-agent-configuration-file
        example_agent_config = gitlab.RepositoryFile("example_agent_config",
            project=example.project,
            branch="main",
            file_path=example.name.apply(lambda name: f".gitlab/agents/{name}/config.yaml"),
            encoding="base64",
            content=std.base64encode(input="# the GitLab Agent for Kubernetes configuration goes here ...\\n").result,
            author_email="terraform@example.com",
            author_name="Terraform",
            commit_message=example.name.apply(lambda name: f"feature: add agent config for {name} [skip ci]"))
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_cluster_agent`. For example:

        terraform

        import {

          to = gitlab_cluster_agent.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        GitLab Agent for Kubernetes can be imported with the following command and the id pattern `<project>:<agent-id>`

        ```sh
        $ pulumi import gitlab:index/clusterAgent:ClusterAgent example '12345:42'
        ```

        :param str resource_name: The name of the resource.
        :param ClusterAgentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterAgentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterAgentArgs.__new__(ClusterAgentArgs)

            __props__.__dict__["name"] = name
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["agent_id"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by_user_id"] = None
        super(ClusterAgent, __self__).__init__(
            'gitlab:index/clusterAgent:ClusterAgent',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_id: Optional[pulumi.Input[builtins.int]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            created_by_user_id: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None) -> 'ClusterAgent':
        """
        Get an existing ClusterAgent resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] agent_id: The ID of the agent.
        :param pulumi.Input[builtins.str] created_at: The ISO8601 datetime when the agent was created.
        :param pulumi.Input[builtins.int] created_by_user_id: The ID of the user who created the agent.
        :param pulumi.Input[builtins.str] name: The Name of the agent.
        :param pulumi.Input[builtins.str] project: ID or full path of the project maintained by the authenticated user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterAgentState.__new__(_ClusterAgentState)

        __props__.__dict__["agent_id"] = agent_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by_user_id"] = created_by_user_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        return ClusterAgent(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Output[builtins.int]:
        """
        The ID of the agent.
        """
        return pulumi.get(self, "agent_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        The ISO8601 datetime when the agent was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdByUserId")
    def created_by_user_id(self) -> pulumi.Output[builtins.int]:
        """
        The ID of the user who created the agent.
        """
        return pulumi.get(self, "created_by_user_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The Name of the agent.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        ID or full path of the project maintained by the authenticated user.
        """
        return pulumi.get(self, "project")

