# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetProjectMergeRequestsResult',
    'AwaitableGetProjectMergeRequestsResult',
    'get_project_merge_requests',
    'get_project_merge_requests_output',
]

@pulumi.output_type
class GetProjectMergeRequestsResult:
    """
    A collection of values returned by getProjectMergeRequests.
    """
    def __init__(__self__, author_id=None, author_username=None, created_after=None, created_before=None, id=None, iids=None, merge_requests=None, milestone=None, my_reaction_emoji=None, order_by=None, project=None, reviewer_username=None, scope=None, search=None, sort=None, source_branch=None, state=None, target_branch=None, updated_after=None, updated_before=None, wip=None):
        if author_id and not isinstance(author_id, int):
            raise TypeError("Expected argument 'author_id' to be a int")
        pulumi.set(__self__, "author_id", author_id)
        if author_username and not isinstance(author_username, str):
            raise TypeError("Expected argument 'author_username' to be a str")
        pulumi.set(__self__, "author_username", author_username)
        if created_after and not isinstance(created_after, str):
            raise TypeError("Expected argument 'created_after' to be a str")
        pulumi.set(__self__, "created_after", created_after)
        if created_before and not isinstance(created_before, str):
            raise TypeError("Expected argument 'created_before' to be a str")
        pulumi.set(__self__, "created_before", created_before)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if iids and not isinstance(iids, list):
            raise TypeError("Expected argument 'iids' to be a list")
        pulumi.set(__self__, "iids", iids)
        if merge_requests and not isinstance(merge_requests, list):
            raise TypeError("Expected argument 'merge_requests' to be a list")
        pulumi.set(__self__, "merge_requests", merge_requests)
        if milestone and not isinstance(milestone, str):
            raise TypeError("Expected argument 'milestone' to be a str")
        pulumi.set(__self__, "milestone", milestone)
        if my_reaction_emoji and not isinstance(my_reaction_emoji, str):
            raise TypeError("Expected argument 'my_reaction_emoji' to be a str")
        pulumi.set(__self__, "my_reaction_emoji", my_reaction_emoji)
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        pulumi.set(__self__, "order_by", order_by)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if reviewer_username and not isinstance(reviewer_username, str):
            raise TypeError("Expected argument 'reviewer_username' to be a str")
        pulumi.set(__self__, "reviewer_username", reviewer_username)
        if scope and not isinstance(scope, str):
            raise TypeError("Expected argument 'scope' to be a str")
        pulumi.set(__self__, "scope", scope)
        if search and not isinstance(search, str):
            raise TypeError("Expected argument 'search' to be a str")
        pulumi.set(__self__, "search", search)
        if sort and not isinstance(sort, str):
            raise TypeError("Expected argument 'sort' to be a str")
        pulumi.set(__self__, "sort", sort)
        if source_branch and not isinstance(source_branch, str):
            raise TypeError("Expected argument 'source_branch' to be a str")
        pulumi.set(__self__, "source_branch", source_branch)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if target_branch and not isinstance(target_branch, str):
            raise TypeError("Expected argument 'target_branch' to be a str")
        pulumi.set(__self__, "target_branch", target_branch)
        if updated_after and not isinstance(updated_after, str):
            raise TypeError("Expected argument 'updated_after' to be a str")
        pulumi.set(__self__, "updated_after", updated_after)
        if updated_before and not isinstance(updated_before, str):
            raise TypeError("Expected argument 'updated_before' to be a str")
        pulumi.set(__self__, "updated_before", updated_before)
        if wip and not isinstance(wip, str):
            raise TypeError("Expected argument 'wip' to be a str")
        pulumi.set(__self__, "wip", wip)

    @property
    @pulumi.getter(name="authorId")
    def author_id(self) -> Optional[builtins.int]:
        """
        Return merge requests created by the given user ID.
        """
        return pulumi.get(self, "author_id")

    @property
    @pulumi.getter(name="authorUsername")
    def author_username(self) -> Optional[builtins.str]:
        """
        Return merge requests created by the given username.
        """
        return pulumi.get(self, "author_username")

    @property
    @pulumi.getter(name="createdAfter")
    def created_after(self) -> Optional[builtins.str]:
        """
        Return merge requests created after the given time. Expected in RFC3339 format (2006-01-02T15:04:05Z).
        """
        return pulumi.get(self, "created_after")

    @property
    @pulumi.getter(name="createdBefore")
    def created_before(self) -> Optional[builtins.str]:
        """
        Return merge requests created before the given time. Expected in RFC3339 format (2006-01-02T15:04:05Z).
        """
        return pulumi.get(self, "created_before")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def iids(self) -> Optional[Sequence[builtins.int]]:
        """
        The unique internal IDs of the merge requests.
        """
        return pulumi.get(self, "iids")

    @property
    @pulumi.getter(name="mergeRequests")
    def merge_requests(self) -> Sequence['outputs.GetProjectMergeRequestsMergeRequestResult']:
        """
        The list of merge requests.
        """
        return pulumi.get(self, "merge_requests")

    @property
    @pulumi.getter
    def milestone(self) -> Optional[builtins.str]:
        """
        Return only merge requests for a specific milestone. `None` returns merge requests with no milestone. `Any` returns merge requests that have an assigned milestone.
        """
        return pulumi.get(self, "milestone")

    @property
    @pulumi.getter(name="myReactionEmoji")
    def my_reaction_emoji(self) -> Optional[builtins.str]:
        """
        Return merge requests reacted to by the authenticated user with the given emoji. `None` returns issues not given a reaction. `Any` returns issues given at least one reaction.
        """
        return pulumi.get(self, "my_reaction_emoji")

    @property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[builtins.str]:
        """
        Return requests ordered by `created_at`, `title` or `updated_at`. Default is `created_at`.
        """
        return pulumi.get(self, "order_by")

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        """
        The ID or path of the project.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="reviewerUsername")
    def reviewer_username(self) -> Optional[builtins.str]:
        """
        Return merge requests reviewed by the given username. `None` returns merge requests with no reviews. `Any` returns merge requests with any reviewer.
        """
        return pulumi.get(self, "reviewer_username")

    @property
    @pulumi.getter
    def scope(self) -> Optional[builtins.str]:
        """
        Return merge requests for the given scope: `created_by_me`, `assigned_to_me`, or `all`.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def search(self) -> Optional[builtins.str]:
        """
        Search merge requests against their `title` or `description`.
        """
        return pulumi.get(self, "search")

    @property
    @pulumi.getter
    def sort(self) -> Optional[builtins.str]:
        """
        Return requests sorted in `asc` or `desc` order. Default is `desc`.
        """
        return pulumi.get(self, "sort")

    @property
    @pulumi.getter(name="sourceBranch")
    def source_branch(self) -> Optional[builtins.str]:
        """
        Return merge requests with the given source branch.
        """
        return pulumi.get(self, "source_branch")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        Return all merge requests (all) or just those that are opened, closed, locked, or merged.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetBranch")
    def target_branch(self) -> Optional[builtins.str]:
        """
        Return merge requests with the given target branch.
        """
        return pulumi.get(self, "target_branch")

    @property
    @pulumi.getter(name="updatedAfter")
    def updated_after(self) -> Optional[builtins.str]:
        """
        Return merge requests updated after the given time. Expected in RFC3339 format (2006-01-02T15:04:05Z).
        """
        return pulumi.get(self, "updated_after")

    @property
    @pulumi.getter(name="updatedBefore")
    def updated_before(self) -> Optional[builtins.str]:
        """
        Return merge requests updated before the given time. Expected in RFC3339 format (2006-01-02T15:04:05Z).
        """
        return pulumi.get(self, "updated_before")

    @property
    @pulumi.getter
    def wip(self) -> Optional[builtins.str]:
        """
        Filter merge requests against their wip status. `yes` to return only draft merge requests, `no` to return non-draft merge requests.
        """
        return pulumi.get(self, "wip")


class AwaitableGetProjectMergeRequestsResult(GetProjectMergeRequestsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectMergeRequestsResult(
            author_id=self.author_id,
            author_username=self.author_username,
            created_after=self.created_after,
            created_before=self.created_before,
            id=self.id,
            iids=self.iids,
            merge_requests=self.merge_requests,
            milestone=self.milestone,
            my_reaction_emoji=self.my_reaction_emoji,
            order_by=self.order_by,
            project=self.project,
            reviewer_username=self.reviewer_username,
            scope=self.scope,
            search=self.search,
            sort=self.sort,
            source_branch=self.source_branch,
            state=self.state,
            target_branch=self.target_branch,
            updated_after=self.updated_after,
            updated_before=self.updated_before,
            wip=self.wip)


def get_project_merge_requests(author_id: Optional[builtins.int] = None,
                               author_username: Optional[builtins.str] = None,
                               created_after: Optional[builtins.str] = None,
                               created_before: Optional[builtins.str] = None,
                               iids: Optional[Sequence[builtins.int]] = None,
                               milestone: Optional[builtins.str] = None,
                               my_reaction_emoji: Optional[builtins.str] = None,
                               order_by: Optional[builtins.str] = None,
                               project: Optional[builtins.str] = None,
                               reviewer_username: Optional[builtins.str] = None,
                               scope: Optional[builtins.str] = None,
                               search: Optional[builtins.str] = None,
                               sort: Optional[builtins.str] = None,
                               source_branch: Optional[builtins.str] = None,
                               state: Optional[builtins.str] = None,
                               target_branch: Optional[builtins.str] = None,
                               updated_after: Optional[builtins.str] = None,
                               updated_before: Optional[builtins.str] = None,
                               wip: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectMergeRequestsResult:
    """
    The `get_project_merge_requests` data source retrieves
    information about a list of merge requests related to a specific project.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/merge_requests/#list-project-merge-requests)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    example_one = gitlab.get_project_merge_requests(project="123",
        target_branch="main",
        wip="yes")
    example_two = gitlab.get_project_merge_requests(project="company/group/project1",
        author_id=5,
        created_after="2024-07-25T12:00:00Z")
    ```


    :param builtins.int author_id: Return merge requests created by the given user ID.
    :param builtins.str author_username: Return merge requests created by the given username.
    :param builtins.str created_after: Return merge requests created after the given time. Expected in RFC3339 format (2006-01-02T15:04:05Z).
    :param builtins.str created_before: Return merge requests created before the given time. Expected in RFC3339 format (2006-01-02T15:04:05Z).
    :param Sequence[builtins.int] iids: The unique internal IDs of the merge requests.
    :param builtins.str milestone: Return only merge requests for a specific milestone. `None` returns merge requests with no milestone. `Any` returns merge requests that have an assigned milestone.
    :param builtins.str my_reaction_emoji: Return merge requests reacted to by the authenticated user with the given emoji. `None` returns issues not given a reaction. `Any` returns issues given at least one reaction.
    :param builtins.str order_by: Return requests ordered by `created_at`, `title` or `updated_at`. Default is `created_at`.
    :param builtins.str project: The ID or path of the project.
    :param builtins.str reviewer_username: Return merge requests reviewed by the given username. `None` returns merge requests with no reviews. `Any` returns merge requests with any reviewer.
    :param builtins.str scope: Return merge requests for the given scope: `created_by_me`, `assigned_to_me`, or `all`.
    :param builtins.str search: Search merge requests against their `title` or `description`.
    :param builtins.str sort: Return requests sorted in `asc` or `desc` order. Default is `desc`.
    :param builtins.str source_branch: Return merge requests with the given source branch.
    :param builtins.str state: Return all merge requests (all) or just those that are opened, closed, locked, or merged.
    :param builtins.str target_branch: Return merge requests with the given target branch.
    :param builtins.str updated_after: Return merge requests updated after the given time. Expected in RFC3339 format (2006-01-02T15:04:05Z).
    :param builtins.str updated_before: Return merge requests updated before the given time. Expected in RFC3339 format (2006-01-02T15:04:05Z).
    :param builtins.str wip: Filter merge requests against their wip status. `yes` to return only draft merge requests, `no` to return non-draft merge requests.
    """
    __args__ = dict()
    __args__['authorId'] = author_id
    __args__['authorUsername'] = author_username
    __args__['createdAfter'] = created_after
    __args__['createdBefore'] = created_before
    __args__['iids'] = iids
    __args__['milestone'] = milestone
    __args__['myReactionEmoji'] = my_reaction_emoji
    __args__['orderBy'] = order_by
    __args__['project'] = project
    __args__['reviewerUsername'] = reviewer_username
    __args__['scope'] = scope
    __args__['search'] = search
    __args__['sort'] = sort
    __args__['sourceBranch'] = source_branch
    __args__['state'] = state
    __args__['targetBranch'] = target_branch
    __args__['updatedAfter'] = updated_after
    __args__['updatedBefore'] = updated_before
    __args__['wip'] = wip
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gitlab:index/getProjectMergeRequests:getProjectMergeRequests', __args__, opts=opts, typ=GetProjectMergeRequestsResult).value

    return AwaitableGetProjectMergeRequestsResult(
        author_id=pulumi.get(__ret__, 'author_id'),
        author_username=pulumi.get(__ret__, 'author_username'),
        created_after=pulumi.get(__ret__, 'created_after'),
        created_before=pulumi.get(__ret__, 'created_before'),
        id=pulumi.get(__ret__, 'id'),
        iids=pulumi.get(__ret__, 'iids'),
        merge_requests=pulumi.get(__ret__, 'merge_requests'),
        milestone=pulumi.get(__ret__, 'milestone'),
        my_reaction_emoji=pulumi.get(__ret__, 'my_reaction_emoji'),
        order_by=pulumi.get(__ret__, 'order_by'),
        project=pulumi.get(__ret__, 'project'),
        reviewer_username=pulumi.get(__ret__, 'reviewer_username'),
        scope=pulumi.get(__ret__, 'scope'),
        search=pulumi.get(__ret__, 'search'),
        sort=pulumi.get(__ret__, 'sort'),
        source_branch=pulumi.get(__ret__, 'source_branch'),
        state=pulumi.get(__ret__, 'state'),
        target_branch=pulumi.get(__ret__, 'target_branch'),
        updated_after=pulumi.get(__ret__, 'updated_after'),
        updated_before=pulumi.get(__ret__, 'updated_before'),
        wip=pulumi.get(__ret__, 'wip'))
def get_project_merge_requests_output(author_id: Optional[pulumi.Input[Optional[builtins.int]]] = None,
                                      author_username: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      created_after: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      created_before: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      iids: Optional[pulumi.Input[Optional[Sequence[builtins.int]]]] = None,
                                      milestone: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      my_reaction_emoji: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      order_by: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      project: Optional[pulumi.Input[builtins.str]] = None,
                                      reviewer_username: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      scope: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      search: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      sort: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      source_branch: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      target_branch: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      updated_after: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      updated_before: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      wip: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectMergeRequestsResult]:
    """
    The `get_project_merge_requests` data source retrieves
    information about a list of merge requests related to a specific project.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/merge_requests/#list-project-merge-requests)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    example_one = gitlab.get_project_merge_requests(project="123",
        target_branch="main",
        wip="yes")
    example_two = gitlab.get_project_merge_requests(project="company/group/project1",
        author_id=5,
        created_after="2024-07-25T12:00:00Z")
    ```


    :param builtins.int author_id: Return merge requests created by the given user ID.
    :param builtins.str author_username: Return merge requests created by the given username.
    :param builtins.str created_after: Return merge requests created after the given time. Expected in RFC3339 format (2006-01-02T15:04:05Z).
    :param builtins.str created_before: Return merge requests created before the given time. Expected in RFC3339 format (2006-01-02T15:04:05Z).
    :param Sequence[builtins.int] iids: The unique internal IDs of the merge requests.
    :param builtins.str milestone: Return only merge requests for a specific milestone. `None` returns merge requests with no milestone. `Any` returns merge requests that have an assigned milestone.
    :param builtins.str my_reaction_emoji: Return merge requests reacted to by the authenticated user with the given emoji. `None` returns issues not given a reaction. `Any` returns issues given at least one reaction.
    :param builtins.str order_by: Return requests ordered by `created_at`, `title` or `updated_at`. Default is `created_at`.
    :param builtins.str project: The ID or path of the project.
    :param builtins.str reviewer_username: Return merge requests reviewed by the given username. `None` returns merge requests with no reviews. `Any` returns merge requests with any reviewer.
    :param builtins.str scope: Return merge requests for the given scope: `created_by_me`, `assigned_to_me`, or `all`.
    :param builtins.str search: Search merge requests against their `title` or `description`.
    :param builtins.str sort: Return requests sorted in `asc` or `desc` order. Default is `desc`.
    :param builtins.str source_branch: Return merge requests with the given source branch.
    :param builtins.str state: Return all merge requests (all) or just those that are opened, closed, locked, or merged.
    :param builtins.str target_branch: Return merge requests with the given target branch.
    :param builtins.str updated_after: Return merge requests updated after the given time. Expected in RFC3339 format (2006-01-02T15:04:05Z).
    :param builtins.str updated_before: Return merge requests updated before the given time. Expected in RFC3339 format (2006-01-02T15:04:05Z).
    :param builtins.str wip: Filter merge requests against their wip status. `yes` to return only draft merge requests, `no` to return non-draft merge requests.
    """
    __args__ = dict()
    __args__['authorId'] = author_id
    __args__['authorUsername'] = author_username
    __args__['createdAfter'] = created_after
    __args__['createdBefore'] = created_before
    __args__['iids'] = iids
    __args__['milestone'] = milestone
    __args__['myReactionEmoji'] = my_reaction_emoji
    __args__['orderBy'] = order_by
    __args__['project'] = project
    __args__['reviewerUsername'] = reviewer_username
    __args__['scope'] = scope
    __args__['search'] = search
    __args__['sort'] = sort
    __args__['sourceBranch'] = source_branch
    __args__['state'] = state
    __args__['targetBranch'] = target_branch
    __args__['updatedAfter'] = updated_after
    __args__['updatedBefore'] = updated_before
    __args__['wip'] = wip
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gitlab:index/getProjectMergeRequests:getProjectMergeRequests', __args__, opts=opts, typ=GetProjectMergeRequestsResult)
    return __ret__.apply(lambda __response__: GetProjectMergeRequestsResult(
        author_id=pulumi.get(__response__, 'author_id'),
        author_username=pulumi.get(__response__, 'author_username'),
        created_after=pulumi.get(__response__, 'created_after'),
        created_before=pulumi.get(__response__, 'created_before'),
        id=pulumi.get(__response__, 'id'),
        iids=pulumi.get(__response__, 'iids'),
        merge_requests=pulumi.get(__response__, 'merge_requests'),
        milestone=pulumi.get(__response__, 'milestone'),
        my_reaction_emoji=pulumi.get(__response__, 'my_reaction_emoji'),
        order_by=pulumi.get(__response__, 'order_by'),
        project=pulumi.get(__response__, 'project'),
        reviewer_username=pulumi.get(__response__, 'reviewer_username'),
        scope=pulumi.get(__response__, 'scope'),
        search=pulumi.get(__response__, 'search'),
        sort=pulumi.get(__response__, 'sort'),
        source_branch=pulumi.get(__response__, 'source_branch'),
        state=pulumi.get(__response__, 'state'),
        target_branch=pulumi.get(__response__, 'target_branch'),
        updated_after=pulumi.get(__response__, 'updated_after'),
        updated_before=pulumi.get(__response__, 'updated_before'),
        wip=pulumi.get(__response__, 'wip')))
