# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetProjectMirrorPublicKeyResult',
    'AwaitableGetProjectMirrorPublicKeyResult',
    'get_project_mirror_public_key',
    'get_project_mirror_public_key_output',
]

@pulumi.output_type
class GetProjectMirrorPublicKeyResult:
    """
    A collection of values returned by getProjectMirrorPublicKey.
    """
    def __init__(__self__, id=None, mirror_id=None, project_id=None, public_key=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if mirror_id and not isinstance(mirror_id, int):
            raise TypeError("Expected argument 'mirror_id' to be a int")
        pulumi.set(__self__, "mirror_id", mirror_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if public_key and not isinstance(public_key, str):
            raise TypeError("Expected argument 'public_key' to be a str")
        pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="mirrorId")
    def mirror_id(self) -> builtins.int:
        """
        The id of the remote mirror.
        """
        return pulumi.get(self, "mirror_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        The integer or path with namespace that uniquely identifies the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> builtins.str:
        """
        Public key of the remote mirror.
        """
        return pulumi.get(self, "public_key")


class AwaitableGetProjectMirrorPublicKeyResult(GetProjectMirrorPublicKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectMirrorPublicKeyResult(
            id=self.id,
            mirror_id=self.mirror_id,
            project_id=self.project_id,
            public_key=self.public_key)


def get_project_mirror_public_key(mirror_id: Optional[builtins.int] = None,
                                  project_id: Optional[builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectMirrorPublicKeyResult:
    """
    The `get_project_mirror_public_key` data source allows the public key of a project mirror to be retrieved by its mirror id and the project it belongs to.

    **Note**: Supported on GitLab 17.9 or higher.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/remote_mirrors/#get-a-single-projects-remote-mirror-public-key)


    :param builtins.int mirror_id: The id of the remote mirror.
    :param builtins.str project_id: The integer or path with namespace that uniquely identifies the project.
    """
    __args__ = dict()
    __args__['mirrorId'] = mirror_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gitlab:index/getProjectMirrorPublicKey:getProjectMirrorPublicKey', __args__, opts=opts, typ=GetProjectMirrorPublicKeyResult).value

    return AwaitableGetProjectMirrorPublicKeyResult(
        id=pulumi.get(__ret__, 'id'),
        mirror_id=pulumi.get(__ret__, 'mirror_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        public_key=pulumi.get(__ret__, 'public_key'))
def get_project_mirror_public_key_output(mirror_id: Optional[pulumi.Input[builtins.int]] = None,
                                         project_id: Optional[pulumi.Input[builtins.str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectMirrorPublicKeyResult]:
    """
    The `get_project_mirror_public_key` data source allows the public key of a project mirror to be retrieved by its mirror id and the project it belongs to.

    **Note**: Supported on GitLab 17.9 or higher.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/remote_mirrors/#get-a-single-projects-remote-mirror-public-key)


    :param builtins.int mirror_id: The id of the remote mirror.
    :param builtins.str project_id: The integer or path with namespace that uniquely identifies the project.
    """
    __args__ = dict()
    __args__['mirrorId'] = mirror_id
    __args__['projectId'] = project_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gitlab:index/getProjectMirrorPublicKey:getProjectMirrorPublicKey', __args__, opts=opts, typ=GetProjectMirrorPublicKeyResult)
    return __ret__.apply(lambda __response__: GetProjectMirrorPublicKeyResult(
        id=pulumi.get(__response__, 'id'),
        mirror_id=pulumi.get(__response__, 'mirror_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        public_key=pulumi.get(__response__, 'public_key')))
