# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetUsersResult',
    'AwaitableGetUsersResult',
    'get_users',
    'get_users_output',
]

@pulumi.output_type
class GetUsersResult:
    """
    A collection of values returned by getUsers.
    """
    def __init__(__self__, active=None, blocked=None, created_after=None, created_before=None, exclude_external=None, exclude_internal=None, extern_provider=None, extern_uid=None, external=None, id=None, order_by=None, search=None, sort=None, username=None, users=None, without_project_bots=None):
        if active and not isinstance(active, bool):
            raise TypeError("Expected argument 'active' to be a bool")
        pulumi.set(__self__, "active", active)
        if blocked and not isinstance(blocked, bool):
            raise TypeError("Expected argument 'blocked' to be a bool")
        pulumi.set(__self__, "blocked", blocked)
        if created_after and not isinstance(created_after, str):
            raise TypeError("Expected argument 'created_after' to be a str")
        pulumi.set(__self__, "created_after", created_after)
        if created_before and not isinstance(created_before, str):
            raise TypeError("Expected argument 'created_before' to be a str")
        pulumi.set(__self__, "created_before", created_before)
        if exclude_external and not isinstance(exclude_external, bool):
            raise TypeError("Expected argument 'exclude_external' to be a bool")
        pulumi.set(__self__, "exclude_external", exclude_external)
        if exclude_internal and not isinstance(exclude_internal, bool):
            raise TypeError("Expected argument 'exclude_internal' to be a bool")
        pulumi.set(__self__, "exclude_internal", exclude_internal)
        if extern_provider and not isinstance(extern_provider, str):
            raise TypeError("Expected argument 'extern_provider' to be a str")
        pulumi.set(__self__, "extern_provider", extern_provider)
        if extern_uid and not isinstance(extern_uid, str):
            raise TypeError("Expected argument 'extern_uid' to be a str")
        pulumi.set(__self__, "extern_uid", extern_uid)
        if external and not isinstance(external, bool):
            raise TypeError("Expected argument 'external' to be a bool")
        pulumi.set(__self__, "external", external)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if order_by and not isinstance(order_by, str):
            raise TypeError("Expected argument 'order_by' to be a str")
        pulumi.set(__self__, "order_by", order_by)
        if search and not isinstance(search, str):
            raise TypeError("Expected argument 'search' to be a str")
        pulumi.set(__self__, "search", search)
        if sort and not isinstance(sort, str):
            raise TypeError("Expected argument 'sort' to be a str")
        pulumi.set(__self__, "sort", sort)
        if username and not isinstance(username, str):
            raise TypeError("Expected argument 'username' to be a str")
        pulumi.set(__self__, "username", username)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)
        if without_project_bots and not isinstance(without_project_bots, bool):
            raise TypeError("Expected argument 'without_project_bots' to be a bool")
        pulumi.set(__self__, "without_project_bots", without_project_bots)

    @property
    @pulumi.getter
    def active(self) -> Optional[builtins.bool]:
        """
        Filter users that are active.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter
    def blocked(self) -> Optional[builtins.bool]:
        """
        Filter users that are blocked.
        """
        return pulumi.get(self, "blocked")

    @property
    @pulumi.getter(name="createdAfter")
    def created_after(self) -> Optional[builtins.str]:
        """
        Search for users created after a specific date. (Requires administrator privileges)
        """
        return pulumi.get(self, "created_after")

    @property
    @pulumi.getter(name="createdBefore")
    def created_before(self) -> Optional[builtins.str]:
        """
        Search for users created before a specific date. (Requires administrator privileges)
        """
        return pulumi.get(self, "created_before")

    @property
    @pulumi.getter(name="excludeExternal")
    def exclude_external(self) -> Optional[builtins.bool]:
        """
        Filters only non external users.
        """
        return pulumi.get(self, "exclude_external")

    @property
    @pulumi.getter(name="excludeInternal")
    def exclude_internal(self) -> Optional[builtins.bool]:
        """
        Filters only non internal users.
        """
        return pulumi.get(self, "exclude_internal")

    @property
    @pulumi.getter(name="externProvider")
    def extern_provider(self) -> Optional[builtins.str]:
        """
        Lookup users by external provider. (Requires administrator privileges)
        """
        return pulumi.get(self, "extern_provider")

    @property
    @pulumi.getter(name="externUid")
    def extern_uid(self) -> Optional[builtins.str]:
        """
        Lookup users by external UID. (Requires administrator privileges)
        """
        return pulumi.get(self, "extern_uid")

    @property
    @pulumi.getter
    def external(self) -> Optional[builtins.bool]:
        """
        Filters only external users.
        """
        return pulumi.get(self, "external")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="orderBy")
    def order_by(self) -> Optional[builtins.str]:
        """
        Order the users' list by `id`, `name`, `username`, `created_at` or `updated_at`. (Requires administrator privileges)
        """
        return pulumi.get(self, "order_by")

    @property
    @pulumi.getter
    def search(self) -> Optional[builtins.str]:
        """
        Search users by username, name or email.
        """
        return pulumi.get(self, "search")

    @property
    @pulumi.getter
    def sort(self) -> Optional[builtins.str]:
        """
        Sort users' list in asc or desc order. (Requires administrator privileges)
        """
        return pulumi.get(self, "sort")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        Get a single user with a specific username.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter
    def users(self) -> Sequence['outputs.GetUsersUserResult']:
        """
        The list of users.
        """
        return pulumi.get(self, "users")

    @property
    @pulumi.getter(name="withoutProjectBots")
    def without_project_bots(self) -> Optional[builtins.bool]:
        """
        Filters user without project bots.
        """
        return pulumi.get(self, "without_project_bots")


class AwaitableGetUsersResult(GetUsersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUsersResult(
            active=self.active,
            blocked=self.blocked,
            created_after=self.created_after,
            created_before=self.created_before,
            exclude_external=self.exclude_external,
            exclude_internal=self.exclude_internal,
            extern_provider=self.extern_provider,
            extern_uid=self.extern_uid,
            external=self.external,
            id=self.id,
            order_by=self.order_by,
            search=self.search,
            sort=self.sort,
            username=self.username,
            users=self.users,
            without_project_bots=self.without_project_bots)


def get_users(active: Optional[builtins.bool] = None,
              blocked: Optional[builtins.bool] = None,
              created_after: Optional[builtins.str] = None,
              created_before: Optional[builtins.str] = None,
              exclude_external: Optional[builtins.bool] = None,
              exclude_internal: Optional[builtins.bool] = None,
              extern_provider: Optional[builtins.str] = None,
              extern_uid: Optional[builtins.str] = None,
              external: Optional[builtins.bool] = None,
              order_by: Optional[builtins.str] = None,
              search: Optional[builtins.str] = None,
              sort: Optional[builtins.str] = None,
              username: Optional[builtins.str] = None,
              without_project_bots: Optional[builtins.bool] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUsersResult:
    """
    The `get_users` data source allows details of multiple users to be retrieved given some optional filter criteria.

    > Some attributes might not be returned depending on if you're an admin or not.

    > Some available options require administrator privileges.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/users/#list-users)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    example = gitlab.get_users(sort="desc",
        order_by="name",
        created_before="2019-01-01")
    example_two = gitlab.get_users(search="username")
    ```


    :param builtins.bool active: Filter users that are active.
    :param builtins.bool blocked: Filter users that are blocked.
    :param builtins.str created_after: Search for users created after a specific date. (Requires administrator privileges)
    :param builtins.str created_before: Search for users created before a specific date. (Requires administrator privileges)
    :param builtins.bool exclude_external: Filters only non external users.
    :param builtins.bool exclude_internal: Filters only non internal users.
    :param builtins.str extern_provider: Lookup users by external provider. (Requires administrator privileges)
    :param builtins.str extern_uid: Lookup users by external UID. (Requires administrator privileges)
    :param builtins.bool external: Filters only external users.
    :param builtins.str order_by: Order the users' list by `id`, `name`, `username`, `created_at` or `updated_at`. (Requires administrator privileges)
    :param builtins.str search: Search users by username, name or email.
    :param builtins.str sort: Sort users' list in asc or desc order. (Requires administrator privileges)
    :param builtins.str username: Get a single user with a specific username.
    :param builtins.bool without_project_bots: Filters user without project bots.
    """
    __args__ = dict()
    __args__['active'] = active
    __args__['blocked'] = blocked
    __args__['createdAfter'] = created_after
    __args__['createdBefore'] = created_before
    __args__['excludeExternal'] = exclude_external
    __args__['excludeInternal'] = exclude_internal
    __args__['externProvider'] = extern_provider
    __args__['externUid'] = extern_uid
    __args__['external'] = external
    __args__['orderBy'] = order_by
    __args__['search'] = search
    __args__['sort'] = sort
    __args__['username'] = username
    __args__['withoutProjectBots'] = without_project_bots
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gitlab:index/getUsers:getUsers', __args__, opts=opts, typ=GetUsersResult).value

    return AwaitableGetUsersResult(
        active=pulumi.get(__ret__, 'active'),
        blocked=pulumi.get(__ret__, 'blocked'),
        created_after=pulumi.get(__ret__, 'created_after'),
        created_before=pulumi.get(__ret__, 'created_before'),
        exclude_external=pulumi.get(__ret__, 'exclude_external'),
        exclude_internal=pulumi.get(__ret__, 'exclude_internal'),
        extern_provider=pulumi.get(__ret__, 'extern_provider'),
        extern_uid=pulumi.get(__ret__, 'extern_uid'),
        external=pulumi.get(__ret__, 'external'),
        id=pulumi.get(__ret__, 'id'),
        order_by=pulumi.get(__ret__, 'order_by'),
        search=pulumi.get(__ret__, 'search'),
        sort=pulumi.get(__ret__, 'sort'),
        username=pulumi.get(__ret__, 'username'),
        users=pulumi.get(__ret__, 'users'),
        without_project_bots=pulumi.get(__ret__, 'without_project_bots'))
def get_users_output(active: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                     blocked: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                     created_after: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                     created_before: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                     exclude_external: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                     exclude_internal: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                     extern_provider: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                     extern_uid: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                     external: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                     order_by: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                     search: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                     sort: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                     username: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                     without_project_bots: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetUsersResult]:
    """
    The `get_users` data source allows details of multiple users to be retrieved given some optional filter criteria.

    > Some attributes might not be returned depending on if you're an admin or not.

    > Some available options require administrator privileges.

    **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/users/#list-users)

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gitlab as gitlab

    example = gitlab.get_users(sort="desc",
        order_by="name",
        created_before="2019-01-01")
    example_two = gitlab.get_users(search="username")
    ```


    :param builtins.bool active: Filter users that are active.
    :param builtins.bool blocked: Filter users that are blocked.
    :param builtins.str created_after: Search for users created after a specific date. (Requires administrator privileges)
    :param builtins.str created_before: Search for users created before a specific date. (Requires administrator privileges)
    :param builtins.bool exclude_external: Filters only non external users.
    :param builtins.bool exclude_internal: Filters only non internal users.
    :param builtins.str extern_provider: Lookup users by external provider. (Requires administrator privileges)
    :param builtins.str extern_uid: Lookup users by external UID. (Requires administrator privileges)
    :param builtins.bool external: Filters only external users.
    :param builtins.str order_by: Order the users' list by `id`, `name`, `username`, `created_at` or `updated_at`. (Requires administrator privileges)
    :param builtins.str search: Search users by username, name or email.
    :param builtins.str sort: Sort users' list in asc or desc order. (Requires administrator privileges)
    :param builtins.str username: Get a single user with a specific username.
    :param builtins.bool without_project_bots: Filters user without project bots.
    """
    __args__ = dict()
    __args__['active'] = active
    __args__['blocked'] = blocked
    __args__['createdAfter'] = created_after
    __args__['createdBefore'] = created_before
    __args__['excludeExternal'] = exclude_external
    __args__['excludeInternal'] = exclude_internal
    __args__['externProvider'] = extern_provider
    __args__['externUid'] = extern_uid
    __args__['external'] = external
    __args__['orderBy'] = order_by
    __args__['search'] = search
    __args__['sort'] = sort
    __args__['username'] = username
    __args__['withoutProjectBots'] = without_project_bots
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gitlab:index/getUsers:getUsers', __args__, opts=opts, typ=GetUsersResult)
    return __ret__.apply(lambda __response__: GetUsersResult(
        active=pulumi.get(__response__, 'active'),
        blocked=pulumi.get(__response__, 'blocked'),
        created_after=pulumi.get(__response__, 'created_after'),
        created_before=pulumi.get(__response__, 'created_before'),
        exclude_external=pulumi.get(__response__, 'exclude_external'),
        exclude_internal=pulumi.get(__response__, 'exclude_internal'),
        extern_provider=pulumi.get(__response__, 'extern_provider'),
        extern_uid=pulumi.get(__response__, 'extern_uid'),
        external=pulumi.get(__response__, 'external'),
        id=pulumi.get(__response__, 'id'),
        order_by=pulumi.get(__response__, 'order_by'),
        search=pulumi.get(__response__, 'search'),
        sort=pulumi.get(__response__, 'sort'),
        username=pulumi.get(__response__, 'username'),
        users=pulumi.get(__response__, 'users'),
        without_project_bots=pulumi.get(__response__, 'without_project_bots')))
