# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GlobalLevelNotificationsArgs', 'GlobalLevelNotifications']

@pulumi.input_type
class GlobalLevelNotificationsArgs:
    def __init__(__self__, *,
                 close_issue: Optional[pulumi.Input[builtins.bool]] = None,
                 close_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
                 failed_pipeline: Optional[pulumi.Input[builtins.bool]] = None,
                 fixed_pipeline: Optional[pulumi.Input[builtins.bool]] = None,
                 issue_due: Optional[pulumi.Input[builtins.bool]] = None,
                 level: Optional[pulumi.Input[builtins.str]] = None,
                 merge_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
                 merge_when_pipeline_succeeds: Optional[pulumi.Input[builtins.bool]] = None,
                 moved_project: Optional[pulumi.Input[builtins.bool]] = None,
                 new_issue: Optional[pulumi.Input[builtins.bool]] = None,
                 new_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
                 new_note: Optional[pulumi.Input[builtins.bool]] = None,
                 push_to_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
                 reassign_issue: Optional[pulumi.Input[builtins.bool]] = None,
                 reassign_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
                 reopen_issue: Optional[pulumi.Input[builtins.bool]] = None,
                 reopen_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
                 success_pipeline: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a GlobalLevelNotifications resource.
        :param pulumi.Input[builtins.bool] close_issue: Enable notifications for closed issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] close_merge_request: Enable notifications for closed merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] failed_pipeline: Enable notifications for failed pipelines. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] fixed_pipeline: Enable notifications for fixed pipelines. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] issue_due: Enable notifications for due issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.str] level: The level of the notification. Valid values are: `disabled`, `participating`, `watch`, `global`, `mention`, `custom`.
        :param pulumi.Input[builtins.bool] merge_merge_request: Enable notifications for merged merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] merge_when_pipeline_succeeds: Enable notifications for merged merge requests when the pipeline succeeds. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] moved_project: Enable notifications for moved projects. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] new_issue: Enable notifications for new issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] new_merge_request: Enable notifications for new merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] new_note: Enable notifications for new notes on merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] push_to_merge_request: Enable notifications for push to merge request branches. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] reassign_issue: Enable notifications for issue reassignments. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] reassign_merge_request: Enable notifications for merge request reassignments. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] reopen_issue: Enable notifications for reopened issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] reopen_merge_request: Enable notifications for reopened merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] success_pipeline: Enable notifications for successful pipelines. Can only be used when `level` is `custom`.
        """
        if close_issue is not None:
            pulumi.set(__self__, "close_issue", close_issue)
        if close_merge_request is not None:
            pulumi.set(__self__, "close_merge_request", close_merge_request)
        if failed_pipeline is not None:
            pulumi.set(__self__, "failed_pipeline", failed_pipeline)
        if fixed_pipeline is not None:
            pulumi.set(__self__, "fixed_pipeline", fixed_pipeline)
        if issue_due is not None:
            pulumi.set(__self__, "issue_due", issue_due)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if merge_merge_request is not None:
            pulumi.set(__self__, "merge_merge_request", merge_merge_request)
        if merge_when_pipeline_succeeds is not None:
            pulumi.set(__self__, "merge_when_pipeline_succeeds", merge_when_pipeline_succeeds)
        if moved_project is not None:
            pulumi.set(__self__, "moved_project", moved_project)
        if new_issue is not None:
            pulumi.set(__self__, "new_issue", new_issue)
        if new_merge_request is not None:
            pulumi.set(__self__, "new_merge_request", new_merge_request)
        if new_note is not None:
            pulumi.set(__self__, "new_note", new_note)
        if push_to_merge_request is not None:
            pulumi.set(__self__, "push_to_merge_request", push_to_merge_request)
        if reassign_issue is not None:
            pulumi.set(__self__, "reassign_issue", reassign_issue)
        if reassign_merge_request is not None:
            pulumi.set(__self__, "reassign_merge_request", reassign_merge_request)
        if reopen_issue is not None:
            pulumi.set(__self__, "reopen_issue", reopen_issue)
        if reopen_merge_request is not None:
            pulumi.set(__self__, "reopen_merge_request", reopen_merge_request)
        if success_pipeline is not None:
            pulumi.set(__self__, "success_pipeline", success_pipeline)

    @property
    @pulumi.getter(name="closeIssue")
    def close_issue(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for closed issues. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "close_issue")

    @close_issue.setter
    def close_issue(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "close_issue", value)

    @property
    @pulumi.getter(name="closeMergeRequest")
    def close_merge_request(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for closed merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "close_merge_request")

    @close_merge_request.setter
    def close_merge_request(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "close_merge_request", value)

    @property
    @pulumi.getter(name="failedPipeline")
    def failed_pipeline(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for failed pipelines. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "failed_pipeline")

    @failed_pipeline.setter
    def failed_pipeline(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "failed_pipeline", value)

    @property
    @pulumi.getter(name="fixedPipeline")
    def fixed_pipeline(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for fixed pipelines. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "fixed_pipeline")

    @fixed_pipeline.setter
    def fixed_pipeline(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "fixed_pipeline", value)

    @property
    @pulumi.getter(name="issueDue")
    def issue_due(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for due issues. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "issue_due")

    @issue_due.setter
    def issue_due(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "issue_due", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The level of the notification. Valid values are: `disabled`, `participating`, `watch`, `global`, `mention`, `custom`.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter(name="mergeMergeRequest")
    def merge_merge_request(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for merged merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "merge_merge_request")

    @merge_merge_request.setter
    def merge_merge_request(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "merge_merge_request", value)

    @property
    @pulumi.getter(name="mergeWhenPipelineSucceeds")
    def merge_when_pipeline_succeeds(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for merged merge requests when the pipeline succeeds. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "merge_when_pipeline_succeeds")

    @merge_when_pipeline_succeeds.setter
    def merge_when_pipeline_succeeds(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "merge_when_pipeline_succeeds", value)

    @property
    @pulumi.getter(name="movedProject")
    def moved_project(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for moved projects. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "moved_project")

    @moved_project.setter
    def moved_project(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "moved_project", value)

    @property
    @pulumi.getter(name="newIssue")
    def new_issue(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for new issues. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "new_issue")

    @new_issue.setter
    def new_issue(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "new_issue", value)

    @property
    @pulumi.getter(name="newMergeRequest")
    def new_merge_request(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for new merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "new_merge_request")

    @new_merge_request.setter
    def new_merge_request(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "new_merge_request", value)

    @property
    @pulumi.getter(name="newNote")
    def new_note(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for new notes on merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "new_note")

    @new_note.setter
    def new_note(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "new_note", value)

    @property
    @pulumi.getter(name="pushToMergeRequest")
    def push_to_merge_request(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for push to merge request branches. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "push_to_merge_request")

    @push_to_merge_request.setter
    def push_to_merge_request(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "push_to_merge_request", value)

    @property
    @pulumi.getter(name="reassignIssue")
    def reassign_issue(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for issue reassignments. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "reassign_issue")

    @reassign_issue.setter
    def reassign_issue(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reassign_issue", value)

    @property
    @pulumi.getter(name="reassignMergeRequest")
    def reassign_merge_request(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for merge request reassignments. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "reassign_merge_request")

    @reassign_merge_request.setter
    def reassign_merge_request(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reassign_merge_request", value)

    @property
    @pulumi.getter(name="reopenIssue")
    def reopen_issue(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for reopened issues. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "reopen_issue")

    @reopen_issue.setter
    def reopen_issue(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reopen_issue", value)

    @property
    @pulumi.getter(name="reopenMergeRequest")
    def reopen_merge_request(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for reopened merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "reopen_merge_request")

    @reopen_merge_request.setter
    def reopen_merge_request(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reopen_merge_request", value)

    @property
    @pulumi.getter(name="successPipeline")
    def success_pipeline(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for successful pipelines. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "success_pipeline")

    @success_pipeline.setter
    def success_pipeline(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "success_pipeline", value)


@pulumi.input_type
class _GlobalLevelNotificationsState:
    def __init__(__self__, *,
                 close_issue: Optional[pulumi.Input[builtins.bool]] = None,
                 close_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
                 failed_pipeline: Optional[pulumi.Input[builtins.bool]] = None,
                 fixed_pipeline: Optional[pulumi.Input[builtins.bool]] = None,
                 issue_due: Optional[pulumi.Input[builtins.bool]] = None,
                 level: Optional[pulumi.Input[builtins.str]] = None,
                 merge_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
                 merge_when_pipeline_succeeds: Optional[pulumi.Input[builtins.bool]] = None,
                 moved_project: Optional[pulumi.Input[builtins.bool]] = None,
                 new_issue: Optional[pulumi.Input[builtins.bool]] = None,
                 new_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
                 new_note: Optional[pulumi.Input[builtins.bool]] = None,
                 push_to_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
                 reassign_issue: Optional[pulumi.Input[builtins.bool]] = None,
                 reassign_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
                 reopen_issue: Optional[pulumi.Input[builtins.bool]] = None,
                 reopen_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
                 success_pipeline: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering GlobalLevelNotifications resources.
        :param pulumi.Input[builtins.bool] close_issue: Enable notifications for closed issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] close_merge_request: Enable notifications for closed merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] failed_pipeline: Enable notifications for failed pipelines. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] fixed_pipeline: Enable notifications for fixed pipelines. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] issue_due: Enable notifications for due issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.str] level: The level of the notification. Valid values are: `disabled`, `participating`, `watch`, `global`, `mention`, `custom`.
        :param pulumi.Input[builtins.bool] merge_merge_request: Enable notifications for merged merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] merge_when_pipeline_succeeds: Enable notifications for merged merge requests when the pipeline succeeds. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] moved_project: Enable notifications for moved projects. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] new_issue: Enable notifications for new issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] new_merge_request: Enable notifications for new merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] new_note: Enable notifications for new notes on merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] push_to_merge_request: Enable notifications for push to merge request branches. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] reassign_issue: Enable notifications for issue reassignments. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] reassign_merge_request: Enable notifications for merge request reassignments. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] reopen_issue: Enable notifications for reopened issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] reopen_merge_request: Enable notifications for reopened merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] success_pipeline: Enable notifications for successful pipelines. Can only be used when `level` is `custom`.
        """
        if close_issue is not None:
            pulumi.set(__self__, "close_issue", close_issue)
        if close_merge_request is not None:
            pulumi.set(__self__, "close_merge_request", close_merge_request)
        if failed_pipeline is not None:
            pulumi.set(__self__, "failed_pipeline", failed_pipeline)
        if fixed_pipeline is not None:
            pulumi.set(__self__, "fixed_pipeline", fixed_pipeline)
        if issue_due is not None:
            pulumi.set(__self__, "issue_due", issue_due)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if merge_merge_request is not None:
            pulumi.set(__self__, "merge_merge_request", merge_merge_request)
        if merge_when_pipeline_succeeds is not None:
            pulumi.set(__self__, "merge_when_pipeline_succeeds", merge_when_pipeline_succeeds)
        if moved_project is not None:
            pulumi.set(__self__, "moved_project", moved_project)
        if new_issue is not None:
            pulumi.set(__self__, "new_issue", new_issue)
        if new_merge_request is not None:
            pulumi.set(__self__, "new_merge_request", new_merge_request)
        if new_note is not None:
            pulumi.set(__self__, "new_note", new_note)
        if push_to_merge_request is not None:
            pulumi.set(__self__, "push_to_merge_request", push_to_merge_request)
        if reassign_issue is not None:
            pulumi.set(__self__, "reassign_issue", reassign_issue)
        if reassign_merge_request is not None:
            pulumi.set(__self__, "reassign_merge_request", reassign_merge_request)
        if reopen_issue is not None:
            pulumi.set(__self__, "reopen_issue", reopen_issue)
        if reopen_merge_request is not None:
            pulumi.set(__self__, "reopen_merge_request", reopen_merge_request)
        if success_pipeline is not None:
            pulumi.set(__self__, "success_pipeline", success_pipeline)

    @property
    @pulumi.getter(name="closeIssue")
    def close_issue(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for closed issues. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "close_issue")

    @close_issue.setter
    def close_issue(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "close_issue", value)

    @property
    @pulumi.getter(name="closeMergeRequest")
    def close_merge_request(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for closed merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "close_merge_request")

    @close_merge_request.setter
    def close_merge_request(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "close_merge_request", value)

    @property
    @pulumi.getter(name="failedPipeline")
    def failed_pipeline(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for failed pipelines. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "failed_pipeline")

    @failed_pipeline.setter
    def failed_pipeline(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "failed_pipeline", value)

    @property
    @pulumi.getter(name="fixedPipeline")
    def fixed_pipeline(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for fixed pipelines. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "fixed_pipeline")

    @fixed_pipeline.setter
    def fixed_pipeline(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "fixed_pipeline", value)

    @property
    @pulumi.getter(name="issueDue")
    def issue_due(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for due issues. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "issue_due")

    @issue_due.setter
    def issue_due(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "issue_due", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The level of the notification. Valid values are: `disabled`, `participating`, `watch`, `global`, `mention`, `custom`.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter(name="mergeMergeRequest")
    def merge_merge_request(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for merged merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "merge_merge_request")

    @merge_merge_request.setter
    def merge_merge_request(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "merge_merge_request", value)

    @property
    @pulumi.getter(name="mergeWhenPipelineSucceeds")
    def merge_when_pipeline_succeeds(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for merged merge requests when the pipeline succeeds. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "merge_when_pipeline_succeeds")

    @merge_when_pipeline_succeeds.setter
    def merge_when_pipeline_succeeds(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "merge_when_pipeline_succeeds", value)

    @property
    @pulumi.getter(name="movedProject")
    def moved_project(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for moved projects. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "moved_project")

    @moved_project.setter
    def moved_project(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "moved_project", value)

    @property
    @pulumi.getter(name="newIssue")
    def new_issue(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for new issues. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "new_issue")

    @new_issue.setter
    def new_issue(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "new_issue", value)

    @property
    @pulumi.getter(name="newMergeRequest")
    def new_merge_request(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for new merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "new_merge_request")

    @new_merge_request.setter
    def new_merge_request(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "new_merge_request", value)

    @property
    @pulumi.getter(name="newNote")
    def new_note(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for new notes on merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "new_note")

    @new_note.setter
    def new_note(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "new_note", value)

    @property
    @pulumi.getter(name="pushToMergeRequest")
    def push_to_merge_request(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for push to merge request branches. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "push_to_merge_request")

    @push_to_merge_request.setter
    def push_to_merge_request(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "push_to_merge_request", value)

    @property
    @pulumi.getter(name="reassignIssue")
    def reassign_issue(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for issue reassignments. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "reassign_issue")

    @reassign_issue.setter
    def reassign_issue(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reassign_issue", value)

    @property
    @pulumi.getter(name="reassignMergeRequest")
    def reassign_merge_request(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for merge request reassignments. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "reassign_merge_request")

    @reassign_merge_request.setter
    def reassign_merge_request(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reassign_merge_request", value)

    @property
    @pulumi.getter(name="reopenIssue")
    def reopen_issue(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for reopened issues. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "reopen_issue")

    @reopen_issue.setter
    def reopen_issue(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reopen_issue", value)

    @property
    @pulumi.getter(name="reopenMergeRequest")
    def reopen_merge_request(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for reopened merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "reopen_merge_request")

    @reopen_merge_request.setter
    def reopen_merge_request(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reopen_merge_request", value)

    @property
    @pulumi.getter(name="successPipeline")
    def success_pipeline(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable notifications for successful pipelines. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "success_pipeline")

    @success_pipeline.setter
    def success_pipeline(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "success_pipeline", value)


@pulumi.type_token("gitlab:index/globalLevelNotifications:GlobalLevelNotifications")
class GlobalLevelNotifications(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 close_issue: Optional[pulumi.Input[builtins.bool]] = None,
                 close_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
                 failed_pipeline: Optional[pulumi.Input[builtins.bool]] = None,
                 fixed_pipeline: Optional[pulumi.Input[builtins.bool]] = None,
                 issue_due: Optional[pulumi.Input[builtins.bool]] = None,
                 level: Optional[pulumi.Input[builtins.str]] = None,
                 merge_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
                 merge_when_pipeline_succeeds: Optional[pulumi.Input[builtins.bool]] = None,
                 moved_project: Optional[pulumi.Input[builtins.bool]] = None,
                 new_issue: Optional[pulumi.Input[builtins.bool]] = None,
                 new_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
                 new_note: Optional[pulumi.Input[builtins.bool]] = None,
                 push_to_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
                 reassign_issue: Optional[pulumi.Input[builtins.bool]] = None,
                 reassign_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
                 reopen_issue: Optional[pulumi.Input[builtins.bool]] = None,
                 reopen_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
                 success_pipeline: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        The `GlobalLevelNotifications` resource allows to manage global notifications.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/notification_settings/#group--project-level-notification-settings)

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_global_level_notifications`. For example:

        terraform

        import {

          to = gitlab_global_level_notifications.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        Note: You can import a global notification state using "gitlab" as the ID.

        The ID will always be gitlab, because the global notificatio only exists

        once per user

        ```sh
        $ pulumi import gitlab:index/globalLevelNotifications:GlobalLevelNotifications example gitlab
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] close_issue: Enable notifications for closed issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] close_merge_request: Enable notifications for closed merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] failed_pipeline: Enable notifications for failed pipelines. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] fixed_pipeline: Enable notifications for fixed pipelines. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] issue_due: Enable notifications for due issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.str] level: The level of the notification. Valid values are: `disabled`, `participating`, `watch`, `global`, `mention`, `custom`.
        :param pulumi.Input[builtins.bool] merge_merge_request: Enable notifications for merged merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] merge_when_pipeline_succeeds: Enable notifications for merged merge requests when the pipeline succeeds. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] moved_project: Enable notifications for moved projects. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] new_issue: Enable notifications for new issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] new_merge_request: Enable notifications for new merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] new_note: Enable notifications for new notes on merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] push_to_merge_request: Enable notifications for push to merge request branches. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] reassign_issue: Enable notifications for issue reassignments. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] reassign_merge_request: Enable notifications for merge request reassignments. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] reopen_issue: Enable notifications for reopened issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] reopen_merge_request: Enable notifications for reopened merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] success_pipeline: Enable notifications for successful pipelines. Can only be used when `level` is `custom`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[GlobalLevelNotificationsArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `GlobalLevelNotifications` resource allows to manage global notifications.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/notification_settings/#group--project-level-notification-settings)

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_global_level_notifications`. For example:

        terraform

        import {

          to = gitlab_global_level_notifications.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        Note: You can import a global notification state using "gitlab" as the ID.

        The ID will always be gitlab, because the global notificatio only exists

        once per user

        ```sh
        $ pulumi import gitlab:index/globalLevelNotifications:GlobalLevelNotifications example gitlab
        ```

        :param str resource_name: The name of the resource.
        :param GlobalLevelNotificationsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GlobalLevelNotificationsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 close_issue: Optional[pulumi.Input[builtins.bool]] = None,
                 close_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
                 failed_pipeline: Optional[pulumi.Input[builtins.bool]] = None,
                 fixed_pipeline: Optional[pulumi.Input[builtins.bool]] = None,
                 issue_due: Optional[pulumi.Input[builtins.bool]] = None,
                 level: Optional[pulumi.Input[builtins.str]] = None,
                 merge_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
                 merge_when_pipeline_succeeds: Optional[pulumi.Input[builtins.bool]] = None,
                 moved_project: Optional[pulumi.Input[builtins.bool]] = None,
                 new_issue: Optional[pulumi.Input[builtins.bool]] = None,
                 new_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
                 new_note: Optional[pulumi.Input[builtins.bool]] = None,
                 push_to_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
                 reassign_issue: Optional[pulumi.Input[builtins.bool]] = None,
                 reassign_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
                 reopen_issue: Optional[pulumi.Input[builtins.bool]] = None,
                 reopen_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
                 success_pipeline: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GlobalLevelNotificationsArgs.__new__(GlobalLevelNotificationsArgs)

            __props__.__dict__["close_issue"] = close_issue
            __props__.__dict__["close_merge_request"] = close_merge_request
            __props__.__dict__["failed_pipeline"] = failed_pipeline
            __props__.__dict__["fixed_pipeline"] = fixed_pipeline
            __props__.__dict__["issue_due"] = issue_due
            __props__.__dict__["level"] = level
            __props__.__dict__["merge_merge_request"] = merge_merge_request
            __props__.__dict__["merge_when_pipeline_succeeds"] = merge_when_pipeline_succeeds
            __props__.__dict__["moved_project"] = moved_project
            __props__.__dict__["new_issue"] = new_issue
            __props__.__dict__["new_merge_request"] = new_merge_request
            __props__.__dict__["new_note"] = new_note
            __props__.__dict__["push_to_merge_request"] = push_to_merge_request
            __props__.__dict__["reassign_issue"] = reassign_issue
            __props__.__dict__["reassign_merge_request"] = reassign_merge_request
            __props__.__dict__["reopen_issue"] = reopen_issue
            __props__.__dict__["reopen_merge_request"] = reopen_merge_request
            __props__.__dict__["success_pipeline"] = success_pipeline
        super(GlobalLevelNotifications, __self__).__init__(
            'gitlab:index/globalLevelNotifications:GlobalLevelNotifications',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            close_issue: Optional[pulumi.Input[builtins.bool]] = None,
            close_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
            failed_pipeline: Optional[pulumi.Input[builtins.bool]] = None,
            fixed_pipeline: Optional[pulumi.Input[builtins.bool]] = None,
            issue_due: Optional[pulumi.Input[builtins.bool]] = None,
            level: Optional[pulumi.Input[builtins.str]] = None,
            merge_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
            merge_when_pipeline_succeeds: Optional[pulumi.Input[builtins.bool]] = None,
            moved_project: Optional[pulumi.Input[builtins.bool]] = None,
            new_issue: Optional[pulumi.Input[builtins.bool]] = None,
            new_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
            new_note: Optional[pulumi.Input[builtins.bool]] = None,
            push_to_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
            reassign_issue: Optional[pulumi.Input[builtins.bool]] = None,
            reassign_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
            reopen_issue: Optional[pulumi.Input[builtins.bool]] = None,
            reopen_merge_request: Optional[pulumi.Input[builtins.bool]] = None,
            success_pipeline: Optional[pulumi.Input[builtins.bool]] = None) -> 'GlobalLevelNotifications':
        """
        Get an existing GlobalLevelNotifications resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] close_issue: Enable notifications for closed issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] close_merge_request: Enable notifications for closed merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] failed_pipeline: Enable notifications for failed pipelines. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] fixed_pipeline: Enable notifications for fixed pipelines. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] issue_due: Enable notifications for due issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.str] level: The level of the notification. Valid values are: `disabled`, `participating`, `watch`, `global`, `mention`, `custom`.
        :param pulumi.Input[builtins.bool] merge_merge_request: Enable notifications for merged merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] merge_when_pipeline_succeeds: Enable notifications for merged merge requests when the pipeline succeeds. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] moved_project: Enable notifications for moved projects. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] new_issue: Enable notifications for new issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] new_merge_request: Enable notifications for new merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] new_note: Enable notifications for new notes on merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] push_to_merge_request: Enable notifications for push to merge request branches. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] reassign_issue: Enable notifications for issue reassignments. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] reassign_merge_request: Enable notifications for merge request reassignments. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] reopen_issue: Enable notifications for reopened issues. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] reopen_merge_request: Enable notifications for reopened merge requests. Can only be used when `level` is `custom`.
        :param pulumi.Input[builtins.bool] success_pipeline: Enable notifications for successful pipelines. Can only be used when `level` is `custom`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GlobalLevelNotificationsState.__new__(_GlobalLevelNotificationsState)

        __props__.__dict__["close_issue"] = close_issue
        __props__.__dict__["close_merge_request"] = close_merge_request
        __props__.__dict__["failed_pipeline"] = failed_pipeline
        __props__.__dict__["fixed_pipeline"] = fixed_pipeline
        __props__.__dict__["issue_due"] = issue_due
        __props__.__dict__["level"] = level
        __props__.__dict__["merge_merge_request"] = merge_merge_request
        __props__.__dict__["merge_when_pipeline_succeeds"] = merge_when_pipeline_succeeds
        __props__.__dict__["moved_project"] = moved_project
        __props__.__dict__["new_issue"] = new_issue
        __props__.__dict__["new_merge_request"] = new_merge_request
        __props__.__dict__["new_note"] = new_note
        __props__.__dict__["push_to_merge_request"] = push_to_merge_request
        __props__.__dict__["reassign_issue"] = reassign_issue
        __props__.__dict__["reassign_merge_request"] = reassign_merge_request
        __props__.__dict__["reopen_issue"] = reopen_issue
        __props__.__dict__["reopen_merge_request"] = reopen_merge_request
        __props__.__dict__["success_pipeline"] = success_pipeline
        return GlobalLevelNotifications(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="closeIssue")
    def close_issue(self) -> pulumi.Output[builtins.bool]:
        """
        Enable notifications for closed issues. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "close_issue")

    @property
    @pulumi.getter(name="closeMergeRequest")
    def close_merge_request(self) -> pulumi.Output[builtins.bool]:
        """
        Enable notifications for closed merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "close_merge_request")

    @property
    @pulumi.getter(name="failedPipeline")
    def failed_pipeline(self) -> pulumi.Output[builtins.bool]:
        """
        Enable notifications for failed pipelines. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "failed_pipeline")

    @property
    @pulumi.getter(name="fixedPipeline")
    def fixed_pipeline(self) -> pulumi.Output[builtins.bool]:
        """
        Enable notifications for fixed pipelines. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "fixed_pipeline")

    @property
    @pulumi.getter(name="issueDue")
    def issue_due(self) -> pulumi.Output[builtins.bool]:
        """
        Enable notifications for due issues. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "issue_due")

    @property
    @pulumi.getter
    def level(self) -> pulumi.Output[builtins.str]:
        """
        The level of the notification. Valid values are: `disabled`, `participating`, `watch`, `global`, `mention`, `custom`.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter(name="mergeMergeRequest")
    def merge_merge_request(self) -> pulumi.Output[builtins.bool]:
        """
        Enable notifications for merged merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "merge_merge_request")

    @property
    @pulumi.getter(name="mergeWhenPipelineSucceeds")
    def merge_when_pipeline_succeeds(self) -> pulumi.Output[builtins.bool]:
        """
        Enable notifications for merged merge requests when the pipeline succeeds. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "merge_when_pipeline_succeeds")

    @property
    @pulumi.getter(name="movedProject")
    def moved_project(self) -> pulumi.Output[builtins.bool]:
        """
        Enable notifications for moved projects. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "moved_project")

    @property
    @pulumi.getter(name="newIssue")
    def new_issue(self) -> pulumi.Output[builtins.bool]:
        """
        Enable notifications for new issues. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "new_issue")

    @property
    @pulumi.getter(name="newMergeRequest")
    def new_merge_request(self) -> pulumi.Output[builtins.bool]:
        """
        Enable notifications for new merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "new_merge_request")

    @property
    @pulumi.getter(name="newNote")
    def new_note(self) -> pulumi.Output[builtins.bool]:
        """
        Enable notifications for new notes on merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "new_note")

    @property
    @pulumi.getter(name="pushToMergeRequest")
    def push_to_merge_request(self) -> pulumi.Output[builtins.bool]:
        """
        Enable notifications for push to merge request branches. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "push_to_merge_request")

    @property
    @pulumi.getter(name="reassignIssue")
    def reassign_issue(self) -> pulumi.Output[builtins.bool]:
        """
        Enable notifications for issue reassignments. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "reassign_issue")

    @property
    @pulumi.getter(name="reassignMergeRequest")
    def reassign_merge_request(self) -> pulumi.Output[builtins.bool]:
        """
        Enable notifications for merge request reassignments. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "reassign_merge_request")

    @property
    @pulumi.getter(name="reopenIssue")
    def reopen_issue(self) -> pulumi.Output[builtins.bool]:
        """
        Enable notifications for reopened issues. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "reopen_issue")

    @property
    @pulumi.getter(name="reopenMergeRequest")
    def reopen_merge_request(self) -> pulumi.Output[builtins.bool]:
        """
        Enable notifications for reopened merge requests. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "reopen_merge_request")

    @property
    @pulumi.getter(name="successPipeline")
    def success_pipeline(self) -> pulumi.Output[builtins.bool]:
        """
        Enable notifications for successful pipelines. Can only be used when `level` is `custom`.
        """
        return pulumi.get(self, "success_pipeline")

