# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['GroupServiceAccountArgs', 'GroupServiceAccount']

@pulumi.input_type
class GroupServiceAccountArgs:
    def __init__(__self__, *,
                 group: pulumi.Input[builtins.str],
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a GroupServiceAccount resource.
        :param pulumi.Input[builtins.str] group: The ID or URL-encoded path of the group that the service account is created in. Must be a top level group.
        :param pulumi.Input[builtins.str] email: User account email. If not specified, generates an email prepended with `service_account_group_`. Custom email addresses require confirmation before the account is active, unless the group has a matching verified domain.
        :param pulumi.Input[builtins.str] name: The name of the user. If not specified, the default Service account user name is used.
        :param pulumi.Input[builtins.str] username: The username of the user. If not specified, it’s automatically generated.
        """
        pulumi.set(__self__, "group", group)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def group(self) -> pulumi.Input[builtins.str]:
        """
        The ID or URL-encoded path of the group that the service account is created in. Must be a top level group.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User account email. If not specified, generates an email prepended with `service_account_group_`. Custom email addresses require confirmation before the account is active, unless the group has a matching verified domain.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the user. If not specified, the default Service account user name is used.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The username of the user. If not specified, it’s automatically generated.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class _GroupServiceAccountState:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 group: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 service_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering GroupServiceAccount resources.
        :param pulumi.Input[builtins.str] email: User account email. If not specified, generates an email prepended with `service_account_group_`. Custom email addresses require confirmation before the account is active, unless the group has a matching verified domain.
        :param pulumi.Input[builtins.str] group: The ID or URL-encoded path of the group that the service account is created in. Must be a top level group.
        :param pulumi.Input[builtins.str] name: The name of the user. If not specified, the default Service account user name is used.
        :param pulumi.Input[builtins.str] service_account_id: The service account id.
        :param pulumi.Input[builtins.str] username: The username of the user. If not specified, it’s automatically generated.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User account email. If not specified, generates an email prepended with `service_account_group_`. Custom email addresses require confirmation before the account is active, unless the group has a matching verified domain.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID or URL-encoded path of the group that the service account is created in. Must be a top level group.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the user. If not specified, the default Service account user name is used.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The service account id.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_account_id", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The username of the user. If not specified, it’s automatically generated.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("gitlab:index/groupServiceAccount:GroupServiceAccount")
class GroupServiceAccount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 group: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The `GroupServiceAccount` resource allows creating a GitLab group service account.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/group_service_accounts/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        # This must be a top-level group
        example = gitlab.Group("example",
            name="example",
            path="example",
            description="An example group")
        # The service account against the top-level group
        example_sa = gitlab.GroupServiceAccount("example_sa",
            group=example.id,
            name="example-name",
            username="example-username")
        # Group to assign the service account to. Can be the same top-level group resource as above, or a subgroup of that group.
        example_subgroup = gitlab.Group("example_subgroup",
            name="subgroup",
            path="example/subgroup",
            description="An example subgroup")
        # To assign the service account to a group
        example_membership = gitlab.GroupMembership("example_membership",
            group_id=example_subgroup.id,
            user_id=example_sa.service_account_id,
            access_level="developer",
            expires_at="2020-03-14")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_group_service_account`. For example:

        terraform

        import {

          to = gitlab_group_service_account.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        ```sh
        $ pulumi import gitlab:index/groupServiceAccount:GroupServiceAccount You can import a group service account using `<resource> <id>`. The
        ```

        `id` is in the form of <group_id>:<service_account_id>

        ```sh
        $ pulumi import gitlab:index/groupServiceAccount:GroupServiceAccount example example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] email: User account email. If not specified, generates an email prepended with `service_account_group_`. Custom email addresses require confirmation before the account is active, unless the group has a matching verified domain.
        :param pulumi.Input[builtins.str] group: The ID or URL-encoded path of the group that the service account is created in. Must be a top level group.
        :param pulumi.Input[builtins.str] name: The name of the user. If not specified, the default Service account user name is used.
        :param pulumi.Input[builtins.str] username: The username of the user. If not specified, it’s automatically generated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupServiceAccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `GroupServiceAccount` resource allows creating a GitLab group service account.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/group_service_accounts/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        # This must be a top-level group
        example = gitlab.Group("example",
            name="example",
            path="example",
            description="An example group")
        # The service account against the top-level group
        example_sa = gitlab.GroupServiceAccount("example_sa",
            group=example.id,
            name="example-name",
            username="example-username")
        # Group to assign the service account to. Can be the same top-level group resource as above, or a subgroup of that group.
        example_subgroup = gitlab.Group("example_subgroup",
            name="subgroup",
            path="example/subgroup",
            description="An example subgroup")
        # To assign the service account to a group
        example_membership = gitlab.GroupMembership("example_membership",
            group_id=example_subgroup.id,
            user_id=example_sa.service_account_id,
            access_level="developer",
            expires_at="2020-03-14")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_group_service_account`. For example:

        terraform

        import {

          to = gitlab_group_service_account.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        ```sh
        $ pulumi import gitlab:index/groupServiceAccount:GroupServiceAccount You can import a group service account using `<resource> <id>`. The
        ```

        `id` is in the form of <group_id>:<service_account_id>

        ```sh
        $ pulumi import gitlab:index/groupServiceAccount:GroupServiceAccount example example
        ```

        :param str resource_name: The name of the resource.
        :param GroupServiceAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupServiceAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[builtins.str]] = None,
                 group: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupServiceAccountArgs.__new__(GroupServiceAccountArgs)

            __props__.__dict__["email"] = email
            if group is None and not opts.urn:
                raise TypeError("Missing required property 'group'")
            __props__.__dict__["group"] = group
            __props__.__dict__["name"] = name
            __props__.__dict__["username"] = username
            __props__.__dict__["service_account_id"] = None
        super(GroupServiceAccount, __self__).__init__(
            'gitlab:index/groupServiceAccount:GroupServiceAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            email: Optional[pulumi.Input[builtins.str]] = None,
            group: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            service_account_id: Optional[pulumi.Input[builtins.str]] = None,
            username: Optional[pulumi.Input[builtins.str]] = None) -> 'GroupServiceAccount':
        """
        Get an existing GroupServiceAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] email: User account email. If not specified, generates an email prepended with `service_account_group_`. Custom email addresses require confirmation before the account is active, unless the group has a matching verified domain.
        :param pulumi.Input[builtins.str] group: The ID or URL-encoded path of the group that the service account is created in. Must be a top level group.
        :param pulumi.Input[builtins.str] name: The name of the user. If not specified, the default Service account user name is used.
        :param pulumi.Input[builtins.str] service_account_id: The service account id.
        :param pulumi.Input[builtins.str] username: The username of the user. If not specified, it’s automatically generated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupServiceAccountState.__new__(_GroupServiceAccountState)

        __props__.__dict__["email"] = email
        __props__.__dict__["group"] = group
        __props__.__dict__["name"] = name
        __props__.__dict__["service_account_id"] = service_account_id
        __props__.__dict__["username"] = username
        return GroupServiceAccount(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[builtins.str]:
        """
        User account email. If not specified, generates an email prepended with `service_account_group_`. Custom email addresses require confirmation before the account is active, unless the group has a matching verified domain.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def group(self) -> pulumi.Output[builtins.str]:
        """
        The ID or URL-encoded path of the group that the service account is created in. Must be a top level group.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the user. If not specified, the default Service account user name is used.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> pulumi.Output[builtins.str]:
        """
        The service account id.
        """
        return pulumi.get(self, "service_account_id")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The username of the user. If not specified, it’s automatically generated.
        """
        return pulumi.get(self, "username")

