# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 allow_merge_on_skipped_pipeline: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_pipeline_trigger_approve_deployment: Optional[pulumi.Input[builtins.bool]] = None,
                 analytics_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 approvals_before_merge: Optional[pulumi.Input[builtins.int]] = None,
                 archive_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 archived: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_cancel_pending_pipelines: Optional[pulumi.Input[builtins.str]] = None,
                 auto_devops_deploy_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 auto_devops_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_duo_code_review_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 autoclose_referenced_issues: Optional[pulumi.Input[builtins.bool]] = None,
                 avatar: Optional[pulumi.Input[builtins.str]] = None,
                 avatar_hash: Optional[pulumi.Input[builtins.str]] = None,
                 branches: Optional[pulumi.Input[builtins.str]] = None,
                 build_git_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 build_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 builds_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 ci_config_path: Optional[pulumi.Input[builtins.str]] = None,
                 ci_default_git_depth: Optional[pulumi.Input[builtins.int]] = None,
                 ci_delete_pipelines_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 ci_forward_deployment_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ci_forward_deployment_rollback_allowed: Optional[pulumi.Input[builtins.bool]] = None,
                 ci_id_token_sub_claim_components: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ci_pipeline_variables_minimum_override_role: Optional[pulumi.Input[builtins.str]] = None,
                 ci_push_repository_for_job_token_allowed: Optional[pulumi.Input[builtins.bool]] = None,
                 ci_restrict_pipeline_cancellation_role: Optional[pulumi.Input[builtins.str]] = None,
                 ci_separated_caches: Optional[pulumi.Input[builtins.bool]] = None,
                 container_expiration_policy: Optional[pulumi.Input['ProjectContainerExpirationPolicyArgs']] = None,
                 container_registry_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 container_registry_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 default_branch: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 emails_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 environments_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 external_authorization_classification_label: Optional[pulumi.Input[builtins.str]] = None,
                 feature_flags_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 forked_from_project_id: Optional[pulumi.Input[builtins.int]] = None,
                 forking_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 group_runners_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 group_with_project_templates_id: Optional[pulumi.Input[builtins.int]] = None,
                 import_url: Optional[pulumi.Input[builtins.str]] = None,
                 import_url_password: Optional[pulumi.Input[builtins.str]] = None,
                 import_url_username: Optional[pulumi.Input[builtins.str]] = None,
                 infrastructure_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 initialize_with_readme: Optional[pulumi.Input[builtins.bool]] = None,
                 issues_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 issues_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 issues_template: Optional[pulumi.Input[builtins.str]] = None,
                 keep_latest_artifact: Optional[pulumi.Input[builtins.bool]] = None,
                 lfs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 merge_commit_template: Optional[pulumi.Input[builtins.str]] = None,
                 merge_method: Optional[pulumi.Input[builtins.str]] = None,
                 merge_pipelines_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 merge_requests_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 merge_requests_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 merge_requests_template: Optional[pulumi.Input[builtins.str]] = None,
                 merge_trains_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 mirror: Optional[pulumi.Input[builtins.bool]] = None,
                 mirror_overwrites_diverged_branches: Optional[pulumi.Input[builtins.bool]] = None,
                 mirror_trigger_builds: Optional[pulumi.Input[builtins.bool]] = None,
                 model_experiments_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 model_registry_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 monitor_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 mr_default_target_self: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[builtins.int]] = None,
                 only_allow_merge_if_all_discussions_are_resolved: Optional[pulumi.Input[builtins.bool]] = None,
                 only_allow_merge_if_pipeline_succeeds: Optional[pulumi.Input[builtins.bool]] = None,
                 only_mirror_protected_branches: Optional[pulumi.Input[builtins.bool]] = None,
                 packages_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 pages_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 permanently_delete_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 pipelines_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 pre_receive_secret_detection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 prevent_merge_without_jira_issue: Optional[pulumi.Input[builtins.bool]] = None,
                 printing_merge_request_link_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 public_builds: Optional[pulumi.Input[builtins.bool]] = None,
                 public_jobs: Optional[pulumi.Input[builtins.bool]] = None,
                 push_rules: Optional[pulumi.Input['ProjectPushRulesArgs']] = None,
                 releases_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 remove_source_branch_after_merge: Optional[pulumi.Input[builtins.bool]] = None,
                 repository_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 repository_storage: Optional[pulumi.Input[builtins.str]] = None,
                 request_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 requirements_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 resolve_outdated_diff_discussions: Optional[pulumi.Input[builtins.bool]] = None,
                 restrict_user_defined_variables: Optional[pulumi.Input[builtins.bool]] = None,
                 security_and_compliance_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 shared_runners_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 skip_wait_for_default_branch_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 snippets_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 snippets_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 squash_commit_template: Optional[pulumi.Input[builtins.str]] = None,
                 squash_option: Optional[pulumi.Input[builtins.str]] = None,
                 suggestion_commit_message: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 template_name: Optional[pulumi.Input[builtins.str]] = None,
                 template_project_id: Optional[pulumi.Input[builtins.int]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 use_custom_template: Optional[pulumi.Input[builtins.bool]] = None,
                 visibility_level: Optional[pulumi.Input[builtins.str]] = None,
                 wiki_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 wiki_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a Project resource.
        :param pulumi.Input[builtins.bool] allow_merge_on_skipped_pipeline: Set to true if you want to treat skipped pipelines as if they finished with success.
        :param pulumi.Input[builtins.bool] allow_pipeline_trigger_approve_deployment: Set whether or not a pipeline triggerer is allowed to approve deployments. Premium and Ultimate only.
        :param pulumi.Input[builtins.str] analytics_access_level: Set the analytics access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.int] approvals_before_merge: Number of merge request approvals required for merging. Default is 0.
               This field **does not** work well in combination with the `ProjectApprovalRule` resource
               and is most likely gonna be deprecated in a future GitLab version (see [this upstream epic](https://gitlab.com/groups/gitlab-org/-/epics/7572)).
               In the meantime we recommend against using this attribute and use `ProjectApprovalRule` instead.
        :param pulumi.Input[builtins.bool] archive_on_destroy: Set to `true` to archive the project instead of deleting on destroy. If set to `true` it will entire omit the `DELETE` operation.
        :param pulumi.Input[builtins.bool] archived: Whether the project is in read-only mode (archived). Repositories can be archived/unarchived by toggling this parameter.
        :param pulumi.Input[builtins.str] auto_cancel_pending_pipelines: Auto-cancel pending pipelines. This isn’t a boolean, but enabled/disabled.
        :param pulumi.Input[builtins.str] auto_devops_deploy_strategy: Auto Deploy strategy. Valid values are `continuous`, `manual`, `timed_incremental`.
        :param pulumi.Input[builtins.bool] auto_devops_enabled: Enable Auto DevOps for this project.
        :param pulumi.Input[builtins.bool] auto_duo_code_review_enabled: Enable automatic reviews by GitLab Duo on merge requests. Ultimate only. Automatic reviews only work with the GitLab Duo Enterprise add-on.
        :param pulumi.Input[builtins.bool] autoclose_referenced_issues: Set whether auto-closing referenced issues on default branch.
        :param pulumi.Input[builtins.str] avatar: A local path to the avatar image to upload. **Note**: not available for imported resources.
        :param pulumi.Input[builtins.str] avatar_hash: The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
        :param pulumi.Input[builtins.str] branches: Branches to fork (empty for all branches).
        :param pulumi.Input[builtins.str] build_git_strategy: The Git strategy. Defaults to fetch. Valid values are `clone`, `fetch`.
        :param pulumi.Input[builtins.int] build_timeout: The maximum amount of time, in seconds, that a job can run.
        :param pulumi.Input[builtins.str] builds_access_level: Set the builds access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.str] ci_config_path: Custom Path to CI config file.
        :param pulumi.Input[builtins.int] ci_default_git_depth: Default number of revisions for shallow cloning.
        :param pulumi.Input[builtins.int] ci_delete_pipelines_in_seconds: Pipelines older than the configured time are deleted.
        :param pulumi.Input[builtins.bool] ci_forward_deployment_enabled: When a new deployment job starts, skip older deployment jobs that are still pending.
        :param pulumi.Input[builtins.bool] ci_forward_deployment_rollback_allowed: Allow job retries even if the deployment job is outdated.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ci_id_token_sub_claim_components: Fields included in the sub claim of the ID Token. Accepts an array starting with project*path. The array might also include ref*type and ref. Defaults to ["project*path", "ref*type", "ref"]. Introduced in GitLab 17.10.
        :param pulumi.Input[builtins.str] ci_pipeline_variables_minimum_override_role: The minimum role required to set variables when running pipelines and jobs. Introduced in GitLab 17.1. Valid values are `developer`, `maintainer`, `owner`, `no_one_allowed`
        :param pulumi.Input[builtins.bool] ci_push_repository_for_job_token_allowed: Allow Git push requests to your project repository that are authenticated with a CI/CD job token.
        :param pulumi.Input[builtins.str] ci_restrict_pipeline_cancellation_role: The role required to cancel a pipeline or job. Premium and Ultimate only. Valid values are `developer`, `maintainer`, `no one`
        :param pulumi.Input[builtins.bool] ci_separated_caches: Use separate caches for protected branches.
        :param pulumi.Input['ProjectContainerExpirationPolicyArgs'] container_expiration_policy: Set the image cleanup policy for this project. **Note**: this field is sometimes named `container_expiration_policy_attributes` in the GitLab Upstream API.
        :param pulumi.Input[builtins.str] container_registry_access_level: Set visibility of container registry, for this project. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] container_registry_enabled: Enable container registry for the project.
        :param pulumi.Input[builtins.str] default_branch: The default branch for the project.
        :param pulumi.Input[builtins.str] description: A description of the project.
        :param pulumi.Input[builtins.bool] emails_enabled: Enable email notifications.
        :param pulumi.Input[builtins.str] environments_access_level: Set the environments access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.str] external_authorization_classification_label: The classification label for the project.
        :param pulumi.Input[builtins.str] feature_flags_access_level: Set the feature flags access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.int] forked_from_project_id: The id of the project to fork. During create the project is forked and during an update the fork relation is changed.
        :param pulumi.Input[builtins.str] forking_access_level: Set the forking access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] group_runners_enabled: Enable group runners for this project.
        :param pulumi.Input[builtins.int] group_with_project_templates_id: For group-level custom templates, specifies ID of group from which all the custom project templates are sourced. Leave empty for instance-level templates. Requires use*custom*template to be true (enterprise edition).
        :param pulumi.Input[builtins.str] import_url: Git URL to a repository to be imported. Together with `mirror = true` it will setup a Pull Mirror. This can also be used together with `forked_from_project_id` to setup a Pull Mirror for a fork. The fork takes precedence over the import. Make sure to provide the credentials in `import_url_username` and `import_url_password`. GitLab never returns the credentials, thus the provider cannot detect configuration drift in the credentials. They can also not be imported using `pulumi import`. See the examples section for how to properly use it.
        :param pulumi.Input[builtins.str] import_url_password: The password for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related to the provider. This field cannot be imported using `pulumi import`. See the examples section for how to properly use it.
        :param pulumi.Input[builtins.str] import_url_username: The username for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related to the provider. This field cannot be imported using `pulumi import`.  See the examples section for how to properly use it.
        :param pulumi.Input[builtins.str] infrastructure_access_level: Set the infrastructure access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] initialize_with_readme: Create main branch with first commit containing a README.md file. Must be set to `true` if importing an uninitialized project with a different `default_branch`.
        :param pulumi.Input[builtins.str] issues_access_level: Set the issues access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] issues_enabled: Enable issue tracking for the project.
        :param pulumi.Input[builtins.str] issues_template: Sets the template for new issues in the project.
        :param pulumi.Input[builtins.bool] keep_latest_artifact: Disable or enable the ability to keep the latest artifact for this project.
        :param pulumi.Input[builtins.bool] lfs_enabled: Enable LFS for the project.
        :param pulumi.Input[builtins.str] merge_commit_template: Template used to create merge commit message in merge requests.
        :param pulumi.Input[builtins.str] merge_method: Set the merge method. Valid values are `merge`, `rebase_merge`, `ff`.
        :param pulumi.Input[builtins.bool] merge_pipelines_enabled: Enable or disable merge pipelines.
        :param pulumi.Input[builtins.str] merge_requests_access_level: Set the merge requests access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] merge_requests_enabled: Enable merge requests for the project.
        :param pulumi.Input[builtins.str] merge_requests_template: Sets the template for new merge requests in the project.
        :param pulumi.Input[builtins.bool] merge_trains_enabled: Enable or disable merge trains. Requires `merge_pipelines_enabled` to be set to `true` to take effect.
        :param pulumi.Input[builtins.bool] mirror: Enable project pull mirror.
        :param pulumi.Input[builtins.bool] mirror_overwrites_diverged_branches: Enable overwrite diverged branches for a mirrored project.
        :param pulumi.Input[builtins.bool] mirror_trigger_builds: Enable trigger builds on pushes for a mirrored project.
        :param pulumi.Input[builtins.str] model_experiments_access_level: Set visibility of machine learning model experiments. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.str] model_registry_access_level: Set visibility of machine learning model registry. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.str] monitor_access_level: Set the monitor access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] mr_default_target_self: For forked projects, target merge requests to this project. If false, the target will be the upstream project.
        :param pulumi.Input[builtins.str] name: The name of the project.
        :param pulumi.Input[builtins.int] namespace_id: The namespace (group or user) of the project. Defaults to your user.
        :param pulumi.Input[builtins.bool] only_allow_merge_if_all_discussions_are_resolved: Set to true if you want allow merges only if all discussions are resolved.
        :param pulumi.Input[builtins.bool] only_allow_merge_if_pipeline_succeeds: Set to true if you want allow merges only if a pipeline succeeds.
        :param pulumi.Input[builtins.bool] only_mirror_protected_branches: Enable only mirror protected branches for a mirrored project.
        :param pulumi.Input[builtins.bool] packages_enabled: Enable packages repository for the project.
        :param pulumi.Input[builtins.str] pages_access_level: Enable pages access control. Valid values are `public`, `private`, `enabled`, `disabled`.
        :param pulumi.Input[builtins.str] path: The path of the repository.
        :param pulumi.Input[builtins.bool] permanently_delete_on_destroy: Set to `true` to immediately permanently delete the project instead of scheduling a delete for Premium and Ultimate tiers.
        :param pulumi.Input[builtins.bool] pipelines_enabled: Enable pipelines for the project. The `pipelines_enabled` field is being sent as `jobs_enabled` in the GitLab API calls.
        :param pulumi.Input[builtins.bool] pre_receive_secret_detection_enabled: Whether Secret Push Detection is enabled. Requires GitLab Ultimate.
        :param pulumi.Input[builtins.bool] prevent_merge_without_jira_issue: Set whether merge requests require an associated issue from Jira. Premium and Ultimate only.
        :param pulumi.Input[builtins.bool] printing_merge_request_link_enabled: Show link to create/view merge request when pushing from the command line
        :param pulumi.Input[builtins.bool] public_builds: If true, jobs can be viewed by non-project members.
        :param pulumi.Input[builtins.bool] public_jobs: If true, jobs can be viewed by non-project members.
        :param pulumi.Input['ProjectPushRulesArgs'] push_rules: Push rules for the project.
        :param pulumi.Input[builtins.str] releases_access_level: Set the releases access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] remove_source_branch_after_merge: Enable `Delete source branch` option by default for all new merge requests.
        :param pulumi.Input[builtins.str] repository_access_level: Set the repository access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.str] repository_storage: Which storage shard the repository is on. (administrator only)
        :param pulumi.Input[builtins.bool] request_access_enabled: Allow users to request member access.
        :param pulumi.Input[builtins.str] requirements_access_level: Set the requirements access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] resolve_outdated_diff_discussions: Automatically resolve merge request diffs discussions on lines changed with a push.
        :param pulumi.Input[builtins.bool] restrict_user_defined_variables: Allow only users with the Maintainer role to pass user-defined variables when triggering a pipeline.
        :param pulumi.Input[builtins.str] security_and_compliance_access_level: Set the security and compliance access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] shared_runners_enabled: Enable shared runners for this project.
        :param pulumi.Input[builtins.bool] skip_wait_for_default_branch_protection: If `true`, the default behavior to wait for the default branch protection to be created is skipped.
               This is necessary if the current user is not an admin and the default branch protection is disabled on an instance-level.
               There is currently no known way to determine if the default branch protection is disabled on an instance-level for non-admin users.
               This attribute is only used during resource creation, thus changes are suppressed and the attribute cannot be imported.
        :param pulumi.Input[builtins.str] snippets_access_level: Set the snippets access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] snippets_enabled: Enable snippets for the project.
        :param pulumi.Input[builtins.str] squash_commit_template: Template used to create squash commit message in merge requests.
        :param pulumi.Input[builtins.str] squash_option: Squash commits when merge request is merged. Valid values are `never` (Do not allow), `always` (Require), `default_on` (Encourage), or `default_off` (Allow). The default value is `default_off` (Allow).
        :param pulumi.Input[builtins.str] suggestion_commit_message: The commit message used to apply merge request suggestions.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The list of tags for a project; put array of tags, that should be finally assigned to a project. Use topics instead.
        :param pulumi.Input[builtins.str] template_name: When used without use*custom*template, name of a built-in project template. When used with use*custom*template, name of a custom project template. This option is mutually exclusive with `template_project_id`.
        :param pulumi.Input[builtins.int] template_project_id: When used with use*custom*template, project ID of a custom project template. This is preferable to using template*name since template*name may be ambiguous (enterprise edition). This option is mutually exclusive with `template_name`. See `GroupProjectFileTemplate` to set a project as a template project. If a project has not been set as a template, using it here will result in an error.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] topics: The list of topics for the project.
        :param pulumi.Input[builtins.bool] use_custom_template: Use either custom instance or group (with group*with*project*templates*id) project template (enterprise edition).
               	> When using a custom template, [Group Tokens won't work](https://docs.gitlab.com/15.7/ee/user/project/settings/import_export_troubleshooting/#import-using-the-rest-api-fails-when-using-a-group-access-token). You must use a real user's Personal Access Token.
        :param pulumi.Input[builtins.str] visibility_level: Set to `public` to create a public project. Valid values are `private`, `internal`, `public`.
        :param pulumi.Input[builtins.str] wiki_access_level: Set the wiki access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] wiki_enabled: Enable wiki for the project.
        """
        if allow_merge_on_skipped_pipeline is not None:
            pulumi.set(__self__, "allow_merge_on_skipped_pipeline", allow_merge_on_skipped_pipeline)
        if allow_pipeline_trigger_approve_deployment is not None:
            pulumi.set(__self__, "allow_pipeline_trigger_approve_deployment", allow_pipeline_trigger_approve_deployment)
        if analytics_access_level is not None:
            pulumi.set(__self__, "analytics_access_level", analytics_access_level)
        if approvals_before_merge is not None:
            pulumi.set(__self__, "approvals_before_merge", approvals_before_merge)
        if archive_on_destroy is not None:
            pulumi.set(__self__, "archive_on_destroy", archive_on_destroy)
        if archived is not None:
            pulumi.set(__self__, "archived", archived)
        if auto_cancel_pending_pipelines is not None:
            pulumi.set(__self__, "auto_cancel_pending_pipelines", auto_cancel_pending_pipelines)
        if auto_devops_deploy_strategy is not None:
            pulumi.set(__self__, "auto_devops_deploy_strategy", auto_devops_deploy_strategy)
        if auto_devops_enabled is not None:
            pulumi.set(__self__, "auto_devops_enabled", auto_devops_enabled)
        if auto_duo_code_review_enabled is not None:
            pulumi.set(__self__, "auto_duo_code_review_enabled", auto_duo_code_review_enabled)
        if autoclose_referenced_issues is not None:
            pulumi.set(__self__, "autoclose_referenced_issues", autoclose_referenced_issues)
        if avatar is not None:
            pulumi.set(__self__, "avatar", avatar)
        if avatar_hash is not None:
            pulumi.set(__self__, "avatar_hash", avatar_hash)
        if branches is not None:
            pulumi.set(__self__, "branches", branches)
        if build_git_strategy is not None:
            pulumi.set(__self__, "build_git_strategy", build_git_strategy)
        if build_timeout is not None:
            pulumi.set(__self__, "build_timeout", build_timeout)
        if builds_access_level is not None:
            pulumi.set(__self__, "builds_access_level", builds_access_level)
        if ci_config_path is not None:
            pulumi.set(__self__, "ci_config_path", ci_config_path)
        if ci_default_git_depth is not None:
            pulumi.set(__self__, "ci_default_git_depth", ci_default_git_depth)
        if ci_delete_pipelines_in_seconds is not None:
            pulumi.set(__self__, "ci_delete_pipelines_in_seconds", ci_delete_pipelines_in_seconds)
        if ci_forward_deployment_enabled is not None:
            pulumi.set(__self__, "ci_forward_deployment_enabled", ci_forward_deployment_enabled)
        if ci_forward_deployment_rollback_allowed is not None:
            pulumi.set(__self__, "ci_forward_deployment_rollback_allowed", ci_forward_deployment_rollback_allowed)
        if ci_id_token_sub_claim_components is not None:
            pulumi.set(__self__, "ci_id_token_sub_claim_components", ci_id_token_sub_claim_components)
        if ci_pipeline_variables_minimum_override_role is not None:
            pulumi.set(__self__, "ci_pipeline_variables_minimum_override_role", ci_pipeline_variables_minimum_override_role)
        if ci_push_repository_for_job_token_allowed is not None:
            pulumi.set(__self__, "ci_push_repository_for_job_token_allowed", ci_push_repository_for_job_token_allowed)
        if ci_restrict_pipeline_cancellation_role is not None:
            pulumi.set(__self__, "ci_restrict_pipeline_cancellation_role", ci_restrict_pipeline_cancellation_role)
        if ci_separated_caches is not None:
            pulumi.set(__self__, "ci_separated_caches", ci_separated_caches)
        if container_expiration_policy is not None:
            pulumi.set(__self__, "container_expiration_policy", container_expiration_policy)
        if container_registry_access_level is not None:
            pulumi.set(__self__, "container_registry_access_level", container_registry_access_level)
        if container_registry_enabled is not None:
            warnings.warn("""Use `container_registry_access_level` instead.""", DeprecationWarning)
            pulumi.log.warn("""container_registry_enabled is deprecated: Use `container_registry_access_level` instead.""")
        if container_registry_enabled is not None:
            pulumi.set(__self__, "container_registry_enabled", container_registry_enabled)
        if default_branch is not None:
            pulumi.set(__self__, "default_branch", default_branch)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if emails_enabled is not None:
            pulumi.set(__self__, "emails_enabled", emails_enabled)
        if environments_access_level is not None:
            pulumi.set(__self__, "environments_access_level", environments_access_level)
        if external_authorization_classification_label is not None:
            pulumi.set(__self__, "external_authorization_classification_label", external_authorization_classification_label)
        if feature_flags_access_level is not None:
            pulumi.set(__self__, "feature_flags_access_level", feature_flags_access_level)
        if forked_from_project_id is not None:
            pulumi.set(__self__, "forked_from_project_id", forked_from_project_id)
        if forking_access_level is not None:
            pulumi.set(__self__, "forking_access_level", forking_access_level)
        if group_runners_enabled is not None:
            pulumi.set(__self__, "group_runners_enabled", group_runners_enabled)
        if group_with_project_templates_id is not None:
            pulumi.set(__self__, "group_with_project_templates_id", group_with_project_templates_id)
        if import_url is not None:
            pulumi.set(__self__, "import_url", import_url)
        if import_url_password is not None:
            pulumi.set(__self__, "import_url_password", import_url_password)
        if import_url_username is not None:
            pulumi.set(__self__, "import_url_username", import_url_username)
        if infrastructure_access_level is not None:
            pulumi.set(__self__, "infrastructure_access_level", infrastructure_access_level)
        if initialize_with_readme is not None:
            pulumi.set(__self__, "initialize_with_readme", initialize_with_readme)
        if issues_access_level is not None:
            pulumi.set(__self__, "issues_access_level", issues_access_level)
        if issues_enabled is not None:
            pulumi.set(__self__, "issues_enabled", issues_enabled)
        if issues_template is not None:
            pulumi.set(__self__, "issues_template", issues_template)
        if keep_latest_artifact is not None:
            pulumi.set(__self__, "keep_latest_artifact", keep_latest_artifact)
        if lfs_enabled is not None:
            pulumi.set(__self__, "lfs_enabled", lfs_enabled)
        if merge_commit_template is not None:
            pulumi.set(__self__, "merge_commit_template", merge_commit_template)
        if merge_method is not None:
            pulumi.set(__self__, "merge_method", merge_method)
        if merge_pipelines_enabled is not None:
            pulumi.set(__self__, "merge_pipelines_enabled", merge_pipelines_enabled)
        if merge_requests_access_level is not None:
            pulumi.set(__self__, "merge_requests_access_level", merge_requests_access_level)
        if merge_requests_enabled is not None:
            pulumi.set(__self__, "merge_requests_enabled", merge_requests_enabled)
        if merge_requests_template is not None:
            pulumi.set(__self__, "merge_requests_template", merge_requests_template)
        if merge_trains_enabled is not None:
            pulumi.set(__self__, "merge_trains_enabled", merge_trains_enabled)
        if mirror is not None:
            pulumi.set(__self__, "mirror", mirror)
        if mirror_overwrites_diverged_branches is not None:
            pulumi.set(__self__, "mirror_overwrites_diverged_branches", mirror_overwrites_diverged_branches)
        if mirror_trigger_builds is not None:
            pulumi.set(__self__, "mirror_trigger_builds", mirror_trigger_builds)
        if model_experiments_access_level is not None:
            pulumi.set(__self__, "model_experiments_access_level", model_experiments_access_level)
        if model_registry_access_level is not None:
            pulumi.set(__self__, "model_registry_access_level", model_registry_access_level)
        if monitor_access_level is not None:
            pulumi.set(__self__, "monitor_access_level", monitor_access_level)
        if mr_default_target_self is not None:
            pulumi.set(__self__, "mr_default_target_self", mr_default_target_self)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace_id is not None:
            pulumi.set(__self__, "namespace_id", namespace_id)
        if only_allow_merge_if_all_discussions_are_resolved is not None:
            pulumi.set(__self__, "only_allow_merge_if_all_discussions_are_resolved", only_allow_merge_if_all_discussions_are_resolved)
        if only_allow_merge_if_pipeline_succeeds is not None:
            pulumi.set(__self__, "only_allow_merge_if_pipeline_succeeds", only_allow_merge_if_pipeline_succeeds)
        if only_mirror_protected_branches is not None:
            pulumi.set(__self__, "only_mirror_protected_branches", only_mirror_protected_branches)
        if packages_enabled is not None:
            pulumi.set(__self__, "packages_enabled", packages_enabled)
        if pages_access_level is not None:
            pulumi.set(__self__, "pages_access_level", pages_access_level)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if permanently_delete_on_destroy is not None:
            pulumi.set(__self__, "permanently_delete_on_destroy", permanently_delete_on_destroy)
        if pipelines_enabled is not None:
            warnings.warn("""Deprecated in favor of `builds_access_level`""", DeprecationWarning)
            pulumi.log.warn("""pipelines_enabled is deprecated: Deprecated in favor of `builds_access_level`""")
        if pipelines_enabled is not None:
            pulumi.set(__self__, "pipelines_enabled", pipelines_enabled)
        if pre_receive_secret_detection_enabled is not None:
            pulumi.set(__self__, "pre_receive_secret_detection_enabled", pre_receive_secret_detection_enabled)
        if prevent_merge_without_jira_issue is not None:
            pulumi.set(__self__, "prevent_merge_without_jira_issue", prevent_merge_without_jira_issue)
        if printing_merge_request_link_enabled is not None:
            pulumi.set(__self__, "printing_merge_request_link_enabled", printing_merge_request_link_enabled)
        if public_builds is not None:
            warnings.warn("""The `public_builds` attribute has been deprecated in favor of `public_jobs` and will be removed in the next major version of the provider.""", DeprecationWarning)
            pulumi.log.warn("""public_builds is deprecated: The `public_builds` attribute has been deprecated in favor of `public_jobs` and will be removed in the next major version of the provider.""")
        if public_builds is not None:
            pulumi.set(__self__, "public_builds", public_builds)
        if public_jobs is not None:
            pulumi.set(__self__, "public_jobs", public_jobs)
        if push_rules is not None:
            pulumi.set(__self__, "push_rules", push_rules)
        if releases_access_level is not None:
            pulumi.set(__self__, "releases_access_level", releases_access_level)
        if remove_source_branch_after_merge is not None:
            pulumi.set(__self__, "remove_source_branch_after_merge", remove_source_branch_after_merge)
        if repository_access_level is not None:
            pulumi.set(__self__, "repository_access_level", repository_access_level)
        if repository_storage is not None:
            pulumi.set(__self__, "repository_storage", repository_storage)
        if request_access_enabled is not None:
            pulumi.set(__self__, "request_access_enabled", request_access_enabled)
        if requirements_access_level is not None:
            pulumi.set(__self__, "requirements_access_level", requirements_access_level)
        if resolve_outdated_diff_discussions is not None:
            pulumi.set(__self__, "resolve_outdated_diff_discussions", resolve_outdated_diff_discussions)
        if restrict_user_defined_variables is not None:
            pulumi.set(__self__, "restrict_user_defined_variables", restrict_user_defined_variables)
        if security_and_compliance_access_level is not None:
            pulumi.set(__self__, "security_and_compliance_access_level", security_and_compliance_access_level)
        if shared_runners_enabled is not None:
            pulumi.set(__self__, "shared_runners_enabled", shared_runners_enabled)
        if skip_wait_for_default_branch_protection is not None:
            pulumi.set(__self__, "skip_wait_for_default_branch_protection", skip_wait_for_default_branch_protection)
        if snippets_access_level is not None:
            pulumi.set(__self__, "snippets_access_level", snippets_access_level)
        if snippets_enabled is not None:
            pulumi.set(__self__, "snippets_enabled", snippets_enabled)
        if squash_commit_template is not None:
            pulumi.set(__self__, "squash_commit_template", squash_commit_template)
        if squash_option is not None:
            pulumi.set(__self__, "squash_option", squash_option)
        if suggestion_commit_message is not None:
            pulumi.set(__self__, "suggestion_commit_message", suggestion_commit_message)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_name is not None:
            pulumi.set(__self__, "template_name", template_name)
        if template_project_id is not None:
            pulumi.set(__self__, "template_project_id", template_project_id)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)
        if use_custom_template is not None:
            pulumi.set(__self__, "use_custom_template", use_custom_template)
        if visibility_level is not None:
            pulumi.set(__self__, "visibility_level", visibility_level)
        if wiki_access_level is not None:
            pulumi.set(__self__, "wiki_access_level", wiki_access_level)
        if wiki_enabled is not None:
            pulumi.set(__self__, "wiki_enabled", wiki_enabled)

    @property
    @pulumi.getter(name="allowMergeOnSkippedPipeline")
    def allow_merge_on_skipped_pipeline(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set to true if you want to treat skipped pipelines as if they finished with success.
        """
        return pulumi.get(self, "allow_merge_on_skipped_pipeline")

    @allow_merge_on_skipped_pipeline.setter
    def allow_merge_on_skipped_pipeline(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_merge_on_skipped_pipeline", value)

    @property
    @pulumi.getter(name="allowPipelineTriggerApproveDeployment")
    def allow_pipeline_trigger_approve_deployment(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set whether or not a pipeline triggerer is allowed to approve deployments. Premium and Ultimate only.
        """
        return pulumi.get(self, "allow_pipeline_trigger_approve_deployment")

    @allow_pipeline_trigger_approve_deployment.setter
    def allow_pipeline_trigger_approve_deployment(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_pipeline_trigger_approve_deployment", value)

    @property
    @pulumi.getter(name="analyticsAccessLevel")
    def analytics_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the analytics access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "analytics_access_level")

    @analytics_access_level.setter
    def analytics_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "analytics_access_level", value)

    @property
    @pulumi.getter(name="approvalsBeforeMerge")
    def approvals_before_merge(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of merge request approvals required for merging. Default is 0.
        This field **does not** work well in combination with the `ProjectApprovalRule` resource
        and is most likely gonna be deprecated in a future GitLab version (see [this upstream epic](https://gitlab.com/groups/gitlab-org/-/epics/7572)).
        In the meantime we recommend against using this attribute and use `ProjectApprovalRule` instead.
        """
        return pulumi.get(self, "approvals_before_merge")

    @approvals_before_merge.setter
    def approvals_before_merge(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "approvals_before_merge", value)

    @property
    @pulumi.getter(name="archiveOnDestroy")
    def archive_on_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set to `true` to archive the project instead of deleting on destroy. If set to `true` it will entire omit the `DELETE` operation.
        """
        return pulumi.get(self, "archive_on_destroy")

    @archive_on_destroy.setter
    def archive_on_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "archive_on_destroy", value)

    @property
    @pulumi.getter
    def archived(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the project is in read-only mode (archived). Repositories can be archived/unarchived by toggling this parameter.
        """
        return pulumi.get(self, "archived")

    @archived.setter
    def archived(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "archived", value)

    @property
    @pulumi.getter(name="autoCancelPendingPipelines")
    def auto_cancel_pending_pipelines(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Auto-cancel pending pipelines. This isn’t a boolean, but enabled/disabled.
        """
        return pulumi.get(self, "auto_cancel_pending_pipelines")

    @auto_cancel_pending_pipelines.setter
    def auto_cancel_pending_pipelines(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auto_cancel_pending_pipelines", value)

    @property
    @pulumi.getter(name="autoDevopsDeployStrategy")
    def auto_devops_deploy_strategy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Auto Deploy strategy. Valid values are `continuous`, `manual`, `timed_incremental`.
        """
        return pulumi.get(self, "auto_devops_deploy_strategy")

    @auto_devops_deploy_strategy.setter
    def auto_devops_deploy_strategy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auto_devops_deploy_strategy", value)

    @property
    @pulumi.getter(name="autoDevopsEnabled")
    def auto_devops_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable Auto DevOps for this project.
        """
        return pulumi.get(self, "auto_devops_enabled")

    @auto_devops_enabled.setter
    def auto_devops_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_devops_enabled", value)

    @property
    @pulumi.getter(name="autoDuoCodeReviewEnabled")
    def auto_duo_code_review_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable automatic reviews by GitLab Duo on merge requests. Ultimate only. Automatic reviews only work with the GitLab Duo Enterprise add-on.
        """
        return pulumi.get(self, "auto_duo_code_review_enabled")

    @auto_duo_code_review_enabled.setter
    def auto_duo_code_review_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_duo_code_review_enabled", value)

    @property
    @pulumi.getter(name="autocloseReferencedIssues")
    def autoclose_referenced_issues(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set whether auto-closing referenced issues on default branch.
        """
        return pulumi.get(self, "autoclose_referenced_issues")

    @autoclose_referenced_issues.setter
    def autoclose_referenced_issues(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "autoclose_referenced_issues", value)

    @property
    @pulumi.getter
    def avatar(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A local path to the avatar image to upload. **Note**: not available for imported resources.
        """
        return pulumi.get(self, "avatar")

    @avatar.setter
    def avatar(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "avatar", value)

    @property
    @pulumi.getter(name="avatarHash")
    def avatar_hash(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
        """
        return pulumi.get(self, "avatar_hash")

    @avatar_hash.setter
    def avatar_hash(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "avatar_hash", value)

    @property
    @pulumi.getter
    def branches(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Branches to fork (empty for all branches).
        """
        return pulumi.get(self, "branches")

    @branches.setter
    def branches(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "branches", value)

    @property
    @pulumi.getter(name="buildGitStrategy")
    def build_git_strategy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Git strategy. Defaults to fetch. Valid values are `clone`, `fetch`.
        """
        return pulumi.get(self, "build_git_strategy")

    @build_git_strategy.setter
    def build_git_strategy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "build_git_strategy", value)

    @property
    @pulumi.getter(name="buildTimeout")
    def build_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum amount of time, in seconds, that a job can run.
        """
        return pulumi.get(self, "build_timeout")

    @build_timeout.setter
    def build_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "build_timeout", value)

    @property
    @pulumi.getter(name="buildsAccessLevel")
    def builds_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the builds access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "builds_access_level")

    @builds_access_level.setter
    def builds_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "builds_access_level", value)

    @property
    @pulumi.getter(name="ciConfigPath")
    def ci_config_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Custom Path to CI config file.
        """
        return pulumi.get(self, "ci_config_path")

    @ci_config_path.setter
    def ci_config_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ci_config_path", value)

    @property
    @pulumi.getter(name="ciDefaultGitDepth")
    def ci_default_git_depth(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Default number of revisions for shallow cloning.
        """
        return pulumi.get(self, "ci_default_git_depth")

    @ci_default_git_depth.setter
    def ci_default_git_depth(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ci_default_git_depth", value)

    @property
    @pulumi.getter(name="ciDeletePipelinesInSeconds")
    def ci_delete_pipelines_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Pipelines older than the configured time are deleted.
        """
        return pulumi.get(self, "ci_delete_pipelines_in_seconds")

    @ci_delete_pipelines_in_seconds.setter
    def ci_delete_pipelines_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ci_delete_pipelines_in_seconds", value)

    @property
    @pulumi.getter(name="ciForwardDeploymentEnabled")
    def ci_forward_deployment_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When a new deployment job starts, skip older deployment jobs that are still pending.
        """
        return pulumi.get(self, "ci_forward_deployment_enabled")

    @ci_forward_deployment_enabled.setter
    def ci_forward_deployment_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ci_forward_deployment_enabled", value)

    @property
    @pulumi.getter(name="ciForwardDeploymentRollbackAllowed")
    def ci_forward_deployment_rollback_allowed(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow job retries even if the deployment job is outdated.
        """
        return pulumi.get(self, "ci_forward_deployment_rollback_allowed")

    @ci_forward_deployment_rollback_allowed.setter
    def ci_forward_deployment_rollback_allowed(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ci_forward_deployment_rollback_allowed", value)

    @property
    @pulumi.getter(name="ciIdTokenSubClaimComponents")
    def ci_id_token_sub_claim_components(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Fields included in the sub claim of the ID Token. Accepts an array starting with project*path. The array might also include ref*type and ref. Defaults to ["project*path", "ref*type", "ref"]. Introduced in GitLab 17.10.
        """
        return pulumi.get(self, "ci_id_token_sub_claim_components")

    @ci_id_token_sub_claim_components.setter
    def ci_id_token_sub_claim_components(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ci_id_token_sub_claim_components", value)

    @property
    @pulumi.getter(name="ciPipelineVariablesMinimumOverrideRole")
    def ci_pipeline_variables_minimum_override_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The minimum role required to set variables when running pipelines and jobs. Introduced in GitLab 17.1. Valid values are `developer`, `maintainer`, `owner`, `no_one_allowed`
        """
        return pulumi.get(self, "ci_pipeline_variables_minimum_override_role")

    @ci_pipeline_variables_minimum_override_role.setter
    def ci_pipeline_variables_minimum_override_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ci_pipeline_variables_minimum_override_role", value)

    @property
    @pulumi.getter(name="ciPushRepositoryForJobTokenAllowed")
    def ci_push_repository_for_job_token_allowed(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow Git push requests to your project repository that are authenticated with a CI/CD job token.
        """
        return pulumi.get(self, "ci_push_repository_for_job_token_allowed")

    @ci_push_repository_for_job_token_allowed.setter
    def ci_push_repository_for_job_token_allowed(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ci_push_repository_for_job_token_allowed", value)

    @property
    @pulumi.getter(name="ciRestrictPipelineCancellationRole")
    def ci_restrict_pipeline_cancellation_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The role required to cancel a pipeline or job. Premium and Ultimate only. Valid values are `developer`, `maintainer`, `no one`
        """
        return pulumi.get(self, "ci_restrict_pipeline_cancellation_role")

    @ci_restrict_pipeline_cancellation_role.setter
    def ci_restrict_pipeline_cancellation_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ci_restrict_pipeline_cancellation_role", value)

    @property
    @pulumi.getter(name="ciSeparatedCaches")
    def ci_separated_caches(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Use separate caches for protected branches.
        """
        return pulumi.get(self, "ci_separated_caches")

    @ci_separated_caches.setter
    def ci_separated_caches(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ci_separated_caches", value)

    @property
    @pulumi.getter(name="containerExpirationPolicy")
    def container_expiration_policy(self) -> Optional[pulumi.Input['ProjectContainerExpirationPolicyArgs']]:
        """
        Set the image cleanup policy for this project. **Note**: this field is sometimes named `container_expiration_policy_attributes` in the GitLab Upstream API.
        """
        return pulumi.get(self, "container_expiration_policy")

    @container_expiration_policy.setter
    def container_expiration_policy(self, value: Optional[pulumi.Input['ProjectContainerExpirationPolicyArgs']]):
        pulumi.set(self, "container_expiration_policy", value)

    @property
    @pulumi.getter(name="containerRegistryAccessLevel")
    def container_registry_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set visibility of container registry, for this project. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "container_registry_access_level")

    @container_registry_access_level.setter
    def container_registry_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "container_registry_access_level", value)

    @property
    @pulumi.getter(name="containerRegistryEnabled")
    @_utilities.deprecated("""Use `container_registry_access_level` instead.""")
    def container_registry_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable container registry for the project.
        """
        return pulumi.get(self, "container_registry_enabled")

    @container_registry_enabled.setter
    def container_registry_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "container_registry_enabled", value)

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The default branch for the project.
        """
        return pulumi.get(self, "default_branch")

    @default_branch.setter
    def default_branch(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_branch", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="emailsEnabled")
    def emails_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable email notifications.
        """
        return pulumi.get(self, "emails_enabled")

    @emails_enabled.setter
    def emails_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "emails_enabled", value)

    @property
    @pulumi.getter(name="environmentsAccessLevel")
    def environments_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the environments access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "environments_access_level")

    @environments_access_level.setter
    def environments_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "environments_access_level", value)

    @property
    @pulumi.getter(name="externalAuthorizationClassificationLabel")
    def external_authorization_classification_label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The classification label for the project.
        """
        return pulumi.get(self, "external_authorization_classification_label")

    @external_authorization_classification_label.setter
    def external_authorization_classification_label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_authorization_classification_label", value)

    @property
    @pulumi.getter(name="featureFlagsAccessLevel")
    def feature_flags_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the feature flags access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "feature_flags_access_level")

    @feature_flags_access_level.setter
    def feature_flags_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "feature_flags_access_level", value)

    @property
    @pulumi.getter(name="forkedFromProjectId")
    def forked_from_project_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The id of the project to fork. During create the project is forked and during an update the fork relation is changed.
        """
        return pulumi.get(self, "forked_from_project_id")

    @forked_from_project_id.setter
    def forked_from_project_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "forked_from_project_id", value)

    @property
    @pulumi.getter(name="forkingAccessLevel")
    def forking_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the forking access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "forking_access_level")

    @forking_access_level.setter
    def forking_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "forking_access_level", value)

    @property
    @pulumi.getter(name="groupRunnersEnabled")
    def group_runners_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable group runners for this project.
        """
        return pulumi.get(self, "group_runners_enabled")

    @group_runners_enabled.setter
    def group_runners_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "group_runners_enabled", value)

    @property
    @pulumi.getter(name="groupWithProjectTemplatesId")
    def group_with_project_templates_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        For group-level custom templates, specifies ID of group from which all the custom project templates are sourced. Leave empty for instance-level templates. Requires use*custom*template to be true (enterprise edition).
        """
        return pulumi.get(self, "group_with_project_templates_id")

    @group_with_project_templates_id.setter
    def group_with_project_templates_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "group_with_project_templates_id", value)

    @property
    @pulumi.getter(name="importUrl")
    def import_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Git URL to a repository to be imported. Together with `mirror = true` it will setup a Pull Mirror. This can also be used together with `forked_from_project_id` to setup a Pull Mirror for a fork. The fork takes precedence over the import. Make sure to provide the credentials in `import_url_username` and `import_url_password`. GitLab never returns the credentials, thus the provider cannot detect configuration drift in the credentials. They can also not be imported using `pulumi import`. See the examples section for how to properly use it.
        """
        return pulumi.get(self, "import_url")

    @import_url.setter
    def import_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "import_url", value)

    @property
    @pulumi.getter(name="importUrlPassword")
    def import_url_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related to the provider. This field cannot be imported using `pulumi import`. See the examples section for how to properly use it.
        """
        return pulumi.get(self, "import_url_password")

    @import_url_password.setter
    def import_url_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "import_url_password", value)

    @property
    @pulumi.getter(name="importUrlUsername")
    def import_url_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The username for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related to the provider. This field cannot be imported using `pulumi import`.  See the examples section for how to properly use it.
        """
        return pulumi.get(self, "import_url_username")

    @import_url_username.setter
    def import_url_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "import_url_username", value)

    @property
    @pulumi.getter(name="infrastructureAccessLevel")
    def infrastructure_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the infrastructure access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "infrastructure_access_level")

    @infrastructure_access_level.setter
    def infrastructure_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "infrastructure_access_level", value)

    @property
    @pulumi.getter(name="initializeWithReadme")
    def initialize_with_readme(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Create main branch with first commit containing a README.md file. Must be set to `true` if importing an uninitialized project with a different `default_branch`.
        """
        return pulumi.get(self, "initialize_with_readme")

    @initialize_with_readme.setter
    def initialize_with_readme(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "initialize_with_readme", value)

    @property
    @pulumi.getter(name="issuesAccessLevel")
    def issues_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the issues access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "issues_access_level")

    @issues_access_level.setter
    def issues_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "issues_access_level", value)

    @property
    @pulumi.getter(name="issuesEnabled")
    def issues_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable issue tracking for the project.
        """
        return pulumi.get(self, "issues_enabled")

    @issues_enabled.setter
    def issues_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "issues_enabled", value)

    @property
    @pulumi.getter(name="issuesTemplate")
    def issues_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Sets the template for new issues in the project.
        """
        return pulumi.get(self, "issues_template")

    @issues_template.setter
    def issues_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "issues_template", value)

    @property
    @pulumi.getter(name="keepLatestArtifact")
    def keep_latest_artifact(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Disable or enable the ability to keep the latest artifact for this project.
        """
        return pulumi.get(self, "keep_latest_artifact")

    @keep_latest_artifact.setter
    def keep_latest_artifact(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "keep_latest_artifact", value)

    @property
    @pulumi.getter(name="lfsEnabled")
    def lfs_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable LFS for the project.
        """
        return pulumi.get(self, "lfs_enabled")

    @lfs_enabled.setter
    def lfs_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "lfs_enabled", value)

    @property
    @pulumi.getter(name="mergeCommitTemplate")
    def merge_commit_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Template used to create merge commit message in merge requests.
        """
        return pulumi.get(self, "merge_commit_template")

    @merge_commit_template.setter
    def merge_commit_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "merge_commit_template", value)

    @property
    @pulumi.getter(name="mergeMethod")
    def merge_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the merge method. Valid values are `merge`, `rebase_merge`, `ff`.
        """
        return pulumi.get(self, "merge_method")

    @merge_method.setter
    def merge_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "merge_method", value)

    @property
    @pulumi.getter(name="mergePipelinesEnabled")
    def merge_pipelines_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable merge pipelines.
        """
        return pulumi.get(self, "merge_pipelines_enabled")

    @merge_pipelines_enabled.setter
    def merge_pipelines_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "merge_pipelines_enabled", value)

    @property
    @pulumi.getter(name="mergeRequestsAccessLevel")
    def merge_requests_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the merge requests access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "merge_requests_access_level")

    @merge_requests_access_level.setter
    def merge_requests_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "merge_requests_access_level", value)

    @property
    @pulumi.getter(name="mergeRequestsEnabled")
    def merge_requests_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable merge requests for the project.
        """
        return pulumi.get(self, "merge_requests_enabled")

    @merge_requests_enabled.setter
    def merge_requests_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "merge_requests_enabled", value)

    @property
    @pulumi.getter(name="mergeRequestsTemplate")
    def merge_requests_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Sets the template for new merge requests in the project.
        """
        return pulumi.get(self, "merge_requests_template")

    @merge_requests_template.setter
    def merge_requests_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "merge_requests_template", value)

    @property
    @pulumi.getter(name="mergeTrainsEnabled")
    def merge_trains_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable merge trains. Requires `merge_pipelines_enabled` to be set to `true` to take effect.
        """
        return pulumi.get(self, "merge_trains_enabled")

    @merge_trains_enabled.setter
    def merge_trains_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "merge_trains_enabled", value)

    @property
    @pulumi.getter
    def mirror(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable project pull mirror.
        """
        return pulumi.get(self, "mirror")

    @mirror.setter
    def mirror(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "mirror", value)

    @property
    @pulumi.getter(name="mirrorOverwritesDivergedBranches")
    def mirror_overwrites_diverged_branches(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable overwrite diverged branches for a mirrored project.
        """
        return pulumi.get(self, "mirror_overwrites_diverged_branches")

    @mirror_overwrites_diverged_branches.setter
    def mirror_overwrites_diverged_branches(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "mirror_overwrites_diverged_branches", value)

    @property
    @pulumi.getter(name="mirrorTriggerBuilds")
    def mirror_trigger_builds(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable trigger builds on pushes for a mirrored project.
        """
        return pulumi.get(self, "mirror_trigger_builds")

    @mirror_trigger_builds.setter
    def mirror_trigger_builds(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "mirror_trigger_builds", value)

    @property
    @pulumi.getter(name="modelExperimentsAccessLevel")
    def model_experiments_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set visibility of machine learning model experiments. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "model_experiments_access_level")

    @model_experiments_access_level.setter
    def model_experiments_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "model_experiments_access_level", value)

    @property
    @pulumi.getter(name="modelRegistryAccessLevel")
    def model_registry_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set visibility of machine learning model registry. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "model_registry_access_level")

    @model_registry_access_level.setter
    def model_registry_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "model_registry_access_level", value)

    @property
    @pulumi.getter(name="monitorAccessLevel")
    def monitor_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the monitor access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "monitor_access_level")

    @monitor_access_level.setter
    def monitor_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "monitor_access_level", value)

    @property
    @pulumi.getter(name="mrDefaultTargetSelf")
    def mr_default_target_self(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        For forked projects, target merge requests to this project. If false, the target will be the upstream project.
        """
        return pulumi.get(self, "mr_default_target_self")

    @mr_default_target_self.setter
    def mr_default_target_self(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "mr_default_target_self", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The namespace (group or user) of the project. Defaults to your user.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "namespace_id", value)

    @property
    @pulumi.getter(name="onlyAllowMergeIfAllDiscussionsAreResolved")
    def only_allow_merge_if_all_discussions_are_resolved(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set to true if you want allow merges only if all discussions are resolved.
        """
        return pulumi.get(self, "only_allow_merge_if_all_discussions_are_resolved")

    @only_allow_merge_if_all_discussions_are_resolved.setter
    def only_allow_merge_if_all_discussions_are_resolved(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "only_allow_merge_if_all_discussions_are_resolved", value)

    @property
    @pulumi.getter(name="onlyAllowMergeIfPipelineSucceeds")
    def only_allow_merge_if_pipeline_succeeds(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set to true if you want allow merges only if a pipeline succeeds.
        """
        return pulumi.get(self, "only_allow_merge_if_pipeline_succeeds")

    @only_allow_merge_if_pipeline_succeeds.setter
    def only_allow_merge_if_pipeline_succeeds(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "only_allow_merge_if_pipeline_succeeds", value)

    @property
    @pulumi.getter(name="onlyMirrorProtectedBranches")
    def only_mirror_protected_branches(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable only mirror protected branches for a mirrored project.
        """
        return pulumi.get(self, "only_mirror_protected_branches")

    @only_mirror_protected_branches.setter
    def only_mirror_protected_branches(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "only_mirror_protected_branches", value)

    @property
    @pulumi.getter(name="packagesEnabled")
    def packages_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable packages repository for the project.
        """
        return pulumi.get(self, "packages_enabled")

    @packages_enabled.setter
    def packages_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "packages_enabled", value)

    @property
    @pulumi.getter(name="pagesAccessLevel")
    def pages_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enable pages access control. Valid values are `public`, `private`, `enabled`, `disabled`.
        """
        return pulumi.get(self, "pages_access_level")

    @pages_access_level.setter
    def pages_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pages_access_level", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path of the repository.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="permanentlyDeleteOnDestroy")
    def permanently_delete_on_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set to `true` to immediately permanently delete the project instead of scheduling a delete for Premium and Ultimate tiers.
        """
        return pulumi.get(self, "permanently_delete_on_destroy")

    @permanently_delete_on_destroy.setter
    def permanently_delete_on_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "permanently_delete_on_destroy", value)

    @property
    @pulumi.getter(name="pipelinesEnabled")
    @_utilities.deprecated("""Deprecated in favor of `builds_access_level`""")
    def pipelines_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable pipelines for the project. The `pipelines_enabled` field is being sent as `jobs_enabled` in the GitLab API calls.
        """
        return pulumi.get(self, "pipelines_enabled")

    @pipelines_enabled.setter
    def pipelines_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "pipelines_enabled", value)

    @property
    @pulumi.getter(name="preReceiveSecretDetectionEnabled")
    def pre_receive_secret_detection_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether Secret Push Detection is enabled. Requires GitLab Ultimate.
        """
        return pulumi.get(self, "pre_receive_secret_detection_enabled")

    @pre_receive_secret_detection_enabled.setter
    def pre_receive_secret_detection_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "pre_receive_secret_detection_enabled", value)

    @property
    @pulumi.getter(name="preventMergeWithoutJiraIssue")
    def prevent_merge_without_jira_issue(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set whether merge requests require an associated issue from Jira. Premium and Ultimate only.
        """
        return pulumi.get(self, "prevent_merge_without_jira_issue")

    @prevent_merge_without_jira_issue.setter
    def prevent_merge_without_jira_issue(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "prevent_merge_without_jira_issue", value)

    @property
    @pulumi.getter(name="printingMergeRequestLinkEnabled")
    def printing_merge_request_link_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Show link to create/view merge request when pushing from the command line
        """
        return pulumi.get(self, "printing_merge_request_link_enabled")

    @printing_merge_request_link_enabled.setter
    def printing_merge_request_link_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "printing_merge_request_link_enabled", value)

    @property
    @pulumi.getter(name="publicBuilds")
    @_utilities.deprecated("""The `public_builds` attribute has been deprecated in favor of `public_jobs` and will be removed in the next major version of the provider.""")
    def public_builds(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, jobs can be viewed by non-project members.
        """
        return pulumi.get(self, "public_builds")

    @public_builds.setter
    def public_builds(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_builds", value)

    @property
    @pulumi.getter(name="publicJobs")
    def public_jobs(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, jobs can be viewed by non-project members.
        """
        return pulumi.get(self, "public_jobs")

    @public_jobs.setter
    def public_jobs(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_jobs", value)

    @property
    @pulumi.getter(name="pushRules")
    def push_rules(self) -> Optional[pulumi.Input['ProjectPushRulesArgs']]:
        """
        Push rules for the project.
        """
        return pulumi.get(self, "push_rules")

    @push_rules.setter
    def push_rules(self, value: Optional[pulumi.Input['ProjectPushRulesArgs']]):
        pulumi.set(self, "push_rules", value)

    @property
    @pulumi.getter(name="releasesAccessLevel")
    def releases_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the releases access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "releases_access_level")

    @releases_access_level.setter
    def releases_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "releases_access_level", value)

    @property
    @pulumi.getter(name="removeSourceBranchAfterMerge")
    def remove_source_branch_after_merge(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable `Delete source branch` option by default for all new merge requests.
        """
        return pulumi.get(self, "remove_source_branch_after_merge")

    @remove_source_branch_after_merge.setter
    def remove_source_branch_after_merge(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "remove_source_branch_after_merge", value)

    @property
    @pulumi.getter(name="repositoryAccessLevel")
    def repository_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the repository access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "repository_access_level")

    @repository_access_level.setter
    def repository_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repository_access_level", value)

    @property
    @pulumi.getter(name="repositoryStorage")
    def repository_storage(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Which storage shard the repository is on. (administrator only)
        """
        return pulumi.get(self, "repository_storage")

    @repository_storage.setter
    def repository_storage(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repository_storage", value)

    @property
    @pulumi.getter(name="requestAccessEnabled")
    def request_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow users to request member access.
        """
        return pulumi.get(self, "request_access_enabled")

    @request_access_enabled.setter
    def request_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "request_access_enabled", value)

    @property
    @pulumi.getter(name="requirementsAccessLevel")
    def requirements_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the requirements access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "requirements_access_level")

    @requirements_access_level.setter
    def requirements_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "requirements_access_level", value)

    @property
    @pulumi.getter(name="resolveOutdatedDiffDiscussions")
    def resolve_outdated_diff_discussions(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Automatically resolve merge request diffs discussions on lines changed with a push.
        """
        return pulumi.get(self, "resolve_outdated_diff_discussions")

    @resolve_outdated_diff_discussions.setter
    def resolve_outdated_diff_discussions(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "resolve_outdated_diff_discussions", value)

    @property
    @pulumi.getter(name="restrictUserDefinedVariables")
    def restrict_user_defined_variables(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow only users with the Maintainer role to pass user-defined variables when triggering a pipeline.
        """
        return pulumi.get(self, "restrict_user_defined_variables")

    @restrict_user_defined_variables.setter
    def restrict_user_defined_variables(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "restrict_user_defined_variables", value)

    @property
    @pulumi.getter(name="securityAndComplianceAccessLevel")
    def security_and_compliance_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the security and compliance access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "security_and_compliance_access_level")

    @security_and_compliance_access_level.setter
    def security_and_compliance_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_and_compliance_access_level", value)

    @property
    @pulumi.getter(name="sharedRunnersEnabled")
    def shared_runners_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable shared runners for this project.
        """
        return pulumi.get(self, "shared_runners_enabled")

    @shared_runners_enabled.setter
    def shared_runners_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "shared_runners_enabled", value)

    @property
    @pulumi.getter(name="skipWaitForDefaultBranchProtection")
    def skip_wait_for_default_branch_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If `true`, the default behavior to wait for the default branch protection to be created is skipped.
        This is necessary if the current user is not an admin and the default branch protection is disabled on an instance-level.
        There is currently no known way to determine if the default branch protection is disabled on an instance-level for non-admin users.
        This attribute is only used during resource creation, thus changes are suppressed and the attribute cannot be imported.
        """
        return pulumi.get(self, "skip_wait_for_default_branch_protection")

    @skip_wait_for_default_branch_protection.setter
    def skip_wait_for_default_branch_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "skip_wait_for_default_branch_protection", value)

    @property
    @pulumi.getter(name="snippetsAccessLevel")
    def snippets_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the snippets access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "snippets_access_level")

    @snippets_access_level.setter
    def snippets_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snippets_access_level", value)

    @property
    @pulumi.getter(name="snippetsEnabled")
    def snippets_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable snippets for the project.
        """
        return pulumi.get(self, "snippets_enabled")

    @snippets_enabled.setter
    def snippets_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "snippets_enabled", value)

    @property
    @pulumi.getter(name="squashCommitTemplate")
    def squash_commit_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Template used to create squash commit message in merge requests.
        """
        return pulumi.get(self, "squash_commit_template")

    @squash_commit_template.setter
    def squash_commit_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "squash_commit_template", value)

    @property
    @pulumi.getter(name="squashOption")
    def squash_option(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Squash commits when merge request is merged. Valid values are `never` (Do not allow), `always` (Require), `default_on` (Encourage), or `default_off` (Allow). The default value is `default_off` (Allow).
        """
        return pulumi.get(self, "squash_option")

    @squash_option.setter
    def squash_option(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "squash_option", value)

    @property
    @pulumi.getter(name="suggestionCommitMessage")
    def suggestion_commit_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The commit message used to apply merge request suggestions.
        """
        return pulumi.get(self, "suggestion_commit_message")

    @suggestion_commit_message.setter
    def suggestion_commit_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "suggestion_commit_message", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of tags for a project; put array of tags, that should be finally assigned to a project. Use topics instead.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When used without use*custom*template, name of a built-in project template. When used with use*custom*template, name of a custom project template. This option is mutually exclusive with `template_project_id`.
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_name", value)

    @property
    @pulumi.getter(name="templateProjectId")
    def template_project_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        When used with use*custom*template, project ID of a custom project template. This is preferable to using template*name since template*name may be ambiguous (enterprise edition). This option is mutually exclusive with `template_name`. See `GroupProjectFileTemplate` to set a project as a template project. If a project has not been set as a template, using it here will result in an error.
        """
        return pulumi.get(self, "template_project_id")

    @template_project_id.setter
    def template_project_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "template_project_id", value)

    @property
    @pulumi.getter
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of topics for the project.
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "topics", value)

    @property
    @pulumi.getter(name="useCustomTemplate")
    def use_custom_template(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Use either custom instance or group (with group*with*project*templates*id) project template (enterprise edition).
        	> When using a custom template, [Group Tokens won't work](https://docs.gitlab.com/15.7/ee/user/project/settings/import_export_troubleshooting/#import-using-the-rest-api-fails-when-using-a-group-access-token). You must use a real user's Personal Access Token.
        """
        return pulumi.get(self, "use_custom_template")

    @use_custom_template.setter
    def use_custom_template(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_custom_template", value)

    @property
    @pulumi.getter(name="visibilityLevel")
    def visibility_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set to `public` to create a public project. Valid values are `private`, `internal`, `public`.
        """
        return pulumi.get(self, "visibility_level")

    @visibility_level.setter
    def visibility_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "visibility_level", value)

    @property
    @pulumi.getter(name="wikiAccessLevel")
    def wiki_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the wiki access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "wiki_access_level")

    @wiki_access_level.setter
    def wiki_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "wiki_access_level", value)

    @property
    @pulumi.getter(name="wikiEnabled")
    def wiki_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable wiki for the project.
        """
        return pulumi.get(self, "wiki_enabled")

    @wiki_enabled.setter
    def wiki_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "wiki_enabled", value)


@pulumi.input_type
class _ProjectState:
    def __init__(__self__, *,
                 allow_merge_on_skipped_pipeline: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_pipeline_trigger_approve_deployment: Optional[pulumi.Input[builtins.bool]] = None,
                 analytics_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 approvals_before_merge: Optional[pulumi.Input[builtins.int]] = None,
                 archive_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 archived: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_cancel_pending_pipelines: Optional[pulumi.Input[builtins.str]] = None,
                 auto_devops_deploy_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 auto_devops_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_duo_code_review_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 autoclose_referenced_issues: Optional[pulumi.Input[builtins.bool]] = None,
                 avatar: Optional[pulumi.Input[builtins.str]] = None,
                 avatar_hash: Optional[pulumi.Input[builtins.str]] = None,
                 avatar_url: Optional[pulumi.Input[builtins.str]] = None,
                 branches: Optional[pulumi.Input[builtins.str]] = None,
                 build_git_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 build_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 builds_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 ci_config_path: Optional[pulumi.Input[builtins.str]] = None,
                 ci_default_git_depth: Optional[pulumi.Input[builtins.int]] = None,
                 ci_delete_pipelines_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 ci_forward_deployment_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ci_forward_deployment_rollback_allowed: Optional[pulumi.Input[builtins.bool]] = None,
                 ci_id_token_sub_claim_components: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ci_pipeline_variables_minimum_override_role: Optional[pulumi.Input[builtins.str]] = None,
                 ci_push_repository_for_job_token_allowed: Optional[pulumi.Input[builtins.bool]] = None,
                 ci_restrict_pipeline_cancellation_role: Optional[pulumi.Input[builtins.str]] = None,
                 ci_separated_caches: Optional[pulumi.Input[builtins.bool]] = None,
                 container_expiration_policy: Optional[pulumi.Input['ProjectContainerExpirationPolicyArgs']] = None,
                 container_registry_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 container_registry_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 default_branch: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 emails_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 empty_repo: Optional[pulumi.Input[builtins.bool]] = None,
                 environments_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 external_authorization_classification_label: Optional[pulumi.Input[builtins.str]] = None,
                 feature_flags_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 forked_from_project_id: Optional[pulumi.Input[builtins.int]] = None,
                 forking_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 group_runners_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 group_with_project_templates_id: Optional[pulumi.Input[builtins.int]] = None,
                 http_url_to_repo: Optional[pulumi.Input[builtins.str]] = None,
                 import_url: Optional[pulumi.Input[builtins.str]] = None,
                 import_url_password: Optional[pulumi.Input[builtins.str]] = None,
                 import_url_username: Optional[pulumi.Input[builtins.str]] = None,
                 infrastructure_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 initialize_with_readme: Optional[pulumi.Input[builtins.bool]] = None,
                 issues_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 issues_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 issues_template: Optional[pulumi.Input[builtins.str]] = None,
                 keep_latest_artifact: Optional[pulumi.Input[builtins.bool]] = None,
                 lfs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 merge_commit_template: Optional[pulumi.Input[builtins.str]] = None,
                 merge_method: Optional[pulumi.Input[builtins.str]] = None,
                 merge_pipelines_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 merge_requests_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 merge_requests_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 merge_requests_template: Optional[pulumi.Input[builtins.str]] = None,
                 merge_trains_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 mirror: Optional[pulumi.Input[builtins.bool]] = None,
                 mirror_overwrites_diverged_branches: Optional[pulumi.Input[builtins.bool]] = None,
                 mirror_trigger_builds: Optional[pulumi.Input[builtins.bool]] = None,
                 model_experiments_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 model_registry_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 monitor_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 mr_default_target_self: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[builtins.int]] = None,
                 only_allow_merge_if_all_discussions_are_resolved: Optional[pulumi.Input[builtins.bool]] = None,
                 only_allow_merge_if_pipeline_succeeds: Optional[pulumi.Input[builtins.bool]] = None,
                 only_mirror_protected_branches: Optional[pulumi.Input[builtins.bool]] = None,
                 packages_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 pages_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 path_with_namespace: Optional[pulumi.Input[builtins.str]] = None,
                 permanently_delete_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 pipelines_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 pre_receive_secret_detection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 prevent_merge_without_jira_issue: Optional[pulumi.Input[builtins.bool]] = None,
                 printing_merge_request_link_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 public_builds: Optional[pulumi.Input[builtins.bool]] = None,
                 public_jobs: Optional[pulumi.Input[builtins.bool]] = None,
                 push_rules: Optional[pulumi.Input['ProjectPushRulesArgs']] = None,
                 releases_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 remove_source_branch_after_merge: Optional[pulumi.Input[builtins.bool]] = None,
                 repository_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 repository_storage: Optional[pulumi.Input[builtins.str]] = None,
                 request_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 requirements_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 resolve_outdated_diff_discussions: Optional[pulumi.Input[builtins.bool]] = None,
                 restrict_user_defined_variables: Optional[pulumi.Input[builtins.bool]] = None,
                 runners_token: Optional[pulumi.Input[builtins.str]] = None,
                 security_and_compliance_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 shared_runners_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 skip_wait_for_default_branch_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 snippets_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 snippets_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 squash_commit_template: Optional[pulumi.Input[builtins.str]] = None,
                 squash_option: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_url_to_repo: Optional[pulumi.Input[builtins.str]] = None,
                 suggestion_commit_message: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 template_name: Optional[pulumi.Input[builtins.str]] = None,
                 template_project_id: Optional[pulumi.Input[builtins.int]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 use_custom_template: Optional[pulumi.Input[builtins.bool]] = None,
                 visibility_level: Optional[pulumi.Input[builtins.str]] = None,
                 web_url: Optional[pulumi.Input[builtins.str]] = None,
                 wiki_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 wiki_enabled: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Project resources.
        :param pulumi.Input[builtins.bool] allow_merge_on_skipped_pipeline: Set to true if you want to treat skipped pipelines as if they finished with success.
        :param pulumi.Input[builtins.bool] allow_pipeline_trigger_approve_deployment: Set whether or not a pipeline triggerer is allowed to approve deployments. Premium and Ultimate only.
        :param pulumi.Input[builtins.str] analytics_access_level: Set the analytics access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.int] approvals_before_merge: Number of merge request approvals required for merging. Default is 0.
               This field **does not** work well in combination with the `ProjectApprovalRule` resource
               and is most likely gonna be deprecated in a future GitLab version (see [this upstream epic](https://gitlab.com/groups/gitlab-org/-/epics/7572)).
               In the meantime we recommend against using this attribute and use `ProjectApprovalRule` instead.
        :param pulumi.Input[builtins.bool] archive_on_destroy: Set to `true` to archive the project instead of deleting on destroy. If set to `true` it will entire omit the `DELETE` operation.
        :param pulumi.Input[builtins.bool] archived: Whether the project is in read-only mode (archived). Repositories can be archived/unarchived by toggling this parameter.
        :param pulumi.Input[builtins.str] auto_cancel_pending_pipelines: Auto-cancel pending pipelines. This isn’t a boolean, but enabled/disabled.
        :param pulumi.Input[builtins.str] auto_devops_deploy_strategy: Auto Deploy strategy. Valid values are `continuous`, `manual`, `timed_incremental`.
        :param pulumi.Input[builtins.bool] auto_devops_enabled: Enable Auto DevOps for this project.
        :param pulumi.Input[builtins.bool] auto_duo_code_review_enabled: Enable automatic reviews by GitLab Duo on merge requests. Ultimate only. Automatic reviews only work with the GitLab Duo Enterprise add-on.
        :param pulumi.Input[builtins.bool] autoclose_referenced_issues: Set whether auto-closing referenced issues on default branch.
        :param pulumi.Input[builtins.str] avatar: A local path to the avatar image to upload. **Note**: not available for imported resources.
        :param pulumi.Input[builtins.str] avatar_hash: The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
        :param pulumi.Input[builtins.str] avatar_url: The URL of the avatar image.
        :param pulumi.Input[builtins.str] branches: Branches to fork (empty for all branches).
        :param pulumi.Input[builtins.str] build_git_strategy: The Git strategy. Defaults to fetch. Valid values are `clone`, `fetch`.
        :param pulumi.Input[builtins.int] build_timeout: The maximum amount of time, in seconds, that a job can run.
        :param pulumi.Input[builtins.str] builds_access_level: Set the builds access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.str] ci_config_path: Custom Path to CI config file.
        :param pulumi.Input[builtins.int] ci_default_git_depth: Default number of revisions for shallow cloning.
        :param pulumi.Input[builtins.int] ci_delete_pipelines_in_seconds: Pipelines older than the configured time are deleted.
        :param pulumi.Input[builtins.bool] ci_forward_deployment_enabled: When a new deployment job starts, skip older deployment jobs that are still pending.
        :param pulumi.Input[builtins.bool] ci_forward_deployment_rollback_allowed: Allow job retries even if the deployment job is outdated.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ci_id_token_sub_claim_components: Fields included in the sub claim of the ID Token. Accepts an array starting with project*path. The array might also include ref*type and ref. Defaults to ["project*path", "ref*type", "ref"]. Introduced in GitLab 17.10.
        :param pulumi.Input[builtins.str] ci_pipeline_variables_minimum_override_role: The minimum role required to set variables when running pipelines and jobs. Introduced in GitLab 17.1. Valid values are `developer`, `maintainer`, `owner`, `no_one_allowed`
        :param pulumi.Input[builtins.bool] ci_push_repository_for_job_token_allowed: Allow Git push requests to your project repository that are authenticated with a CI/CD job token.
        :param pulumi.Input[builtins.str] ci_restrict_pipeline_cancellation_role: The role required to cancel a pipeline or job. Premium and Ultimate only. Valid values are `developer`, `maintainer`, `no one`
        :param pulumi.Input[builtins.bool] ci_separated_caches: Use separate caches for protected branches.
        :param pulumi.Input['ProjectContainerExpirationPolicyArgs'] container_expiration_policy: Set the image cleanup policy for this project. **Note**: this field is sometimes named `container_expiration_policy_attributes` in the GitLab Upstream API.
        :param pulumi.Input[builtins.str] container_registry_access_level: Set visibility of container registry, for this project. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] container_registry_enabled: Enable container registry for the project.
        :param pulumi.Input[builtins.str] default_branch: The default branch for the project.
        :param pulumi.Input[builtins.str] description: A description of the project.
        :param pulumi.Input[builtins.bool] emails_enabled: Enable email notifications.
        :param pulumi.Input[builtins.bool] empty_repo: Whether the project is empty.
        :param pulumi.Input[builtins.str] environments_access_level: Set the environments access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.str] external_authorization_classification_label: The classification label for the project.
        :param pulumi.Input[builtins.str] feature_flags_access_level: Set the feature flags access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.int] forked_from_project_id: The id of the project to fork. During create the project is forked and during an update the fork relation is changed.
        :param pulumi.Input[builtins.str] forking_access_level: Set the forking access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] group_runners_enabled: Enable group runners for this project.
        :param pulumi.Input[builtins.int] group_with_project_templates_id: For group-level custom templates, specifies ID of group from which all the custom project templates are sourced. Leave empty for instance-level templates. Requires use*custom*template to be true (enterprise edition).
        :param pulumi.Input[builtins.str] http_url_to_repo: URL that can be provided to `git clone` to clone the
        :param pulumi.Input[builtins.str] import_url: Git URL to a repository to be imported. Together with `mirror = true` it will setup a Pull Mirror. This can also be used together with `forked_from_project_id` to setup a Pull Mirror for a fork. The fork takes precedence over the import. Make sure to provide the credentials in `import_url_username` and `import_url_password`. GitLab never returns the credentials, thus the provider cannot detect configuration drift in the credentials. They can also not be imported using `pulumi import`. See the examples section for how to properly use it.
        :param pulumi.Input[builtins.str] import_url_password: The password for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related to the provider. This field cannot be imported using `pulumi import`. See the examples section for how to properly use it.
        :param pulumi.Input[builtins.str] import_url_username: The username for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related to the provider. This field cannot be imported using `pulumi import`.  See the examples section for how to properly use it.
        :param pulumi.Input[builtins.str] infrastructure_access_level: Set the infrastructure access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] initialize_with_readme: Create main branch with first commit containing a README.md file. Must be set to `true` if importing an uninitialized project with a different `default_branch`.
        :param pulumi.Input[builtins.str] issues_access_level: Set the issues access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] issues_enabled: Enable issue tracking for the project.
        :param pulumi.Input[builtins.str] issues_template: Sets the template for new issues in the project.
        :param pulumi.Input[builtins.bool] keep_latest_artifact: Disable or enable the ability to keep the latest artifact for this project.
        :param pulumi.Input[builtins.bool] lfs_enabled: Enable LFS for the project.
        :param pulumi.Input[builtins.str] merge_commit_template: Template used to create merge commit message in merge requests.
        :param pulumi.Input[builtins.str] merge_method: Set the merge method. Valid values are `merge`, `rebase_merge`, `ff`.
        :param pulumi.Input[builtins.bool] merge_pipelines_enabled: Enable or disable merge pipelines.
        :param pulumi.Input[builtins.str] merge_requests_access_level: Set the merge requests access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] merge_requests_enabled: Enable merge requests for the project.
        :param pulumi.Input[builtins.str] merge_requests_template: Sets the template for new merge requests in the project.
        :param pulumi.Input[builtins.bool] merge_trains_enabled: Enable or disable merge trains. Requires `merge_pipelines_enabled` to be set to `true` to take effect.
        :param pulumi.Input[builtins.bool] mirror: Enable project pull mirror.
        :param pulumi.Input[builtins.bool] mirror_overwrites_diverged_branches: Enable overwrite diverged branches for a mirrored project.
        :param pulumi.Input[builtins.bool] mirror_trigger_builds: Enable trigger builds on pushes for a mirrored project.
        :param pulumi.Input[builtins.str] model_experiments_access_level: Set visibility of machine learning model experiments. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.str] model_registry_access_level: Set visibility of machine learning model registry. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.str] monitor_access_level: Set the monitor access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] mr_default_target_self: For forked projects, target merge requests to this project. If false, the target will be the upstream project.
        :param pulumi.Input[builtins.str] name: The name of the project.
        :param pulumi.Input[builtins.int] namespace_id: The namespace (group or user) of the project. Defaults to your user.
        :param pulumi.Input[builtins.bool] only_allow_merge_if_all_discussions_are_resolved: Set to true if you want allow merges only if all discussions are resolved.
        :param pulumi.Input[builtins.bool] only_allow_merge_if_pipeline_succeeds: Set to true if you want allow merges only if a pipeline succeeds.
        :param pulumi.Input[builtins.bool] only_mirror_protected_branches: Enable only mirror protected branches for a mirrored project.
        :param pulumi.Input[builtins.bool] packages_enabled: Enable packages repository for the project.
        :param pulumi.Input[builtins.str] pages_access_level: Enable pages access control. Valid values are `public`, `private`, `enabled`, `disabled`.
        :param pulumi.Input[builtins.str] path: The path of the repository.
        :param pulumi.Input[builtins.str] path_with_namespace: The path of the repository with namespace.
        :param pulumi.Input[builtins.bool] permanently_delete_on_destroy: Set to `true` to immediately permanently delete the project instead of scheduling a delete for Premium and Ultimate tiers.
        :param pulumi.Input[builtins.bool] pipelines_enabled: Enable pipelines for the project. The `pipelines_enabled` field is being sent as `jobs_enabled` in the GitLab API calls.
        :param pulumi.Input[builtins.bool] pre_receive_secret_detection_enabled: Whether Secret Push Detection is enabled. Requires GitLab Ultimate.
        :param pulumi.Input[builtins.bool] prevent_merge_without_jira_issue: Set whether merge requests require an associated issue from Jira. Premium and Ultimate only.
        :param pulumi.Input[builtins.bool] printing_merge_request_link_enabled: Show link to create/view merge request when pushing from the command line
        :param pulumi.Input[builtins.bool] public_builds: If true, jobs can be viewed by non-project members.
        :param pulumi.Input[builtins.bool] public_jobs: If true, jobs can be viewed by non-project members.
        :param pulumi.Input['ProjectPushRulesArgs'] push_rules: Push rules for the project.
        :param pulumi.Input[builtins.str] releases_access_level: Set the releases access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] remove_source_branch_after_merge: Enable `Delete source branch` option by default for all new merge requests.
        :param pulumi.Input[builtins.str] repository_access_level: Set the repository access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.str] repository_storage: Which storage shard the repository is on. (administrator only)
        :param pulumi.Input[builtins.bool] request_access_enabled: Allow users to request member access.
        :param pulumi.Input[builtins.str] requirements_access_level: Set the requirements access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] resolve_outdated_diff_discussions: Automatically resolve merge request diffs discussions on lines changed with a push.
        :param pulumi.Input[builtins.bool] restrict_user_defined_variables: Allow only users with the Maintainer role to pass user-defined variables when triggering a pipeline.
        :param pulumi.Input[builtins.str] runners_token: Registration token to use during runner setup.
        :param pulumi.Input[builtins.str] security_and_compliance_access_level: Set the security and compliance access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] shared_runners_enabled: Enable shared runners for this project.
        :param pulumi.Input[builtins.bool] skip_wait_for_default_branch_protection: If `true`, the default behavior to wait for the default branch protection to be created is skipped.
               This is necessary if the current user is not an admin and the default branch protection is disabled on an instance-level.
               There is currently no known way to determine if the default branch protection is disabled on an instance-level for non-admin users.
               This attribute is only used during resource creation, thus changes are suppressed and the attribute cannot be imported.
        :param pulumi.Input[builtins.str] snippets_access_level: Set the snippets access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] snippets_enabled: Enable snippets for the project.
        :param pulumi.Input[builtins.str] squash_commit_template: Template used to create squash commit message in merge requests.
        :param pulumi.Input[builtins.str] squash_option: Squash commits when merge request is merged. Valid values are `never` (Do not allow), `always` (Require), `default_on` (Encourage), or `default_off` (Allow). The default value is `default_off` (Allow).
        :param pulumi.Input[builtins.str] ssh_url_to_repo: URL that can be provided to `git clone` to clone the
        :param pulumi.Input[builtins.str] suggestion_commit_message: The commit message used to apply merge request suggestions.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The list of tags for a project; put array of tags, that should be finally assigned to a project. Use topics instead.
        :param pulumi.Input[builtins.str] template_name: When used without use*custom*template, name of a built-in project template. When used with use*custom*template, name of a custom project template. This option is mutually exclusive with `template_project_id`.
        :param pulumi.Input[builtins.int] template_project_id: When used with use*custom*template, project ID of a custom project template. This is preferable to using template*name since template*name may be ambiguous (enterprise edition). This option is mutually exclusive with `template_name`. See `GroupProjectFileTemplate` to set a project as a template project. If a project has not been set as a template, using it here will result in an error.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] topics: The list of topics for the project.
        :param pulumi.Input[builtins.bool] use_custom_template: Use either custom instance or group (with group*with*project*templates*id) project template (enterprise edition).
               	> When using a custom template, [Group Tokens won't work](https://docs.gitlab.com/15.7/ee/user/project/settings/import_export_troubleshooting/#import-using-the-rest-api-fails-when-using-a-group-access-token). You must use a real user's Personal Access Token.
        :param pulumi.Input[builtins.str] visibility_level: Set to `public` to create a public project. Valid values are `private`, `internal`, `public`.
        :param pulumi.Input[builtins.str] web_url: URL that can be used to find the project in a browser.
        :param pulumi.Input[builtins.str] wiki_access_level: Set the wiki access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] wiki_enabled: Enable wiki for the project.
        """
        if allow_merge_on_skipped_pipeline is not None:
            pulumi.set(__self__, "allow_merge_on_skipped_pipeline", allow_merge_on_skipped_pipeline)
        if allow_pipeline_trigger_approve_deployment is not None:
            pulumi.set(__self__, "allow_pipeline_trigger_approve_deployment", allow_pipeline_trigger_approve_deployment)
        if analytics_access_level is not None:
            pulumi.set(__self__, "analytics_access_level", analytics_access_level)
        if approvals_before_merge is not None:
            pulumi.set(__self__, "approvals_before_merge", approvals_before_merge)
        if archive_on_destroy is not None:
            pulumi.set(__self__, "archive_on_destroy", archive_on_destroy)
        if archived is not None:
            pulumi.set(__self__, "archived", archived)
        if auto_cancel_pending_pipelines is not None:
            pulumi.set(__self__, "auto_cancel_pending_pipelines", auto_cancel_pending_pipelines)
        if auto_devops_deploy_strategy is not None:
            pulumi.set(__self__, "auto_devops_deploy_strategy", auto_devops_deploy_strategy)
        if auto_devops_enabled is not None:
            pulumi.set(__self__, "auto_devops_enabled", auto_devops_enabled)
        if auto_duo_code_review_enabled is not None:
            pulumi.set(__self__, "auto_duo_code_review_enabled", auto_duo_code_review_enabled)
        if autoclose_referenced_issues is not None:
            pulumi.set(__self__, "autoclose_referenced_issues", autoclose_referenced_issues)
        if avatar is not None:
            pulumi.set(__self__, "avatar", avatar)
        if avatar_hash is not None:
            pulumi.set(__self__, "avatar_hash", avatar_hash)
        if avatar_url is not None:
            pulumi.set(__self__, "avatar_url", avatar_url)
        if branches is not None:
            pulumi.set(__self__, "branches", branches)
        if build_git_strategy is not None:
            pulumi.set(__self__, "build_git_strategy", build_git_strategy)
        if build_timeout is not None:
            pulumi.set(__self__, "build_timeout", build_timeout)
        if builds_access_level is not None:
            pulumi.set(__self__, "builds_access_level", builds_access_level)
        if ci_config_path is not None:
            pulumi.set(__self__, "ci_config_path", ci_config_path)
        if ci_default_git_depth is not None:
            pulumi.set(__self__, "ci_default_git_depth", ci_default_git_depth)
        if ci_delete_pipelines_in_seconds is not None:
            pulumi.set(__self__, "ci_delete_pipelines_in_seconds", ci_delete_pipelines_in_seconds)
        if ci_forward_deployment_enabled is not None:
            pulumi.set(__self__, "ci_forward_deployment_enabled", ci_forward_deployment_enabled)
        if ci_forward_deployment_rollback_allowed is not None:
            pulumi.set(__self__, "ci_forward_deployment_rollback_allowed", ci_forward_deployment_rollback_allowed)
        if ci_id_token_sub_claim_components is not None:
            pulumi.set(__self__, "ci_id_token_sub_claim_components", ci_id_token_sub_claim_components)
        if ci_pipeline_variables_minimum_override_role is not None:
            pulumi.set(__self__, "ci_pipeline_variables_minimum_override_role", ci_pipeline_variables_minimum_override_role)
        if ci_push_repository_for_job_token_allowed is not None:
            pulumi.set(__self__, "ci_push_repository_for_job_token_allowed", ci_push_repository_for_job_token_allowed)
        if ci_restrict_pipeline_cancellation_role is not None:
            pulumi.set(__self__, "ci_restrict_pipeline_cancellation_role", ci_restrict_pipeline_cancellation_role)
        if ci_separated_caches is not None:
            pulumi.set(__self__, "ci_separated_caches", ci_separated_caches)
        if container_expiration_policy is not None:
            pulumi.set(__self__, "container_expiration_policy", container_expiration_policy)
        if container_registry_access_level is not None:
            pulumi.set(__self__, "container_registry_access_level", container_registry_access_level)
        if container_registry_enabled is not None:
            warnings.warn("""Use `container_registry_access_level` instead.""", DeprecationWarning)
            pulumi.log.warn("""container_registry_enabled is deprecated: Use `container_registry_access_level` instead.""")
        if container_registry_enabled is not None:
            pulumi.set(__self__, "container_registry_enabled", container_registry_enabled)
        if default_branch is not None:
            pulumi.set(__self__, "default_branch", default_branch)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if emails_enabled is not None:
            pulumi.set(__self__, "emails_enabled", emails_enabled)
        if empty_repo is not None:
            pulumi.set(__self__, "empty_repo", empty_repo)
        if environments_access_level is not None:
            pulumi.set(__self__, "environments_access_level", environments_access_level)
        if external_authorization_classification_label is not None:
            pulumi.set(__self__, "external_authorization_classification_label", external_authorization_classification_label)
        if feature_flags_access_level is not None:
            pulumi.set(__self__, "feature_flags_access_level", feature_flags_access_level)
        if forked_from_project_id is not None:
            pulumi.set(__self__, "forked_from_project_id", forked_from_project_id)
        if forking_access_level is not None:
            pulumi.set(__self__, "forking_access_level", forking_access_level)
        if group_runners_enabled is not None:
            pulumi.set(__self__, "group_runners_enabled", group_runners_enabled)
        if group_with_project_templates_id is not None:
            pulumi.set(__self__, "group_with_project_templates_id", group_with_project_templates_id)
        if http_url_to_repo is not None:
            pulumi.set(__self__, "http_url_to_repo", http_url_to_repo)
        if import_url is not None:
            pulumi.set(__self__, "import_url", import_url)
        if import_url_password is not None:
            pulumi.set(__self__, "import_url_password", import_url_password)
        if import_url_username is not None:
            pulumi.set(__self__, "import_url_username", import_url_username)
        if infrastructure_access_level is not None:
            pulumi.set(__self__, "infrastructure_access_level", infrastructure_access_level)
        if initialize_with_readme is not None:
            pulumi.set(__self__, "initialize_with_readme", initialize_with_readme)
        if issues_access_level is not None:
            pulumi.set(__self__, "issues_access_level", issues_access_level)
        if issues_enabled is not None:
            pulumi.set(__self__, "issues_enabled", issues_enabled)
        if issues_template is not None:
            pulumi.set(__self__, "issues_template", issues_template)
        if keep_latest_artifact is not None:
            pulumi.set(__self__, "keep_latest_artifact", keep_latest_artifact)
        if lfs_enabled is not None:
            pulumi.set(__self__, "lfs_enabled", lfs_enabled)
        if merge_commit_template is not None:
            pulumi.set(__self__, "merge_commit_template", merge_commit_template)
        if merge_method is not None:
            pulumi.set(__self__, "merge_method", merge_method)
        if merge_pipelines_enabled is not None:
            pulumi.set(__self__, "merge_pipelines_enabled", merge_pipelines_enabled)
        if merge_requests_access_level is not None:
            pulumi.set(__self__, "merge_requests_access_level", merge_requests_access_level)
        if merge_requests_enabled is not None:
            pulumi.set(__self__, "merge_requests_enabled", merge_requests_enabled)
        if merge_requests_template is not None:
            pulumi.set(__self__, "merge_requests_template", merge_requests_template)
        if merge_trains_enabled is not None:
            pulumi.set(__self__, "merge_trains_enabled", merge_trains_enabled)
        if mirror is not None:
            pulumi.set(__self__, "mirror", mirror)
        if mirror_overwrites_diverged_branches is not None:
            pulumi.set(__self__, "mirror_overwrites_diverged_branches", mirror_overwrites_diverged_branches)
        if mirror_trigger_builds is not None:
            pulumi.set(__self__, "mirror_trigger_builds", mirror_trigger_builds)
        if model_experiments_access_level is not None:
            pulumi.set(__self__, "model_experiments_access_level", model_experiments_access_level)
        if model_registry_access_level is not None:
            pulumi.set(__self__, "model_registry_access_level", model_registry_access_level)
        if monitor_access_level is not None:
            pulumi.set(__self__, "monitor_access_level", monitor_access_level)
        if mr_default_target_self is not None:
            pulumi.set(__self__, "mr_default_target_self", mr_default_target_self)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace_id is not None:
            pulumi.set(__self__, "namespace_id", namespace_id)
        if only_allow_merge_if_all_discussions_are_resolved is not None:
            pulumi.set(__self__, "only_allow_merge_if_all_discussions_are_resolved", only_allow_merge_if_all_discussions_are_resolved)
        if only_allow_merge_if_pipeline_succeeds is not None:
            pulumi.set(__self__, "only_allow_merge_if_pipeline_succeeds", only_allow_merge_if_pipeline_succeeds)
        if only_mirror_protected_branches is not None:
            pulumi.set(__self__, "only_mirror_protected_branches", only_mirror_protected_branches)
        if packages_enabled is not None:
            pulumi.set(__self__, "packages_enabled", packages_enabled)
        if pages_access_level is not None:
            pulumi.set(__self__, "pages_access_level", pages_access_level)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if path_with_namespace is not None:
            pulumi.set(__self__, "path_with_namespace", path_with_namespace)
        if permanently_delete_on_destroy is not None:
            pulumi.set(__self__, "permanently_delete_on_destroy", permanently_delete_on_destroy)
        if pipelines_enabled is not None:
            warnings.warn("""Deprecated in favor of `builds_access_level`""", DeprecationWarning)
            pulumi.log.warn("""pipelines_enabled is deprecated: Deprecated in favor of `builds_access_level`""")
        if pipelines_enabled is not None:
            pulumi.set(__self__, "pipelines_enabled", pipelines_enabled)
        if pre_receive_secret_detection_enabled is not None:
            pulumi.set(__self__, "pre_receive_secret_detection_enabled", pre_receive_secret_detection_enabled)
        if prevent_merge_without_jira_issue is not None:
            pulumi.set(__self__, "prevent_merge_without_jira_issue", prevent_merge_without_jira_issue)
        if printing_merge_request_link_enabled is not None:
            pulumi.set(__self__, "printing_merge_request_link_enabled", printing_merge_request_link_enabled)
        if public_builds is not None:
            warnings.warn("""The `public_builds` attribute has been deprecated in favor of `public_jobs` and will be removed in the next major version of the provider.""", DeprecationWarning)
            pulumi.log.warn("""public_builds is deprecated: The `public_builds` attribute has been deprecated in favor of `public_jobs` and will be removed in the next major version of the provider.""")
        if public_builds is not None:
            pulumi.set(__self__, "public_builds", public_builds)
        if public_jobs is not None:
            pulumi.set(__self__, "public_jobs", public_jobs)
        if push_rules is not None:
            pulumi.set(__self__, "push_rules", push_rules)
        if releases_access_level is not None:
            pulumi.set(__self__, "releases_access_level", releases_access_level)
        if remove_source_branch_after_merge is not None:
            pulumi.set(__self__, "remove_source_branch_after_merge", remove_source_branch_after_merge)
        if repository_access_level is not None:
            pulumi.set(__self__, "repository_access_level", repository_access_level)
        if repository_storage is not None:
            pulumi.set(__self__, "repository_storage", repository_storage)
        if request_access_enabled is not None:
            pulumi.set(__self__, "request_access_enabled", request_access_enabled)
        if requirements_access_level is not None:
            pulumi.set(__self__, "requirements_access_level", requirements_access_level)
        if resolve_outdated_diff_discussions is not None:
            pulumi.set(__self__, "resolve_outdated_diff_discussions", resolve_outdated_diff_discussions)
        if restrict_user_defined_variables is not None:
            pulumi.set(__self__, "restrict_user_defined_variables", restrict_user_defined_variables)
        if runners_token is not None:
            pulumi.set(__self__, "runners_token", runners_token)
        if security_and_compliance_access_level is not None:
            pulumi.set(__self__, "security_and_compliance_access_level", security_and_compliance_access_level)
        if shared_runners_enabled is not None:
            pulumi.set(__self__, "shared_runners_enabled", shared_runners_enabled)
        if skip_wait_for_default_branch_protection is not None:
            pulumi.set(__self__, "skip_wait_for_default_branch_protection", skip_wait_for_default_branch_protection)
        if snippets_access_level is not None:
            pulumi.set(__self__, "snippets_access_level", snippets_access_level)
        if snippets_enabled is not None:
            pulumi.set(__self__, "snippets_enabled", snippets_enabled)
        if squash_commit_template is not None:
            pulumi.set(__self__, "squash_commit_template", squash_commit_template)
        if squash_option is not None:
            pulumi.set(__self__, "squash_option", squash_option)
        if ssh_url_to_repo is not None:
            pulumi.set(__self__, "ssh_url_to_repo", ssh_url_to_repo)
        if suggestion_commit_message is not None:
            pulumi.set(__self__, "suggestion_commit_message", suggestion_commit_message)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_name is not None:
            pulumi.set(__self__, "template_name", template_name)
        if template_project_id is not None:
            pulumi.set(__self__, "template_project_id", template_project_id)
        if topics is not None:
            pulumi.set(__self__, "topics", topics)
        if use_custom_template is not None:
            pulumi.set(__self__, "use_custom_template", use_custom_template)
        if visibility_level is not None:
            pulumi.set(__self__, "visibility_level", visibility_level)
        if web_url is not None:
            pulumi.set(__self__, "web_url", web_url)
        if wiki_access_level is not None:
            pulumi.set(__self__, "wiki_access_level", wiki_access_level)
        if wiki_enabled is not None:
            pulumi.set(__self__, "wiki_enabled", wiki_enabled)

    @property
    @pulumi.getter(name="allowMergeOnSkippedPipeline")
    def allow_merge_on_skipped_pipeline(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set to true if you want to treat skipped pipelines as if they finished with success.
        """
        return pulumi.get(self, "allow_merge_on_skipped_pipeline")

    @allow_merge_on_skipped_pipeline.setter
    def allow_merge_on_skipped_pipeline(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_merge_on_skipped_pipeline", value)

    @property
    @pulumi.getter(name="allowPipelineTriggerApproveDeployment")
    def allow_pipeline_trigger_approve_deployment(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set whether or not a pipeline triggerer is allowed to approve deployments. Premium and Ultimate only.
        """
        return pulumi.get(self, "allow_pipeline_trigger_approve_deployment")

    @allow_pipeline_trigger_approve_deployment.setter
    def allow_pipeline_trigger_approve_deployment(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_pipeline_trigger_approve_deployment", value)

    @property
    @pulumi.getter(name="analyticsAccessLevel")
    def analytics_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the analytics access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "analytics_access_level")

    @analytics_access_level.setter
    def analytics_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "analytics_access_level", value)

    @property
    @pulumi.getter(name="approvalsBeforeMerge")
    def approvals_before_merge(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of merge request approvals required for merging. Default is 0.
        This field **does not** work well in combination with the `ProjectApprovalRule` resource
        and is most likely gonna be deprecated in a future GitLab version (see [this upstream epic](https://gitlab.com/groups/gitlab-org/-/epics/7572)).
        In the meantime we recommend against using this attribute and use `ProjectApprovalRule` instead.
        """
        return pulumi.get(self, "approvals_before_merge")

    @approvals_before_merge.setter
    def approvals_before_merge(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "approvals_before_merge", value)

    @property
    @pulumi.getter(name="archiveOnDestroy")
    def archive_on_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set to `true` to archive the project instead of deleting on destroy. If set to `true` it will entire omit the `DELETE` operation.
        """
        return pulumi.get(self, "archive_on_destroy")

    @archive_on_destroy.setter
    def archive_on_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "archive_on_destroy", value)

    @property
    @pulumi.getter
    def archived(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the project is in read-only mode (archived). Repositories can be archived/unarchived by toggling this parameter.
        """
        return pulumi.get(self, "archived")

    @archived.setter
    def archived(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "archived", value)

    @property
    @pulumi.getter(name="autoCancelPendingPipelines")
    def auto_cancel_pending_pipelines(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Auto-cancel pending pipelines. This isn’t a boolean, but enabled/disabled.
        """
        return pulumi.get(self, "auto_cancel_pending_pipelines")

    @auto_cancel_pending_pipelines.setter
    def auto_cancel_pending_pipelines(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auto_cancel_pending_pipelines", value)

    @property
    @pulumi.getter(name="autoDevopsDeployStrategy")
    def auto_devops_deploy_strategy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Auto Deploy strategy. Valid values are `continuous`, `manual`, `timed_incremental`.
        """
        return pulumi.get(self, "auto_devops_deploy_strategy")

    @auto_devops_deploy_strategy.setter
    def auto_devops_deploy_strategy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "auto_devops_deploy_strategy", value)

    @property
    @pulumi.getter(name="autoDevopsEnabled")
    def auto_devops_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable Auto DevOps for this project.
        """
        return pulumi.get(self, "auto_devops_enabled")

    @auto_devops_enabled.setter
    def auto_devops_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_devops_enabled", value)

    @property
    @pulumi.getter(name="autoDuoCodeReviewEnabled")
    def auto_duo_code_review_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable automatic reviews by GitLab Duo on merge requests. Ultimate only. Automatic reviews only work with the GitLab Duo Enterprise add-on.
        """
        return pulumi.get(self, "auto_duo_code_review_enabled")

    @auto_duo_code_review_enabled.setter
    def auto_duo_code_review_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_duo_code_review_enabled", value)

    @property
    @pulumi.getter(name="autocloseReferencedIssues")
    def autoclose_referenced_issues(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set whether auto-closing referenced issues on default branch.
        """
        return pulumi.get(self, "autoclose_referenced_issues")

    @autoclose_referenced_issues.setter
    def autoclose_referenced_issues(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "autoclose_referenced_issues", value)

    @property
    @pulumi.getter
    def avatar(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A local path to the avatar image to upload. **Note**: not available for imported resources.
        """
        return pulumi.get(self, "avatar")

    @avatar.setter
    def avatar(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "avatar", value)

    @property
    @pulumi.getter(name="avatarHash")
    def avatar_hash(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
        """
        return pulumi.get(self, "avatar_hash")

    @avatar_hash.setter
    def avatar_hash(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "avatar_hash", value)

    @property
    @pulumi.getter(name="avatarUrl")
    def avatar_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of the avatar image.
        """
        return pulumi.get(self, "avatar_url")

    @avatar_url.setter
    def avatar_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "avatar_url", value)

    @property
    @pulumi.getter
    def branches(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Branches to fork (empty for all branches).
        """
        return pulumi.get(self, "branches")

    @branches.setter
    def branches(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "branches", value)

    @property
    @pulumi.getter(name="buildGitStrategy")
    def build_git_strategy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Git strategy. Defaults to fetch. Valid values are `clone`, `fetch`.
        """
        return pulumi.get(self, "build_git_strategy")

    @build_git_strategy.setter
    def build_git_strategy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "build_git_strategy", value)

    @property
    @pulumi.getter(name="buildTimeout")
    def build_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The maximum amount of time, in seconds, that a job can run.
        """
        return pulumi.get(self, "build_timeout")

    @build_timeout.setter
    def build_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "build_timeout", value)

    @property
    @pulumi.getter(name="buildsAccessLevel")
    def builds_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the builds access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "builds_access_level")

    @builds_access_level.setter
    def builds_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "builds_access_level", value)

    @property
    @pulumi.getter(name="ciConfigPath")
    def ci_config_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Custom Path to CI config file.
        """
        return pulumi.get(self, "ci_config_path")

    @ci_config_path.setter
    def ci_config_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ci_config_path", value)

    @property
    @pulumi.getter(name="ciDefaultGitDepth")
    def ci_default_git_depth(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Default number of revisions for shallow cloning.
        """
        return pulumi.get(self, "ci_default_git_depth")

    @ci_default_git_depth.setter
    def ci_default_git_depth(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ci_default_git_depth", value)

    @property
    @pulumi.getter(name="ciDeletePipelinesInSeconds")
    def ci_delete_pipelines_in_seconds(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Pipelines older than the configured time are deleted.
        """
        return pulumi.get(self, "ci_delete_pipelines_in_seconds")

    @ci_delete_pipelines_in_seconds.setter
    def ci_delete_pipelines_in_seconds(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ci_delete_pipelines_in_seconds", value)

    @property
    @pulumi.getter(name="ciForwardDeploymentEnabled")
    def ci_forward_deployment_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When a new deployment job starts, skip older deployment jobs that are still pending.
        """
        return pulumi.get(self, "ci_forward_deployment_enabled")

    @ci_forward_deployment_enabled.setter
    def ci_forward_deployment_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ci_forward_deployment_enabled", value)

    @property
    @pulumi.getter(name="ciForwardDeploymentRollbackAllowed")
    def ci_forward_deployment_rollback_allowed(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow job retries even if the deployment job is outdated.
        """
        return pulumi.get(self, "ci_forward_deployment_rollback_allowed")

    @ci_forward_deployment_rollback_allowed.setter
    def ci_forward_deployment_rollback_allowed(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ci_forward_deployment_rollback_allowed", value)

    @property
    @pulumi.getter(name="ciIdTokenSubClaimComponents")
    def ci_id_token_sub_claim_components(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Fields included in the sub claim of the ID Token. Accepts an array starting with project*path. The array might also include ref*type and ref. Defaults to ["project*path", "ref*type", "ref"]. Introduced in GitLab 17.10.
        """
        return pulumi.get(self, "ci_id_token_sub_claim_components")

    @ci_id_token_sub_claim_components.setter
    def ci_id_token_sub_claim_components(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ci_id_token_sub_claim_components", value)

    @property
    @pulumi.getter(name="ciPipelineVariablesMinimumOverrideRole")
    def ci_pipeline_variables_minimum_override_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The minimum role required to set variables when running pipelines and jobs. Introduced in GitLab 17.1. Valid values are `developer`, `maintainer`, `owner`, `no_one_allowed`
        """
        return pulumi.get(self, "ci_pipeline_variables_minimum_override_role")

    @ci_pipeline_variables_minimum_override_role.setter
    def ci_pipeline_variables_minimum_override_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ci_pipeline_variables_minimum_override_role", value)

    @property
    @pulumi.getter(name="ciPushRepositoryForJobTokenAllowed")
    def ci_push_repository_for_job_token_allowed(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow Git push requests to your project repository that are authenticated with a CI/CD job token.
        """
        return pulumi.get(self, "ci_push_repository_for_job_token_allowed")

    @ci_push_repository_for_job_token_allowed.setter
    def ci_push_repository_for_job_token_allowed(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ci_push_repository_for_job_token_allowed", value)

    @property
    @pulumi.getter(name="ciRestrictPipelineCancellationRole")
    def ci_restrict_pipeline_cancellation_role(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The role required to cancel a pipeline or job. Premium and Ultimate only. Valid values are `developer`, `maintainer`, `no one`
        """
        return pulumi.get(self, "ci_restrict_pipeline_cancellation_role")

    @ci_restrict_pipeline_cancellation_role.setter
    def ci_restrict_pipeline_cancellation_role(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ci_restrict_pipeline_cancellation_role", value)

    @property
    @pulumi.getter(name="ciSeparatedCaches")
    def ci_separated_caches(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Use separate caches for protected branches.
        """
        return pulumi.get(self, "ci_separated_caches")

    @ci_separated_caches.setter
    def ci_separated_caches(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ci_separated_caches", value)

    @property
    @pulumi.getter(name="containerExpirationPolicy")
    def container_expiration_policy(self) -> Optional[pulumi.Input['ProjectContainerExpirationPolicyArgs']]:
        """
        Set the image cleanup policy for this project. **Note**: this field is sometimes named `container_expiration_policy_attributes` in the GitLab Upstream API.
        """
        return pulumi.get(self, "container_expiration_policy")

    @container_expiration_policy.setter
    def container_expiration_policy(self, value: Optional[pulumi.Input['ProjectContainerExpirationPolicyArgs']]):
        pulumi.set(self, "container_expiration_policy", value)

    @property
    @pulumi.getter(name="containerRegistryAccessLevel")
    def container_registry_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set visibility of container registry, for this project. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "container_registry_access_level")

    @container_registry_access_level.setter
    def container_registry_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "container_registry_access_level", value)

    @property
    @pulumi.getter(name="containerRegistryEnabled")
    @_utilities.deprecated("""Use `container_registry_access_level` instead.""")
    def container_registry_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable container registry for the project.
        """
        return pulumi.get(self, "container_registry_enabled")

    @container_registry_enabled.setter
    def container_registry_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "container_registry_enabled", value)

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The default branch for the project.
        """
        return pulumi.get(self, "default_branch")

    @default_branch.setter
    def default_branch(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_branch", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="emailsEnabled")
    def emails_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable email notifications.
        """
        return pulumi.get(self, "emails_enabled")

    @emails_enabled.setter
    def emails_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "emails_enabled", value)

    @property
    @pulumi.getter(name="emptyRepo")
    def empty_repo(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the project is empty.
        """
        return pulumi.get(self, "empty_repo")

    @empty_repo.setter
    def empty_repo(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "empty_repo", value)

    @property
    @pulumi.getter(name="environmentsAccessLevel")
    def environments_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the environments access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "environments_access_level")

    @environments_access_level.setter
    def environments_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "environments_access_level", value)

    @property
    @pulumi.getter(name="externalAuthorizationClassificationLabel")
    def external_authorization_classification_label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The classification label for the project.
        """
        return pulumi.get(self, "external_authorization_classification_label")

    @external_authorization_classification_label.setter
    def external_authorization_classification_label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_authorization_classification_label", value)

    @property
    @pulumi.getter(name="featureFlagsAccessLevel")
    def feature_flags_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the feature flags access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "feature_flags_access_level")

    @feature_flags_access_level.setter
    def feature_flags_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "feature_flags_access_level", value)

    @property
    @pulumi.getter(name="forkedFromProjectId")
    def forked_from_project_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The id of the project to fork. During create the project is forked and during an update the fork relation is changed.
        """
        return pulumi.get(self, "forked_from_project_id")

    @forked_from_project_id.setter
    def forked_from_project_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "forked_from_project_id", value)

    @property
    @pulumi.getter(name="forkingAccessLevel")
    def forking_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the forking access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "forking_access_level")

    @forking_access_level.setter
    def forking_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "forking_access_level", value)

    @property
    @pulumi.getter(name="groupRunnersEnabled")
    def group_runners_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable group runners for this project.
        """
        return pulumi.get(self, "group_runners_enabled")

    @group_runners_enabled.setter
    def group_runners_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "group_runners_enabled", value)

    @property
    @pulumi.getter(name="groupWithProjectTemplatesId")
    def group_with_project_templates_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        For group-level custom templates, specifies ID of group from which all the custom project templates are sourced. Leave empty for instance-level templates. Requires use*custom*template to be true (enterprise edition).
        """
        return pulumi.get(self, "group_with_project_templates_id")

    @group_with_project_templates_id.setter
    def group_with_project_templates_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "group_with_project_templates_id", value)

    @property
    @pulumi.getter(name="httpUrlToRepo")
    def http_url_to_repo(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL that can be provided to `git clone` to clone the
        """
        return pulumi.get(self, "http_url_to_repo")

    @http_url_to_repo.setter
    def http_url_to_repo(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "http_url_to_repo", value)

    @property
    @pulumi.getter(name="importUrl")
    def import_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Git URL to a repository to be imported. Together with `mirror = true` it will setup a Pull Mirror. This can also be used together with `forked_from_project_id` to setup a Pull Mirror for a fork. The fork takes precedence over the import. Make sure to provide the credentials in `import_url_username` and `import_url_password`. GitLab never returns the credentials, thus the provider cannot detect configuration drift in the credentials. They can also not be imported using `pulumi import`. See the examples section for how to properly use it.
        """
        return pulumi.get(self, "import_url")

    @import_url.setter
    def import_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "import_url", value)

    @property
    @pulumi.getter(name="importUrlPassword")
    def import_url_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The password for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related to the provider. This field cannot be imported using `pulumi import`. See the examples section for how to properly use it.
        """
        return pulumi.get(self, "import_url_password")

    @import_url_password.setter
    def import_url_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "import_url_password", value)

    @property
    @pulumi.getter(name="importUrlUsername")
    def import_url_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The username for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related to the provider. This field cannot be imported using `pulumi import`.  See the examples section for how to properly use it.
        """
        return pulumi.get(self, "import_url_username")

    @import_url_username.setter
    def import_url_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "import_url_username", value)

    @property
    @pulumi.getter(name="infrastructureAccessLevel")
    def infrastructure_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the infrastructure access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "infrastructure_access_level")

    @infrastructure_access_level.setter
    def infrastructure_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "infrastructure_access_level", value)

    @property
    @pulumi.getter(name="initializeWithReadme")
    def initialize_with_readme(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Create main branch with first commit containing a README.md file. Must be set to `true` if importing an uninitialized project with a different `default_branch`.
        """
        return pulumi.get(self, "initialize_with_readme")

    @initialize_with_readme.setter
    def initialize_with_readme(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "initialize_with_readme", value)

    @property
    @pulumi.getter(name="issuesAccessLevel")
    def issues_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the issues access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "issues_access_level")

    @issues_access_level.setter
    def issues_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "issues_access_level", value)

    @property
    @pulumi.getter(name="issuesEnabled")
    def issues_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable issue tracking for the project.
        """
        return pulumi.get(self, "issues_enabled")

    @issues_enabled.setter
    def issues_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "issues_enabled", value)

    @property
    @pulumi.getter(name="issuesTemplate")
    def issues_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Sets the template for new issues in the project.
        """
        return pulumi.get(self, "issues_template")

    @issues_template.setter
    def issues_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "issues_template", value)

    @property
    @pulumi.getter(name="keepLatestArtifact")
    def keep_latest_artifact(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Disable or enable the ability to keep the latest artifact for this project.
        """
        return pulumi.get(self, "keep_latest_artifact")

    @keep_latest_artifact.setter
    def keep_latest_artifact(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "keep_latest_artifact", value)

    @property
    @pulumi.getter(name="lfsEnabled")
    def lfs_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable LFS for the project.
        """
        return pulumi.get(self, "lfs_enabled")

    @lfs_enabled.setter
    def lfs_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "lfs_enabled", value)

    @property
    @pulumi.getter(name="mergeCommitTemplate")
    def merge_commit_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Template used to create merge commit message in merge requests.
        """
        return pulumi.get(self, "merge_commit_template")

    @merge_commit_template.setter
    def merge_commit_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "merge_commit_template", value)

    @property
    @pulumi.getter(name="mergeMethod")
    def merge_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the merge method. Valid values are `merge`, `rebase_merge`, `ff`.
        """
        return pulumi.get(self, "merge_method")

    @merge_method.setter
    def merge_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "merge_method", value)

    @property
    @pulumi.getter(name="mergePipelinesEnabled")
    def merge_pipelines_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable merge pipelines.
        """
        return pulumi.get(self, "merge_pipelines_enabled")

    @merge_pipelines_enabled.setter
    def merge_pipelines_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "merge_pipelines_enabled", value)

    @property
    @pulumi.getter(name="mergeRequestsAccessLevel")
    def merge_requests_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the merge requests access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "merge_requests_access_level")

    @merge_requests_access_level.setter
    def merge_requests_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "merge_requests_access_level", value)

    @property
    @pulumi.getter(name="mergeRequestsEnabled")
    def merge_requests_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable merge requests for the project.
        """
        return pulumi.get(self, "merge_requests_enabled")

    @merge_requests_enabled.setter
    def merge_requests_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "merge_requests_enabled", value)

    @property
    @pulumi.getter(name="mergeRequestsTemplate")
    def merge_requests_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Sets the template for new merge requests in the project.
        """
        return pulumi.get(self, "merge_requests_template")

    @merge_requests_template.setter
    def merge_requests_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "merge_requests_template", value)

    @property
    @pulumi.getter(name="mergeTrainsEnabled")
    def merge_trains_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable merge trains. Requires `merge_pipelines_enabled` to be set to `true` to take effect.
        """
        return pulumi.get(self, "merge_trains_enabled")

    @merge_trains_enabled.setter
    def merge_trains_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "merge_trains_enabled", value)

    @property
    @pulumi.getter
    def mirror(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable project pull mirror.
        """
        return pulumi.get(self, "mirror")

    @mirror.setter
    def mirror(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "mirror", value)

    @property
    @pulumi.getter(name="mirrorOverwritesDivergedBranches")
    def mirror_overwrites_diverged_branches(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable overwrite diverged branches for a mirrored project.
        """
        return pulumi.get(self, "mirror_overwrites_diverged_branches")

    @mirror_overwrites_diverged_branches.setter
    def mirror_overwrites_diverged_branches(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "mirror_overwrites_diverged_branches", value)

    @property
    @pulumi.getter(name="mirrorTriggerBuilds")
    def mirror_trigger_builds(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable trigger builds on pushes for a mirrored project.
        """
        return pulumi.get(self, "mirror_trigger_builds")

    @mirror_trigger_builds.setter
    def mirror_trigger_builds(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "mirror_trigger_builds", value)

    @property
    @pulumi.getter(name="modelExperimentsAccessLevel")
    def model_experiments_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set visibility of machine learning model experiments. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "model_experiments_access_level")

    @model_experiments_access_level.setter
    def model_experiments_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "model_experiments_access_level", value)

    @property
    @pulumi.getter(name="modelRegistryAccessLevel")
    def model_registry_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set visibility of machine learning model registry. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "model_registry_access_level")

    @model_registry_access_level.setter
    def model_registry_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "model_registry_access_level", value)

    @property
    @pulumi.getter(name="monitorAccessLevel")
    def monitor_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the monitor access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "monitor_access_level")

    @monitor_access_level.setter
    def monitor_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "monitor_access_level", value)

    @property
    @pulumi.getter(name="mrDefaultTargetSelf")
    def mr_default_target_self(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        For forked projects, target merge requests to this project. If false, the target will be the upstream project.
        """
        return pulumi.get(self, "mr_default_target_self")

    @mr_default_target_self.setter
    def mr_default_target_self(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "mr_default_target_self", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The namespace (group or user) of the project. Defaults to your user.
        """
        return pulumi.get(self, "namespace_id")

    @namespace_id.setter
    def namespace_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "namespace_id", value)

    @property
    @pulumi.getter(name="onlyAllowMergeIfAllDiscussionsAreResolved")
    def only_allow_merge_if_all_discussions_are_resolved(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set to true if you want allow merges only if all discussions are resolved.
        """
        return pulumi.get(self, "only_allow_merge_if_all_discussions_are_resolved")

    @only_allow_merge_if_all_discussions_are_resolved.setter
    def only_allow_merge_if_all_discussions_are_resolved(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "only_allow_merge_if_all_discussions_are_resolved", value)

    @property
    @pulumi.getter(name="onlyAllowMergeIfPipelineSucceeds")
    def only_allow_merge_if_pipeline_succeeds(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set to true if you want allow merges only if a pipeline succeeds.
        """
        return pulumi.get(self, "only_allow_merge_if_pipeline_succeeds")

    @only_allow_merge_if_pipeline_succeeds.setter
    def only_allow_merge_if_pipeline_succeeds(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "only_allow_merge_if_pipeline_succeeds", value)

    @property
    @pulumi.getter(name="onlyMirrorProtectedBranches")
    def only_mirror_protected_branches(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable only mirror protected branches for a mirrored project.
        """
        return pulumi.get(self, "only_mirror_protected_branches")

    @only_mirror_protected_branches.setter
    def only_mirror_protected_branches(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "only_mirror_protected_branches", value)

    @property
    @pulumi.getter(name="packagesEnabled")
    def packages_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable packages repository for the project.
        """
        return pulumi.get(self, "packages_enabled")

    @packages_enabled.setter
    def packages_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "packages_enabled", value)

    @property
    @pulumi.getter(name="pagesAccessLevel")
    def pages_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Enable pages access control. Valid values are `public`, `private`, `enabled`, `disabled`.
        """
        return pulumi.get(self, "pages_access_level")

    @pages_access_level.setter
    def pages_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pages_access_level", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path of the repository.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="pathWithNamespace")
    def path_with_namespace(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path of the repository with namespace.
        """
        return pulumi.get(self, "path_with_namespace")

    @path_with_namespace.setter
    def path_with_namespace(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path_with_namespace", value)

    @property
    @pulumi.getter(name="permanentlyDeleteOnDestroy")
    def permanently_delete_on_destroy(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set to `true` to immediately permanently delete the project instead of scheduling a delete for Premium and Ultimate tiers.
        """
        return pulumi.get(self, "permanently_delete_on_destroy")

    @permanently_delete_on_destroy.setter
    def permanently_delete_on_destroy(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "permanently_delete_on_destroy", value)

    @property
    @pulumi.getter(name="pipelinesEnabled")
    @_utilities.deprecated("""Deprecated in favor of `builds_access_level`""")
    def pipelines_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable pipelines for the project. The `pipelines_enabled` field is being sent as `jobs_enabled` in the GitLab API calls.
        """
        return pulumi.get(self, "pipelines_enabled")

    @pipelines_enabled.setter
    def pipelines_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "pipelines_enabled", value)

    @property
    @pulumi.getter(name="preReceiveSecretDetectionEnabled")
    def pre_receive_secret_detection_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether Secret Push Detection is enabled. Requires GitLab Ultimate.
        """
        return pulumi.get(self, "pre_receive_secret_detection_enabled")

    @pre_receive_secret_detection_enabled.setter
    def pre_receive_secret_detection_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "pre_receive_secret_detection_enabled", value)

    @property
    @pulumi.getter(name="preventMergeWithoutJiraIssue")
    def prevent_merge_without_jira_issue(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Set whether merge requests require an associated issue from Jira. Premium and Ultimate only.
        """
        return pulumi.get(self, "prevent_merge_without_jira_issue")

    @prevent_merge_without_jira_issue.setter
    def prevent_merge_without_jira_issue(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "prevent_merge_without_jira_issue", value)

    @property
    @pulumi.getter(name="printingMergeRequestLinkEnabled")
    def printing_merge_request_link_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Show link to create/view merge request when pushing from the command line
        """
        return pulumi.get(self, "printing_merge_request_link_enabled")

    @printing_merge_request_link_enabled.setter
    def printing_merge_request_link_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "printing_merge_request_link_enabled", value)

    @property
    @pulumi.getter(name="publicBuilds")
    @_utilities.deprecated("""The `public_builds` attribute has been deprecated in favor of `public_jobs` and will be removed in the next major version of the provider.""")
    def public_builds(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, jobs can be viewed by non-project members.
        """
        return pulumi.get(self, "public_builds")

    @public_builds.setter
    def public_builds(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_builds", value)

    @property
    @pulumi.getter(name="publicJobs")
    def public_jobs(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, jobs can be viewed by non-project members.
        """
        return pulumi.get(self, "public_jobs")

    @public_jobs.setter
    def public_jobs(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "public_jobs", value)

    @property
    @pulumi.getter(name="pushRules")
    def push_rules(self) -> Optional[pulumi.Input['ProjectPushRulesArgs']]:
        """
        Push rules for the project.
        """
        return pulumi.get(self, "push_rules")

    @push_rules.setter
    def push_rules(self, value: Optional[pulumi.Input['ProjectPushRulesArgs']]):
        pulumi.set(self, "push_rules", value)

    @property
    @pulumi.getter(name="releasesAccessLevel")
    def releases_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the releases access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "releases_access_level")

    @releases_access_level.setter
    def releases_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "releases_access_level", value)

    @property
    @pulumi.getter(name="removeSourceBranchAfterMerge")
    def remove_source_branch_after_merge(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable `Delete source branch` option by default for all new merge requests.
        """
        return pulumi.get(self, "remove_source_branch_after_merge")

    @remove_source_branch_after_merge.setter
    def remove_source_branch_after_merge(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "remove_source_branch_after_merge", value)

    @property
    @pulumi.getter(name="repositoryAccessLevel")
    def repository_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the repository access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "repository_access_level")

    @repository_access_level.setter
    def repository_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repository_access_level", value)

    @property
    @pulumi.getter(name="repositoryStorage")
    def repository_storage(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Which storage shard the repository is on. (administrator only)
        """
        return pulumi.get(self, "repository_storage")

    @repository_storage.setter
    def repository_storage(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repository_storage", value)

    @property
    @pulumi.getter(name="requestAccessEnabled")
    def request_access_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow users to request member access.
        """
        return pulumi.get(self, "request_access_enabled")

    @request_access_enabled.setter
    def request_access_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "request_access_enabled", value)

    @property
    @pulumi.getter(name="requirementsAccessLevel")
    def requirements_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the requirements access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "requirements_access_level")

    @requirements_access_level.setter
    def requirements_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "requirements_access_level", value)

    @property
    @pulumi.getter(name="resolveOutdatedDiffDiscussions")
    def resolve_outdated_diff_discussions(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Automatically resolve merge request diffs discussions on lines changed with a push.
        """
        return pulumi.get(self, "resolve_outdated_diff_discussions")

    @resolve_outdated_diff_discussions.setter
    def resolve_outdated_diff_discussions(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "resolve_outdated_diff_discussions", value)

    @property
    @pulumi.getter(name="restrictUserDefinedVariables")
    def restrict_user_defined_variables(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow only users with the Maintainer role to pass user-defined variables when triggering a pipeline.
        """
        return pulumi.get(self, "restrict_user_defined_variables")

    @restrict_user_defined_variables.setter
    def restrict_user_defined_variables(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "restrict_user_defined_variables", value)

    @property
    @pulumi.getter(name="runnersToken")
    def runners_token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Registration token to use during runner setup.
        """
        return pulumi.get(self, "runners_token")

    @runners_token.setter
    def runners_token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "runners_token", value)

    @property
    @pulumi.getter(name="securityAndComplianceAccessLevel")
    def security_and_compliance_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the security and compliance access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "security_and_compliance_access_level")

    @security_and_compliance_access_level.setter
    def security_and_compliance_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_and_compliance_access_level", value)

    @property
    @pulumi.getter(name="sharedRunnersEnabled")
    def shared_runners_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable shared runners for this project.
        """
        return pulumi.get(self, "shared_runners_enabled")

    @shared_runners_enabled.setter
    def shared_runners_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "shared_runners_enabled", value)

    @property
    @pulumi.getter(name="skipWaitForDefaultBranchProtection")
    def skip_wait_for_default_branch_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If `true`, the default behavior to wait for the default branch protection to be created is skipped.
        This is necessary if the current user is not an admin and the default branch protection is disabled on an instance-level.
        There is currently no known way to determine if the default branch protection is disabled on an instance-level for non-admin users.
        This attribute is only used during resource creation, thus changes are suppressed and the attribute cannot be imported.
        """
        return pulumi.get(self, "skip_wait_for_default_branch_protection")

    @skip_wait_for_default_branch_protection.setter
    def skip_wait_for_default_branch_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "skip_wait_for_default_branch_protection", value)

    @property
    @pulumi.getter(name="snippetsAccessLevel")
    def snippets_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the snippets access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "snippets_access_level")

    @snippets_access_level.setter
    def snippets_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "snippets_access_level", value)

    @property
    @pulumi.getter(name="snippetsEnabled")
    def snippets_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable snippets for the project.
        """
        return pulumi.get(self, "snippets_enabled")

    @snippets_enabled.setter
    def snippets_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "snippets_enabled", value)

    @property
    @pulumi.getter(name="squashCommitTemplate")
    def squash_commit_template(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Template used to create squash commit message in merge requests.
        """
        return pulumi.get(self, "squash_commit_template")

    @squash_commit_template.setter
    def squash_commit_template(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "squash_commit_template", value)

    @property
    @pulumi.getter(name="squashOption")
    def squash_option(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Squash commits when merge request is merged. Valid values are `never` (Do not allow), `always` (Require), `default_on` (Encourage), or `default_off` (Allow). The default value is `default_off` (Allow).
        """
        return pulumi.get(self, "squash_option")

    @squash_option.setter
    def squash_option(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "squash_option", value)

    @property
    @pulumi.getter(name="sshUrlToRepo")
    def ssh_url_to_repo(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL that can be provided to `git clone` to clone the
        """
        return pulumi.get(self, "ssh_url_to_repo")

    @ssh_url_to_repo.setter
    def ssh_url_to_repo(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssh_url_to_repo", value)

    @property
    @pulumi.getter(name="suggestionCommitMessage")
    def suggestion_commit_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The commit message used to apply merge request suggestions.
        """
        return pulumi.get(self, "suggestion_commit_message")

    @suggestion_commit_message.setter
    def suggestion_commit_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "suggestion_commit_message", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of tags for a project; put array of tags, that should be finally assigned to a project. Use topics instead.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        When used without use*custom*template, name of a built-in project template. When used with use*custom*template, name of a custom project template. This option is mutually exclusive with `template_project_id`.
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_name", value)

    @property
    @pulumi.getter(name="templateProjectId")
    def template_project_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        When used with use*custom*template, project ID of a custom project template. This is preferable to using template*name since template*name may be ambiguous (enterprise edition). This option is mutually exclusive with `template_name`. See `GroupProjectFileTemplate` to set a project as a template project. If a project has not been set as a template, using it here will result in an error.
        """
        return pulumi.get(self, "template_project_id")

    @template_project_id.setter
    def template_project_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "template_project_id", value)

    @property
    @pulumi.getter
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of topics for the project.
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "topics", value)

    @property
    @pulumi.getter(name="useCustomTemplate")
    def use_custom_template(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Use either custom instance or group (with group*with*project*templates*id) project template (enterprise edition).
        	> When using a custom template, [Group Tokens won't work](https://docs.gitlab.com/15.7/ee/user/project/settings/import_export_troubleshooting/#import-using-the-rest-api-fails-when-using-a-group-access-token). You must use a real user's Personal Access Token.
        """
        return pulumi.get(self, "use_custom_template")

    @use_custom_template.setter
    def use_custom_template(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_custom_template", value)

    @property
    @pulumi.getter(name="visibilityLevel")
    def visibility_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set to `public` to create a public project. Valid values are `private`, `internal`, `public`.
        """
        return pulumi.get(self, "visibility_level")

    @visibility_level.setter
    def visibility_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "visibility_level", value)

    @property
    @pulumi.getter(name="webUrl")
    def web_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL that can be used to find the project in a browser.
        """
        return pulumi.get(self, "web_url")

    @web_url.setter
    def web_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "web_url", value)

    @property
    @pulumi.getter(name="wikiAccessLevel")
    def wiki_access_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set the wiki access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "wiki_access_level")

    @wiki_access_level.setter
    def wiki_access_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "wiki_access_level", value)

    @property
    @pulumi.getter(name="wikiEnabled")
    def wiki_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable wiki for the project.
        """
        return pulumi.get(self, "wiki_enabled")

    @wiki_enabled.setter
    def wiki_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "wiki_enabled", value)


@pulumi.type_token("gitlab:index/project:Project")
class Project(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_merge_on_skipped_pipeline: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_pipeline_trigger_approve_deployment: Optional[pulumi.Input[builtins.bool]] = None,
                 analytics_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 approvals_before_merge: Optional[pulumi.Input[builtins.int]] = None,
                 archive_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 archived: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_cancel_pending_pipelines: Optional[pulumi.Input[builtins.str]] = None,
                 auto_devops_deploy_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 auto_devops_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_duo_code_review_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 autoclose_referenced_issues: Optional[pulumi.Input[builtins.bool]] = None,
                 avatar: Optional[pulumi.Input[builtins.str]] = None,
                 avatar_hash: Optional[pulumi.Input[builtins.str]] = None,
                 branches: Optional[pulumi.Input[builtins.str]] = None,
                 build_git_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 build_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 builds_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 ci_config_path: Optional[pulumi.Input[builtins.str]] = None,
                 ci_default_git_depth: Optional[pulumi.Input[builtins.int]] = None,
                 ci_delete_pipelines_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 ci_forward_deployment_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ci_forward_deployment_rollback_allowed: Optional[pulumi.Input[builtins.bool]] = None,
                 ci_id_token_sub_claim_components: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ci_pipeline_variables_minimum_override_role: Optional[pulumi.Input[builtins.str]] = None,
                 ci_push_repository_for_job_token_allowed: Optional[pulumi.Input[builtins.bool]] = None,
                 ci_restrict_pipeline_cancellation_role: Optional[pulumi.Input[builtins.str]] = None,
                 ci_separated_caches: Optional[pulumi.Input[builtins.bool]] = None,
                 container_expiration_policy: Optional[pulumi.Input[Union['ProjectContainerExpirationPolicyArgs', 'ProjectContainerExpirationPolicyArgsDict']]] = None,
                 container_registry_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 container_registry_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 default_branch: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 emails_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 environments_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 external_authorization_classification_label: Optional[pulumi.Input[builtins.str]] = None,
                 feature_flags_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 forked_from_project_id: Optional[pulumi.Input[builtins.int]] = None,
                 forking_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 group_runners_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 group_with_project_templates_id: Optional[pulumi.Input[builtins.int]] = None,
                 import_url: Optional[pulumi.Input[builtins.str]] = None,
                 import_url_password: Optional[pulumi.Input[builtins.str]] = None,
                 import_url_username: Optional[pulumi.Input[builtins.str]] = None,
                 infrastructure_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 initialize_with_readme: Optional[pulumi.Input[builtins.bool]] = None,
                 issues_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 issues_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 issues_template: Optional[pulumi.Input[builtins.str]] = None,
                 keep_latest_artifact: Optional[pulumi.Input[builtins.bool]] = None,
                 lfs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 merge_commit_template: Optional[pulumi.Input[builtins.str]] = None,
                 merge_method: Optional[pulumi.Input[builtins.str]] = None,
                 merge_pipelines_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 merge_requests_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 merge_requests_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 merge_requests_template: Optional[pulumi.Input[builtins.str]] = None,
                 merge_trains_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 mirror: Optional[pulumi.Input[builtins.bool]] = None,
                 mirror_overwrites_diverged_branches: Optional[pulumi.Input[builtins.bool]] = None,
                 mirror_trigger_builds: Optional[pulumi.Input[builtins.bool]] = None,
                 model_experiments_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 model_registry_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 monitor_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 mr_default_target_self: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[builtins.int]] = None,
                 only_allow_merge_if_all_discussions_are_resolved: Optional[pulumi.Input[builtins.bool]] = None,
                 only_allow_merge_if_pipeline_succeeds: Optional[pulumi.Input[builtins.bool]] = None,
                 only_mirror_protected_branches: Optional[pulumi.Input[builtins.bool]] = None,
                 packages_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 pages_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 permanently_delete_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 pipelines_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 pre_receive_secret_detection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 prevent_merge_without_jira_issue: Optional[pulumi.Input[builtins.bool]] = None,
                 printing_merge_request_link_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 public_builds: Optional[pulumi.Input[builtins.bool]] = None,
                 public_jobs: Optional[pulumi.Input[builtins.bool]] = None,
                 push_rules: Optional[pulumi.Input[Union['ProjectPushRulesArgs', 'ProjectPushRulesArgsDict']]] = None,
                 releases_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 remove_source_branch_after_merge: Optional[pulumi.Input[builtins.bool]] = None,
                 repository_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 repository_storage: Optional[pulumi.Input[builtins.str]] = None,
                 request_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 requirements_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 resolve_outdated_diff_discussions: Optional[pulumi.Input[builtins.bool]] = None,
                 restrict_user_defined_variables: Optional[pulumi.Input[builtins.bool]] = None,
                 security_and_compliance_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 shared_runners_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 skip_wait_for_default_branch_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 snippets_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 snippets_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 squash_commit_template: Optional[pulumi.Input[builtins.str]] = None,
                 squash_option: Optional[pulumi.Input[builtins.str]] = None,
                 suggestion_commit_message: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 template_name: Optional[pulumi.Input[builtins.str]] = None,
                 template_project_id: Optional[pulumi.Input[builtins.int]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 use_custom_template: Optional[pulumi.Input[builtins.bool]] = None,
                 visibility_level: Optional[pulumi.Input[builtins.str]] = None,
                 wiki_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 wiki_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_project`. For example:

        terraform

        import {

          to = gitlab_project.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        ```sh
        $ pulumi import gitlab:index/project:Project You can import a project state using `<resource> <id>`. The
        ```

        `id` can be whatever the [get single project api][get_single_project] takes for

        its `:id` value, so for example:

        ```sh
        $ pulumi import gitlab:index/project:Project example richardc/example
        ```

        NOTE: the `import_url_username` and `import_url_password` cannot be imported.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_merge_on_skipped_pipeline: Set to true if you want to treat skipped pipelines as if they finished with success.
        :param pulumi.Input[builtins.bool] allow_pipeline_trigger_approve_deployment: Set whether or not a pipeline triggerer is allowed to approve deployments. Premium and Ultimate only.
        :param pulumi.Input[builtins.str] analytics_access_level: Set the analytics access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.int] approvals_before_merge: Number of merge request approvals required for merging. Default is 0.
               This field **does not** work well in combination with the `ProjectApprovalRule` resource
               and is most likely gonna be deprecated in a future GitLab version (see [this upstream epic](https://gitlab.com/groups/gitlab-org/-/epics/7572)).
               In the meantime we recommend against using this attribute and use `ProjectApprovalRule` instead.
        :param pulumi.Input[builtins.bool] archive_on_destroy: Set to `true` to archive the project instead of deleting on destroy. If set to `true` it will entire omit the `DELETE` operation.
        :param pulumi.Input[builtins.bool] archived: Whether the project is in read-only mode (archived). Repositories can be archived/unarchived by toggling this parameter.
        :param pulumi.Input[builtins.str] auto_cancel_pending_pipelines: Auto-cancel pending pipelines. This isn’t a boolean, but enabled/disabled.
        :param pulumi.Input[builtins.str] auto_devops_deploy_strategy: Auto Deploy strategy. Valid values are `continuous`, `manual`, `timed_incremental`.
        :param pulumi.Input[builtins.bool] auto_devops_enabled: Enable Auto DevOps for this project.
        :param pulumi.Input[builtins.bool] auto_duo_code_review_enabled: Enable automatic reviews by GitLab Duo on merge requests. Ultimate only. Automatic reviews only work with the GitLab Duo Enterprise add-on.
        :param pulumi.Input[builtins.bool] autoclose_referenced_issues: Set whether auto-closing referenced issues on default branch.
        :param pulumi.Input[builtins.str] avatar: A local path to the avatar image to upload. **Note**: not available for imported resources.
        :param pulumi.Input[builtins.str] avatar_hash: The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
        :param pulumi.Input[builtins.str] branches: Branches to fork (empty for all branches).
        :param pulumi.Input[builtins.str] build_git_strategy: The Git strategy. Defaults to fetch. Valid values are `clone`, `fetch`.
        :param pulumi.Input[builtins.int] build_timeout: The maximum amount of time, in seconds, that a job can run.
        :param pulumi.Input[builtins.str] builds_access_level: Set the builds access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.str] ci_config_path: Custom Path to CI config file.
        :param pulumi.Input[builtins.int] ci_default_git_depth: Default number of revisions for shallow cloning.
        :param pulumi.Input[builtins.int] ci_delete_pipelines_in_seconds: Pipelines older than the configured time are deleted.
        :param pulumi.Input[builtins.bool] ci_forward_deployment_enabled: When a new deployment job starts, skip older deployment jobs that are still pending.
        :param pulumi.Input[builtins.bool] ci_forward_deployment_rollback_allowed: Allow job retries even if the deployment job is outdated.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ci_id_token_sub_claim_components: Fields included in the sub claim of the ID Token. Accepts an array starting with project*path. The array might also include ref*type and ref. Defaults to ["project*path", "ref*type", "ref"]. Introduced in GitLab 17.10.
        :param pulumi.Input[builtins.str] ci_pipeline_variables_minimum_override_role: The minimum role required to set variables when running pipelines and jobs. Introduced in GitLab 17.1. Valid values are `developer`, `maintainer`, `owner`, `no_one_allowed`
        :param pulumi.Input[builtins.bool] ci_push_repository_for_job_token_allowed: Allow Git push requests to your project repository that are authenticated with a CI/CD job token.
        :param pulumi.Input[builtins.str] ci_restrict_pipeline_cancellation_role: The role required to cancel a pipeline or job. Premium and Ultimate only. Valid values are `developer`, `maintainer`, `no one`
        :param pulumi.Input[builtins.bool] ci_separated_caches: Use separate caches for protected branches.
        :param pulumi.Input[Union['ProjectContainerExpirationPolicyArgs', 'ProjectContainerExpirationPolicyArgsDict']] container_expiration_policy: Set the image cleanup policy for this project. **Note**: this field is sometimes named `container_expiration_policy_attributes` in the GitLab Upstream API.
        :param pulumi.Input[builtins.str] container_registry_access_level: Set visibility of container registry, for this project. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] container_registry_enabled: Enable container registry for the project.
        :param pulumi.Input[builtins.str] default_branch: The default branch for the project.
        :param pulumi.Input[builtins.str] description: A description of the project.
        :param pulumi.Input[builtins.bool] emails_enabled: Enable email notifications.
        :param pulumi.Input[builtins.str] environments_access_level: Set the environments access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.str] external_authorization_classification_label: The classification label for the project.
        :param pulumi.Input[builtins.str] feature_flags_access_level: Set the feature flags access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.int] forked_from_project_id: The id of the project to fork. During create the project is forked and during an update the fork relation is changed.
        :param pulumi.Input[builtins.str] forking_access_level: Set the forking access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] group_runners_enabled: Enable group runners for this project.
        :param pulumi.Input[builtins.int] group_with_project_templates_id: For group-level custom templates, specifies ID of group from which all the custom project templates are sourced. Leave empty for instance-level templates. Requires use*custom*template to be true (enterprise edition).
        :param pulumi.Input[builtins.str] import_url: Git URL to a repository to be imported. Together with `mirror = true` it will setup a Pull Mirror. This can also be used together with `forked_from_project_id` to setup a Pull Mirror for a fork. The fork takes precedence over the import. Make sure to provide the credentials in `import_url_username` and `import_url_password`. GitLab never returns the credentials, thus the provider cannot detect configuration drift in the credentials. They can also not be imported using `pulumi import`. See the examples section for how to properly use it.
        :param pulumi.Input[builtins.str] import_url_password: The password for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related to the provider. This field cannot be imported using `pulumi import`. See the examples section for how to properly use it.
        :param pulumi.Input[builtins.str] import_url_username: The username for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related to the provider. This field cannot be imported using `pulumi import`.  See the examples section for how to properly use it.
        :param pulumi.Input[builtins.str] infrastructure_access_level: Set the infrastructure access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] initialize_with_readme: Create main branch with first commit containing a README.md file. Must be set to `true` if importing an uninitialized project with a different `default_branch`.
        :param pulumi.Input[builtins.str] issues_access_level: Set the issues access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] issues_enabled: Enable issue tracking for the project.
        :param pulumi.Input[builtins.str] issues_template: Sets the template for new issues in the project.
        :param pulumi.Input[builtins.bool] keep_latest_artifact: Disable or enable the ability to keep the latest artifact for this project.
        :param pulumi.Input[builtins.bool] lfs_enabled: Enable LFS for the project.
        :param pulumi.Input[builtins.str] merge_commit_template: Template used to create merge commit message in merge requests.
        :param pulumi.Input[builtins.str] merge_method: Set the merge method. Valid values are `merge`, `rebase_merge`, `ff`.
        :param pulumi.Input[builtins.bool] merge_pipelines_enabled: Enable or disable merge pipelines.
        :param pulumi.Input[builtins.str] merge_requests_access_level: Set the merge requests access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] merge_requests_enabled: Enable merge requests for the project.
        :param pulumi.Input[builtins.str] merge_requests_template: Sets the template for new merge requests in the project.
        :param pulumi.Input[builtins.bool] merge_trains_enabled: Enable or disable merge trains. Requires `merge_pipelines_enabled` to be set to `true` to take effect.
        :param pulumi.Input[builtins.bool] mirror: Enable project pull mirror.
        :param pulumi.Input[builtins.bool] mirror_overwrites_diverged_branches: Enable overwrite diverged branches for a mirrored project.
        :param pulumi.Input[builtins.bool] mirror_trigger_builds: Enable trigger builds on pushes for a mirrored project.
        :param pulumi.Input[builtins.str] model_experiments_access_level: Set visibility of machine learning model experiments. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.str] model_registry_access_level: Set visibility of machine learning model registry. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.str] monitor_access_level: Set the monitor access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] mr_default_target_self: For forked projects, target merge requests to this project. If false, the target will be the upstream project.
        :param pulumi.Input[builtins.str] name: The name of the project.
        :param pulumi.Input[builtins.int] namespace_id: The namespace (group or user) of the project. Defaults to your user.
        :param pulumi.Input[builtins.bool] only_allow_merge_if_all_discussions_are_resolved: Set to true if you want allow merges only if all discussions are resolved.
        :param pulumi.Input[builtins.bool] only_allow_merge_if_pipeline_succeeds: Set to true if you want allow merges only if a pipeline succeeds.
        :param pulumi.Input[builtins.bool] only_mirror_protected_branches: Enable only mirror protected branches for a mirrored project.
        :param pulumi.Input[builtins.bool] packages_enabled: Enable packages repository for the project.
        :param pulumi.Input[builtins.str] pages_access_level: Enable pages access control. Valid values are `public`, `private`, `enabled`, `disabled`.
        :param pulumi.Input[builtins.str] path: The path of the repository.
        :param pulumi.Input[builtins.bool] permanently_delete_on_destroy: Set to `true` to immediately permanently delete the project instead of scheduling a delete for Premium and Ultimate tiers.
        :param pulumi.Input[builtins.bool] pipelines_enabled: Enable pipelines for the project. The `pipelines_enabled` field is being sent as `jobs_enabled` in the GitLab API calls.
        :param pulumi.Input[builtins.bool] pre_receive_secret_detection_enabled: Whether Secret Push Detection is enabled. Requires GitLab Ultimate.
        :param pulumi.Input[builtins.bool] prevent_merge_without_jira_issue: Set whether merge requests require an associated issue from Jira. Premium and Ultimate only.
        :param pulumi.Input[builtins.bool] printing_merge_request_link_enabled: Show link to create/view merge request when pushing from the command line
        :param pulumi.Input[builtins.bool] public_builds: If true, jobs can be viewed by non-project members.
        :param pulumi.Input[builtins.bool] public_jobs: If true, jobs can be viewed by non-project members.
        :param pulumi.Input[Union['ProjectPushRulesArgs', 'ProjectPushRulesArgsDict']] push_rules: Push rules for the project.
        :param pulumi.Input[builtins.str] releases_access_level: Set the releases access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] remove_source_branch_after_merge: Enable `Delete source branch` option by default for all new merge requests.
        :param pulumi.Input[builtins.str] repository_access_level: Set the repository access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.str] repository_storage: Which storage shard the repository is on. (administrator only)
        :param pulumi.Input[builtins.bool] request_access_enabled: Allow users to request member access.
        :param pulumi.Input[builtins.str] requirements_access_level: Set the requirements access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] resolve_outdated_diff_discussions: Automatically resolve merge request diffs discussions on lines changed with a push.
        :param pulumi.Input[builtins.bool] restrict_user_defined_variables: Allow only users with the Maintainer role to pass user-defined variables when triggering a pipeline.
        :param pulumi.Input[builtins.str] security_and_compliance_access_level: Set the security and compliance access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] shared_runners_enabled: Enable shared runners for this project.
        :param pulumi.Input[builtins.bool] skip_wait_for_default_branch_protection: If `true`, the default behavior to wait for the default branch protection to be created is skipped.
               This is necessary if the current user is not an admin and the default branch protection is disabled on an instance-level.
               There is currently no known way to determine if the default branch protection is disabled on an instance-level for non-admin users.
               This attribute is only used during resource creation, thus changes are suppressed and the attribute cannot be imported.
        :param pulumi.Input[builtins.str] snippets_access_level: Set the snippets access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] snippets_enabled: Enable snippets for the project.
        :param pulumi.Input[builtins.str] squash_commit_template: Template used to create squash commit message in merge requests.
        :param pulumi.Input[builtins.str] squash_option: Squash commits when merge request is merged. Valid values are `never` (Do not allow), `always` (Require), `default_on` (Encourage), or `default_off` (Allow). The default value is `default_off` (Allow).
        :param pulumi.Input[builtins.str] suggestion_commit_message: The commit message used to apply merge request suggestions.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The list of tags for a project; put array of tags, that should be finally assigned to a project. Use topics instead.
        :param pulumi.Input[builtins.str] template_name: When used without use*custom*template, name of a built-in project template. When used with use*custom*template, name of a custom project template. This option is mutually exclusive with `template_project_id`.
        :param pulumi.Input[builtins.int] template_project_id: When used with use*custom*template, project ID of a custom project template. This is preferable to using template*name since template*name may be ambiguous (enterprise edition). This option is mutually exclusive with `template_name`. See `GroupProjectFileTemplate` to set a project as a template project. If a project has not been set as a template, using it here will result in an error.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] topics: The list of topics for the project.
        :param pulumi.Input[builtins.bool] use_custom_template: Use either custom instance or group (with group*with*project*templates*id) project template (enterprise edition).
               	> When using a custom template, [Group Tokens won't work](https://docs.gitlab.com/15.7/ee/user/project/settings/import_export_troubleshooting/#import-using-the-rest-api-fails-when-using-a-group-access-token). You must use a real user's Personal Access Token.
        :param pulumi.Input[builtins.str] visibility_level: Set to `public` to create a public project. Valid values are `private`, `internal`, `public`.
        :param pulumi.Input[builtins.str] wiki_access_level: Set the wiki access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] wiki_enabled: Enable wiki for the project.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProjectArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_project`. For example:

        terraform

        import {

          to = gitlab_project.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        ```sh
        $ pulumi import gitlab:index/project:Project You can import a project state using `<resource> <id>`. The
        ```

        `id` can be whatever the [get single project api][get_single_project] takes for

        its `:id` value, so for example:

        ```sh
        $ pulumi import gitlab:index/project:Project example richardc/example
        ```

        NOTE: the `import_url_username` and `import_url_password` cannot be imported.

        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_merge_on_skipped_pipeline: Optional[pulumi.Input[builtins.bool]] = None,
                 allow_pipeline_trigger_approve_deployment: Optional[pulumi.Input[builtins.bool]] = None,
                 analytics_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 approvals_before_merge: Optional[pulumi.Input[builtins.int]] = None,
                 archive_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 archived: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_cancel_pending_pipelines: Optional[pulumi.Input[builtins.str]] = None,
                 auto_devops_deploy_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 auto_devops_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 auto_duo_code_review_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 autoclose_referenced_issues: Optional[pulumi.Input[builtins.bool]] = None,
                 avatar: Optional[pulumi.Input[builtins.str]] = None,
                 avatar_hash: Optional[pulumi.Input[builtins.str]] = None,
                 branches: Optional[pulumi.Input[builtins.str]] = None,
                 build_git_strategy: Optional[pulumi.Input[builtins.str]] = None,
                 build_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 builds_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 ci_config_path: Optional[pulumi.Input[builtins.str]] = None,
                 ci_default_git_depth: Optional[pulumi.Input[builtins.int]] = None,
                 ci_delete_pipelines_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
                 ci_forward_deployment_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 ci_forward_deployment_rollback_allowed: Optional[pulumi.Input[builtins.bool]] = None,
                 ci_id_token_sub_claim_components: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ci_pipeline_variables_minimum_override_role: Optional[pulumi.Input[builtins.str]] = None,
                 ci_push_repository_for_job_token_allowed: Optional[pulumi.Input[builtins.bool]] = None,
                 ci_restrict_pipeline_cancellation_role: Optional[pulumi.Input[builtins.str]] = None,
                 ci_separated_caches: Optional[pulumi.Input[builtins.bool]] = None,
                 container_expiration_policy: Optional[pulumi.Input[Union['ProjectContainerExpirationPolicyArgs', 'ProjectContainerExpirationPolicyArgsDict']]] = None,
                 container_registry_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 container_registry_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 default_branch: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 emails_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 environments_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 external_authorization_classification_label: Optional[pulumi.Input[builtins.str]] = None,
                 feature_flags_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 forked_from_project_id: Optional[pulumi.Input[builtins.int]] = None,
                 forking_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 group_runners_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 group_with_project_templates_id: Optional[pulumi.Input[builtins.int]] = None,
                 import_url: Optional[pulumi.Input[builtins.str]] = None,
                 import_url_password: Optional[pulumi.Input[builtins.str]] = None,
                 import_url_username: Optional[pulumi.Input[builtins.str]] = None,
                 infrastructure_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 initialize_with_readme: Optional[pulumi.Input[builtins.bool]] = None,
                 issues_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 issues_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 issues_template: Optional[pulumi.Input[builtins.str]] = None,
                 keep_latest_artifact: Optional[pulumi.Input[builtins.bool]] = None,
                 lfs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 merge_commit_template: Optional[pulumi.Input[builtins.str]] = None,
                 merge_method: Optional[pulumi.Input[builtins.str]] = None,
                 merge_pipelines_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 merge_requests_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 merge_requests_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 merge_requests_template: Optional[pulumi.Input[builtins.str]] = None,
                 merge_trains_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 mirror: Optional[pulumi.Input[builtins.bool]] = None,
                 mirror_overwrites_diverged_branches: Optional[pulumi.Input[builtins.bool]] = None,
                 mirror_trigger_builds: Optional[pulumi.Input[builtins.bool]] = None,
                 model_experiments_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 model_registry_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 monitor_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 mr_default_target_self: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 namespace_id: Optional[pulumi.Input[builtins.int]] = None,
                 only_allow_merge_if_all_discussions_are_resolved: Optional[pulumi.Input[builtins.bool]] = None,
                 only_allow_merge_if_pipeline_succeeds: Optional[pulumi.Input[builtins.bool]] = None,
                 only_mirror_protected_branches: Optional[pulumi.Input[builtins.bool]] = None,
                 packages_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 pages_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 permanently_delete_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
                 pipelines_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 pre_receive_secret_detection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 prevent_merge_without_jira_issue: Optional[pulumi.Input[builtins.bool]] = None,
                 printing_merge_request_link_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 public_builds: Optional[pulumi.Input[builtins.bool]] = None,
                 public_jobs: Optional[pulumi.Input[builtins.bool]] = None,
                 push_rules: Optional[pulumi.Input[Union['ProjectPushRulesArgs', 'ProjectPushRulesArgsDict']]] = None,
                 releases_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 remove_source_branch_after_merge: Optional[pulumi.Input[builtins.bool]] = None,
                 repository_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 repository_storage: Optional[pulumi.Input[builtins.str]] = None,
                 request_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 requirements_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 resolve_outdated_diff_discussions: Optional[pulumi.Input[builtins.bool]] = None,
                 restrict_user_defined_variables: Optional[pulumi.Input[builtins.bool]] = None,
                 security_and_compliance_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 shared_runners_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 skip_wait_for_default_branch_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 snippets_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 snippets_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 squash_commit_template: Optional[pulumi.Input[builtins.str]] = None,
                 squash_option: Optional[pulumi.Input[builtins.str]] = None,
                 suggestion_commit_message: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 template_name: Optional[pulumi.Input[builtins.str]] = None,
                 template_project_id: Optional[pulumi.Input[builtins.int]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 use_custom_template: Optional[pulumi.Input[builtins.bool]] = None,
                 visibility_level: Optional[pulumi.Input[builtins.str]] = None,
                 wiki_access_level: Optional[pulumi.Input[builtins.str]] = None,
                 wiki_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            __props__.__dict__["allow_merge_on_skipped_pipeline"] = allow_merge_on_skipped_pipeline
            __props__.__dict__["allow_pipeline_trigger_approve_deployment"] = allow_pipeline_trigger_approve_deployment
            __props__.__dict__["analytics_access_level"] = analytics_access_level
            __props__.__dict__["approvals_before_merge"] = approvals_before_merge
            __props__.__dict__["archive_on_destroy"] = archive_on_destroy
            __props__.__dict__["archived"] = archived
            __props__.__dict__["auto_cancel_pending_pipelines"] = auto_cancel_pending_pipelines
            __props__.__dict__["auto_devops_deploy_strategy"] = auto_devops_deploy_strategy
            __props__.__dict__["auto_devops_enabled"] = auto_devops_enabled
            __props__.__dict__["auto_duo_code_review_enabled"] = auto_duo_code_review_enabled
            __props__.__dict__["autoclose_referenced_issues"] = autoclose_referenced_issues
            __props__.__dict__["avatar"] = avatar
            __props__.__dict__["avatar_hash"] = avatar_hash
            __props__.__dict__["branches"] = branches
            __props__.__dict__["build_git_strategy"] = build_git_strategy
            __props__.__dict__["build_timeout"] = build_timeout
            __props__.__dict__["builds_access_level"] = builds_access_level
            __props__.__dict__["ci_config_path"] = ci_config_path
            __props__.__dict__["ci_default_git_depth"] = ci_default_git_depth
            __props__.__dict__["ci_delete_pipelines_in_seconds"] = ci_delete_pipelines_in_seconds
            __props__.__dict__["ci_forward_deployment_enabled"] = ci_forward_deployment_enabled
            __props__.__dict__["ci_forward_deployment_rollback_allowed"] = ci_forward_deployment_rollback_allowed
            __props__.__dict__["ci_id_token_sub_claim_components"] = ci_id_token_sub_claim_components
            __props__.__dict__["ci_pipeline_variables_minimum_override_role"] = ci_pipeline_variables_minimum_override_role
            __props__.__dict__["ci_push_repository_for_job_token_allowed"] = ci_push_repository_for_job_token_allowed
            __props__.__dict__["ci_restrict_pipeline_cancellation_role"] = ci_restrict_pipeline_cancellation_role
            __props__.__dict__["ci_separated_caches"] = ci_separated_caches
            __props__.__dict__["container_expiration_policy"] = container_expiration_policy
            __props__.__dict__["container_registry_access_level"] = container_registry_access_level
            __props__.__dict__["container_registry_enabled"] = container_registry_enabled
            __props__.__dict__["default_branch"] = default_branch
            __props__.__dict__["description"] = description
            __props__.__dict__["emails_enabled"] = emails_enabled
            __props__.__dict__["environments_access_level"] = environments_access_level
            __props__.__dict__["external_authorization_classification_label"] = external_authorization_classification_label
            __props__.__dict__["feature_flags_access_level"] = feature_flags_access_level
            __props__.__dict__["forked_from_project_id"] = forked_from_project_id
            __props__.__dict__["forking_access_level"] = forking_access_level
            __props__.__dict__["group_runners_enabled"] = group_runners_enabled
            __props__.__dict__["group_with_project_templates_id"] = group_with_project_templates_id
            __props__.__dict__["import_url"] = import_url
            __props__.__dict__["import_url_password"] = None if import_url_password is None else pulumi.Output.secret(import_url_password)
            __props__.__dict__["import_url_username"] = import_url_username
            __props__.__dict__["infrastructure_access_level"] = infrastructure_access_level
            __props__.__dict__["initialize_with_readme"] = initialize_with_readme
            __props__.__dict__["issues_access_level"] = issues_access_level
            __props__.__dict__["issues_enabled"] = issues_enabled
            __props__.__dict__["issues_template"] = issues_template
            __props__.__dict__["keep_latest_artifact"] = keep_latest_artifact
            __props__.__dict__["lfs_enabled"] = lfs_enabled
            __props__.__dict__["merge_commit_template"] = merge_commit_template
            __props__.__dict__["merge_method"] = merge_method
            __props__.__dict__["merge_pipelines_enabled"] = merge_pipelines_enabled
            __props__.__dict__["merge_requests_access_level"] = merge_requests_access_level
            __props__.__dict__["merge_requests_enabled"] = merge_requests_enabled
            __props__.__dict__["merge_requests_template"] = merge_requests_template
            __props__.__dict__["merge_trains_enabled"] = merge_trains_enabled
            __props__.__dict__["mirror"] = mirror
            __props__.__dict__["mirror_overwrites_diverged_branches"] = mirror_overwrites_diverged_branches
            __props__.__dict__["mirror_trigger_builds"] = mirror_trigger_builds
            __props__.__dict__["model_experiments_access_level"] = model_experiments_access_level
            __props__.__dict__["model_registry_access_level"] = model_registry_access_level
            __props__.__dict__["monitor_access_level"] = monitor_access_level
            __props__.__dict__["mr_default_target_self"] = mr_default_target_self
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace_id"] = namespace_id
            __props__.__dict__["only_allow_merge_if_all_discussions_are_resolved"] = only_allow_merge_if_all_discussions_are_resolved
            __props__.__dict__["only_allow_merge_if_pipeline_succeeds"] = only_allow_merge_if_pipeline_succeeds
            __props__.__dict__["only_mirror_protected_branches"] = only_mirror_protected_branches
            __props__.__dict__["packages_enabled"] = packages_enabled
            __props__.__dict__["pages_access_level"] = pages_access_level
            __props__.__dict__["path"] = path
            __props__.__dict__["permanently_delete_on_destroy"] = permanently_delete_on_destroy
            __props__.__dict__["pipelines_enabled"] = pipelines_enabled
            __props__.__dict__["pre_receive_secret_detection_enabled"] = pre_receive_secret_detection_enabled
            __props__.__dict__["prevent_merge_without_jira_issue"] = prevent_merge_without_jira_issue
            __props__.__dict__["printing_merge_request_link_enabled"] = printing_merge_request_link_enabled
            __props__.__dict__["public_builds"] = public_builds
            __props__.__dict__["public_jobs"] = public_jobs
            __props__.__dict__["push_rules"] = push_rules
            __props__.__dict__["releases_access_level"] = releases_access_level
            __props__.__dict__["remove_source_branch_after_merge"] = remove_source_branch_after_merge
            __props__.__dict__["repository_access_level"] = repository_access_level
            __props__.__dict__["repository_storage"] = repository_storage
            __props__.__dict__["request_access_enabled"] = request_access_enabled
            __props__.__dict__["requirements_access_level"] = requirements_access_level
            __props__.__dict__["resolve_outdated_diff_discussions"] = resolve_outdated_diff_discussions
            __props__.__dict__["restrict_user_defined_variables"] = restrict_user_defined_variables
            __props__.__dict__["security_and_compliance_access_level"] = security_and_compliance_access_level
            __props__.__dict__["shared_runners_enabled"] = shared_runners_enabled
            __props__.__dict__["skip_wait_for_default_branch_protection"] = skip_wait_for_default_branch_protection
            __props__.__dict__["snippets_access_level"] = snippets_access_level
            __props__.__dict__["snippets_enabled"] = snippets_enabled
            __props__.__dict__["squash_commit_template"] = squash_commit_template
            __props__.__dict__["squash_option"] = squash_option
            __props__.__dict__["suggestion_commit_message"] = suggestion_commit_message
            __props__.__dict__["tags"] = tags
            __props__.__dict__["template_name"] = template_name
            __props__.__dict__["template_project_id"] = template_project_id
            __props__.__dict__["topics"] = topics
            __props__.__dict__["use_custom_template"] = use_custom_template
            __props__.__dict__["visibility_level"] = visibility_level
            __props__.__dict__["wiki_access_level"] = wiki_access_level
            __props__.__dict__["wiki_enabled"] = wiki_enabled
            __props__.__dict__["avatar_url"] = None
            __props__.__dict__["empty_repo"] = None
            __props__.__dict__["http_url_to_repo"] = None
            __props__.__dict__["path_with_namespace"] = None
            __props__.__dict__["runners_token"] = None
            __props__.__dict__["ssh_url_to_repo"] = None
            __props__.__dict__["web_url"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["importUrlPassword", "runnersToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Project, __self__).__init__(
            'gitlab:index/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_merge_on_skipped_pipeline: Optional[pulumi.Input[builtins.bool]] = None,
            allow_pipeline_trigger_approve_deployment: Optional[pulumi.Input[builtins.bool]] = None,
            analytics_access_level: Optional[pulumi.Input[builtins.str]] = None,
            approvals_before_merge: Optional[pulumi.Input[builtins.int]] = None,
            archive_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
            archived: Optional[pulumi.Input[builtins.bool]] = None,
            auto_cancel_pending_pipelines: Optional[pulumi.Input[builtins.str]] = None,
            auto_devops_deploy_strategy: Optional[pulumi.Input[builtins.str]] = None,
            auto_devops_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            auto_duo_code_review_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            autoclose_referenced_issues: Optional[pulumi.Input[builtins.bool]] = None,
            avatar: Optional[pulumi.Input[builtins.str]] = None,
            avatar_hash: Optional[pulumi.Input[builtins.str]] = None,
            avatar_url: Optional[pulumi.Input[builtins.str]] = None,
            branches: Optional[pulumi.Input[builtins.str]] = None,
            build_git_strategy: Optional[pulumi.Input[builtins.str]] = None,
            build_timeout: Optional[pulumi.Input[builtins.int]] = None,
            builds_access_level: Optional[pulumi.Input[builtins.str]] = None,
            ci_config_path: Optional[pulumi.Input[builtins.str]] = None,
            ci_default_git_depth: Optional[pulumi.Input[builtins.int]] = None,
            ci_delete_pipelines_in_seconds: Optional[pulumi.Input[builtins.int]] = None,
            ci_forward_deployment_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            ci_forward_deployment_rollback_allowed: Optional[pulumi.Input[builtins.bool]] = None,
            ci_id_token_sub_claim_components: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            ci_pipeline_variables_minimum_override_role: Optional[pulumi.Input[builtins.str]] = None,
            ci_push_repository_for_job_token_allowed: Optional[pulumi.Input[builtins.bool]] = None,
            ci_restrict_pipeline_cancellation_role: Optional[pulumi.Input[builtins.str]] = None,
            ci_separated_caches: Optional[pulumi.Input[builtins.bool]] = None,
            container_expiration_policy: Optional[pulumi.Input[Union['ProjectContainerExpirationPolicyArgs', 'ProjectContainerExpirationPolicyArgsDict']]] = None,
            container_registry_access_level: Optional[pulumi.Input[builtins.str]] = None,
            container_registry_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            default_branch: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            emails_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            empty_repo: Optional[pulumi.Input[builtins.bool]] = None,
            environments_access_level: Optional[pulumi.Input[builtins.str]] = None,
            external_authorization_classification_label: Optional[pulumi.Input[builtins.str]] = None,
            feature_flags_access_level: Optional[pulumi.Input[builtins.str]] = None,
            forked_from_project_id: Optional[pulumi.Input[builtins.int]] = None,
            forking_access_level: Optional[pulumi.Input[builtins.str]] = None,
            group_runners_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            group_with_project_templates_id: Optional[pulumi.Input[builtins.int]] = None,
            http_url_to_repo: Optional[pulumi.Input[builtins.str]] = None,
            import_url: Optional[pulumi.Input[builtins.str]] = None,
            import_url_password: Optional[pulumi.Input[builtins.str]] = None,
            import_url_username: Optional[pulumi.Input[builtins.str]] = None,
            infrastructure_access_level: Optional[pulumi.Input[builtins.str]] = None,
            initialize_with_readme: Optional[pulumi.Input[builtins.bool]] = None,
            issues_access_level: Optional[pulumi.Input[builtins.str]] = None,
            issues_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            issues_template: Optional[pulumi.Input[builtins.str]] = None,
            keep_latest_artifact: Optional[pulumi.Input[builtins.bool]] = None,
            lfs_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            merge_commit_template: Optional[pulumi.Input[builtins.str]] = None,
            merge_method: Optional[pulumi.Input[builtins.str]] = None,
            merge_pipelines_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            merge_requests_access_level: Optional[pulumi.Input[builtins.str]] = None,
            merge_requests_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            merge_requests_template: Optional[pulumi.Input[builtins.str]] = None,
            merge_trains_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            mirror: Optional[pulumi.Input[builtins.bool]] = None,
            mirror_overwrites_diverged_branches: Optional[pulumi.Input[builtins.bool]] = None,
            mirror_trigger_builds: Optional[pulumi.Input[builtins.bool]] = None,
            model_experiments_access_level: Optional[pulumi.Input[builtins.str]] = None,
            model_registry_access_level: Optional[pulumi.Input[builtins.str]] = None,
            monitor_access_level: Optional[pulumi.Input[builtins.str]] = None,
            mr_default_target_self: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            namespace_id: Optional[pulumi.Input[builtins.int]] = None,
            only_allow_merge_if_all_discussions_are_resolved: Optional[pulumi.Input[builtins.bool]] = None,
            only_allow_merge_if_pipeline_succeeds: Optional[pulumi.Input[builtins.bool]] = None,
            only_mirror_protected_branches: Optional[pulumi.Input[builtins.bool]] = None,
            packages_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            pages_access_level: Optional[pulumi.Input[builtins.str]] = None,
            path: Optional[pulumi.Input[builtins.str]] = None,
            path_with_namespace: Optional[pulumi.Input[builtins.str]] = None,
            permanently_delete_on_destroy: Optional[pulumi.Input[builtins.bool]] = None,
            pipelines_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            pre_receive_secret_detection_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            prevent_merge_without_jira_issue: Optional[pulumi.Input[builtins.bool]] = None,
            printing_merge_request_link_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            public_builds: Optional[pulumi.Input[builtins.bool]] = None,
            public_jobs: Optional[pulumi.Input[builtins.bool]] = None,
            push_rules: Optional[pulumi.Input[Union['ProjectPushRulesArgs', 'ProjectPushRulesArgsDict']]] = None,
            releases_access_level: Optional[pulumi.Input[builtins.str]] = None,
            remove_source_branch_after_merge: Optional[pulumi.Input[builtins.bool]] = None,
            repository_access_level: Optional[pulumi.Input[builtins.str]] = None,
            repository_storage: Optional[pulumi.Input[builtins.str]] = None,
            request_access_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            requirements_access_level: Optional[pulumi.Input[builtins.str]] = None,
            resolve_outdated_diff_discussions: Optional[pulumi.Input[builtins.bool]] = None,
            restrict_user_defined_variables: Optional[pulumi.Input[builtins.bool]] = None,
            runners_token: Optional[pulumi.Input[builtins.str]] = None,
            security_and_compliance_access_level: Optional[pulumi.Input[builtins.str]] = None,
            shared_runners_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            skip_wait_for_default_branch_protection: Optional[pulumi.Input[builtins.bool]] = None,
            snippets_access_level: Optional[pulumi.Input[builtins.str]] = None,
            snippets_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            squash_commit_template: Optional[pulumi.Input[builtins.str]] = None,
            squash_option: Optional[pulumi.Input[builtins.str]] = None,
            ssh_url_to_repo: Optional[pulumi.Input[builtins.str]] = None,
            suggestion_commit_message: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            template_name: Optional[pulumi.Input[builtins.str]] = None,
            template_project_id: Optional[pulumi.Input[builtins.int]] = None,
            topics: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            use_custom_template: Optional[pulumi.Input[builtins.bool]] = None,
            visibility_level: Optional[pulumi.Input[builtins.str]] = None,
            web_url: Optional[pulumi.Input[builtins.str]] = None,
            wiki_access_level: Optional[pulumi.Input[builtins.str]] = None,
            wiki_enabled: Optional[pulumi.Input[builtins.bool]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_merge_on_skipped_pipeline: Set to true if you want to treat skipped pipelines as if they finished with success.
        :param pulumi.Input[builtins.bool] allow_pipeline_trigger_approve_deployment: Set whether or not a pipeline triggerer is allowed to approve deployments. Premium and Ultimate only.
        :param pulumi.Input[builtins.str] analytics_access_level: Set the analytics access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.int] approvals_before_merge: Number of merge request approvals required for merging. Default is 0.
               This field **does not** work well in combination with the `ProjectApprovalRule` resource
               and is most likely gonna be deprecated in a future GitLab version (see [this upstream epic](https://gitlab.com/groups/gitlab-org/-/epics/7572)).
               In the meantime we recommend against using this attribute and use `ProjectApprovalRule` instead.
        :param pulumi.Input[builtins.bool] archive_on_destroy: Set to `true` to archive the project instead of deleting on destroy. If set to `true` it will entire omit the `DELETE` operation.
        :param pulumi.Input[builtins.bool] archived: Whether the project is in read-only mode (archived). Repositories can be archived/unarchived by toggling this parameter.
        :param pulumi.Input[builtins.str] auto_cancel_pending_pipelines: Auto-cancel pending pipelines. This isn’t a boolean, but enabled/disabled.
        :param pulumi.Input[builtins.str] auto_devops_deploy_strategy: Auto Deploy strategy. Valid values are `continuous`, `manual`, `timed_incremental`.
        :param pulumi.Input[builtins.bool] auto_devops_enabled: Enable Auto DevOps for this project.
        :param pulumi.Input[builtins.bool] auto_duo_code_review_enabled: Enable automatic reviews by GitLab Duo on merge requests. Ultimate only. Automatic reviews only work with the GitLab Duo Enterprise add-on.
        :param pulumi.Input[builtins.bool] autoclose_referenced_issues: Set whether auto-closing referenced issues on default branch.
        :param pulumi.Input[builtins.str] avatar: A local path to the avatar image to upload. **Note**: not available for imported resources.
        :param pulumi.Input[builtins.str] avatar_hash: The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
        :param pulumi.Input[builtins.str] avatar_url: The URL of the avatar image.
        :param pulumi.Input[builtins.str] branches: Branches to fork (empty for all branches).
        :param pulumi.Input[builtins.str] build_git_strategy: The Git strategy. Defaults to fetch. Valid values are `clone`, `fetch`.
        :param pulumi.Input[builtins.int] build_timeout: The maximum amount of time, in seconds, that a job can run.
        :param pulumi.Input[builtins.str] builds_access_level: Set the builds access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.str] ci_config_path: Custom Path to CI config file.
        :param pulumi.Input[builtins.int] ci_default_git_depth: Default number of revisions for shallow cloning.
        :param pulumi.Input[builtins.int] ci_delete_pipelines_in_seconds: Pipelines older than the configured time are deleted.
        :param pulumi.Input[builtins.bool] ci_forward_deployment_enabled: When a new deployment job starts, skip older deployment jobs that are still pending.
        :param pulumi.Input[builtins.bool] ci_forward_deployment_rollback_allowed: Allow job retries even if the deployment job is outdated.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ci_id_token_sub_claim_components: Fields included in the sub claim of the ID Token. Accepts an array starting with project*path. The array might also include ref*type and ref. Defaults to ["project*path", "ref*type", "ref"]. Introduced in GitLab 17.10.
        :param pulumi.Input[builtins.str] ci_pipeline_variables_minimum_override_role: The minimum role required to set variables when running pipelines and jobs. Introduced in GitLab 17.1. Valid values are `developer`, `maintainer`, `owner`, `no_one_allowed`
        :param pulumi.Input[builtins.bool] ci_push_repository_for_job_token_allowed: Allow Git push requests to your project repository that are authenticated with a CI/CD job token.
        :param pulumi.Input[builtins.str] ci_restrict_pipeline_cancellation_role: The role required to cancel a pipeline or job. Premium and Ultimate only. Valid values are `developer`, `maintainer`, `no one`
        :param pulumi.Input[builtins.bool] ci_separated_caches: Use separate caches for protected branches.
        :param pulumi.Input[Union['ProjectContainerExpirationPolicyArgs', 'ProjectContainerExpirationPolicyArgsDict']] container_expiration_policy: Set the image cleanup policy for this project. **Note**: this field is sometimes named `container_expiration_policy_attributes` in the GitLab Upstream API.
        :param pulumi.Input[builtins.str] container_registry_access_level: Set visibility of container registry, for this project. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] container_registry_enabled: Enable container registry for the project.
        :param pulumi.Input[builtins.str] default_branch: The default branch for the project.
        :param pulumi.Input[builtins.str] description: A description of the project.
        :param pulumi.Input[builtins.bool] emails_enabled: Enable email notifications.
        :param pulumi.Input[builtins.bool] empty_repo: Whether the project is empty.
        :param pulumi.Input[builtins.str] environments_access_level: Set the environments access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.str] external_authorization_classification_label: The classification label for the project.
        :param pulumi.Input[builtins.str] feature_flags_access_level: Set the feature flags access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.int] forked_from_project_id: The id of the project to fork. During create the project is forked and during an update the fork relation is changed.
        :param pulumi.Input[builtins.str] forking_access_level: Set the forking access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] group_runners_enabled: Enable group runners for this project.
        :param pulumi.Input[builtins.int] group_with_project_templates_id: For group-level custom templates, specifies ID of group from which all the custom project templates are sourced. Leave empty for instance-level templates. Requires use*custom*template to be true (enterprise edition).
        :param pulumi.Input[builtins.str] http_url_to_repo: URL that can be provided to `git clone` to clone the
        :param pulumi.Input[builtins.str] import_url: Git URL to a repository to be imported. Together with `mirror = true` it will setup a Pull Mirror. This can also be used together with `forked_from_project_id` to setup a Pull Mirror for a fork. The fork takes precedence over the import. Make sure to provide the credentials in `import_url_username` and `import_url_password`. GitLab never returns the credentials, thus the provider cannot detect configuration drift in the credentials. They can also not be imported using `pulumi import`. See the examples section for how to properly use it.
        :param pulumi.Input[builtins.str] import_url_password: The password for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related to the provider. This field cannot be imported using `pulumi import`. See the examples section for how to properly use it.
        :param pulumi.Input[builtins.str] import_url_username: The username for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related to the provider. This field cannot be imported using `pulumi import`.  See the examples section for how to properly use it.
        :param pulumi.Input[builtins.str] infrastructure_access_level: Set the infrastructure access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] initialize_with_readme: Create main branch with first commit containing a README.md file. Must be set to `true` if importing an uninitialized project with a different `default_branch`.
        :param pulumi.Input[builtins.str] issues_access_level: Set the issues access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] issues_enabled: Enable issue tracking for the project.
        :param pulumi.Input[builtins.str] issues_template: Sets the template for new issues in the project.
        :param pulumi.Input[builtins.bool] keep_latest_artifact: Disable or enable the ability to keep the latest artifact for this project.
        :param pulumi.Input[builtins.bool] lfs_enabled: Enable LFS for the project.
        :param pulumi.Input[builtins.str] merge_commit_template: Template used to create merge commit message in merge requests.
        :param pulumi.Input[builtins.str] merge_method: Set the merge method. Valid values are `merge`, `rebase_merge`, `ff`.
        :param pulumi.Input[builtins.bool] merge_pipelines_enabled: Enable or disable merge pipelines.
        :param pulumi.Input[builtins.str] merge_requests_access_level: Set the merge requests access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] merge_requests_enabled: Enable merge requests for the project.
        :param pulumi.Input[builtins.str] merge_requests_template: Sets the template for new merge requests in the project.
        :param pulumi.Input[builtins.bool] merge_trains_enabled: Enable or disable merge trains. Requires `merge_pipelines_enabled` to be set to `true` to take effect.
        :param pulumi.Input[builtins.bool] mirror: Enable project pull mirror.
        :param pulumi.Input[builtins.bool] mirror_overwrites_diverged_branches: Enable overwrite diverged branches for a mirrored project.
        :param pulumi.Input[builtins.bool] mirror_trigger_builds: Enable trigger builds on pushes for a mirrored project.
        :param pulumi.Input[builtins.str] model_experiments_access_level: Set visibility of machine learning model experiments. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.str] model_registry_access_level: Set visibility of machine learning model registry. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.str] monitor_access_level: Set the monitor access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] mr_default_target_self: For forked projects, target merge requests to this project. If false, the target will be the upstream project.
        :param pulumi.Input[builtins.str] name: The name of the project.
        :param pulumi.Input[builtins.int] namespace_id: The namespace (group or user) of the project. Defaults to your user.
        :param pulumi.Input[builtins.bool] only_allow_merge_if_all_discussions_are_resolved: Set to true if you want allow merges only if all discussions are resolved.
        :param pulumi.Input[builtins.bool] only_allow_merge_if_pipeline_succeeds: Set to true if you want allow merges only if a pipeline succeeds.
        :param pulumi.Input[builtins.bool] only_mirror_protected_branches: Enable only mirror protected branches for a mirrored project.
        :param pulumi.Input[builtins.bool] packages_enabled: Enable packages repository for the project.
        :param pulumi.Input[builtins.str] pages_access_level: Enable pages access control. Valid values are `public`, `private`, `enabled`, `disabled`.
        :param pulumi.Input[builtins.str] path: The path of the repository.
        :param pulumi.Input[builtins.str] path_with_namespace: The path of the repository with namespace.
        :param pulumi.Input[builtins.bool] permanently_delete_on_destroy: Set to `true` to immediately permanently delete the project instead of scheduling a delete for Premium and Ultimate tiers.
        :param pulumi.Input[builtins.bool] pipelines_enabled: Enable pipelines for the project. The `pipelines_enabled` field is being sent as `jobs_enabled` in the GitLab API calls.
        :param pulumi.Input[builtins.bool] pre_receive_secret_detection_enabled: Whether Secret Push Detection is enabled. Requires GitLab Ultimate.
        :param pulumi.Input[builtins.bool] prevent_merge_without_jira_issue: Set whether merge requests require an associated issue from Jira. Premium and Ultimate only.
        :param pulumi.Input[builtins.bool] printing_merge_request_link_enabled: Show link to create/view merge request when pushing from the command line
        :param pulumi.Input[builtins.bool] public_builds: If true, jobs can be viewed by non-project members.
        :param pulumi.Input[builtins.bool] public_jobs: If true, jobs can be viewed by non-project members.
        :param pulumi.Input[Union['ProjectPushRulesArgs', 'ProjectPushRulesArgsDict']] push_rules: Push rules for the project.
        :param pulumi.Input[builtins.str] releases_access_level: Set the releases access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] remove_source_branch_after_merge: Enable `Delete source branch` option by default for all new merge requests.
        :param pulumi.Input[builtins.str] repository_access_level: Set the repository access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.str] repository_storage: Which storage shard the repository is on. (administrator only)
        :param pulumi.Input[builtins.bool] request_access_enabled: Allow users to request member access.
        :param pulumi.Input[builtins.str] requirements_access_level: Set the requirements access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] resolve_outdated_diff_discussions: Automatically resolve merge request diffs discussions on lines changed with a push.
        :param pulumi.Input[builtins.bool] restrict_user_defined_variables: Allow only users with the Maintainer role to pass user-defined variables when triggering a pipeline.
        :param pulumi.Input[builtins.str] runners_token: Registration token to use during runner setup.
        :param pulumi.Input[builtins.str] security_and_compliance_access_level: Set the security and compliance access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] shared_runners_enabled: Enable shared runners for this project.
        :param pulumi.Input[builtins.bool] skip_wait_for_default_branch_protection: If `true`, the default behavior to wait for the default branch protection to be created is skipped.
               This is necessary if the current user is not an admin and the default branch protection is disabled on an instance-level.
               There is currently no known way to determine if the default branch protection is disabled on an instance-level for non-admin users.
               This attribute is only used during resource creation, thus changes are suppressed and the attribute cannot be imported.
        :param pulumi.Input[builtins.str] snippets_access_level: Set the snippets access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] snippets_enabled: Enable snippets for the project.
        :param pulumi.Input[builtins.str] squash_commit_template: Template used to create squash commit message in merge requests.
        :param pulumi.Input[builtins.str] squash_option: Squash commits when merge request is merged. Valid values are `never` (Do not allow), `always` (Require), `default_on` (Encourage), or `default_off` (Allow). The default value is `default_off` (Allow).
        :param pulumi.Input[builtins.str] ssh_url_to_repo: URL that can be provided to `git clone` to clone the
        :param pulumi.Input[builtins.str] suggestion_commit_message: The commit message used to apply merge request suggestions.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: The list of tags for a project; put array of tags, that should be finally assigned to a project. Use topics instead.
        :param pulumi.Input[builtins.str] template_name: When used without use*custom*template, name of a built-in project template. When used with use*custom*template, name of a custom project template. This option is mutually exclusive with `template_project_id`.
        :param pulumi.Input[builtins.int] template_project_id: When used with use*custom*template, project ID of a custom project template. This is preferable to using template*name since template*name may be ambiguous (enterprise edition). This option is mutually exclusive with `template_name`. See `GroupProjectFileTemplate` to set a project as a template project. If a project has not been set as a template, using it here will result in an error.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] topics: The list of topics for the project.
        :param pulumi.Input[builtins.bool] use_custom_template: Use either custom instance or group (with group*with*project*templates*id) project template (enterprise edition).
               	> When using a custom template, [Group Tokens won't work](https://docs.gitlab.com/15.7/ee/user/project/settings/import_export_troubleshooting/#import-using-the-rest-api-fails-when-using-a-group-access-token). You must use a real user's Personal Access Token.
        :param pulumi.Input[builtins.str] visibility_level: Set to `public` to create a public project. Valid values are `private`, `internal`, `public`.
        :param pulumi.Input[builtins.str] web_url: URL that can be used to find the project in a browser.
        :param pulumi.Input[builtins.str] wiki_access_level: Set the wiki access level. Valid values are `disabled`, `private`, `enabled`.
        :param pulumi.Input[builtins.bool] wiki_enabled: Enable wiki for the project.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectState.__new__(_ProjectState)

        __props__.__dict__["allow_merge_on_skipped_pipeline"] = allow_merge_on_skipped_pipeline
        __props__.__dict__["allow_pipeline_trigger_approve_deployment"] = allow_pipeline_trigger_approve_deployment
        __props__.__dict__["analytics_access_level"] = analytics_access_level
        __props__.__dict__["approvals_before_merge"] = approvals_before_merge
        __props__.__dict__["archive_on_destroy"] = archive_on_destroy
        __props__.__dict__["archived"] = archived
        __props__.__dict__["auto_cancel_pending_pipelines"] = auto_cancel_pending_pipelines
        __props__.__dict__["auto_devops_deploy_strategy"] = auto_devops_deploy_strategy
        __props__.__dict__["auto_devops_enabled"] = auto_devops_enabled
        __props__.__dict__["auto_duo_code_review_enabled"] = auto_duo_code_review_enabled
        __props__.__dict__["autoclose_referenced_issues"] = autoclose_referenced_issues
        __props__.__dict__["avatar"] = avatar
        __props__.__dict__["avatar_hash"] = avatar_hash
        __props__.__dict__["avatar_url"] = avatar_url
        __props__.__dict__["branches"] = branches
        __props__.__dict__["build_git_strategy"] = build_git_strategy
        __props__.__dict__["build_timeout"] = build_timeout
        __props__.__dict__["builds_access_level"] = builds_access_level
        __props__.__dict__["ci_config_path"] = ci_config_path
        __props__.__dict__["ci_default_git_depth"] = ci_default_git_depth
        __props__.__dict__["ci_delete_pipelines_in_seconds"] = ci_delete_pipelines_in_seconds
        __props__.__dict__["ci_forward_deployment_enabled"] = ci_forward_deployment_enabled
        __props__.__dict__["ci_forward_deployment_rollback_allowed"] = ci_forward_deployment_rollback_allowed
        __props__.__dict__["ci_id_token_sub_claim_components"] = ci_id_token_sub_claim_components
        __props__.__dict__["ci_pipeline_variables_minimum_override_role"] = ci_pipeline_variables_minimum_override_role
        __props__.__dict__["ci_push_repository_for_job_token_allowed"] = ci_push_repository_for_job_token_allowed
        __props__.__dict__["ci_restrict_pipeline_cancellation_role"] = ci_restrict_pipeline_cancellation_role
        __props__.__dict__["ci_separated_caches"] = ci_separated_caches
        __props__.__dict__["container_expiration_policy"] = container_expiration_policy
        __props__.__dict__["container_registry_access_level"] = container_registry_access_level
        __props__.__dict__["container_registry_enabled"] = container_registry_enabled
        __props__.__dict__["default_branch"] = default_branch
        __props__.__dict__["description"] = description
        __props__.__dict__["emails_enabled"] = emails_enabled
        __props__.__dict__["empty_repo"] = empty_repo
        __props__.__dict__["environments_access_level"] = environments_access_level
        __props__.__dict__["external_authorization_classification_label"] = external_authorization_classification_label
        __props__.__dict__["feature_flags_access_level"] = feature_flags_access_level
        __props__.__dict__["forked_from_project_id"] = forked_from_project_id
        __props__.__dict__["forking_access_level"] = forking_access_level
        __props__.__dict__["group_runners_enabled"] = group_runners_enabled
        __props__.__dict__["group_with_project_templates_id"] = group_with_project_templates_id
        __props__.__dict__["http_url_to_repo"] = http_url_to_repo
        __props__.__dict__["import_url"] = import_url
        __props__.__dict__["import_url_password"] = import_url_password
        __props__.__dict__["import_url_username"] = import_url_username
        __props__.__dict__["infrastructure_access_level"] = infrastructure_access_level
        __props__.__dict__["initialize_with_readme"] = initialize_with_readme
        __props__.__dict__["issues_access_level"] = issues_access_level
        __props__.__dict__["issues_enabled"] = issues_enabled
        __props__.__dict__["issues_template"] = issues_template
        __props__.__dict__["keep_latest_artifact"] = keep_latest_artifact
        __props__.__dict__["lfs_enabled"] = lfs_enabled
        __props__.__dict__["merge_commit_template"] = merge_commit_template
        __props__.__dict__["merge_method"] = merge_method
        __props__.__dict__["merge_pipelines_enabled"] = merge_pipelines_enabled
        __props__.__dict__["merge_requests_access_level"] = merge_requests_access_level
        __props__.__dict__["merge_requests_enabled"] = merge_requests_enabled
        __props__.__dict__["merge_requests_template"] = merge_requests_template
        __props__.__dict__["merge_trains_enabled"] = merge_trains_enabled
        __props__.__dict__["mirror"] = mirror
        __props__.__dict__["mirror_overwrites_diverged_branches"] = mirror_overwrites_diverged_branches
        __props__.__dict__["mirror_trigger_builds"] = mirror_trigger_builds
        __props__.__dict__["model_experiments_access_level"] = model_experiments_access_level
        __props__.__dict__["model_registry_access_level"] = model_registry_access_level
        __props__.__dict__["monitor_access_level"] = monitor_access_level
        __props__.__dict__["mr_default_target_self"] = mr_default_target_self
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace_id"] = namespace_id
        __props__.__dict__["only_allow_merge_if_all_discussions_are_resolved"] = only_allow_merge_if_all_discussions_are_resolved
        __props__.__dict__["only_allow_merge_if_pipeline_succeeds"] = only_allow_merge_if_pipeline_succeeds
        __props__.__dict__["only_mirror_protected_branches"] = only_mirror_protected_branches
        __props__.__dict__["packages_enabled"] = packages_enabled
        __props__.__dict__["pages_access_level"] = pages_access_level
        __props__.__dict__["path"] = path
        __props__.__dict__["path_with_namespace"] = path_with_namespace
        __props__.__dict__["permanently_delete_on_destroy"] = permanently_delete_on_destroy
        __props__.__dict__["pipelines_enabled"] = pipelines_enabled
        __props__.__dict__["pre_receive_secret_detection_enabled"] = pre_receive_secret_detection_enabled
        __props__.__dict__["prevent_merge_without_jira_issue"] = prevent_merge_without_jira_issue
        __props__.__dict__["printing_merge_request_link_enabled"] = printing_merge_request_link_enabled
        __props__.__dict__["public_builds"] = public_builds
        __props__.__dict__["public_jobs"] = public_jobs
        __props__.__dict__["push_rules"] = push_rules
        __props__.__dict__["releases_access_level"] = releases_access_level
        __props__.__dict__["remove_source_branch_after_merge"] = remove_source_branch_after_merge
        __props__.__dict__["repository_access_level"] = repository_access_level
        __props__.__dict__["repository_storage"] = repository_storage
        __props__.__dict__["request_access_enabled"] = request_access_enabled
        __props__.__dict__["requirements_access_level"] = requirements_access_level
        __props__.__dict__["resolve_outdated_diff_discussions"] = resolve_outdated_diff_discussions
        __props__.__dict__["restrict_user_defined_variables"] = restrict_user_defined_variables
        __props__.__dict__["runners_token"] = runners_token
        __props__.__dict__["security_and_compliance_access_level"] = security_and_compliance_access_level
        __props__.__dict__["shared_runners_enabled"] = shared_runners_enabled
        __props__.__dict__["skip_wait_for_default_branch_protection"] = skip_wait_for_default_branch_protection
        __props__.__dict__["snippets_access_level"] = snippets_access_level
        __props__.__dict__["snippets_enabled"] = snippets_enabled
        __props__.__dict__["squash_commit_template"] = squash_commit_template
        __props__.__dict__["squash_option"] = squash_option
        __props__.__dict__["ssh_url_to_repo"] = ssh_url_to_repo
        __props__.__dict__["suggestion_commit_message"] = suggestion_commit_message
        __props__.__dict__["tags"] = tags
        __props__.__dict__["template_name"] = template_name
        __props__.__dict__["template_project_id"] = template_project_id
        __props__.__dict__["topics"] = topics
        __props__.__dict__["use_custom_template"] = use_custom_template
        __props__.__dict__["visibility_level"] = visibility_level
        __props__.__dict__["web_url"] = web_url
        __props__.__dict__["wiki_access_level"] = wiki_access_level
        __props__.__dict__["wiki_enabled"] = wiki_enabled
        return Project(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowMergeOnSkippedPipeline")
    def allow_merge_on_skipped_pipeline(self) -> pulumi.Output[builtins.bool]:
        """
        Set to true if you want to treat skipped pipelines as if they finished with success.
        """
        return pulumi.get(self, "allow_merge_on_skipped_pipeline")

    @property
    @pulumi.getter(name="allowPipelineTriggerApproveDeployment")
    def allow_pipeline_trigger_approve_deployment(self) -> pulumi.Output[builtins.bool]:
        """
        Set whether or not a pipeline triggerer is allowed to approve deployments. Premium and Ultimate only.
        """
        return pulumi.get(self, "allow_pipeline_trigger_approve_deployment")

    @property
    @pulumi.getter(name="analyticsAccessLevel")
    def analytics_access_level(self) -> pulumi.Output[builtins.str]:
        """
        Set the analytics access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "analytics_access_level")

    @property
    @pulumi.getter(name="approvalsBeforeMerge")
    def approvals_before_merge(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Number of merge request approvals required for merging. Default is 0.
        This field **does not** work well in combination with the `ProjectApprovalRule` resource
        and is most likely gonna be deprecated in a future GitLab version (see [this upstream epic](https://gitlab.com/groups/gitlab-org/-/epics/7572)).
        In the meantime we recommend against using this attribute and use `ProjectApprovalRule` instead.
        """
        return pulumi.get(self, "approvals_before_merge")

    @property
    @pulumi.getter(name="archiveOnDestroy")
    def archive_on_destroy(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Set to `true` to archive the project instead of deleting on destroy. If set to `true` it will entire omit the `DELETE` operation.
        """
        return pulumi.get(self, "archive_on_destroy")

    @property
    @pulumi.getter
    def archived(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the project is in read-only mode (archived). Repositories can be archived/unarchived by toggling this parameter.
        """
        return pulumi.get(self, "archived")

    @property
    @pulumi.getter(name="autoCancelPendingPipelines")
    def auto_cancel_pending_pipelines(self) -> pulumi.Output[builtins.str]:
        """
        Auto-cancel pending pipelines. This isn’t a boolean, but enabled/disabled.
        """
        return pulumi.get(self, "auto_cancel_pending_pipelines")

    @property
    @pulumi.getter(name="autoDevopsDeployStrategy")
    def auto_devops_deploy_strategy(self) -> pulumi.Output[builtins.str]:
        """
        Auto Deploy strategy. Valid values are `continuous`, `manual`, `timed_incremental`.
        """
        return pulumi.get(self, "auto_devops_deploy_strategy")

    @property
    @pulumi.getter(name="autoDevopsEnabled")
    def auto_devops_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Enable Auto DevOps for this project.
        """
        return pulumi.get(self, "auto_devops_enabled")

    @property
    @pulumi.getter(name="autoDuoCodeReviewEnabled")
    def auto_duo_code_review_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Enable automatic reviews by GitLab Duo on merge requests. Ultimate only. Automatic reviews only work with the GitLab Duo Enterprise add-on.
        """
        return pulumi.get(self, "auto_duo_code_review_enabled")

    @property
    @pulumi.getter(name="autocloseReferencedIssues")
    def autoclose_referenced_issues(self) -> pulumi.Output[builtins.bool]:
        """
        Set whether auto-closing referenced issues on default branch.
        """
        return pulumi.get(self, "autoclose_referenced_issues")

    @property
    @pulumi.getter
    def avatar(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A local path to the avatar image to upload. **Note**: not available for imported resources.
        """
        return pulumi.get(self, "avatar")

    @property
    @pulumi.getter(name="avatarHash")
    def avatar_hash(self) -> pulumi.Output[builtins.str]:
        """
        The hash of the avatar image. Use `filesha256("path/to/avatar.png")` whenever possible. **Note**: this is used to trigger an update of the avatar. If it's not given, but an avatar is given, the avatar will be updated each time.
        """
        return pulumi.get(self, "avatar_hash")

    @property
    @pulumi.getter(name="avatarUrl")
    def avatar_url(self) -> pulumi.Output[builtins.str]:
        """
        The URL of the avatar image.
        """
        return pulumi.get(self, "avatar_url")

    @property
    @pulumi.getter
    def branches(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Branches to fork (empty for all branches).
        """
        return pulumi.get(self, "branches")

    @property
    @pulumi.getter(name="buildGitStrategy")
    def build_git_strategy(self) -> pulumi.Output[builtins.str]:
        """
        The Git strategy. Defaults to fetch. Valid values are `clone`, `fetch`.
        """
        return pulumi.get(self, "build_git_strategy")

    @property
    @pulumi.getter(name="buildTimeout")
    def build_timeout(self) -> pulumi.Output[builtins.int]:
        """
        The maximum amount of time, in seconds, that a job can run.
        """
        return pulumi.get(self, "build_timeout")

    @property
    @pulumi.getter(name="buildsAccessLevel")
    def builds_access_level(self) -> pulumi.Output[builtins.str]:
        """
        Set the builds access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "builds_access_level")

    @property
    @pulumi.getter(name="ciConfigPath")
    def ci_config_path(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Custom Path to CI config file.
        """
        return pulumi.get(self, "ci_config_path")

    @property
    @pulumi.getter(name="ciDefaultGitDepth")
    def ci_default_git_depth(self) -> pulumi.Output[builtins.int]:
        """
        Default number of revisions for shallow cloning.
        """
        return pulumi.get(self, "ci_default_git_depth")

    @property
    @pulumi.getter(name="ciDeletePipelinesInSeconds")
    def ci_delete_pipelines_in_seconds(self) -> pulumi.Output[builtins.int]:
        """
        Pipelines older than the configured time are deleted.
        """
        return pulumi.get(self, "ci_delete_pipelines_in_seconds")

    @property
    @pulumi.getter(name="ciForwardDeploymentEnabled")
    def ci_forward_deployment_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        When a new deployment job starts, skip older deployment jobs that are still pending.
        """
        return pulumi.get(self, "ci_forward_deployment_enabled")

    @property
    @pulumi.getter(name="ciForwardDeploymentRollbackAllowed")
    def ci_forward_deployment_rollback_allowed(self) -> pulumi.Output[builtins.bool]:
        """
        Allow job retries even if the deployment job is outdated.
        """
        return pulumi.get(self, "ci_forward_deployment_rollback_allowed")

    @property
    @pulumi.getter(name="ciIdTokenSubClaimComponents")
    def ci_id_token_sub_claim_components(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Fields included in the sub claim of the ID Token. Accepts an array starting with project*path. The array might also include ref*type and ref. Defaults to ["project*path", "ref*type", "ref"]. Introduced in GitLab 17.10.
        """
        return pulumi.get(self, "ci_id_token_sub_claim_components")

    @property
    @pulumi.getter(name="ciPipelineVariablesMinimumOverrideRole")
    def ci_pipeline_variables_minimum_override_role(self) -> pulumi.Output[builtins.str]:
        """
        The minimum role required to set variables when running pipelines and jobs. Introduced in GitLab 17.1. Valid values are `developer`, `maintainer`, `owner`, `no_one_allowed`
        """
        return pulumi.get(self, "ci_pipeline_variables_minimum_override_role")

    @property
    @pulumi.getter(name="ciPushRepositoryForJobTokenAllowed")
    def ci_push_repository_for_job_token_allowed(self) -> pulumi.Output[builtins.bool]:
        """
        Allow Git push requests to your project repository that are authenticated with a CI/CD job token.
        """
        return pulumi.get(self, "ci_push_repository_for_job_token_allowed")

    @property
    @pulumi.getter(name="ciRestrictPipelineCancellationRole")
    def ci_restrict_pipeline_cancellation_role(self) -> pulumi.Output[builtins.str]:
        """
        The role required to cancel a pipeline or job. Premium and Ultimate only. Valid values are `developer`, `maintainer`, `no one`
        """
        return pulumi.get(self, "ci_restrict_pipeline_cancellation_role")

    @property
    @pulumi.getter(name="ciSeparatedCaches")
    def ci_separated_caches(self) -> pulumi.Output[builtins.bool]:
        """
        Use separate caches for protected branches.
        """
        return pulumi.get(self, "ci_separated_caches")

    @property
    @pulumi.getter(name="containerExpirationPolicy")
    def container_expiration_policy(self) -> pulumi.Output['outputs.ProjectContainerExpirationPolicy']:
        """
        Set the image cleanup policy for this project. **Note**: this field is sometimes named `container_expiration_policy_attributes` in the GitLab Upstream API.
        """
        return pulumi.get(self, "container_expiration_policy")

    @property
    @pulumi.getter(name="containerRegistryAccessLevel")
    def container_registry_access_level(self) -> pulumi.Output[builtins.str]:
        """
        Set visibility of container registry, for this project. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "container_registry_access_level")

    @property
    @pulumi.getter(name="containerRegistryEnabled")
    @_utilities.deprecated("""Use `container_registry_access_level` instead.""")
    def container_registry_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Enable container registry for the project.
        """
        return pulumi.get(self, "container_registry_enabled")

    @property
    @pulumi.getter(name="defaultBranch")
    def default_branch(self) -> pulumi.Output[builtins.str]:
        """
        The default branch for the project.
        """
        return pulumi.get(self, "default_branch")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description of the project.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="emailsEnabled")
    def emails_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Enable email notifications.
        """
        return pulumi.get(self, "emails_enabled")

    @property
    @pulumi.getter(name="emptyRepo")
    def empty_repo(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the project is empty.
        """
        return pulumi.get(self, "empty_repo")

    @property
    @pulumi.getter(name="environmentsAccessLevel")
    def environments_access_level(self) -> pulumi.Output[builtins.str]:
        """
        Set the environments access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "environments_access_level")

    @property
    @pulumi.getter(name="externalAuthorizationClassificationLabel")
    def external_authorization_classification_label(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The classification label for the project.
        """
        return pulumi.get(self, "external_authorization_classification_label")

    @property
    @pulumi.getter(name="featureFlagsAccessLevel")
    def feature_flags_access_level(self) -> pulumi.Output[builtins.str]:
        """
        Set the feature flags access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "feature_flags_access_level")

    @property
    @pulumi.getter(name="forkedFromProjectId")
    def forked_from_project_id(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The id of the project to fork. During create the project is forked and during an update the fork relation is changed.
        """
        return pulumi.get(self, "forked_from_project_id")

    @property
    @pulumi.getter(name="forkingAccessLevel")
    def forking_access_level(self) -> pulumi.Output[builtins.str]:
        """
        Set the forking access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "forking_access_level")

    @property
    @pulumi.getter(name="groupRunnersEnabled")
    def group_runners_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Enable group runners for this project.
        """
        return pulumi.get(self, "group_runners_enabled")

    @property
    @pulumi.getter(name="groupWithProjectTemplatesId")
    def group_with_project_templates_id(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        For group-level custom templates, specifies ID of group from which all the custom project templates are sourced. Leave empty for instance-level templates. Requires use*custom*template to be true (enterprise edition).
        """
        return pulumi.get(self, "group_with_project_templates_id")

    @property
    @pulumi.getter(name="httpUrlToRepo")
    def http_url_to_repo(self) -> pulumi.Output[builtins.str]:
        """
        URL that can be provided to `git clone` to clone the
        """
        return pulumi.get(self, "http_url_to_repo")

    @property
    @pulumi.getter(name="importUrl")
    def import_url(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Git URL to a repository to be imported. Together with `mirror = true` it will setup a Pull Mirror. This can also be used together with `forked_from_project_id` to setup a Pull Mirror for a fork. The fork takes precedence over the import. Make sure to provide the credentials in `import_url_username` and `import_url_password`. GitLab never returns the credentials, thus the provider cannot detect configuration drift in the credentials. They can also not be imported using `pulumi import`. See the examples section for how to properly use it.
        """
        return pulumi.get(self, "import_url")

    @property
    @pulumi.getter(name="importUrlPassword")
    def import_url_password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The password for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related to the provider. This field cannot be imported using `pulumi import`. See the examples section for how to properly use it.
        """
        return pulumi.get(self, "import_url_password")

    @property
    @pulumi.getter(name="importUrlUsername")
    def import_url_username(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The username for the `import_url`. The value of this field is used to construct a valid `import_url` and is only related to the provider. This field cannot be imported using `pulumi import`.  See the examples section for how to properly use it.
        """
        return pulumi.get(self, "import_url_username")

    @property
    @pulumi.getter(name="infrastructureAccessLevel")
    def infrastructure_access_level(self) -> pulumi.Output[builtins.str]:
        """
        Set the infrastructure access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "infrastructure_access_level")

    @property
    @pulumi.getter(name="initializeWithReadme")
    def initialize_with_readme(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Create main branch with first commit containing a README.md file. Must be set to `true` if importing an uninitialized project with a different `default_branch`.
        """
        return pulumi.get(self, "initialize_with_readme")

    @property
    @pulumi.getter(name="issuesAccessLevel")
    def issues_access_level(self) -> pulumi.Output[builtins.str]:
        """
        Set the issues access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "issues_access_level")

    @property
    @pulumi.getter(name="issuesEnabled")
    def issues_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Enable issue tracking for the project.
        """
        return pulumi.get(self, "issues_enabled")

    @property
    @pulumi.getter(name="issuesTemplate")
    def issues_template(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Sets the template for new issues in the project.
        """
        return pulumi.get(self, "issues_template")

    @property
    @pulumi.getter(name="keepLatestArtifact")
    def keep_latest_artifact(self) -> pulumi.Output[builtins.bool]:
        """
        Disable or enable the ability to keep the latest artifact for this project.
        """
        return pulumi.get(self, "keep_latest_artifact")

    @property
    @pulumi.getter(name="lfsEnabled")
    def lfs_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Enable LFS for the project.
        """
        return pulumi.get(self, "lfs_enabled")

    @property
    @pulumi.getter(name="mergeCommitTemplate")
    def merge_commit_template(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Template used to create merge commit message in merge requests.
        """
        return pulumi.get(self, "merge_commit_template")

    @property
    @pulumi.getter(name="mergeMethod")
    def merge_method(self) -> pulumi.Output[builtins.str]:
        """
        Set the merge method. Valid values are `merge`, `rebase_merge`, `ff`.
        """
        return pulumi.get(self, "merge_method")

    @property
    @pulumi.getter(name="mergePipelinesEnabled")
    def merge_pipelines_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Enable or disable merge pipelines.
        """
        return pulumi.get(self, "merge_pipelines_enabled")

    @property
    @pulumi.getter(name="mergeRequestsAccessLevel")
    def merge_requests_access_level(self) -> pulumi.Output[builtins.str]:
        """
        Set the merge requests access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "merge_requests_access_level")

    @property
    @pulumi.getter(name="mergeRequestsEnabled")
    def merge_requests_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Enable merge requests for the project.
        """
        return pulumi.get(self, "merge_requests_enabled")

    @property
    @pulumi.getter(name="mergeRequestsTemplate")
    def merge_requests_template(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Sets the template for new merge requests in the project.
        """
        return pulumi.get(self, "merge_requests_template")

    @property
    @pulumi.getter(name="mergeTrainsEnabled")
    def merge_trains_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Enable or disable merge trains. Requires `merge_pipelines_enabled` to be set to `true` to take effect.
        """
        return pulumi.get(self, "merge_trains_enabled")

    @property
    @pulumi.getter
    def mirror(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable project pull mirror.
        """
        return pulumi.get(self, "mirror")

    @property
    @pulumi.getter(name="mirrorOverwritesDivergedBranches")
    def mirror_overwrites_diverged_branches(self) -> pulumi.Output[builtins.bool]:
        """
        Enable overwrite diverged branches for a mirrored project.
        """
        return pulumi.get(self, "mirror_overwrites_diverged_branches")

    @property
    @pulumi.getter(name="mirrorTriggerBuilds")
    def mirror_trigger_builds(self) -> pulumi.Output[builtins.bool]:
        """
        Enable trigger builds on pushes for a mirrored project.
        """
        return pulumi.get(self, "mirror_trigger_builds")

    @property
    @pulumi.getter(name="modelExperimentsAccessLevel")
    def model_experiments_access_level(self) -> pulumi.Output[builtins.str]:
        """
        Set visibility of machine learning model experiments. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "model_experiments_access_level")

    @property
    @pulumi.getter(name="modelRegistryAccessLevel")
    def model_registry_access_level(self) -> pulumi.Output[builtins.str]:
        """
        Set visibility of machine learning model registry. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "model_registry_access_level")

    @property
    @pulumi.getter(name="monitorAccessLevel")
    def monitor_access_level(self) -> pulumi.Output[builtins.str]:
        """
        Set the monitor access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "monitor_access_level")

    @property
    @pulumi.getter(name="mrDefaultTargetSelf")
    def mr_default_target_self(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        For forked projects, target merge requests to this project. If false, the target will be the upstream project.
        """
        return pulumi.get(self, "mr_default_target_self")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the project.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namespaceId")
    def namespace_id(self) -> pulumi.Output[builtins.int]:
        """
        The namespace (group or user) of the project. Defaults to your user.
        """
        return pulumi.get(self, "namespace_id")

    @property
    @pulumi.getter(name="onlyAllowMergeIfAllDiscussionsAreResolved")
    def only_allow_merge_if_all_discussions_are_resolved(self) -> pulumi.Output[builtins.bool]:
        """
        Set to true if you want allow merges only if all discussions are resolved.
        """
        return pulumi.get(self, "only_allow_merge_if_all_discussions_are_resolved")

    @property
    @pulumi.getter(name="onlyAllowMergeIfPipelineSucceeds")
    def only_allow_merge_if_pipeline_succeeds(self) -> pulumi.Output[builtins.bool]:
        """
        Set to true if you want allow merges only if a pipeline succeeds.
        """
        return pulumi.get(self, "only_allow_merge_if_pipeline_succeeds")

    @property
    @pulumi.getter(name="onlyMirrorProtectedBranches")
    def only_mirror_protected_branches(self) -> pulumi.Output[builtins.bool]:
        """
        Enable only mirror protected branches for a mirrored project.
        """
        return pulumi.get(self, "only_mirror_protected_branches")

    @property
    @pulumi.getter(name="packagesEnabled")
    def packages_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Enable packages repository for the project.
        """
        return pulumi.get(self, "packages_enabled")

    @property
    @pulumi.getter(name="pagesAccessLevel")
    def pages_access_level(self) -> pulumi.Output[builtins.str]:
        """
        Enable pages access control. Valid values are `public`, `private`, `enabled`, `disabled`.
        """
        return pulumi.get(self, "pages_access_level")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The path of the repository.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="pathWithNamespace")
    def path_with_namespace(self) -> pulumi.Output[builtins.str]:
        """
        The path of the repository with namespace.
        """
        return pulumi.get(self, "path_with_namespace")

    @property
    @pulumi.getter(name="permanentlyDeleteOnDestroy")
    def permanently_delete_on_destroy(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Set to `true` to immediately permanently delete the project instead of scheduling a delete for Premium and Ultimate tiers.
        """
        return pulumi.get(self, "permanently_delete_on_destroy")

    @property
    @pulumi.getter(name="pipelinesEnabled")
    @_utilities.deprecated("""Deprecated in favor of `builds_access_level`""")
    def pipelines_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Enable pipelines for the project. The `pipelines_enabled` field is being sent as `jobs_enabled` in the GitLab API calls.
        """
        return pulumi.get(self, "pipelines_enabled")

    @property
    @pulumi.getter(name="preReceiveSecretDetectionEnabled")
    def pre_receive_secret_detection_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Whether Secret Push Detection is enabled. Requires GitLab Ultimate.
        """
        return pulumi.get(self, "pre_receive_secret_detection_enabled")

    @property
    @pulumi.getter(name="preventMergeWithoutJiraIssue")
    def prevent_merge_without_jira_issue(self) -> pulumi.Output[builtins.bool]:
        """
        Set whether merge requests require an associated issue from Jira. Premium and Ultimate only.
        """
        return pulumi.get(self, "prevent_merge_without_jira_issue")

    @property
    @pulumi.getter(name="printingMergeRequestLinkEnabled")
    def printing_merge_request_link_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Show link to create/view merge request when pushing from the command line
        """
        return pulumi.get(self, "printing_merge_request_link_enabled")

    @property
    @pulumi.getter(name="publicBuilds")
    @_utilities.deprecated("""The `public_builds` attribute has been deprecated in favor of `public_jobs` and will be removed in the next major version of the provider.""")
    def public_builds(self) -> pulumi.Output[builtins.bool]:
        """
        If true, jobs can be viewed by non-project members.
        """
        return pulumi.get(self, "public_builds")

    @property
    @pulumi.getter(name="publicJobs")
    def public_jobs(self) -> pulumi.Output[builtins.bool]:
        """
        If true, jobs can be viewed by non-project members.
        """
        return pulumi.get(self, "public_jobs")

    @property
    @pulumi.getter(name="pushRules")
    def push_rules(self) -> pulumi.Output['outputs.ProjectPushRules']:
        """
        Push rules for the project.
        """
        return pulumi.get(self, "push_rules")

    @property
    @pulumi.getter(name="releasesAccessLevel")
    def releases_access_level(self) -> pulumi.Output[builtins.str]:
        """
        Set the releases access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "releases_access_level")

    @property
    @pulumi.getter(name="removeSourceBranchAfterMerge")
    def remove_source_branch_after_merge(self) -> pulumi.Output[builtins.bool]:
        """
        Enable `Delete source branch` option by default for all new merge requests.
        """
        return pulumi.get(self, "remove_source_branch_after_merge")

    @property
    @pulumi.getter(name="repositoryAccessLevel")
    def repository_access_level(self) -> pulumi.Output[builtins.str]:
        """
        Set the repository access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "repository_access_level")

    @property
    @pulumi.getter(name="repositoryStorage")
    def repository_storage(self) -> pulumi.Output[builtins.str]:
        """
        Which storage shard the repository is on. (administrator only)
        """
        return pulumi.get(self, "repository_storage")

    @property
    @pulumi.getter(name="requestAccessEnabled")
    def request_access_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Allow users to request member access.
        """
        return pulumi.get(self, "request_access_enabled")

    @property
    @pulumi.getter(name="requirementsAccessLevel")
    def requirements_access_level(self) -> pulumi.Output[builtins.str]:
        """
        Set the requirements access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "requirements_access_level")

    @property
    @pulumi.getter(name="resolveOutdatedDiffDiscussions")
    def resolve_outdated_diff_discussions(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Automatically resolve merge request diffs discussions on lines changed with a push.
        """
        return pulumi.get(self, "resolve_outdated_diff_discussions")

    @property
    @pulumi.getter(name="restrictUserDefinedVariables")
    def restrict_user_defined_variables(self) -> pulumi.Output[builtins.bool]:
        """
        Allow only users with the Maintainer role to pass user-defined variables when triggering a pipeline.
        """
        return pulumi.get(self, "restrict_user_defined_variables")

    @property
    @pulumi.getter(name="runnersToken")
    def runners_token(self) -> pulumi.Output[builtins.str]:
        """
        Registration token to use during runner setup.
        """
        return pulumi.get(self, "runners_token")

    @property
    @pulumi.getter(name="securityAndComplianceAccessLevel")
    def security_and_compliance_access_level(self) -> pulumi.Output[builtins.str]:
        """
        Set the security and compliance access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "security_and_compliance_access_level")

    @property
    @pulumi.getter(name="sharedRunnersEnabled")
    def shared_runners_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Enable shared runners for this project.
        """
        return pulumi.get(self, "shared_runners_enabled")

    @property
    @pulumi.getter(name="skipWaitForDefaultBranchProtection")
    def skip_wait_for_default_branch_protection(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If `true`, the default behavior to wait for the default branch protection to be created is skipped.
        This is necessary if the current user is not an admin and the default branch protection is disabled on an instance-level.
        There is currently no known way to determine if the default branch protection is disabled on an instance-level for non-admin users.
        This attribute is only used during resource creation, thus changes are suppressed and the attribute cannot be imported.
        """
        return pulumi.get(self, "skip_wait_for_default_branch_protection")

    @property
    @pulumi.getter(name="snippetsAccessLevel")
    def snippets_access_level(self) -> pulumi.Output[builtins.str]:
        """
        Set the snippets access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "snippets_access_level")

    @property
    @pulumi.getter(name="snippetsEnabled")
    def snippets_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Enable snippets for the project.
        """
        return pulumi.get(self, "snippets_enabled")

    @property
    @pulumi.getter(name="squashCommitTemplate")
    def squash_commit_template(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Template used to create squash commit message in merge requests.
        """
        return pulumi.get(self, "squash_commit_template")

    @property
    @pulumi.getter(name="squashOption")
    def squash_option(self) -> pulumi.Output[builtins.str]:
        """
        Squash commits when merge request is merged. Valid values are `never` (Do not allow), `always` (Require), `default_on` (Encourage), or `default_off` (Allow). The default value is `default_off` (Allow).
        """
        return pulumi.get(self, "squash_option")

    @property
    @pulumi.getter(name="sshUrlToRepo")
    def ssh_url_to_repo(self) -> pulumi.Output[builtins.str]:
        """
        URL that can be provided to `git clone` to clone the
        """
        return pulumi.get(self, "ssh_url_to_repo")

    @property
    @pulumi.getter(name="suggestionCommitMessage")
    def suggestion_commit_message(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The commit message used to apply merge request suggestions.
        """
        return pulumi.get(self, "suggestion_commit_message")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The list of tags for a project; put array of tags, that should be finally assigned to a project. Use topics instead.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        When used without use*custom*template, name of a built-in project template. When used with use*custom*template, name of a custom project template. This option is mutually exclusive with `template_project_id`.
        """
        return pulumi.get(self, "template_name")

    @property
    @pulumi.getter(name="templateProjectId")
    def template_project_id(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        When used with use*custom*template, project ID of a custom project template. This is preferable to using template*name since template*name may be ambiguous (enterprise edition). This option is mutually exclusive with `template_name`. See `GroupProjectFileTemplate` to set a project as a template project. If a project has not been set as a template, using it here will result in an error.
        """
        return pulumi.get(self, "template_project_id")

    @property
    @pulumi.getter
    def topics(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The list of topics for the project.
        """
        return pulumi.get(self, "topics")

    @property
    @pulumi.getter(name="useCustomTemplate")
    def use_custom_template(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Use either custom instance or group (with group*with*project*templates*id) project template (enterprise edition).
        	> When using a custom template, [Group Tokens won't work](https://docs.gitlab.com/15.7/ee/user/project/settings/import_export_troubleshooting/#import-using-the-rest-api-fails-when-using-a-group-access-token). You must use a real user's Personal Access Token.
        """
        return pulumi.get(self, "use_custom_template")

    @property
    @pulumi.getter(name="visibilityLevel")
    def visibility_level(self) -> pulumi.Output[builtins.str]:
        """
        Set to `public` to create a public project. Valid values are `private`, `internal`, `public`.
        """
        return pulumi.get(self, "visibility_level")

    @property
    @pulumi.getter(name="webUrl")
    def web_url(self) -> pulumi.Output[builtins.str]:
        """
        URL that can be used to find the project in a browser.
        """
        return pulumi.get(self, "web_url")

    @property
    @pulumi.getter(name="wikiAccessLevel")
    def wiki_access_level(self) -> pulumi.Output[builtins.str]:
        """
        Set the wiki access level. Valid values are `disabled`, `private`, `enabled`.
        """
        return pulumi.get(self, "wiki_access_level")

    @property
    @pulumi.getter(name="wikiEnabled")
    def wiki_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Enable wiki for the project.
        """
        return pulumi.get(self, "wiki_enabled")

