# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProjectContainerRepositoryProtectionArgs', 'ProjectContainerRepositoryProtection']

@pulumi.input_type
class ProjectContainerRepositoryProtectionArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[builtins.str],
                 repository_path_pattern: pulumi.Input[builtins.str],
                 minimum_access_level_for_delete: Optional[pulumi.Input[builtins.str]] = None,
                 minimum_access_level_for_push: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ProjectContainerRepositoryProtection resource.
        :param pulumi.Input[builtins.str] project: ID or URL-encoded path of the project.
        :param pulumi.Input[builtins.str] repository_path_pattern: Container repository path pattern protected by the protection rule. Wildcard character * allowed. Repository path pattern should start with the project's full path
        :param pulumi.Input[builtins.str] minimum_access_level_for_delete: Minimum GitLab access level required to delete container images in the container registry. For example maintainer, owner, admin. Must be provided when `minimum_access_level_for_push` is not set.
        :param pulumi.Input[builtins.str] minimum_access_level_for_push: Minimum GitLab access level required to push container images to the container registry. For example maintainer, owner or admin. Must be provided when `minimum_access_level_for_delete` is not set.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "repository_path_pattern", repository_path_pattern)
        if minimum_access_level_for_delete is not None:
            pulumi.set(__self__, "minimum_access_level_for_delete", minimum_access_level_for_delete)
        if minimum_access_level_for_push is not None:
            pulumi.set(__self__, "minimum_access_level_for_push", minimum_access_level_for_push)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[builtins.str]:
        """
        ID or URL-encoded path of the project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="repositoryPathPattern")
    def repository_path_pattern(self) -> pulumi.Input[builtins.str]:
        """
        Container repository path pattern protected by the protection rule. Wildcard character * allowed. Repository path pattern should start with the project's full path
        """
        return pulumi.get(self, "repository_path_pattern")

    @repository_path_pattern.setter
    def repository_path_pattern(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "repository_path_pattern", value)

    @property
    @pulumi.getter(name="minimumAccessLevelForDelete")
    def minimum_access_level_for_delete(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Minimum GitLab access level required to delete container images in the container registry. For example maintainer, owner, admin. Must be provided when `minimum_access_level_for_push` is not set.
        """
        return pulumi.get(self, "minimum_access_level_for_delete")

    @minimum_access_level_for_delete.setter
    def minimum_access_level_for_delete(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "minimum_access_level_for_delete", value)

    @property
    @pulumi.getter(name="minimumAccessLevelForPush")
    def minimum_access_level_for_push(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Minimum GitLab access level required to push container images to the container registry. For example maintainer, owner or admin. Must be provided when `minimum_access_level_for_delete` is not set.
        """
        return pulumi.get(self, "minimum_access_level_for_push")

    @minimum_access_level_for_push.setter
    def minimum_access_level_for_push(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "minimum_access_level_for_push", value)


@pulumi.input_type
class _ProjectContainerRepositoryProtectionState:
    def __init__(__self__, *,
                 minimum_access_level_for_delete: Optional[pulumi.Input[builtins.str]] = None,
                 minimum_access_level_for_push: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 protection_rule_id: Optional[pulumi.Input[builtins.int]] = None,
                 repository_path_pattern: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProjectContainerRepositoryProtection resources.
        :param pulumi.Input[builtins.str] minimum_access_level_for_delete: Minimum GitLab access level required to delete container images in the container registry. For example maintainer, owner, admin. Must be provided when `minimum_access_level_for_push` is not set.
        :param pulumi.Input[builtins.str] minimum_access_level_for_push: Minimum GitLab access level required to push container images to the container registry. For example maintainer, owner or admin. Must be provided when `minimum_access_level_for_delete` is not set.
        :param pulumi.Input[builtins.str] project: ID or URL-encoded path of the project.
        :param pulumi.Input[builtins.int] protection_rule_id: Unique ID of the protection rule.
        :param pulumi.Input[builtins.str] repository_path_pattern: Container repository path pattern protected by the protection rule. Wildcard character * allowed. Repository path pattern should start with the project's full path
        """
        if minimum_access_level_for_delete is not None:
            pulumi.set(__self__, "minimum_access_level_for_delete", minimum_access_level_for_delete)
        if minimum_access_level_for_push is not None:
            pulumi.set(__self__, "minimum_access_level_for_push", minimum_access_level_for_push)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if protection_rule_id is not None:
            pulumi.set(__self__, "protection_rule_id", protection_rule_id)
        if repository_path_pattern is not None:
            pulumi.set(__self__, "repository_path_pattern", repository_path_pattern)

    @property
    @pulumi.getter(name="minimumAccessLevelForDelete")
    def minimum_access_level_for_delete(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Minimum GitLab access level required to delete container images in the container registry. For example maintainer, owner, admin. Must be provided when `minimum_access_level_for_push` is not set.
        """
        return pulumi.get(self, "minimum_access_level_for_delete")

    @minimum_access_level_for_delete.setter
    def minimum_access_level_for_delete(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "minimum_access_level_for_delete", value)

    @property
    @pulumi.getter(name="minimumAccessLevelForPush")
    def minimum_access_level_for_push(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Minimum GitLab access level required to push container images to the container registry. For example maintainer, owner or admin. Must be provided when `minimum_access_level_for_delete` is not set.
        """
        return pulumi.get(self, "minimum_access_level_for_push")

    @minimum_access_level_for_push.setter
    def minimum_access_level_for_push(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "minimum_access_level_for_push", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID or URL-encoded path of the project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="protectionRuleId")
    def protection_rule_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Unique ID of the protection rule.
        """
        return pulumi.get(self, "protection_rule_id")

    @protection_rule_id.setter
    def protection_rule_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "protection_rule_id", value)

    @property
    @pulumi.getter(name="repositoryPathPattern")
    def repository_path_pattern(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Container repository path pattern protected by the protection rule. Wildcard character * allowed. Repository path pattern should start with the project's full path
        """
        return pulumi.get(self, "repository_path_pattern")

    @repository_path_pattern.setter
    def repository_path_pattern(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repository_path_pattern", value)


@pulumi.type_token("gitlab:index/projectContainerRepositoryProtection:ProjectContainerRepositoryProtection")
class ProjectContainerRepositoryProtection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 minimum_access_level_for_delete: Optional[pulumi.Input[builtins.str]] = None,
                 minimum_access_level_for_push: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 repository_path_pattern: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The `ProjectContainerRepositoryProtection` resource allows managing the lifecycle of a container repository protection rule.

        You can use a wildcard (*) to protect multiple container repositories with the same container protection rule.
        You can apply several protection rules to the same container repository. A container repository is protected if at least one protection rule matches.

        **Upstream API**: [GitLab API docs](https://docs.gitlab.com/api/container_repository_protection_rules/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        this = gitlab.ProjectContainerRepositoryProtection("this",
            project="123",
            repository_path_pattern="my_namespace/project*",
            minimum_access_level_for_push="owner",
            minimum_access_level_for_delete="admin")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_project_container_repository_protection`. For example:

        terraform

        import {

          to = gitlab_project_container_repository_protection.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        GitLab project container repository protection rules can be imported using an id made up of `<project_id>:<protection_rule_id>`, e.g.

        ```sh
        $ pulumi import gitlab:index/projectContainerRepositoryProtection:ProjectContainerRepositoryProtection this 123:321
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] minimum_access_level_for_delete: Minimum GitLab access level required to delete container images in the container registry. For example maintainer, owner, admin. Must be provided when `minimum_access_level_for_push` is not set.
        :param pulumi.Input[builtins.str] minimum_access_level_for_push: Minimum GitLab access level required to push container images to the container registry. For example maintainer, owner or admin. Must be provided when `minimum_access_level_for_delete` is not set.
        :param pulumi.Input[builtins.str] project: ID or URL-encoded path of the project.
        :param pulumi.Input[builtins.str] repository_path_pattern: Container repository path pattern protected by the protection rule. Wildcard character * allowed. Repository path pattern should start with the project's full path
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectContainerRepositoryProtectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `ProjectContainerRepositoryProtection` resource allows managing the lifecycle of a container repository protection rule.

        You can use a wildcard (*) to protect multiple container repositories with the same container protection rule.
        You can apply several protection rules to the same container repository. A container repository is protected if at least one protection rule matches.

        **Upstream API**: [GitLab API docs](https://docs.gitlab.com/api/container_repository_protection_rules/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        this = gitlab.ProjectContainerRepositoryProtection("this",
            project="123",
            repository_path_pattern="my_namespace/project*",
            minimum_access_level_for_push="owner",
            minimum_access_level_for_delete="admin")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_project_container_repository_protection`. For example:

        terraform

        import {

          to = gitlab_project_container_repository_protection.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        GitLab project container repository protection rules can be imported using an id made up of `<project_id>:<protection_rule_id>`, e.g.

        ```sh
        $ pulumi import gitlab:index/projectContainerRepositoryProtection:ProjectContainerRepositoryProtection this 123:321
        ```

        :param str resource_name: The name of the resource.
        :param ProjectContainerRepositoryProtectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectContainerRepositoryProtectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 minimum_access_level_for_delete: Optional[pulumi.Input[builtins.str]] = None,
                 minimum_access_level_for_push: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 repository_path_pattern: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectContainerRepositoryProtectionArgs.__new__(ProjectContainerRepositoryProtectionArgs)

            __props__.__dict__["minimum_access_level_for_delete"] = minimum_access_level_for_delete
            __props__.__dict__["minimum_access_level_for_push"] = minimum_access_level_for_push
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if repository_path_pattern is None and not opts.urn:
                raise TypeError("Missing required property 'repository_path_pattern'")
            __props__.__dict__["repository_path_pattern"] = repository_path_pattern
            __props__.__dict__["protection_rule_id"] = None
        super(ProjectContainerRepositoryProtection, __self__).__init__(
            'gitlab:index/projectContainerRepositoryProtection:ProjectContainerRepositoryProtection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            minimum_access_level_for_delete: Optional[pulumi.Input[builtins.str]] = None,
            minimum_access_level_for_push: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            protection_rule_id: Optional[pulumi.Input[builtins.int]] = None,
            repository_path_pattern: Optional[pulumi.Input[builtins.str]] = None) -> 'ProjectContainerRepositoryProtection':
        """
        Get an existing ProjectContainerRepositoryProtection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] minimum_access_level_for_delete: Minimum GitLab access level required to delete container images in the container registry. For example maintainer, owner, admin. Must be provided when `minimum_access_level_for_push` is not set.
        :param pulumi.Input[builtins.str] minimum_access_level_for_push: Minimum GitLab access level required to push container images to the container registry. For example maintainer, owner or admin. Must be provided when `minimum_access_level_for_delete` is not set.
        :param pulumi.Input[builtins.str] project: ID or URL-encoded path of the project.
        :param pulumi.Input[builtins.int] protection_rule_id: Unique ID of the protection rule.
        :param pulumi.Input[builtins.str] repository_path_pattern: Container repository path pattern protected by the protection rule. Wildcard character * allowed. Repository path pattern should start with the project's full path
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectContainerRepositoryProtectionState.__new__(_ProjectContainerRepositoryProtectionState)

        __props__.__dict__["minimum_access_level_for_delete"] = minimum_access_level_for_delete
        __props__.__dict__["minimum_access_level_for_push"] = minimum_access_level_for_push
        __props__.__dict__["project"] = project
        __props__.__dict__["protection_rule_id"] = protection_rule_id
        __props__.__dict__["repository_path_pattern"] = repository_path_pattern
        return ProjectContainerRepositoryProtection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="minimumAccessLevelForDelete")
    def minimum_access_level_for_delete(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Minimum GitLab access level required to delete container images in the container registry. For example maintainer, owner, admin. Must be provided when `minimum_access_level_for_push` is not set.
        """
        return pulumi.get(self, "minimum_access_level_for_delete")

    @property
    @pulumi.getter(name="minimumAccessLevelForPush")
    def minimum_access_level_for_push(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Minimum GitLab access level required to push container images to the container registry. For example maintainer, owner or admin. Must be provided when `minimum_access_level_for_delete` is not set.
        """
        return pulumi.get(self, "minimum_access_level_for_push")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        ID or URL-encoded path of the project.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="protectionRuleId")
    def protection_rule_id(self) -> pulumi.Output[builtins.int]:
        """
        Unique ID of the protection rule.
        """
        return pulumi.get(self, "protection_rule_id")

    @property
    @pulumi.getter(name="repositoryPathPattern")
    def repository_path_pattern(self) -> pulumi.Output[builtins.str]:
        """
        Container repository path pattern protected by the protection rule. Wildcard character * allowed. Repository path pattern should start with the project's full path
        """
        return pulumi.get(self, "repository_path_pattern")

