# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProjectIntegrationHarborArgs', 'ProjectIntegrationHarbor']

@pulumi.input_type
class ProjectIntegrationHarborArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[builtins.str],
                 project: pulumi.Input[builtins.str],
                 project_name: pulumi.Input[builtins.str],
                 url: pulumi.Input[builtins.str],
                 username: pulumi.Input[builtins.str],
                 use_inherited_settings: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a ProjectIntegrationHarbor resource.
        :param pulumi.Input[builtins.str] password: Password for authentication with the Harbor server, if authentication is required by the server.
        :param pulumi.Input[builtins.str] project: ID of the GitLab project you want to activate integration on.
        :param pulumi.Input[builtins.str] project_name: The URL-friendly Harbor project name. This project needs to already exist in Harbor. Example: `my_project_name`.
        :param pulumi.Input[builtins.str] url: Harbor URL. Example: `http://harbor.example.com`
        :param pulumi.Input[builtins.str] username: Username for authentication with the Harbor server, if authentication is required by the server.
        :param pulumi.Input[builtins.bool] use_inherited_settings: Indicates whether or not to inherit default settings. Defaults to false.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "project_name", project_name)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "username", username)
        if use_inherited_settings is not None:
            pulumi.set(__self__, "use_inherited_settings", use_inherited_settings)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        """
        Password for authentication with the Harbor server, if authentication is required by the server.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[builtins.str]:
        """
        ID of the GitLab project you want to activate integration on.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Input[builtins.str]:
        """
        The URL-friendly Harbor project name. This project needs to already exist in Harbor. Example: `my_project_name`.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[builtins.str]:
        """
        Harbor URL. Example: `http://harbor.example.com`
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[builtins.str]:
        """
        Username for authentication with the Harbor server, if authentication is required by the server.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="useInheritedSettings")
    def use_inherited_settings(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether or not to inherit default settings. Defaults to false.
        """
        return pulumi.get(self, "use_inherited_settings")

    @use_inherited_settings.setter
    def use_inherited_settings(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_inherited_settings", value)


@pulumi.input_type
class _ProjectIntegrationHarborState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 project_name: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 use_inherited_settings: Optional[pulumi.Input[builtins.bool]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProjectIntegrationHarbor resources.
        :param pulumi.Input[builtins.bool] active: Whether the integration is active.
        :param pulumi.Input[builtins.str] password: Password for authentication with the Harbor server, if authentication is required by the server.
        :param pulumi.Input[builtins.str] project: ID of the GitLab project you want to activate integration on.
        :param pulumi.Input[builtins.str] project_name: The URL-friendly Harbor project name. This project needs to already exist in Harbor. Example: `my_project_name`.
        :param pulumi.Input[builtins.str] url: Harbor URL. Example: `http://harbor.example.com`
        :param pulumi.Input[builtins.bool] use_inherited_settings: Indicates whether or not to inherit default settings. Defaults to false.
        :param pulumi.Input[builtins.str] username: Username for authentication with the Harbor server, if authentication is required by the server.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if use_inherited_settings is not None:
            pulumi.set(__self__, "use_inherited_settings", use_inherited_settings)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the integration is active.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Password for authentication with the Harbor server, if authentication is required by the server.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the GitLab project you want to activate integration on.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL-friendly Harbor project name. This project needs to already exist in Harbor. Example: `my_project_name`.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Harbor URL. Example: `http://harbor.example.com`
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="useInheritedSettings")
    def use_inherited_settings(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether or not to inherit default settings. Defaults to false.
        """
        return pulumi.get(self, "use_inherited_settings")

    @use_inherited_settings.setter
    def use_inherited_settings(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_inherited_settings", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Username for authentication with the Harbor server, if authentication is required by the server.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("gitlab:index/projectIntegrationHarbor:ProjectIntegrationHarbor")
class ProjectIntegrationHarbor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 project_name: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 use_inherited_settings: Optional[pulumi.Input[builtins.bool]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The `ProjectIntegrationHarbor` resource manages the lifecycle of a project integration with Harbor.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/project_integrations/#harbor)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        awesome_project = gitlab.Project("awesome_project",
            name="awesome_project",
            description="My awesome project.",
            visibility_level="public")
        harbor = gitlab.ProjectIntegrationHarbor("harbor",
            project=awesome_project.id,
            url="http://harbor.example.com",
            project_name="my_project_name")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_project_integration_harbor`. For example:

        terraform

        import {

          to = gitlab_project_integration_harbor.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        ```sh
        $ pulumi import gitlab:index/projectIntegrationHarbor:ProjectIntegrationHarbor You can import a gitlab_project_integration_harbor state using `<resource> <project_id>`:
        ```

        ```sh
        $ pulumi import gitlab:index/projectIntegrationHarbor:ProjectIntegrationHarbor harbor 1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] password: Password for authentication with the Harbor server, if authentication is required by the server.
        :param pulumi.Input[builtins.str] project: ID of the GitLab project you want to activate integration on.
        :param pulumi.Input[builtins.str] project_name: The URL-friendly Harbor project name. This project needs to already exist in Harbor. Example: `my_project_name`.
        :param pulumi.Input[builtins.str] url: Harbor URL. Example: `http://harbor.example.com`
        :param pulumi.Input[builtins.bool] use_inherited_settings: Indicates whether or not to inherit default settings. Defaults to false.
        :param pulumi.Input[builtins.str] username: Username for authentication with the Harbor server, if authentication is required by the server.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectIntegrationHarborArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `ProjectIntegrationHarbor` resource manages the lifecycle of a project integration with Harbor.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/project_integrations/#harbor)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        awesome_project = gitlab.Project("awesome_project",
            name="awesome_project",
            description="My awesome project.",
            visibility_level="public")
        harbor = gitlab.ProjectIntegrationHarbor("harbor",
            project=awesome_project.id,
            url="http://harbor.example.com",
            project_name="my_project_name")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_project_integration_harbor`. For example:

        terraform

        import {

          to = gitlab_project_integration_harbor.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        ```sh
        $ pulumi import gitlab:index/projectIntegrationHarbor:ProjectIntegrationHarbor You can import a gitlab_project_integration_harbor state using `<resource> <project_id>`:
        ```

        ```sh
        $ pulumi import gitlab:index/projectIntegrationHarbor:ProjectIntegrationHarbor harbor 1
        ```

        :param str resource_name: The name of the resource.
        :param ProjectIntegrationHarborArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectIntegrationHarborArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 project_name: Optional[pulumi.Input[builtins.str]] = None,
                 url: Optional[pulumi.Input[builtins.str]] = None,
                 use_inherited_settings: Optional[pulumi.Input[builtins.bool]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectIntegrationHarborArgs.__new__(ProjectIntegrationHarborArgs)

            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if project_name is None and not opts.urn:
                raise TypeError("Missing required property 'project_name'")
            __props__.__dict__["project_name"] = project_name
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__.__dict__["url"] = url
            __props__.__dict__["use_inherited_settings"] = use_inherited_settings
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            __props__.__dict__["active"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ProjectIntegrationHarbor, __self__).__init__(
            'gitlab:index/projectIntegrationHarbor:ProjectIntegrationHarbor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[builtins.bool]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            project_name: Optional[pulumi.Input[builtins.str]] = None,
            url: Optional[pulumi.Input[builtins.str]] = None,
            use_inherited_settings: Optional[pulumi.Input[builtins.bool]] = None,
            username: Optional[pulumi.Input[builtins.str]] = None) -> 'ProjectIntegrationHarbor':
        """
        Get an existing ProjectIntegrationHarbor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] active: Whether the integration is active.
        :param pulumi.Input[builtins.str] password: Password for authentication with the Harbor server, if authentication is required by the server.
        :param pulumi.Input[builtins.str] project: ID of the GitLab project you want to activate integration on.
        :param pulumi.Input[builtins.str] project_name: The URL-friendly Harbor project name. This project needs to already exist in Harbor. Example: `my_project_name`.
        :param pulumi.Input[builtins.str] url: Harbor URL. Example: `http://harbor.example.com`
        :param pulumi.Input[builtins.bool] use_inherited_settings: Indicates whether or not to inherit default settings. Defaults to false.
        :param pulumi.Input[builtins.str] username: Username for authentication with the Harbor server, if authentication is required by the server.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectIntegrationHarborState.__new__(_ProjectIntegrationHarborState)

        __props__.__dict__["active"] = active
        __props__.__dict__["password"] = password
        __props__.__dict__["project"] = project
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["url"] = url
        __props__.__dict__["use_inherited_settings"] = use_inherited_settings
        __props__.__dict__["username"] = username
        return ProjectIntegrationHarbor(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the integration is active.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[builtins.str]:
        """
        Password for authentication with the Harbor server, if authentication is required by the server.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        ID of the GitLab project you want to activate integration on.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[builtins.str]:
        """
        The URL-friendly Harbor project name. This project needs to already exist in Harbor. Example: `my_project_name`.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[builtins.str]:
        """
        Harbor URL. Example: `http://harbor.example.com`
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="useInheritedSettings")
    def use_inherited_settings(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether or not to inherit default settings. Defaults to false.
        """
        return pulumi.get(self, "use_inherited_settings")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[builtins.str]:
        """
        Username for authentication with the Harbor server, if authentication is required by the server.
        """
        return pulumi.get(self, "username")

