# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ProjectIntegrationRedmineArgs', 'ProjectIntegrationRedmine']

@pulumi.input_type
class ProjectIntegrationRedmineArgs:
    def __init__(__self__, *,
                 issues_url: pulumi.Input[builtins.str],
                 new_issue_url: pulumi.Input[builtins.str],
                 project: pulumi.Input[builtins.str],
                 project_url: pulumi.Input[builtins.str],
                 use_inherited_settings: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a ProjectIntegrationRedmine resource.
        :param pulumi.Input[builtins.str] issues_url: The URL to the Redmine project issue to link to this GitLab project.
        :param pulumi.Input[builtins.str] new_issue_url: The URL to use to create a new issue in the Redmine project linked to this GitLab project.
        :param pulumi.Input[builtins.str] project: ID of the project you want to activate integration on.
        :param pulumi.Input[builtins.str] project_url: The URL to the Redmine project to link to this GitLab project.
        :param pulumi.Input[builtins.bool] use_inherited_settings: Indicates whether or not to inherit default settings. Defaults to false.
        """
        pulumi.set(__self__, "issues_url", issues_url)
        pulumi.set(__self__, "new_issue_url", new_issue_url)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "project_url", project_url)
        if use_inherited_settings is not None:
            pulumi.set(__self__, "use_inherited_settings", use_inherited_settings)

    @property
    @pulumi.getter(name="issuesUrl")
    def issues_url(self) -> pulumi.Input[builtins.str]:
        """
        The URL to the Redmine project issue to link to this GitLab project.
        """
        return pulumi.get(self, "issues_url")

    @issues_url.setter
    def issues_url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "issues_url", value)

    @property
    @pulumi.getter(name="newIssueUrl")
    def new_issue_url(self) -> pulumi.Input[builtins.str]:
        """
        The URL to use to create a new issue in the Redmine project linked to this GitLab project.
        """
        return pulumi.get(self, "new_issue_url")

    @new_issue_url.setter
    def new_issue_url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "new_issue_url", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[builtins.str]:
        """
        ID of the project you want to activate integration on.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="projectUrl")
    def project_url(self) -> pulumi.Input[builtins.str]:
        """
        The URL to the Redmine project to link to this GitLab project.
        """
        return pulumi.get(self, "project_url")

    @project_url.setter
    def project_url(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project_url", value)

    @property
    @pulumi.getter(name="useInheritedSettings")
    def use_inherited_settings(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether or not to inherit default settings. Defaults to false.
        """
        return pulumi.get(self, "use_inherited_settings")

    @use_inherited_settings.setter
    def use_inherited_settings(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_inherited_settings", value)


@pulumi.input_type
class _ProjectIntegrationRedmineState:
    def __init__(__self__, *,
                 issues_url: Optional[pulumi.Input[builtins.str]] = None,
                 new_issue_url: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 project_url: Optional[pulumi.Input[builtins.str]] = None,
                 use_inherited_settings: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering ProjectIntegrationRedmine resources.
        :param pulumi.Input[builtins.str] issues_url: The URL to the Redmine project issue to link to this GitLab project.
        :param pulumi.Input[builtins.str] new_issue_url: The URL to use to create a new issue in the Redmine project linked to this GitLab project.
        :param pulumi.Input[builtins.str] project: ID of the project you want to activate integration on.
        :param pulumi.Input[builtins.str] project_url: The URL to the Redmine project to link to this GitLab project.
        :param pulumi.Input[builtins.bool] use_inherited_settings: Indicates whether or not to inherit default settings. Defaults to false.
        """
        if issues_url is not None:
            pulumi.set(__self__, "issues_url", issues_url)
        if new_issue_url is not None:
            pulumi.set(__self__, "new_issue_url", new_issue_url)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if project_url is not None:
            pulumi.set(__self__, "project_url", project_url)
        if use_inherited_settings is not None:
            pulumi.set(__self__, "use_inherited_settings", use_inherited_settings)

    @property
    @pulumi.getter(name="issuesUrl")
    def issues_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL to the Redmine project issue to link to this GitLab project.
        """
        return pulumi.get(self, "issues_url")

    @issues_url.setter
    def issues_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "issues_url", value)

    @property
    @pulumi.getter(name="newIssueUrl")
    def new_issue_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL to use to create a new issue in the Redmine project linked to this GitLab project.
        """
        return pulumi.get(self, "new_issue_url")

    @new_issue_url.setter
    def new_issue_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "new_issue_url", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the project you want to activate integration on.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="projectUrl")
    def project_url(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL to the Redmine project to link to this GitLab project.
        """
        return pulumi.get(self, "project_url")

    @project_url.setter
    def project_url(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_url", value)

    @property
    @pulumi.getter(name="useInheritedSettings")
    def use_inherited_settings(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether or not to inherit default settings. Defaults to false.
        """
        return pulumi.get(self, "use_inherited_settings")

    @use_inherited_settings.setter
    def use_inherited_settings(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "use_inherited_settings", value)


@pulumi.type_token("gitlab:index/projectIntegrationRedmine:ProjectIntegrationRedmine")
class ProjectIntegrationRedmine(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 issues_url: Optional[pulumi.Input[builtins.str]] = None,
                 new_issue_url: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 project_url: Optional[pulumi.Input[builtins.str]] = None,
                 use_inherited_settings: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        The `ProjectIntegrationRedmine` resource manages the lifecycle of a project integration with Redmine.

        > Using Redmine requires that GitLab internal issue tracking is disabled for the project.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/project_integrations/#redmine)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        awesome_project = gitlab.Project("awesome_project",
            name="awesome_project",
            description="My awesome project.",
            visibility_level="public")
        redmine = gitlab.ProjectIntegrationRedmine("redmine",
            project=awesome_project.id,
            new_issue_url="https://redmine.example.com/issue",
            project_url="https://redmine.example.com/project",
            issues_url="https://redmine.example.com/issue/:id")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_project_integration_redmine`. For example:

        terraform

        import {

          to = gitlab_project_integration_redmine.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        ```sh
        $ pulumi import gitlab:index/projectIntegrationRedmine:ProjectIntegrationRedmine You can import a gitlab_project_integration_redmine state using `<resource> <project_id>`:
        ```

        ```sh
        $ pulumi import gitlab:index/projectIntegrationRedmine:ProjectIntegrationRedmine redmine 1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] issues_url: The URL to the Redmine project issue to link to this GitLab project.
        :param pulumi.Input[builtins.str] new_issue_url: The URL to use to create a new issue in the Redmine project linked to this GitLab project.
        :param pulumi.Input[builtins.str] project: ID of the project you want to activate integration on.
        :param pulumi.Input[builtins.str] project_url: The URL to the Redmine project to link to this GitLab project.
        :param pulumi.Input[builtins.bool] use_inherited_settings: Indicates whether or not to inherit default settings. Defaults to false.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectIntegrationRedmineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `ProjectIntegrationRedmine` resource manages the lifecycle of a project integration with Redmine.

        > Using Redmine requires that GitLab internal issue tracking is disabled for the project.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/project_integrations/#redmine)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        awesome_project = gitlab.Project("awesome_project",
            name="awesome_project",
            description="My awesome project.",
            visibility_level="public")
        redmine = gitlab.ProjectIntegrationRedmine("redmine",
            project=awesome_project.id,
            new_issue_url="https://redmine.example.com/issue",
            project_url="https://redmine.example.com/project",
            issues_url="https://redmine.example.com/issue/:id")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_project_integration_redmine`. For example:

        terraform

        import {

          to = gitlab_project_integration_redmine.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        ```sh
        $ pulumi import gitlab:index/projectIntegrationRedmine:ProjectIntegrationRedmine You can import a gitlab_project_integration_redmine state using `<resource> <project_id>`:
        ```

        ```sh
        $ pulumi import gitlab:index/projectIntegrationRedmine:ProjectIntegrationRedmine redmine 1
        ```

        :param str resource_name: The name of the resource.
        :param ProjectIntegrationRedmineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectIntegrationRedmineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 issues_url: Optional[pulumi.Input[builtins.str]] = None,
                 new_issue_url: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 project_url: Optional[pulumi.Input[builtins.str]] = None,
                 use_inherited_settings: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectIntegrationRedmineArgs.__new__(ProjectIntegrationRedmineArgs)

            if issues_url is None and not opts.urn:
                raise TypeError("Missing required property 'issues_url'")
            __props__.__dict__["issues_url"] = issues_url
            if new_issue_url is None and not opts.urn:
                raise TypeError("Missing required property 'new_issue_url'")
            __props__.__dict__["new_issue_url"] = new_issue_url
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if project_url is None and not opts.urn:
                raise TypeError("Missing required property 'project_url'")
            __props__.__dict__["project_url"] = project_url
            __props__.__dict__["use_inherited_settings"] = use_inherited_settings
        super(ProjectIntegrationRedmine, __self__).__init__(
            'gitlab:index/projectIntegrationRedmine:ProjectIntegrationRedmine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            issues_url: Optional[pulumi.Input[builtins.str]] = None,
            new_issue_url: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            project_url: Optional[pulumi.Input[builtins.str]] = None,
            use_inherited_settings: Optional[pulumi.Input[builtins.bool]] = None) -> 'ProjectIntegrationRedmine':
        """
        Get an existing ProjectIntegrationRedmine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] issues_url: The URL to the Redmine project issue to link to this GitLab project.
        :param pulumi.Input[builtins.str] new_issue_url: The URL to use to create a new issue in the Redmine project linked to this GitLab project.
        :param pulumi.Input[builtins.str] project: ID of the project you want to activate integration on.
        :param pulumi.Input[builtins.str] project_url: The URL to the Redmine project to link to this GitLab project.
        :param pulumi.Input[builtins.bool] use_inherited_settings: Indicates whether or not to inherit default settings. Defaults to false.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectIntegrationRedmineState.__new__(_ProjectIntegrationRedmineState)

        __props__.__dict__["issues_url"] = issues_url
        __props__.__dict__["new_issue_url"] = new_issue_url
        __props__.__dict__["project"] = project
        __props__.__dict__["project_url"] = project_url
        __props__.__dict__["use_inherited_settings"] = use_inherited_settings
        return ProjectIntegrationRedmine(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="issuesUrl")
    def issues_url(self) -> pulumi.Output[builtins.str]:
        """
        The URL to the Redmine project issue to link to this GitLab project.
        """
        return pulumi.get(self, "issues_url")

    @property
    @pulumi.getter(name="newIssueUrl")
    def new_issue_url(self) -> pulumi.Output[builtins.str]:
        """
        The URL to use to create a new issue in the Redmine project linked to this GitLab project.
        """
        return pulumi.get(self, "new_issue_url")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        ID of the project you want to activate integration on.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="projectUrl")
    def project_url(self) -> pulumi.Output[builtins.str]:
        """
        The URL to the Redmine project to link to this GitLab project.
        """
        return pulumi.get(self, "project_url")

    @property
    @pulumi.getter(name="useInheritedSettings")
    def use_inherited_settings(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether or not to inherit default settings. Defaults to false.
        """
        return pulumi.get(self, "use_inherited_settings")

