# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UserImpersonationTokenArgs', 'UserImpersonationToken']

@pulumi.input_type
class UserImpersonationTokenArgs:
    def __init__(__self__, *,
                 expires_at: pulumi.Input[builtins.str],
                 scopes: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 user_id: pulumi.Input[builtins.int],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a UserImpersonationToken resource.
        :param pulumi.Input[builtins.str] expires_at: Expiration date of the impersonation token in ISO format (YYYY-MM-DD).
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scopes: Array of scopes of the impersonation token. valid values are: `api`, `read_user`, `read_api`, `read_repository`, `write_repository`, `read_registry`, `write_registry`, `read_virtual_registry`, `write_virtual_registry`, `sudo`, `admin_mode`, `create_runner`, `manage_runner`, `ai_features`, `k8s_proxy`, `self_rotate`, `read_service_ping`
        :param pulumi.Input[builtins.int] user_id: The ID of the user.
        :param pulumi.Input[builtins.str] name: The name of the impersonation token.
        """
        pulumi.set(__self__, "expires_at", expires_at)
        pulumi.set(__self__, "scopes", scopes)
        pulumi.set(__self__, "user_id", user_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> pulumi.Input[builtins.str]:
        """
        Expiration date of the impersonation token in ISO format (YYYY-MM-DD).
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "expires_at", value)

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        Array of scopes of the impersonation token. valid values are: `api`, `read_user`, `read_api`, `read_repository`, `write_repository`, `read_registry`, `write_registry`, `read_virtual_registry`, `write_virtual_registry`, `sudo`, `admin_mode`, `create_runner`, `manage_runner`, `ai_features`, `k8s_proxy`, `self_rotate`, `read_service_ping`
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Input[builtins.int]:
        """
        The ID of the user.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "user_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the impersonation token.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _UserImpersonationTokenState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 created_at: Optional[pulumi.Input[builtins.str]] = None,
                 expires_at: Optional[pulumi.Input[builtins.str]] = None,
                 impersonation: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 revoked: Optional[pulumi.Input[builtins.bool]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 token: Optional[pulumi.Input[builtins.str]] = None,
                 token_id: Optional[pulumi.Input[builtins.int]] = None,
                 user_id: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering UserImpersonationToken resources.
        :param pulumi.Input[builtins.bool] active: True if the token is active.
        :param pulumi.Input[builtins.str] created_at: Time the token has been created, RFC3339 format.
        :param pulumi.Input[builtins.str] expires_at: Expiration date of the impersonation token in ISO format (YYYY-MM-DD).
        :param pulumi.Input[builtins.bool] impersonation: True as the token is always an impersonation token.
        :param pulumi.Input[builtins.str] name: The name of the impersonation token.
        :param pulumi.Input[builtins.bool] revoked: True if the token is revoked.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scopes: Array of scopes of the impersonation token. valid values are: `api`, `read_user`, `read_api`, `read_repository`, `write_repository`, `read_registry`, `write_registry`, `read_virtual_registry`, `write_virtual_registry`, `sudo`, `admin_mode`, `create_runner`, `manage_runner`, `ai_features`, `k8s_proxy`, `self_rotate`, `read_service_ping`
        :param pulumi.Input[builtins.str] token: The token of the user impersonation token. **Note**: the token is not available for imported resources.
        :param pulumi.Input[builtins.int] token_id: ID of the impersonation token.
        :param pulumi.Input[builtins.int] user_id: The ID of the user.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if impersonation is not None:
            pulumi.set(__self__, "impersonation", impersonation)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if revoked is not None:
            pulumi.set(__self__, "revoked", revoked)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if token_id is not None:
            pulumi.set(__self__, "token_id", token_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        True if the token is active.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time the token has been created, RFC3339 format.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Expiration date of the impersonation token in ISO format (YYYY-MM-DD).
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expires_at", value)

    @property
    @pulumi.getter
    def impersonation(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        True as the token is always an impersonation token.
        """
        return pulumi.get(self, "impersonation")

    @impersonation.setter
    def impersonation(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "impersonation", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the impersonation token.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def revoked(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        True if the token is revoked.
        """
        return pulumi.get(self, "revoked")

    @revoked.setter
    def revoked(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "revoked", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Array of scopes of the impersonation token. valid values are: `api`, `read_user`, `read_api`, `read_repository`, `write_repository`, `read_registry`, `write_registry`, `read_virtual_registry`, `write_virtual_registry`, `sudo`, `admin_mode`, `create_runner`, `manage_runner`, `ai_features`, `k8s_proxy`, `self_rotate`, `read_service_ping`
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The token of the user impersonation token. **Note**: the token is not available for imported resources.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "token", value)

    @property
    @pulumi.getter(name="tokenId")
    def token_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        ID of the impersonation token.
        """
        return pulumi.get(self, "token_id")

    @token_id.setter
    def token_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "token_id", value)

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The ID of the user.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "user_id", value)


@pulumi.type_token("gitlab:index/userImpersonationToken:UserImpersonationToken")
class UserImpersonationToken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expires_at: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user_id: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        The `UserImpersonationToken` resource allows to manage impersonation tokens of users.
        Requires administrator access. Token values are returned once. You are only able to create impersonation tokens to impersonate the user and perform both API calls and Git reads and writes. The user can’t see these tokens in their profile settings page.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/users/#create-an-impersonation-token)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        this = gitlab.UserImpersonationToken("this",
            user_id=12345,
            name="token_name",
            scopes=["api"],
            expires_at="2024-08-27")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_user_impersonation_token`. For example:

        terraform

        import {

          to = gitlab_user_impersonation_token.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        A GitLab User Impersonation Token can be imported using a key composed of `<user-id>:<token-id>`, e.g.

        ```sh
        $ pulumi import gitlab:index/userImpersonationToken:UserImpersonationToken example "12345:1"
        ```

        NOTE: the `token` resource attribute is not available for imported resources as this information cannot be read from the GitLab API.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] expires_at: Expiration date of the impersonation token in ISO format (YYYY-MM-DD).
        :param pulumi.Input[builtins.str] name: The name of the impersonation token.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scopes: Array of scopes of the impersonation token. valid values are: `api`, `read_user`, `read_api`, `read_repository`, `write_repository`, `read_registry`, `write_registry`, `read_virtual_registry`, `write_virtual_registry`, `sudo`, `admin_mode`, `create_runner`, `manage_runner`, `ai_features`, `k8s_proxy`, `self_rotate`, `read_service_ping`
        :param pulumi.Input[builtins.int] user_id: The ID of the user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserImpersonationTokenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `UserImpersonationToken` resource allows to manage impersonation tokens of users.
        Requires administrator access. Token values are returned once. You are only able to create impersonation tokens to impersonate the user and perform both API calls and Git reads and writes. The user can’t see these tokens in their profile settings page.

        **Upstream API**: [GitLab REST API docs](https://docs.gitlab.com/api/users/#create-an-impersonation-token)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gitlab as gitlab

        this = gitlab.UserImpersonationToken("this",
            user_id=12345,
            name="token_name",
            scopes=["api"],
            expires_at="2024-08-27")
        ```

        ## Import

        Starting in Terraform v1.5.0, you can use an import block to import `gitlab_user_impersonation_token`. For example:

        terraform

        import {

          to = gitlab_user_impersonation_token.example

          id = "see CLI command below for ID"

        }

        Importing using the CLI is supported with the following syntax:

        A GitLab User Impersonation Token can be imported using a key composed of `<user-id>:<token-id>`, e.g.

        ```sh
        $ pulumi import gitlab:index/userImpersonationToken:UserImpersonationToken example "12345:1"
        ```

        NOTE: the `token` resource attribute is not available for imported resources as this information cannot be read from the GitLab API.

        :param str resource_name: The name of the resource.
        :param UserImpersonationTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserImpersonationTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 expires_at: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 user_id: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserImpersonationTokenArgs.__new__(UserImpersonationTokenArgs)

            if expires_at is None and not opts.urn:
                raise TypeError("Missing required property 'expires_at'")
            __props__.__dict__["expires_at"] = expires_at
            __props__.__dict__["name"] = name
            if scopes is None and not opts.urn:
                raise TypeError("Missing required property 'scopes'")
            __props__.__dict__["scopes"] = scopes
            if user_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_id'")
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["active"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["impersonation"] = None
            __props__.__dict__["revoked"] = None
            __props__.__dict__["token"] = None
            __props__.__dict__["token_id"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(UserImpersonationToken, __self__).__init__(
            'gitlab:index/userImpersonationToken:UserImpersonationToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[builtins.bool]] = None,
            created_at: Optional[pulumi.Input[builtins.str]] = None,
            expires_at: Optional[pulumi.Input[builtins.str]] = None,
            impersonation: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            revoked: Optional[pulumi.Input[builtins.bool]] = None,
            scopes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            token: Optional[pulumi.Input[builtins.str]] = None,
            token_id: Optional[pulumi.Input[builtins.int]] = None,
            user_id: Optional[pulumi.Input[builtins.int]] = None) -> 'UserImpersonationToken':
        """
        Get an existing UserImpersonationToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] active: True if the token is active.
        :param pulumi.Input[builtins.str] created_at: Time the token has been created, RFC3339 format.
        :param pulumi.Input[builtins.str] expires_at: Expiration date of the impersonation token in ISO format (YYYY-MM-DD).
        :param pulumi.Input[builtins.bool] impersonation: True as the token is always an impersonation token.
        :param pulumi.Input[builtins.str] name: The name of the impersonation token.
        :param pulumi.Input[builtins.bool] revoked: True if the token is revoked.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] scopes: Array of scopes of the impersonation token. valid values are: `api`, `read_user`, `read_api`, `read_repository`, `write_repository`, `read_registry`, `write_registry`, `read_virtual_registry`, `write_virtual_registry`, `sudo`, `admin_mode`, `create_runner`, `manage_runner`, `ai_features`, `k8s_proxy`, `self_rotate`, `read_service_ping`
        :param pulumi.Input[builtins.str] token: The token of the user impersonation token. **Note**: the token is not available for imported resources.
        :param pulumi.Input[builtins.int] token_id: ID of the impersonation token.
        :param pulumi.Input[builtins.int] user_id: The ID of the user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserImpersonationTokenState.__new__(_UserImpersonationTokenState)

        __props__.__dict__["active"] = active
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["expires_at"] = expires_at
        __props__.__dict__["impersonation"] = impersonation
        __props__.__dict__["name"] = name
        __props__.__dict__["revoked"] = revoked
        __props__.__dict__["scopes"] = scopes
        __props__.__dict__["token"] = token
        __props__.__dict__["token_id"] = token_id
        __props__.__dict__["user_id"] = user_id
        return UserImpersonationToken(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[builtins.bool]:
        """
        True if the token is active.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[builtins.str]:
        """
        Time the token has been created, RFC3339 format.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> pulumi.Output[builtins.str]:
        """
        Expiration date of the impersonation token in ISO format (YYYY-MM-DD).
        """
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter
    def impersonation(self) -> pulumi.Output[builtins.bool]:
        """
        True as the token is always an impersonation token.
        """
        return pulumi.get(self, "impersonation")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the impersonation token.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def revoked(self) -> pulumi.Output[builtins.bool]:
        """
        True if the token is revoked.
        """
        return pulumi.get(self, "revoked")

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Array of scopes of the impersonation token. valid values are: `api`, `read_user`, `read_api`, `read_repository`, `write_repository`, `read_registry`, `write_registry`, `read_virtual_registry`, `write_virtual_registry`, `sudo`, `admin_mode`, `create_runner`, `manage_runner`, `ai_features`, `k8s_proxy`, `self_rotate`, `read_service_ping`
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[builtins.str]:
        """
        The token of the user impersonation token. **Note**: the token is not available for imported resources.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter(name="tokenId")
    def token_id(self) -> pulumi.Output[builtins.int]:
        """
        ID of the impersonation token.
        """
        return pulumi.get(self, "token_id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[builtins.int]:
        """
        The ID of the user.
        """
        return pulumi.get(self, "user_id")

