/*
 * Decompiled with CFR 0.152.
 */
package controller;

import controller.Main;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TextField;

public class DataModelController {
    @FXML
    private TextField dataDfs;
    @FXML
    private TextField dataInputPath;
    @FXML
    private ChoiceBox<String> colFormat;
    ObservableList<String> colFormatList = FXCollections.observableArrayList((Object[])new String[]{"UIR", "UIRT"});
    @FXML
    private ChoiceBox<String> dataModelType;
    ObservableList<String> dataModelList = FXCollections.observableArrayList((Object[])new String[]{"text", "arff"});
    @FXML
    private ChoiceBox<String> splitterType;
    ObservableList<String> splitterList = FXCollections.observableArrayList((Object[])new String[]{"ratio", "kcv", "givenn", "loocv", "testset"});
    @FXML
    private TextField splitterConf;
    @FXML
    private TextField binarizeThreshold;
    @FXML
    private TextField randomSeed;
    @FXML
    private TextField resultPath;

    @FXML
    public void initialize() {
        this.colFormat.setItems(this.colFormatList);
        this.dataModelType.setItems(this.dataModelList);
        this.splitterType.setItems(this.splitterList);
    }

    @FXML
    public void goBack() {
        String dataDfsString = this.dataDfs.getText();
        String dataInputPathString = this.dataInputPath.getText();
        String colFormatString = (String)this.colFormat.getValue();
        String dataModelTypeString = (String)this.dataModelType.getValue();
        String splitterTypeString = (String)this.splitterType.getValue();
        String splitterConfString = this.splitterConf.getText();
        String thresholdString = this.binarizeThreshold.getText();
        String randomSeedString = this.randomSeed.getText();
        String resultPathString = this.resultPath.getText();
        if (!dataDfsString.isEmpty()) {
            Main.conf.set("dfs.data.dir", dataDfsString);
        }
        if (!dataInputPathString.isEmpty()) {
            Main.conf.set("data.input.path", dataInputPathString);
        }
        if (!colFormatString.isEmpty()) {
            Main.conf.set("data.column.format", colFormatString);
        }
        if (!dataModelTypeString.isEmpty()) {
            Main.conf.set("data.model.format", dataModelTypeString);
        }
        if (!dataDfsString.isEmpty()) {
            Main.conf.set("dfs.data.dir", dataDfsString);
        }
        if (!splitterTypeString.isEmpty()) {
            Main.conf.set("data.model.splitter", splitterTypeString);
        }
        if (!splitterTypeString.isEmpty()) {
            // empty if block
        }
        if (!thresholdString.isEmpty()) {
            Main.conf.set("data.convert.binarize.threshold", thresholdString);
        }
        if (!randomSeedString.isEmpty()) {
            Main.conf.set("rec.random.seed", randomSeedString);
        }
        if (!resultPathString.isEmpty()) {
            Main.conf.set("dfs.result.dir", resultPathString);
        }
        Main.showMainScene();
    }

    @FXML
    public void returnToMain() {
        Main.showMainScene();
    }
}

