/*
 * Decompiled with CFR 0.152.
 */
package controller;

import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import net.librec.conf.Configuration;
import org.apache.log4j.PropertyConfigurator;

public class Main
extends Application {
    static Stage window;
    static Scene mainScene;
    static Scene dataModelScene;
    static Scene similarityScene;
    static Scene recommenderScene;
    static Scene evaluatorScene;
    static Scene filterScene;
    static Scene outputScene;
    public static Configuration conf;

    public void start(Stage primaryStage) throws Exception {
        Properties loggingProperties = new Properties();
        loggingProperties.load(((Object)((Object)this)).getClass().getResourceAsStream("/log4j.properties"));
        PropertyConfigurator.configure(loggingProperties);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("internationalization", new Locale("zh", "CN"));
        this.buildStages(primaryStage, resourceBundle);
    }

    public void buildStages(Stage primaryStage, ResourceBundle resourceBundle) throws Exception {
        int width = 800;
        int height = 459;
        window = primaryStage;
        Parent root = (Parent)FXMLLoader.load((URL)((Object)((Object)this)).getClass().getResource("/main.fxml"), (ResourceBundle)resourceBundle);
        window.setTitle("LibRec V2.0");
        mainScene = new Scene(root, (double)width, (double)height);
        window.setScene(mainScene);
        window.show();
        root = (Parent)FXMLLoader.load((URL)((Object)((Object)this)).getClass().getResource("/dataModel.fxml"), (ResourceBundle)resourceBundle);
        dataModelScene = new Scene(root, (double)width, (double)height);
        root = (Parent)FXMLLoader.load((URL)((Object)((Object)this)).getClass().getResource("/evaluator.fxml"), (ResourceBundle)resourceBundle);
        evaluatorScene = new Scene(root, (double)width, (double)height);
        root = (Parent)FXMLLoader.load((URL)((Object)((Object)this)).getClass().getResource("/filter.fxml"), (ResourceBundle)resourceBundle);
        filterScene = new Scene(root, (double)width, (double)height);
        root = (Parent)FXMLLoader.load((URL)((Object)((Object)this)).getClass().getResource("/output_1.fxml"), (ResourceBundle)resourceBundle);
        outputScene = new Scene(root, (double)width, (double)height);
        root = (Parent)FXMLLoader.load((URL)((Object)((Object)this)).getClass().getResource("/recommender.fxml"), (ResourceBundle)resourceBundle);
        recommenderScene = new Scene(root, (double)width, (double)height);
        root = (Parent)FXMLLoader.load((URL)((Object)((Object)this)).getClass().getResource("/similarity.fxml"), (ResourceBundle)resourceBundle);
        similarityScene = new Scene(root, (double)width, (double)height);
        conf = new Configuration();
    }

    public static void showDataModelScene() {
        window.setScene(dataModelScene);
        window.show();
    }

    public static void showEvalScene() {
        window.setScene(evaluatorScene);
        window.show();
    }

    public static void showFilterScene() {
        window.setScene(filterScene);
        window.show();
    }

    public static void showMainScene() {
        window.setScene(mainScene);
        window.show();
    }

    public static void showOutputScene() {
        window.setScene(outputScene);
        window.show();
    }

    public static void showRecommenderScene() {
        window.setScene(recommenderScene);
        window.show();
    }

    public static void showSimilarityScene() {
        window.setScene(similarityScene);
        window.show();
    }

    public void switchToChinese() {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("internationalization", new Locale("zh", "CN"));
            this.buildStages(window, resourceBundle);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void switchToEngish() {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("internationalization", new Locale("en", "EN"));
            this.buildStages(window, resourceBundle);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void exit() {
        window.close();
    }

    public static void main(String[] args) {
        Main.launch((String[])args);
    }
}

