/*
 * Decompiled with CFR 0.152.
 */
package controller;

import controller.Main;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TextArea;
import org.apache.commons.lang.StringUtils;
import util.AbbreviateListFinder;

public class RecommenderController {
    ObservableList<String> recList = FXCollections.observableArrayList(AbbreviateListFinder.getListByKeyWord("net.librec.recommender"));
    @FXML
    ChoiceBox<String> recommenderTypeBox;
    @FXML
    TextArea recConfArea;

    @FXML
    public void initialize() {
        this.recommenderTypeBox.setItems(this.recList);
        this.recommenderTypeBox.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                RecommenderController.this.getDefaultConf(newValue.intValue());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void getDefaultConf(int newValue) {
        String abbrevRecName = AbbreviateListFinder.getListByKeyWord("net.librec.recommender").get(newValue);
        if (StringUtils.isEmpty(abbrevRecName)) {
            return;
        }
        Main.conf.set("rec.recommender.class", abbrevRecName);
        InputStream is = null;
        Properties prop = new Properties();
        String[] dir1 = new String[]{"baseline", "cf", "content", "context", "ensemble", "ext", "hybrid", "incremental", "nn", "poi"};
        String[] dir2 = new String[]{"ranking", "rating", ""};
        try {
            block11: for (int i = 0; i < dir1.length; ++i) {
                for (int j = 0; j < dir2.length; ++j) {
                    String path = "";
                    path = j != 2 ? "rec/" + dir1[i] + "/" + dir2[j] + "/" + abbrevRecName + "-test.properties" : "rec/" + dir1[i] + "/" + abbrevRecName + "-test.properties";
                    is = RecommenderController.class.getClassLoader().getResourceAsStream(path);
                    if (is != null) break block11;
                }
            }
            prop.load(is);
        }
        catch (IOException var12) {
            var12.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException var11) {
                var11.printStackTrace();
            }
        }
        StringBuilder defaultConf = new StringBuilder();
        for (Map.Entry<Object, Object> entry : prop.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            defaultConf.append(key + "=" + value + "\n");
        }
        this.recConfArea.setText(defaultConf.toString());
    }

    @FXML
    public void goBack() throws Exception {
        if (!this.recConfArea.getText().isEmpty()) {
            String[] recConfs;
            for (String recConf : recConfs = this.recConfArea.getText().split("\n")) {
                String key = recConf.split("=")[0];
                String value = recConf.split("=")[1];
                Main.conf.set(key, value);
            }
        }
        Main.showMainScene();
    }

    @FXML
    public void returnToMain() {
        Main.showMainScene();
    }
}

