/*
 * Decompiled with CFR 0.152.
 */
package net.librec.data.convertor;

import java.io.IOException;
import net.librec.conf.Configuration;
import net.librec.data.DataConvertor;
import net.librec.job.progress.ProgressReporter;
import net.librec.math.structure.DataFrame;
import net.librec.math.structure.SequentialAccessSparseMatrix;
import net.librec.math.structure.SparseTensor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDataConvertor
extends ProgressReporter
implements DataConvertor {
    protected final Log LOG = LogFactory.getLog(this.getClass());
    protected DataFrame matrix;
    protected SequentialAccessSparseMatrix preferenceMatrix;
    protected SequentialAccessSparseMatrix datetimeMatrix;
    protected SparseTensor sparseTensor;

    @Override
    public DataFrame getMatrix() {
        if (null == this.matrix) {
            try {
                this.processData();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.matrix;
    }

    @Override
    public SequentialAccessSparseMatrix getPreferenceMatrix() {
        if (null == this.preferenceMatrix) {
            this.preferenceMatrix = this.getMatrix().toSparseMatrix("preferenceMatrix");
        }
        return this.preferenceMatrix;
    }

    @Override
    public SequentialAccessSparseMatrix getPreferenceMatrix(Configuration conf) {
        if (null == this.preferenceMatrix) {
            this.preferenceMatrix = this.getMatrix().toSparseMatrix(conf);
        }
        return this.preferenceMatrix;
    }

    @Override
    public SequentialAccessSparseMatrix getDatetimeMatrix() {
        if (null == this.datetimeMatrix) {
            this.datetimeMatrix = this.getMatrix().toSparseMatrix("datetimeMatrix");
        }
        return this.datetimeMatrix;
    }

    @Override
    public SparseTensor getSparseTensor() {
        if (null == this.sparseTensor) {
            this.sparseTensor = this.getMatrix().toSparseTensor();
        }
        return this.sparseTensor;
    }

    @Override
    public SparseTensor getSparseTensor(String[] indices, String valueIndex) {
        if (null == this.sparseTensor) {
            this.sparseTensor = this.getMatrix().toSparseTensor(indices, valueIndex);
        }
        return this.sparseTensor;
    }
}

