/*
 * Decompiled with CFR 0.152.
 */
package net.librec.data.convertor;

import com.google.common.collect.BiMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import net.librec.data.convertor.AbstractDataConvertor;
import net.librec.data.model.ArffAttribute;
import net.librec.data.model.ArffInstance;
import net.librec.math.structure.DataFrame;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArffDataConvertor
extends AbstractDataConvertor {
    private static final Log LOG = LogFactory.getLog(ArffDataConvertor.class);
    private String[] inputDataPath;
    private String relationName;
    private ArrayList<ArffInstance> instances;
    private ArrayList<ArffAttribute> attributes;
    private ArrayList<String> attrTypes;
    private ArrayList<BiMap<String, Integer>> columnIds;
    private int userCol;
    private int itemCol;
    private int ratingCol;
    private ArrayList<BiMap<String, Integer>> featuresInnerMapping;

    public ArffDataConvertor(String ... path) {
        this.inputDataPath = path;
        this.instances = new ArrayList();
        this.attributes = new ArrayList();
        this.columnIds = new ArrayList();
        this.attrTypes = new ArrayList();
        this.userCol = -1;
        this.itemCol = -1;
        this.ratingCol = -1;
    }

    public ArffDataConvertor(String path, ArrayList<BiMap<String, Integer>> featureMapping) {
        this(path);
        this.featuresInnerMapping = featureMapping;
    }

    public void readData() throws IOException {
        this.readData(this.inputDataPath);
    }

    public void readData(String ... inputDataPath) throws IOException {
        int i;
        LOG.info(String.format("Dataset: %s", Arrays.toString(inputDataPath)));
        this.matrix = new DataFrame();
        ArrayList<String> attrTypeList = new ArrayList<String>();
        final ArrayList files = new ArrayList();
        SimpleFileVisitor<Path> finder = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                files.add(file.toFile());
                return super.visitFile(file, attrs);
            }
        };
        for (String path : inputDataPath) {
            Files.walkFileTree(Paths.get(path.trim(), new String[0]), (FileVisitor<? super Path>)finder);
        }
        for (i = 0; i < files.size(); ++i) {
            boolean dataFlag;
            BufferedReader br;
            if (0 == i) {
                br = new BufferedReader(new FileReader((File)files.get(i)));
                dataFlag = false;
                int attrIdx = 0;
                String attrName = null;
                String attrType = null;
                String line = null;
                while (true) {
                    if (dataFlag) {
                        for (ArffAttribute attr : this.attributes) {
                            this.attrTypes.add(attr.getType());
                        }
                        this.matrix.setAttrType(this.attrTypes);
                        this.dataReader(br);
                    }
                    if ((line = br.readLine()) == null) break;
                    if (line.isEmpty() || line.startsWith("%")) continue;
                    String[] data = line.trim().split("[ \t]");
                    if (data[0].toUpperCase().equals("@RELATION")) {
                        this.relationName = data[1];
                        this.matrix.setName(data[1]);
                        continue;
                    }
                    if (data[0].toUpperCase().equals("@ATTRIBUTE")) {
                        attrName = data[1];
                        attrType = data[2];
                        boolean isNominal = false;
                        if (attrName.equals("user")) {
                            this.userCol = attrIdx;
                        }
                        if (attrName.equals("item")) {
                            this.itemCol = attrIdx;
                        }
                        if (attrName.equals("rating")) {
                            this.ratingCol = attrIdx;
                        }
                        if (attrType.startsWith("{") && attrType.endsWith("}")) {
                            isNominal = true;
                        }
                        BiMap<String, Integer> colId = DataFrame.getInnerMapping(attrName);
                        if (isNominal) {
                            String nominalAttrs = attrType.substring(1, attrType.length() - 1);
                            boolean val = false;
                            for (String attr : nominalAttrs.split(",")) {
                                if (colId.keySet().contains(attr.trim())) continue;
                                colId.put(attr.trim(), colId.size());
                            }
                            attrType = "NOMINAL";
                        }
                        this.matrix.addHeader(attrName);
                        this.columnIds.add(colId);
                        this.attributes.add(new ArffAttribute(attrName, attrType.toUpperCase(), attrIdx++));
                        attrTypeList.add(attrType.toUpperCase());
                        continue;
                    }
                    if (!data[0].toUpperCase().equals("@DATA")) continue;
                    dataFlag = true;
                }
                br.close();
                continue;
            }
            br = new BufferedReader(new FileReader((File)files.get(i)));
            dataFlag = false;
            String line = null;
            while (true) {
                String[] data;
                if (dataFlag) {
                    this.dataReader(br);
                }
                if ((line = br.readLine()) == null) break;
                if (line.isEmpty() || line.startsWith("%") || (data = line.trim().split("[ \t]"))[0].toUpperCase().equals("@RELATION") || data[0].toUpperCase().equals("@ATTRIBUTE") || !data[0].toUpperCase().equals("@DATA")) continue;
                dataFlag = true;
            }
            br.close();
        }
        for (i = 0; i < this.attributes.size(); ++i) {
            this.attributes.get(i).setColumnSet(DataFrame.getInnerMapping(this.attributes.get(i).getName()).keySet());
        }
        ArffInstance.attrs = this.attributes;
    }

    private void dataReader(Reader rd) throws IOException {
        ArrayList<String> dataLine = new ArrayList<String>();
        StringBuilder subString = new StringBuilder();
        boolean isInQuote = false;
        boolean isInBracket = false;
        int c = 0;
        while ((c = rd.read()) != -1) {
            char ch = (char)c;
            if (ch == '\n') {
                if (dataLine.size() == 0 || ((String)dataLine.get(0)).startsWith("%")) continue;
                dataLine.add(subString.toString());
                if (dataLine.size() != this.attrTypes.size()) {
                    throw new IOException("Read data error, inconsistent attribute number!");
                }
                for (int i = 0; i < dataLine.size(); ++i) {
                    String type;
                    String col = ((String)dataLine.get(i)).trim();
                    switch (type = this.attrTypes.get(i)) {
                        case "NUMERIC": 
                        case "REAL": 
                        case "INTEGER": {
                            break;
                        }
                        case "STRING": {
                            DataFrame.setId(col, this.attributes.get(i).getName());
                            break;
                        }
                        case "NOMINAL": {
                            BiMap<String, Integer> colId = DataFrame.getInnerMapping(this.attributes.get(i).getName());
                            StringBuilder sb = new StringBuilder();
                            String[] ss = col.split(",");
                            for (int ns = 0; ns < ss.length; ++ns) {
                                String _s = ss[ns].trim();
                                if (!colId.containsKey(_s)) {
                                    throw new IOException("Read data error, inconsistent nominal value!");
                                }
                                sb.append(_s);
                                if (ns == ss.length - 1) continue;
                                sb.append(",");
                            }
                            col = sb.toString();
                            break;
                        }
                    }
                    dataLine.set(i, col);
                }
                this.instances.add(new ArffInstance(dataLine));
                this.matrix.add(dataLine.toArray(new String[dataLine.size()]));
                subString = new StringBuilder();
                dataLine = new ArrayList();
                continue;
            }
            if (ch == '[' || ch == ']') {
                isInBracket = !isInBracket;
                continue;
            }
            if (ch == '\r') continue;
            if (ch == '\"') {
                isInQuote = !isInQuote;
                continue;
            }
            if (ch == ',' && !isInQuote && !isInBracket) {
                dataLine.add(subString.toString());
                subString = new StringBuilder();
                continue;
            }
            subString.append(ch);
        }
    }

    @Override
    public void processData() throws IOException {
        this.readData();
    }

    @Override
    public void progress() {
    }

    public String getRelationName() {
        return this.relationName;
    }

    public ArrayList<ArffInstance> getInstances() {
        return this.instances;
    }

    public ArrayList<ArffAttribute> getAttributes() {
        return this.attributes;
    }

    public BiMap<String, Integer> getUserIds() {
        return DataFrame.getInnerMapping("user");
    }

    public BiMap<String, Integer> getItemIds() {
        return DataFrame.getInnerMapping("item");
    }

    public ArrayList<BiMap<String, Integer>> getAllFeatureIds() {
        return this.featuresInnerMapping;
    }
}

