/*
 * Decompiled with CFR 0.152.
 */
package net.librec.data.convertor;

import com.google.common.collect.BiMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.librec.data.convertor.AbstractDataConvertor;
import net.librec.math.structure.DataFrame;
import net.librec.util.StringUtil;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextDataConvertor
extends AbstractDataConvertor {
    private static final Log LOG = LogFactory.getLog(TextDataConvertor.class);
    private static final int BSIZE = 0x100000;
    private static final String DATA_COLUMN_DEFAULT_FORMAT = "UIR";
    private String dataColumnFormat;
    private String[] header;
    private String[] attr;
    private String sep;
    private float fileRate;
    private String[] inputDataPath;
    private double binThold = -1.0;
    private BiMap<String, Integer> userIds;
    private BiMap<String, Integer> itemIds;
    private TimeUnit timeUnit = TimeUnit.SECONDS;

    public TextDataConvertor(String inputDataPath) {
        this(DATA_COLUMN_DEFAULT_FORMAT, inputDataPath, ",");
    }

    public TextDataConvertor(String dataColumnFormat, String inputDataPath) {
        this(dataColumnFormat, inputDataPath, " ");
    }

    public TextDataConvertor(String[] header, String[] attr, String inputDataPath, String sep) {
        this.header = header;
        this.attr = attr;
        this.inputDataPath = inputDataPath.split(",");
        this.sep = sep;
    }

    public TextDataConvertor(String dataColumnFormat, String inputDataPath, String sep) {
        this.dataColumnFormat = dataColumnFormat;
        this.inputDataPath = inputDataPath.split(",");
        this.sep = sep;
    }

    public TextDataConvertor(String[] inputDataPath) {
        this(DATA_COLUMN_DEFAULT_FORMAT, inputDataPath, ",");
    }

    public TextDataConvertor(String[] inputDataPath, String sep) {
        this(DATA_COLUMN_DEFAULT_FORMAT, inputDataPath, sep);
    }

    public TextDataConvertor(String dataColumnFormat, String[] inputDataPath, String sep) {
        this.dataColumnFormat = dataColumnFormat;
        this.inputDataPath = inputDataPath;
        this.sep = sep;
    }

    @Override
    public void processData() throws IOException {
        this.readData(this.inputDataPath);
    }

    private void readData(String ... inputDataPath) throws IOException {
        LOG.info(String.format("Dataset: %s", Arrays.toString(inputDataPath)));
        this.matrix = new DataFrame();
        if (Objects.isNull(this.header)) {
            if (this.dataColumnFormat.toLowerCase().equals("uirt")) {
                this.header = new String[]{"user", "item", "rating", "datetime"};
                this.attr = new String[]{"STRING", "STRING", "NUMERIC", "DATE"};
            } else {
                this.header = new String[]{"user", "item", "rating"};
                this.attr = new String[]{"STRING", "STRING", "NUMERIC"};
            }
        }
        this.matrix.setAttrType(this.attr);
        this.matrix.setHeader(this.header);
        final ArrayList files = new ArrayList();
        SimpleFileVisitor<Path> finder = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                files.add(file.toFile());
                return super.visitFile(file, attrs);
            }
        };
        for (String path : inputDataPath) {
            Files.walkFileTree(Paths.get(path.trim(), new String[0]), (FileVisitor<? super Path>)finder);
        }
        int numFiles = files.size();
        int cur = 0;
        Pattern pattern = Pattern.compile(this.sep);
        for (File file : files) {
            try {
                Source fileSource = Okio.source(file);
                Throwable throwable = null;
                try {
                    BufferedSource bufferedSource = Okio.buffer(fileSource);
                    Throwable throwable2 = null;
                    try {
                        String temp;
                        while ((temp = bufferedSource.readUtf8Line()) != null && !"".equals(temp.trim())) {
                            String[] eachRow = pattern.split(temp);
                            for (int i = 0; i < this.header.length; ++i) {
                                if (!Objects.equals(this.attr[i], "STRING")) continue;
                                DataFrame.setId(eachRow[i], this.matrix.getHeader(i));
                            }
                            this.matrix.add(eachRow);
                        }
                        LOG.info(String.format("DataSet: %s is finished", StringUtil.last(file.toString(), 38)));
                        this.fileRate = ++cur / numFiles;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (bufferedSource == null) continue;
                        if (throwable2 != null) {
                            try {
                                bufferedSource.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        bufferedSource.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (fileSource == null) continue;
                    if (throwable != null) {
                        try {
                            fileSource.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    fileSource.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        List<Double> ratingScale = this.matrix.getRatingScale();
        if (ratingScale != null) {
            if (ratingScale.size() < 10) {
                LOG.info(String.format("rating Scale: %s", ratingScale.toString()));
            } else {
                LOG.info(String.format("rating Scale (real): %s to %s", ratingScale.get(0), ratingScale.get(ratingScale.size() - 1)));
            }
        }
        LOG.info(String.format("user number: %d,\t item number is: %d", this.matrix.numUsers(), this.matrix.numItems()));
    }

    @Override
    public void progress() {
        this.getJobStatus().setProgress(this.fileRate);
    }
}

