/*
 * Decompiled with CFR 0.152.
 */
package net.librec.data.convertor.appender;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import net.librec.conf.Configuration;
import net.librec.conf.Configured;
import net.librec.data.DataAppender;
import net.librec.data.model.ArffAttribute;
import net.librec.data.model.ArffInstance;
import org.apache.commons.lang.StringUtils;

public class AuxiliaryDataAppender
extends Configured
implements DataAppender {
    private String inputDataPath;
    private ArrayList<BiMap<String, Integer>> columnIds;
    private ArrayList<ArffAttribute> attributes;
    private ArrayList<String> attrTypes;
    private String relationName;
    private ArrayList<ArffInstance> instances;

    public AuxiliaryDataAppender() {
        this(null);
    }

    public AuxiliaryDataAppender(Configuration conf) {
        this.conf = conf;
        this.instances = new ArrayList();
        this.attributes = new ArrayList();
        this.columnIds = new ArrayList();
        this.attrTypes = new ArrayList();
    }

    @Override
    public void processData() throws IOException {
        if (this.conf != null && StringUtils.isNotBlank(this.conf.get("data.appender.path"))) {
            this.inputDataPath = this.conf.get("dfs.data.dir") + "/" + this.conf.get("data.appender.path");
            this.readData(this.inputDataPath);
        }
    }

    private void readData(String inputDataPath) throws IOException {
        int i;
        final ArrayList files = new ArrayList();
        SimpleFileVisitor<Path> finder = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                files.add(file.toFile());
                return super.visitFile(file, attrs);
            }
        };
        Files.walkFileTree(Paths.get(inputDataPath, new String[0]), (FileVisitor<? super Path>)finder);
        for (i = 0; i < files.size(); ++i) {
            boolean dataFlag;
            BufferedReader br;
            if (0 == i) {
                br = new BufferedReader(new FileReader((File)files.get(i)));
                dataFlag = false;
                int attrIdx = 0;
                String attrName = null;
                String attrType = null;
                String line = null;
                while (true) {
                    if (dataFlag) {
                        for (ArffAttribute attr : this.attributes) {
                            this.attrTypes.add(attr.getType());
                        }
                        this.dataReader(br);
                    }
                    if ((line = br.readLine()) == null) break;
                    if (line.isEmpty() || line.startsWith("%")) continue;
                    String[] data = line.trim().split("[ \t]");
                    if (data[0].toUpperCase().equals("@RELATION")) {
                        this.relationName = data[1];
                        continue;
                    }
                    if (data[0].toUpperCase().equals("@ATTRIBUTE")) {
                        attrName = data[1];
                        attrType = data[2];
                        boolean isNominal = false;
                        if (attrType.startsWith("{") && attrType.endsWith("}")) {
                            isNominal = true;
                        }
                        HashBiMap<String, Integer> colId = HashBiMap.create();
                        if (isNominal) {
                            String nominalAttrs = attrType.substring(1, attrType.length() - 1);
                            int val = 0;
                            for (String attr : nominalAttrs.split(",")) {
                                colId.put(attr.trim(), val++);
                            }
                            attrType = "NOMINAL";
                        }
                        this.columnIds.add(colId);
                        this.attributes.add(new ArffAttribute(attrName, attrType.toUpperCase(), attrIdx++));
                        continue;
                    }
                    if (!data[0].toUpperCase().equals("@DATA")) continue;
                    dataFlag = true;
                }
                br.close();
                continue;
            }
            br = new BufferedReader(new FileReader((File)files.get(i)));
            dataFlag = false;
            String line = null;
            while (true) {
                String[] data;
                if (dataFlag) {
                    this.dataReader(br);
                }
                if ((line = br.readLine()) == null) break;
                if (line.isEmpty() || line.startsWith("%") || (data = line.trim().split("[ \t]"))[0].toUpperCase().equals("@RELATION") || data[0].toUpperCase().equals("@ATTRIBUTE") || !data[0].toUpperCase().equals("@DATA")) continue;
                dataFlag = true;
            }
            br.close();
        }
        for (i = 0; i < this.attributes.size(); ++i) {
            this.attributes.get(i).setColumnSet(this.columnIds.get(i).keySet());
        }
        ArffInstance.attrs = this.attributes;
    }

    private void dataReader(Reader rd) throws IOException {
        ArrayList<String> dataLine = new ArrayList<String>();
        StringBuilder subString = new StringBuilder();
        boolean isInQuote = false;
        boolean isInBracket = false;
        int c = 0;
        while ((c = rd.read()) != -1) {
            char ch = (char)c;
            if (ch == '\n') {
                if (dataLine.size() == 0 || ((String)dataLine.get(0)).startsWith("%")) continue;
                dataLine.add(subString.toString());
                if (dataLine.size() != this.attrTypes.size()) {
                    throw new IOException("Read data error, inconsistent attribute number!");
                }
                for (int i = 0; i < dataLine.size(); ++i) {
                    String col = ((String)dataLine.get(i)).trim();
                    String type = this.attrTypes.get(i);
                    BiMap<String, Integer> colId = this.columnIds.get(i);
                    switch (type) {
                        case "NUMERIC": 
                        case "REAL": 
                        case "INTEGER": {
                            break;
                        }
                        case "STRING": {
                            int val = colId.containsKey(col) ? ((Integer)colId.get(col)).intValue() : colId.size();
                            colId.put(col, val);
                            break;
                        }
                        case "NOMINAL": {
                            StringBuilder sb = new StringBuilder();
                            String[] ss = col.split(",");
                            for (int ns = 0; ns < ss.length; ++ns) {
                                String _s = ss[ns].trim();
                                if (!colId.containsKey(_s)) {
                                    throw new IOException("Read data error, inconsistent nominal value!");
                                }
                                sb.append(_s);
                                if (ns == ss.length - 1) continue;
                                sb.append(",");
                            }
                            col = sb.toString();
                        }
                    }
                    dataLine.set(i, col);
                }
                this.instances.add(new ArffInstance(dataLine));
                subString = new StringBuilder();
                dataLine = new ArrayList();
                continue;
            }
            if (ch == '[' || ch == ']') {
                isInBracket = !isInBracket;
                continue;
            }
            if (ch == '\r') continue;
            if (ch == '\"') {
                isInQuote = !isInQuote;
                continue;
            }
            if (ch == ',' && !isInQuote && !isInBracket) {
                dataLine.add(subString.toString());
                subString = new StringBuilder();
                continue;
            }
            subString.append(ch);
        }
    }

    @Override
    public void setUserMappingData(BiMap<String, Integer> userMappingData) {
    }

    @Override
    public void setItemMappingData(BiMap<String, Integer> itemMappingData) {
    }

    public ArrayList<ArffInstance> getAuxiliaryData() {
        return this.instances;
    }
}

