/*
 * Decompiled with CFR 0.152.
 */
package net.librec.data.convertor.appender;

import com.google.common.collect.BiMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import net.librec.conf.Configuration;
import net.librec.conf.Configured;
import net.librec.data.DataAppender;
import net.librec.math.structure.SequentialAccessSparseMatrix;
import net.librec.recommender.item.KeyValue;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocationDataAppender
extends Configured
implements DataAppender {
    private static final Log LOG = LogFactory.getLog(LocationDataAppender.class);
    private static final int BSIZE = 0x100000;
    KeyValue<Double, Double>[] locationArray;
    private String inputDataPath;
    private BiMap<String, Integer> userIds;
    private BiMap<String, Integer> itemIds;

    public LocationDataAppender() {
        this(null);
    }

    public LocationDataAppender(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public void processData() throws IOException {
        if (this.conf != null && StringUtils.isNotBlank(this.conf.get("data.appender.path"))) {
            this.inputDataPath = this.conf.get("dfs.data.dir") + "/" + this.conf.get("data.appender.path");
            LOG.info(this.inputDataPath);
            this.locationArray = new KeyValue[this.itemIds.size()];
            this.readData(this.inputDataPath);
        }
    }

    private void readData(String inputDataPath) throws IOException {
        final ArrayList files = new ArrayList();
        final ArrayList fileSizeList = new ArrayList();
        SimpleFileVisitor<Path> finder = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                fileSizeList.add(file.toFile().length());
                files.add(file.toFile());
                return super.visitFile(file, attrs);
            }
        };
        Files.walkFileTree(Paths.get(inputDataPath, new String[0]), (FileVisitor<? super Path>)finder);
        long allFileSize = 0L;
        for (Long everyFileSize : fileSizeList) {
            allFileSize += everyFileSize.longValue();
        }
        for (File dataFile : files) {
            int len;
            FileInputStream fis = new FileInputStream(dataFile);
            FileChannel fileRead = fis.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate(0x100000);
            String bufferLine = new String();
            byte[] bytes = new byte[0x100000];
            while ((len = fileRead.read(buffer)) != -1) {
                buffer.flip();
                buffer.get(bytes, 0, len);
                bufferLine = bufferLine.concat(new String(bytes, 0, len)).replaceAll("\r", "\n");
                String[] bufferData = bufferLine.split("(\n)+");
                boolean isComplete = bufferLine.endsWith("\n");
                int loopLength = isComplete ? bufferData.length : bufferData.length - 1;
                for (int i = 0; i < loopLength; ++i) {
                    String line = new String(bufferData[i]);
                    String[] data = line.trim().split("[ \t,]+");
                    String POIId = data[0];
                    Double latitude = Double.parseDouble(data[1]);
                    Double longtitude = Double.parseDouble(data[2]);
                    if (!this.itemIds.containsKey(POIId)) continue;
                    this.locationArray[((Integer)this.itemIds.get((Object)POIId)).intValue()] = new KeyValue<Double, Double>(latitude, longtitude);
                }
                if (!isComplete) {
                    bufferLine = bufferData[bufferData.length - 1];
                }
                buffer.clear();
            }
            fileRead.close();
            fis.close();
        }
    }

    public KeyValue<Double, Double>[] getLocationAppender() {
        return this.locationArray;
    }

    public SequentialAccessSparseMatrix getItemAppender() {
        return null;
    }

    @Override
    public void setUserMappingData(BiMap<String, Integer> userMappingData) {
        this.userIds = userMappingData;
    }

    @Override
    public void setItemMappingData(BiMap<String, Integer> itemMappingData) {
        this.itemIds = itemMappingData;
    }
}

