/*
 * Decompiled with CFR 0.152.
 */
package net.librec.data.model;

import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.List;
import net.librec.common.LibrecException;
import net.librec.conf.Configuration;
import net.librec.data.DataModel;
import net.librec.data.convertor.ArffDataConvertor;
import net.librec.data.model.AbstractDataModel;
import net.librec.math.structure.DataSet;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.SequentialAccessSparseMatrix;
import net.librec.math.structure.SparseTensor;

public class ArffDataModel
extends AbstractDataModel
implements DataModel {
    public ArffDataModel() {
    }

    public ArffDataModel(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public void buildConvert() throws LibrecException {
        String splitter = this.conf.get("data.model.splitter");
        String dfsDataDir = this.conf.get("dfs.data.dir");
        String inputDataPath = dfsDataDir + "/" + this.conf.get("data.input.path");
        this.dataConvertor = new ArffDataConvertor(inputDataPath);
    }

    @Override
    protected void buildSplitter() throws LibrecException {
        super.buildSplitter();
    }

    private void amendSplitter() {
        if (this.dataConvertor != null && this.dataSplitter != null) {
            SparseTensor totalTensor = this.dataConvertor.getSparseTensor();
            SequentialAccessSparseMatrix testMatrix = this.dataSplitter.getTestData();
            SparseTensor trainTensor = totalTensor.clone();
            int[] dimensions = trainTensor.dimensions();
            SparseTensor testTensor = new SparseTensor(dimensions);
            testTensor.setUserDimension(trainTensor.getUserDimension());
            testTensor.setItemDimension(trainTensor.getItemDimension());
            for (MatrixEntry me : testMatrix) {
                int u = me.row();
                int i = me.column();
                List<Integer> indices = totalTensor.getIndices(u, i);
                for (int index : indices) {
                    int[] keys = totalTensor.keys(index);
                    try {
                        testTensor.set(totalTensor.value(index), keys);
                        trainTensor.remove(keys);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            this.trainDataSet = trainTensor;
            this.testDataSet = testTensor;
        }
    }

    @Override
    public void nextFold() {
        this.amendSplitter();
    }

    @Override
    public DataSet getDatetimeDataSet() {
        return null;
    }

    public ArrayList<BiMap<String, Integer>> getAllFeaturesMappingData() {
        return ((ArffDataConvertor)this.dataConvertor).getAllFeatureIds();
    }
}

