/*
 * Decompiled with CFR 0.152.
 */
package net.librec.data.model;

import java.io.IOException;
import net.librec.common.LibrecException;
import net.librec.conf.Configuration;
import net.librec.data.convertor.TextDataConvertor;
import net.librec.data.model.AbstractDataModel;
import net.librec.math.structure.DataSet;

public class TextDataModel
extends AbstractDataModel {
    public TextDataModel() {
    }

    public TextDataModel(Configuration conf) {
        this.conf = conf;
    }

    @Override
    public void buildConvert() throws LibrecException {
        String[] inputDataPath = this.conf.get("data.input.path").trim().split(":");
        for (int i = 0; i < inputDataPath.length; ++i) {
            inputDataPath[i] = this.conf.get("dfs.data.dir") + "/" + inputDataPath[i];
        }
        String dataColumnFormat = this.conf.get("data.column.format", "UIR");
        this.dataConvertor = new TextDataConvertor(dataColumnFormat, inputDataPath, this.conf.get("data.convert.sep", "[\t;, ]"));
        try {
            this.dataConvertor.processData();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void loadDataModel() throws LibrecException {
    }

    @Override
    public void saveDataModel() throws LibrecException {
    }

    @Override
    public DataSet getDatetimeDataSet() {
        return this.dataConvertor.getDatetimeMatrix();
    }
}

