/*
 * Decompiled with CFR 0.152.
 */
package net.librec.data.splitter;

import java.util.LinkedList;
import net.librec.conf.Configured;
import net.librec.data.DataConvertor;
import net.librec.data.DataSplitter;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.SequentialAccessSparseMatrix;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDataSplitter
extends Configured
implements DataSplitter {
    protected final Log LOG = LogFactory.getLog(this.getClass());
    protected DataConvertor dataConvertor;
    protected SequentialAccessSparseMatrix trainMatrix;
    protected SequentialAccessSparseMatrix testMatrix;
    protected SequentialAccessSparseMatrix validationMatrix;
    protected LinkedList<SequentialAccessSparseMatrix> assignMatrixList;
    protected SequentialAccessSparseMatrix preferenceMatrix = null;
    protected SequentialAccessSparseMatrix datetimeMatrix = null;

    @Override
    public void setDataConvertor(DataConvertor dataConvertor) {
        this.dataConvertor = dataConvertor;
    }

    @Override
    public SequentialAccessSparseMatrix getTrainData() {
        return this.trainMatrix;
    }

    @Override
    public SequentialAccessSparseMatrix getTestData() {
        return this.testMatrix;
    }

    @Override
    public SequentialAccessSparseMatrix getValidData() {
        return this.validationMatrix;
    }

    public void setPreferenceMatrix(SequentialAccessSparseMatrix preferenceMatrix) {
        this.preferenceMatrix = preferenceMatrix;
    }

    @Override
    public boolean nextFold() {
        if (this.assignMatrixList == null) {
            this.assignMatrixList = new LinkedList();
            return true;
        }
        if (this.assignMatrixList.size() > 0) {
            SequentialAccessSparseMatrix assign = this.assignMatrixList.poll();
            this.trainMatrix = this.preferenceMatrix.clone();
            this.testMatrix = this.preferenceMatrix.clone();
            for (MatrixEntry matrixEntry : this.preferenceMatrix) {
                if (assign.get(matrixEntry.row(), matrixEntry.column()) == 1.0) {
                    this.trainMatrix.setAtColumnPosition(matrixEntry.row(), matrixEntry.columnPosition(), 0.0);
                    continue;
                }
                this.testMatrix.setAtColumnPosition(matrixEntry.row(), matrixEntry.columnPosition(), 0.0);
            }
            this.trainMatrix.reshape();
            this.testMatrix.reshape();
            return true;
        }
        return false;
    }
}

