/*
 * Decompiled with CFR 0.152.
 */
package net.librec.data.splitter;

import java.io.IOException;
import net.librec.common.LibrecException;
import net.librec.conf.Configuration;
import net.librec.data.DataConvertor;
import net.librec.data.convertor.AbstractDataConvertor;
import net.librec.data.convertor.ArffDataConvertor;
import net.librec.data.convertor.TextDataConvertor;
import net.librec.data.splitter.AbstractDataSplitter;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.SequentialAccessSparseMatrix;

public class GivenTestSetDataSplitter
extends AbstractDataSplitter {
    private SequentialAccessSparseMatrix preferenceMatrix;

    public GivenTestSetDataSplitter() {
    }

    public GivenTestSetDataSplitter(DataConvertor convertor, Configuration conf) {
        this.dataConvertor = convertor;
        this.conf = conf;
    }

    @Override
    public void splitData() throws LibrecException {
        AbstractDataConvertor testConvertor = null;
        String dataFormat = this.conf.get("data.model.format");
        String[] inputDataPath = this.conf.get("data.testset.path").trim().split(":");
        for (int i = 0; i < inputDataPath.length; ++i) {
            inputDataPath[i] = this.conf.get("dfs.data.dir") + "/" + inputDataPath[i];
        }
        switch (dataFormat.toLowerCase()) {
            case "text": {
                String dataColumnFormat = this.conf.get("data.column.format", "UIR");
                testConvertor = new TextDataConvertor(dataColumnFormat, inputDataPath, "[\t;, ]");
                break;
            }
            case "arff": {
                testConvertor = new ArffDataConvertor(inputDataPath);
                break;
            }
            default: {
                this.LOG.info("Not implement now or please check data.model.format");
            }
        }
        try {
            testConvertor.processData();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.testMatrix = testConvertor.getPreferenceMatrix(this.conf);
        this.trainMatrix = this.dataConvertor.getPreferenceMatrix(this.conf);
        for (MatrixEntry me : this.testMatrix) {
            int rowIdx = me.row();
            int colIdx = me.column();
            this.trainMatrix.set(rowIdx, colIdx, 0.0);
        }
        this.trainMatrix.reshape();
    }
}

