/*
 * Decompiled with CFR 0.152.
 */
package net.librec.data.splitter;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.librec.common.LibrecException;
import net.librec.conf.Configuration;
import net.librec.data.DataConvertor;
import net.librec.data.convertor.ArffDataConvertor;
import net.librec.data.splitter.AbstractDataSplitter;
import net.librec.math.algorithm.Randoms;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.SequentialAccessSparseMatrix;
import net.librec.util.Lists;
import org.apache.commons.lang.StringUtils;

public class KCVDataSplitter
extends AbstractDataSplitter {
    private SequentialAccessSparseMatrix assignMatrix;
    private int cvNumber;
    private int cvIndex;

    public KCVDataSplitter() {
    }

    public KCVDataSplitter(DataConvertor dataConvertor, Configuration conf) {
        this.dataConvertor = dataConvertor;
        this.conf = conf;
    }

    public void splitData(int kFold) {
        if (null == this.preferenceMatrix) {
            this.preferenceMatrix = this.dataConvertor.getPreferenceMatrix(this.conf);
            if (!(this.dataConvertor instanceof ArffDataConvertor) && StringUtils.equals(this.conf.get("data.column.format"), "UIRT")) {
                this.datetimeMatrix = this.dataConvertor.getDatetimeMatrix();
            }
        }
        if (kFold > 0) {
            this.assignMatrix = this.preferenceMatrix.clone();
            int numRates = this.preferenceMatrix.getNumEntries();
            int numFold = kFold > numRates ? numRates : kFold;
            ArrayList rdm = new ArrayList(numRates);
            double indvCount = ((double)numRates + 0.0) / (double)numFold;
            for (int index = 0; index < numRates; ++index) {
                rdm.add(new AbstractMap.SimpleImmutableEntry<Integer, Double>((int)((double)index / indvCount) + 1, Randoms.uniform()));
            }
            int[] fold = new int[numRates];
            Lists.sortList(rdm, true);
            for (int index = 0; index < numRates; ++index) {
                fold[index] = (Integer)((Map.Entry)rdm.get(index)).getKey();
            }
            int i = 0;
            for (MatrixEntry matrixEntry : this.assignMatrix) {
                this.assignMatrix.setAtColumnPosition(matrixEntry.row(), matrixEntry.columnPosition(), fold[i++]);
            }
        }
        if (null == this.assignMatrixList) {
            ArrayList tableList = new ArrayList(kFold + 1);
            for (int i = 0; i < kFold + 1; ++i) {
                tableList.add(HashBasedTable.create());
            }
            for (MatrixEntry me : this.assignMatrix) {
                if (me.get() == 0.0) continue;
                ((Table)tableList.get((int)me.get())).put(me.row(), me.column(), 1);
            }
            this.assignMatrixList = new LinkedList();
            for (int i = 1; i < kFold + 1; ++i) {
                this.assignMatrixList.add(new SequentialAccessSparseMatrix(this.assignMatrix.rowSize(), this.assignMatrix.columnSize(), (Table)tableList.get(i)));
            }
        }
    }

    @Override
    public void splitData() throws LibrecException {
        this.cvNumber = this.conf.getInt("data.splitter.cv.number", 5);
        if (null == this.assignMatrix) {
            this.splitData(this.cvNumber);
        }
    }

    public List<SequentialAccessSparseMatrix> getAssignMatrixList() {
        return this.assignMatrixList;
    }
}

