/*
 * Decompiled with CFR 0.152.
 */
package net.librec.data.splitter;

import com.google.common.collect.HashBasedTable;
import java.util.ArrayList;
import java.util.Collections;
import net.librec.common.LibrecException;
import net.librec.conf.Configuration;
import net.librec.data.DataConvertor;
import net.librec.data.convertor.ArffDataConvertor;
import net.librec.data.splitter.AbstractDataSplitter;
import net.librec.data.splitter.KCVDataSplitter;
import net.librec.math.algorithm.Randoms;
import net.librec.math.structure.SequentialAccessSparseMatrix;
import net.librec.math.structure.SequentialSparseVector;
import net.librec.math.structure.Vector;
import net.librec.util.RatingContext;
import org.apache.commons.lang.StringUtils;

public class LOOCVDataSplitter
extends AbstractDataSplitter {
    private SequentialAccessSparseMatrix preferenceMatrix;
    private SequentialAccessSparseMatrix datetimeMatrix;
    private KCVDataSplitter kcv;

    public LOOCVDataSplitter() {
    }

    public LOOCVDataSplitter(DataConvertor dataConvertor, Configuration conf) {
        this.dataConvertor = dataConvertor;
        this.conf = conf;
    }

    @Override
    public void splitData() throws LibrecException {
        if (null == this.preferenceMatrix) {
            this.preferenceMatrix = this.dataConvertor.getPreferenceMatrix(this.conf);
            if (!(this.dataConvertor instanceof ArffDataConvertor) && StringUtils.equals(this.conf.get("data.column.format"), "UIRT")) {
                this.datetimeMatrix = this.dataConvertor.getDatetimeMatrix();
            }
        }
        String splitter = this.conf.get("data.splitter.loocv");
        switch (splitter.toLowerCase()) {
            case "user": {
                this.getLOOByUser();
                break;
            }
            case "item": {
                this.getLOOByItems();
                break;
            }
            case "userdate": {
                this.getLOOByUserDate();
                break;
            }
            case "itemdate": {
                this.getLooByItemsDate();
                break;
            }
            default: {
                this.LOG.info("Please check ");
            }
        }
    }

    public void getLOOByUser() {
        this.trainMatrix = new SequentialAccessSparseMatrix(this.preferenceMatrix);
        HashBasedTable<Integer, Integer, Double> dataTable = HashBasedTable.create();
        int rowSize = this.preferenceMatrix.rowSize();
        for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
            int numColumnEntries = this.preferenceMatrix.row(rowIndex).getNumEntries();
            if (numColumnEntries == 0) continue;
            int randomRowPosition = (int)((double)numColumnEntries * Randoms.uniform());
            this.preferenceMatrix = this.dataConvertor.getPreferenceMatrix();
            this.trainMatrix.setAtColumnPosition(rowIndex, randomRowPosition, 0.0);
            dataTable.put(rowIndex, this.preferenceMatrix.row(rowIndex).getIndexAtPosition(randomRowPosition), this.preferenceMatrix.getAtColumnPosition(rowIndex, randomRowPosition));
        }
        this.trainMatrix.reshape();
        this.testMatrix = new SequentialAccessSparseMatrix(this.preferenceMatrix.rowSize(), this.preferenceMatrix.columnSize(), dataTable);
    }

    public void getLOOByUserDate() {
        this.trainMatrix = new SequentialAccessSparseMatrix(this.preferenceMatrix);
        HashBasedTable<Integer, Integer, Double> dataTable = HashBasedTable.create();
        int rowSize = this.preferenceMatrix.rowSize();
        for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
            SequentialSparseVector itemRatingVector = this.preferenceMatrix.row(rowIndex);
            if (itemRatingVector.getNumEntries() == 0) continue;
            ArrayList<RatingContext> ratingContexts = new ArrayList<RatingContext>(itemRatingVector.getNumEntries());
            for (Vector.VectorEntry vectorEntry : itemRatingVector) {
                ratingContexts.add(new RatingContext(rowIndex, vectorEntry.position(), (long)this.datetimeMatrix.getAtColumnPosition(rowIndex, vectorEntry.position())));
            }
            Collections.sort(ratingContexts);
            int columnPosition = ((RatingContext)ratingContexts.get(ratingContexts.size() - 1)).getItem();
            this.trainMatrix.setAtColumnPosition(rowIndex, columnPosition, 0.0);
            dataTable.put(rowIndex, this.preferenceMatrix.row(rowIndex).getIndexAtPosition(columnPosition), this.preferenceMatrix.getAtColumnPosition(rowIndex, columnPosition));
        }
        this.trainMatrix.reshape();
        this.testMatrix = new SequentialAccessSparseMatrix(this.preferenceMatrix.rowSize(), this.preferenceMatrix.columnSize(), dataTable);
    }

    public void getLOOByItems() {
        this.trainMatrix = new SequentialAccessSparseMatrix(this.preferenceMatrix);
        HashBasedTable<Integer, Integer, Double> dataTable = HashBasedTable.create();
        int columnSize = this.preferenceMatrix.columnSize();
        for (int columnIndex = 0; columnIndex < columnSize; ++columnIndex) {
            int numRowEntries = this.preferenceMatrix.column(columnIndex).getNumEntries();
            if (numRowEntries == 0) continue;
            int randomRowPosition = (int)((double)numRowEntries * Randoms.uniform());
            this.trainMatrix.setAtRowPosition(randomRowPosition, columnIndex, 0.0);
            dataTable.put(this.preferenceMatrix.column(columnIndex).getIndexAtPosition(randomRowPosition), columnIndex, this.preferenceMatrix.getAtRowPosition(randomRowPosition, columnIndex));
        }
        this.trainMatrix.reshape();
        this.testMatrix = new SequentialAccessSparseMatrix(this.preferenceMatrix.rowSize(), this.preferenceMatrix.columnSize(), dataTable);
    }

    public void getLooByItemsDate() {
        this.trainMatrix = new SequentialAccessSparseMatrix(this.preferenceMatrix);
        HashBasedTable<Integer, Integer, Double> dataTable = HashBasedTable.create();
        int columnSize = this.preferenceMatrix.columnSize();
        for (int columnIndex = 0; columnIndex < columnSize; ++columnIndex) {
            SequentialSparseVector userRatingVector = this.preferenceMatrix.column(columnIndex);
            if (userRatingVector.getNumEntries() == 0) continue;
            ArrayList<RatingContext> ratingContexts = new ArrayList<RatingContext>();
            for (Vector.VectorEntry vectorEntry : userRatingVector) {
                ratingContexts.add(new RatingContext(vectorEntry.position(), columnIndex, (long)this.datetimeMatrix.getAtRowPosition(vectorEntry.position(), columnIndex)));
            }
            Collections.sort(ratingContexts);
            int rowPosition = ((RatingContext)ratingContexts.get(ratingContexts.size() - 1)).getUser();
            this.trainMatrix.setAtRowPosition(rowPosition, columnIndex, 0.0);
            dataTable.put(this.preferenceMatrix.column(columnIndex).getIndexAtPosition(rowPosition), columnIndex, this.preferenceMatrix.getAtRowPosition(rowPosition, columnIndex));
        }
        this.trainMatrix.reshape();
        this.testMatrix = new SequentialAccessSparseMatrix(this.preferenceMatrix.rowSize(), this.preferenceMatrix.columnSize(), dataTable);
    }

    static enum LOOCVType {
        LOOByUser,
        LOOByItem;

    }
}

