/*
 * Decompiled with CFR 0.152.
 */
package net.librec.ensemble;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.librec.common.LibrecException;
import net.librec.conf.Configuration;
import net.librec.data.DataModel;
import net.librec.data.model.TextDataModel;
import net.librec.data.splitter.KCVDataSplitter;
import net.librec.data.splitter.LOOCVDataSplitter;
import net.librec.job.RecommenderJob;
import net.librec.math.structure.MatrixEntry;
import net.librec.math.structure.SequentialAccessSparseMatrix;
import net.librec.recommender.Recommender;
import net.librec.recommender.RecommenderContext;
import net.librec.recommender.item.RecommendedItem;
import net.librec.recommender.item.RecommendedList;
import net.librec.similarity.PCCSimilarity;
import net.librec.util.DriverClassUtil;
import net.librec.util.FileUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Ensemble {
    public String configFile;
    public Configuration conf;
    public String algClass;
    public String data;
    public int numsOfAlg;
    public String isranking;
    public List<Double> weights;
    public List<Double> evaluationList;
    public List<String> namesOfAlg;
    public List<RecommendedList> recommendedItemListOfAlgs;
    public List<RecommendedList> recommendedItemListResult;
    public List<RecommendedItem> recommendedItemFinal;
    public List validationList;
    public List recommendedItemListFilter;
    public int topN;
    public DataModel dataModel;
    public List<Double> realRating;
    protected final Log LOG = LogFactory.getLog(RecommenderJob.class);

    public Ensemble(String configFile) throws Exception {
        this.configFile = configFile;
        this.weights = new ArrayList<Double>();
        this.evaluationList = new ArrayList<Double>();
        this.namesOfAlg = new ArrayList<String>();
        this.recommendedItemListOfAlgs = new ArrayList<RecommendedList>();
        this.recommendedItemListResult = new ArrayList<RecommendedList>();
        this.validationList = new ArrayList();
        this.recommendedItemListFilter = new ArrayList();
        this.recommendedItemFinal = new ArrayList<RecommendedItem>();
        this.realRating = new ArrayList<Double>();
        this.conf = this.configInfo(configFile);
        this.numsOfAlg = this.conf.getInt("rec.ensemble.numsOfAlg");
        this.isranking = this.conf.get("rec.recommender.isranking");
        this.topN = this.conf.getInt("rec.recommender.topN");
        this.algClass = this.conf.get("rec.recommender.class");
    }

    protected void trainModel() throws Exception {
        this.dataModel = this.dataModel(this.conf);
        this.trainDataRealRating(this.dataModel);
        for (int tempNums = this.numsOfAlg; tempNums > 0; --tempNums) {
            String algNum = String.valueOf(this.numsOfAlg - tempNums);
            double weightTemp = this.conf.getDouble("rec.ensemble.weight." + algNum);
            this.weights.add(weightTemp);
        }
    }

    protected Configuration configInfo(String sourceFile) throws LibrecException {
        Configuration conff = new Configuration();
        Configuration.Resource resource = new Configuration.Resource(sourceFile);
        conff.addResource(resource);
        return conff;
    }

    protected DataModel dataModel(Configuration conf) throws LibrecException {
        TextDataModel dataModel = new TextDataModel(conf);
        dataModel.buildDataModel();
        return dataModel;
    }

    protected Recommender recommender(String configFilePath, DataModel dataModel) throws Exception {
        Configuration conf = this.configInfo(configFilePath);
        RecommenderContext context = this.context(conf, dataModel);
        String algClass = conf.get("rec.recommender.fullClassName");
        Recommender newRecommender = this.newRecommemder(context, algClass);
        return newRecommender;
    }

    protected RecommenderContext context(Configuration conf, DataModel dataModel) throws LibrecException {
        RecommenderContext context = new RecommenderContext(conf, dataModel);
        PCCSimilarity similarity = new PCCSimilarity();
        similarity.buildSimilarityMatrix(dataModel);
        context.setSimilarity(similarity);
        return context;
    }

    protected Recommender newRecommemder(RecommenderContext context, String algClass) throws Exception {
        Object newAlg = Class.forName(algClass).newInstance();
        Recommender recommender = (Recommender)newAlg;
        recommender.setContext(context);
        recommender.train(context);
        return recommender;
    }

    protected List recommendedResult() {
        return this.recommendedItemFinal;
    }

    protected int getTotalItems() {
        return this.recommendedItemListOfAlgs.size();
    }

    protected int getNumsOfAlg() {
        return this.numsOfAlg;
    }

    protected void trainDataRealRating(DataModel dataModel) {
        SequentialAccessSparseMatrix trainMatrix = (SequentialAccessSparseMatrix)dataModel.getTrainDataSet();
        for (MatrixEntry trainMatrixEntry : trainMatrix) {
            double trainRealRating = trainMatrixEntry.get();
            this.realRating.add(trainRealRating);
        }
    }

    public void saveResult(List<RecommendedItem> recommendedList, Configuration confAlg, int tempNums, String resultType) throws LibrecException, IOException, ClassNotFoundException {
        if (recommendedList != null && recommendedList.size() > 0) {
            String algoSimpleName = DriverClassUtil.getDriverName(this.recommenderClass(confAlg));
            String outputPath = this.conf.get("dfs.result.dir") + "/ensemble/" + algoSimpleName + "-" + tempNums + "/" + resultType;
            if (null != this.dataModel && (this.dataModel.getDataSplitter() instanceof KCVDataSplitter || this.dataModel.getDataSplitter() instanceof LOOCVDataSplitter) && null != this.conf.getInt("data.splitter.cv.index")) {
                outputPath = outputPath + "/fold-" + String.valueOf(this.conf.getInt("data.splitter.cv.index"));
            }
            this.LOG.info("Result path is " + outputPath);
            StringBuilder sb = new StringBuilder();
            for (RecommendedItem recItem : recommendedList) {
                String userId = recItem.getUserId();
                String itemId = recItem.getItemId();
                String value = String.valueOf(recItem.getValue());
                sb.append(userId).append(",").append(itemId).append(",").append(value).append("\n");
            }
            String resultData = sb.toString();
            try {
                FileUtil.writeString(outputPath, resultData);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Class<? extends Recommender> recommenderClass(Configuration confAlg) throws ClassNotFoundException, IOException {
        return DriverClassUtil.getClass(confAlg.get("rec.recommender.class"));
    }

    protected List<Double> ensembelParameter() {
        return Collections.emptyList();
    }
}

