/*
 * Decompiled with CFR 0.152.
 */
package net.librec.ensemble;

import java.util.ArrayList;
import java.util.List;
import net.librec.common.LibrecException;
import net.librec.ensemble.Ensemble;
import net.librec.recommender.Recommender;
import net.librec.recommender.item.GenericRecommendedItem;
import net.librec.recommender.item.RecommendedItem;
import net.librec.recommender.item.RecommendedList;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

public class EnsembleLinear
extends Ensemble {
    protected List<Double> weightList;

    public EnsembleLinear(String configFile) throws Exception {
        super(configFile);
    }

    @Override
    protected void trainModel() throws Exception {
        super.trainModel();
        for (int tempNums = this.numsOfAlg; tempNums > 0; --tempNums) {
            String algNum = String.valueOf(this.numsOfAlg - tempNums);
            String configFilePath = this.conf.get("rec.recommender.location." + algNum);
            Recommender recommender = this.recommender(configFilePath, this.dataModel);
            RecommendedList resultRecommend = this.getRecommendedList(recommender);
            this.recommendedItemListOfAlgs.add(resultRecommend);
        }
    }

    protected RecommendedList getRecommendedList(Recommender recommender) throws LibrecException {
        RecommendedList recommendedList = Boolean.valueOf(this.isranking) != false ? recommender.recommendRank() : recommender.recommendRating(this.dataModel.getTestDataSet());
        return recommendedList;
    }

    protected List<Double> LeastSquaretrainModel() throws Exception {
        double[][] myList = this.getMList();
        double[] yList = this.getYList();
        Array2DRowRealMatrix coefficients = new Array2DRowRealMatrix(myList, false);
        DecompositionSolver solver = new LUDecomposition((RealMatrix)coefficients).getSolver();
        ArrayRealVector constants = new ArrayRealVector(yList, false);
        RealVector solution = solver.solve((RealVector)constants);
        this.weightList = this.getAlgorithmWeight(solution);
        return this.weightList;
    }

    protected double[][] getMList() {
        List OneAlgSum = this.getOneAlgSum();
        int n = this.getTotalItems();
        int k = this.getNumsOfAlg();
        double[][] myList = new double[k][k];
        for (int i = 0; i < k; ++i) {
            for (int j = 0; j < k; ++j) {
                if (i == 0) {
                    if (j == 0) {
                        myList[i][j] = n;
                        continue;
                    }
                    myList[i][j] = (Double)OneAlgSum.get(i);
                    continue;
                }
                myList[i][j] = j == 0 ? ((Double)OneAlgSum.get(i)).doubleValue() : this.getMutiAlgSum(i, j);
            }
        }
        return myList;
    }

    protected List getOneAlgSum() {
        List recommendedItemListTemp = this.recommendedItemListOfAlgs;
        ArrayList<Double> algSum = new ArrayList<Double>();
        for (int i = 0; i < recommendedItemListTemp.size(); ++i) {
            RecommendedList reList = (RecommendedList)recommendedItemListTemp.get(i);
            List list = (List)recommendedItemListTemp.get(i);
            double algSumTemp = 0.0;
            for (int j = 0; j < list.size(); ++j) {
            }
            algSum.add(algSumTemp);
        }
        return algSum;
    }

    protected double getMutiAlgSum(int i, int k) {
        List recommendedItemListTemp = this.recommendedItemListOfAlgs;
        List list1 = (List)recommendedItemListTemp.get(i);
        List listk = (List)recommendedItemListTemp.get(k);
        double algSumIK = 0.0;
        for (int j = 0; j < list1.size(); ++j) {
            GenericRecommendedItem tem1 = (GenericRecommendedItem)list1.get(j);
            GenericRecommendedItem tem2 = (GenericRecommendedItem)list1.get(j);
            algSumIK += tem1.getValue() * tem2.getValue();
        }
        return algSumIK;
    }

    protected double[] getYList() {
        int k = this.getNumsOfAlg();
        double[] yList = new double[k];
        List yReal = this.realRating;
        List recommendedItemListTemp = this.recommendedItemListOfAlgs;
        for (int i = 0; i < recommendedItemListTemp.size(); ++i) {
            List list = (List)recommendedItemListTemp.get(i);
            double algSumTemp = 0.0;
            if (i == 0) {
                algSumTemp += ((Double)yReal.get(i)).doubleValue();
            } else {
                for (int j = 0; j < list.size(); ++j) {
                    GenericRecommendedItem tem = (GenericRecommendedItem)list.get(j);
                    algSumTemp += tem.getValue() * (Double)yReal.get(j);
                }
            }
            yList[i] = algSumTemp;
        }
        return yList;
    }

    protected List getAlgorithmWeight(RealVector solution) throws Exception {
        ArrayList<Double> weightList = new ArrayList<Double>();
        Integer n = solution.getDimension();
        for (int i = 0; i < n; ++i) {
            weightList.add(solution.getEntry(i));
        }
        return weightList;
    }

    protected void getRecommandResultByLinear() throws Exception {
        ArrayList recommandResultByLinear = new ArrayList();
        List recommendedItemListTemp = this.recommendedItemListOfAlgs;
        for (int i = 0; i < recommendedItemListTemp.size(); ++i) {
            List list = (List)recommendedItemListTemp.get(i);
            for (int j = 0; j < list.size(); ++j) {
                Double weight = this.weightList.get(i);
                GenericRecommendedItem tem = (GenericRecommendedItem)list.get(j);
                tem.setValue(tem.getValue() * weight);
                list.set(j, tem);
            }
            this.recommendResultBlend(recommendedItemListTemp);
        }
    }

    protected void recommendResultBlend(List recommendedItemListTemp) throws Exception {
        int n = this.getTotalItems();
        for (int j = 0; j < n; ++j) {
            Double valueSum = 0.0;
            String userId = "";
            String itemId = "";
            for (int i = 0; i < recommendedItemListTemp.size(); ++i) {
                List list = (List)recommendedItemListTemp.get(i);
                GenericRecommendedItem tem = (GenericRecommendedItem)list.get(j);
                userId = tem.getUserId();
                itemId = tem.getItemId();
                valueSum = valueSum + tem.getValue();
            }
            GenericRecommendedItem genericObj = new GenericRecommendedItem(userId, itemId, valueSum);
            this.recommendedItemFinal.add(genericObj);
        }
    }

    protected void validationListFilter() {
        List validationListTem = this.validationList;
        List recommendedItemListTemp = this.recommendedItemListOfAlgs;
        for (int i = 0; i < recommendedItemListTemp.size(); ++i) {
            ArrayList<GenericRecommendedItem> recommendedItemListOne = new ArrayList<GenericRecommendedItem>();
            List list = (List)recommendedItemListTemp.get(i);
            for (int j = 0; j < list.size(); ++j) {
                GenericRecommendedItem tem = (GenericRecommendedItem)list.get(j);
                String userId = tem.getUserId();
                String itemId = tem.getItemId();
                for (int m = 0; m < validationListTem.size(); ++m) {
                    GenericRecommendedItem temp = (GenericRecommendedItem)validationListTem.get(m);
                    if (userId != temp.getUserId() || itemId != temp.getItemId()) continue;
                    recommendedItemListOne.add(temp);
                }
            }
            this.recommendedItemListFilter.add(recommendedItemListOne);
        }
    }

    public List<Double> ensembelWeight() {
        return this.weightList;
    }

    public List<RecommendedItem> getEnsembleRecommendedList() throws LibrecException {
        double weightedValue = 0.0;
        int userItemPairs = ((RecommendedList)this.recommendedItemListOfAlgs.get(0)).size();
        ArrayList<RecommendedItem> result = new ArrayList<RecommendedItem>();
        for (int k = 0; k < userItemPairs; ++k) {
            result.set(k, new GenericRecommendedItem("", "", 0.0));
        }
        for (int i = 0; i < this.recommendedItemListOfAlgs.size(); ++i) {
            List list = (List)this.recommendedItemListOfAlgs.get(i);
            for (int j = 0; j < list.size(); ++j) {
                RecommendedItem rating = (RecommendedItem)list.get(j);
                double value = rating.getValue();
                weightedValue = value * this.weightList.get(i);
                String userId = rating.getUserId();
                String itemId = rating.getItemId();
                GenericRecommendedItem men = new GenericRecommendedItem(userId, itemId, ((RecommendedItem)result.get(j)).getValue() + weightedValue);
                result.set(i, men);
            }
        }
        return result;
    }

    public void evaluate(List<RecommendedItem> recommender) throws LibrecException {
    }
}

