/*
 * Decompiled with CFR 0.152.
 */
package net.librec.ensemble;

import net.librec.conf.Configuration;
import net.librec.data.convertor.TextDataConvertor;
import net.librec.data.splitter.KCVDataSplitter;
import net.librec.data.splitter.RatioDataSplitter;
import net.librec.ensemble.Ensemble;
import net.librec.math.structure.SequentialAccessSparseMatrix;
import net.librec.recommender.RecommenderContext;

public class EnsembleStacking
extends Ensemble {
    public int fold = 5;
    public double ratio = 0.8;
    SequentialAccessSparseMatrix trainData;
    SequentialAccessSparseMatrix testData;
    SequentialAccessSparseMatrix[] trainSliceData;
    public String stacker;

    public EnsembleStacking(String configFile) throws Exception {
        super(configFile);
    }

    @Override
    protected void trainModel() throws Exception {
        super.trainModel();
        this.fold = Integer.parseInt(this.conf.get("data.splitter.cv.number"));
        this.ratio = Integer.parseInt(this.conf.get("data.splitter.trainset.ratio"));
        this.EnsembleStackModel();
    }

    protected void EnsembleStackModel() throws Exception {
        this.dataKFlodSpliter(this.fold, this.ratio);
        for (int numsOfAlg = this.numsOfAlg; numsOfAlg > 0; --numsOfAlg) {
            RecommenderContext context;
            String algNum = String.valueOf(this.numsOfAlg - numsOfAlg);
            String configFileForOneAlg = this.conf.get(algNum + ".rec.recommender.location");
            String algClass = (String)this.namesOfAlg.get(Integer.parseInt(algNum));
            for (int i = 1; i <= this.fold; ++i) {
                context = this.preTraining(configFileForOneAlg, "kcv", i);
            }
            if (numsOfAlg != 1) continue;
            context = this.preTraining(configFileForOneAlg, "ratio", 0);
            break;
        }
    }

    protected void dataKFlodSpliter(int kFold, double ratio) throws Exception {
        this.conf.set("inputDataPath", this.conf.get("dfs.data.dir") + this.conf.get("data.input.path"));
        TextDataConvertor convertor = new TextDataConvertor(new String[]{"user", "item", "rating"}, new String[]{"STRING", "STRING", "NUMERIC"}, this.conf.get("inputDataPath"), " ");
        convertor.processData();
        SequentialAccessSparseMatrix allData = convertor.getPreferenceMatrix();
        RatioDataSplitter ratioSplitter = new RatioDataSplitter();
        ratioSplitter.setPreferenceMatrix(allData);
        ratioSplitter.getRatioByRating(ratio);
        this.trainData = ratioSplitter.getTrainData();
        this.testData = ratioSplitter.getTestData();
        KCVDataSplitter kcvSplitter = new KCVDataSplitter();
        kcvSplitter.setPreferenceMatrix(this.trainData);
        kcvSplitter.splitData(kFold);
        this.trainSliceData = kcvSplitter.getAssignMatrixList().toArray(new SequentialAccessSparseMatrix[kFold]);
        System.out.println("trainsSlice cardinality:");
        for (int i = 0; i < this.trainSliceData.length; ++i) {
            System.out.println(this.trainSliceData[i].size());
        }
        System.out.println("train cardinality: " + this.trainData.size());
        System.out.println("test cardinality: " + this.testData.size());
    }

    protected RecommenderContext preTraining(String configFile, String splitterType, int iFold) throws Exception {
        Configuration confAlg = this.configInfo(configFile);
        double weightTemp = this.conf.getDouble("rec.ensemble.weight", 1.0);
        this.weights.add(weightTemp);
        String algClass = confAlg.get("rec.recommender.fullClassName");
        RecommenderContext context = this.context(confAlg, this.dataModel);
        return context;
    }

    protected void stackerModel(RecommenderContext context, String algClass) throws Exception {
    }
}

