/*
 * Decompiled with CFR 0.152.
 */
package net.librec.ensemble.tools;

public class LeastSquare {
    private double[] x;
    private double[] y;
    private double[] weight;
    private int n;
    private double[] coefficient;

    public LeastSquare(double[] x, double[] y, int n) {
        if (x == null || y == null || x.length < 2 || x.length != y.length || n < 2) {
            throw new IllegalArgumentException("IllegalArgumentException occurred.");
        }
        this.x = x;
        this.y = y;
        this.n = n;
        this.weight = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            this.weight[i] = 1.0;
        }
        this.compute();
    }

    public LeastSquare(double[] x, double[] y, double[] weight, int n) {
        if (x == null || y == null || weight == null || x.length < 2 || x.length != y.length || x.length != weight.length || n < 2) {
            throw new IllegalArgumentException("IllegalArgumentException occurred.");
        }
        this.x = x;
        this.y = y;
        this.n = n;
        this.weight = weight;
        this.compute();
    }

    public double[] getCoefficient() {
        return this.coefficient;
    }

    public double fit(double x) {
        if (this.coefficient == null) {
            return 0.0;
        }
        double sum2 = 0.0;
        for (int i = 0; i < this.coefficient.length; ++i) {
            sum2 += Math.pow(x, i) * this.coefficient[i];
        }
        return sum2;
    }

    public double solve(double y) {
        return this.solve(y, 1.0);
    }

    public double solve(double y, double startX) {
        double EPS = 1.0E-7;
        if (this.coefficient == null) {
            return 0.0;
        }
        double x1 = 0.0;
        double x2 = startX;
        while (Math.abs((x1 = x2) - (x2 = x1 - (this.fit(x1) - y) / this.calcReciprocal(x1))) > 1.0E-7) {
        }
        return x2;
    }

    private double calcReciprocal(double x) {
        if (this.coefficient == null) {
            return 0.0;
        }
        double sum2 = 0.0;
        for (int i = 1; i < this.coefficient.length; ++i) {
            sum2 += (double)i * Math.pow(x, i - 1) * this.coefficient[i];
        }
        return sum2;
    }

    private void compute() {
        if (this.x == null || this.y == null || this.x.length <= 1 || this.x.length != this.y.length || this.x.length < this.n || this.n < 2) {
            return;
        }
        double[] s = new double[(this.n - 1) * 2 + 1];
        for (int i = 0; i < s.length; ++i) {
            for (int j = 0; j < this.x.length; ++j) {
                int n = i;
                s[n] = s[n] + Math.pow(this.x[j], i) * this.weight[j];
            }
        }
        double[] b = new double[this.n];
        for (int i = 0; i < b.length; ++i) {
            for (int j = 0; j < this.x.length; ++j) {
                int n = i;
                b[n] = b[n] + Math.pow(this.x[j], i) * this.y[j] * this.weight[j];
            }
        }
        double[][] a = new double[this.n][this.n];
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                a[i][j] = s[i + j];
            }
        }
        this.coefficient = this.calcLinearEquation(a, b);
    }

    private double[] calcLinearEquation(double[][] a, double[] b) {
        if (a == null || b == null || a.length == 0 || a.length != b.length) {
            return null;
        }
        for (double[] x : a) {
            if (x != null && x.length == a.length) continue;
            return null;
        }
        int len = a.length - 1;
        double[] result = new double[a.length];
        if (len == 0) {
            result[0] = b[0] / a[0][0];
            return result;
        }
        double[][] aa = new double[len][len];
        double[] bb = new double[len];
        int posx = -1;
        int posy = -1;
        for (int i = 0; i <= len; ++i) {
            for (int j = 0; j <= len; ++j) {
                if (a[i][j] == 0.0) continue;
                posy = j;
                break;
            }
            if (posy == -1) continue;
            posx = i;
            break;
        }
        if (posx == -1) {
            return null;
        }
        int count = 0;
        for (int i = 0; i <= len; ++i) {
            if (i == posx) continue;
            bb[count] = b[i] * a[posx][posy] - b[posx] * a[i][posy];
            int count2 = 0;
            for (int j = 0; j <= len; ++j) {
                if (j == posy) continue;
                aa[count][count2] = a[i][j] * a[posx][posy] - a[posx][j] * a[i][posy];
                ++count2;
            }
            ++count;
        }
        double[] result2 = this.calcLinearEquation(aa, bb);
        double sum2 = b[posx];
        count = 0;
        for (int i = 0; i <= len; ++i) {
            if (i == posy) continue;
            sum2 -= a[posx][i] * result2[count];
            result[i] = result2[count];
            ++count;
        }
        result[posy] = sum2 / a[posx][posy];
        return result;
    }

    public static void main(String[] args) {
        LeastSquare eastSquareMethod = new LeastSquare(new double[]{0.5, 1.0, 1.5, 2.0, 2.5, 3.0}, new double[]{1.75, 2.45, 3.81, 4.8, 7.0, 8.6}, 3);
        System.out.println(eastSquareMethod.fit(4.0));
        LeastSquare eastSquareMethod2 = new LeastSquare(new double[]{0.5, 1.0, 1.5, 2.0, 2.5, 3.0}, new double[]{1.75, 2.45, 3.81, 4.8, 7.0, 8.6}, 2);
        System.out.println(eastSquareMethod2.solve(100.0));
    }
}

