/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval;

import java.util.Map;
import net.librec.conf.Configuration;
import net.librec.data.DataModel;
import net.librec.eval.EvalContext;
import net.librec.eval.RecommenderEvaluator;
import net.librec.math.structure.SymmMatrix;
import net.librec.recommender.RecommenderContext;
import net.librec.recommender.item.RecommendedList;
import net.librec.similarity.RecommenderSimilarity;

public abstract class AbstractRecommenderEvaluator
implements RecommenderEvaluator {
    protected DataModel dataModel;
    protected int topN;
    protected Configuration conf;
    protected SymmMatrix similarityMatrix;
    protected Map<String, RecommenderSimilarity> similarities;

    @Override
    public double evaluate(RecommenderContext context, RecommendedList groundTruthList, RecommendedList recommendedList) {
        this.conf = context.getConf();
        String[] similarityKeys = this.conf.getStrings("rec.recommender.similarities");
        if (similarityKeys != null && similarityKeys.length > 0) {
            this.similarityMatrix = context.getSimilarity().getSimilarityMatrix();
            this.similarities = context.getSimilarities();
        }
        return this.evaluate(groundTruthList, recommendedList);
    }

    @Override
    public double evaluate(EvalContext evalContext) {
        this.conf = evalContext.getConf();
        if (evalContext.getSimilarityMatrix() != null) {
            this.similarityMatrix = evalContext.getSimilarityMatrix();
        }
        if (evalContext.getSimilarities() != null) {
            this.similarities = evalContext.getSimilarities();
        }
        return this.evaluate(evalContext.getGroundTruthList(), evalContext.getRecommendedList());
    }

    public abstract double evaluate(RecommendedList var1, RecommendedList var2);

    public double evaluateIndependently(Configuration conf, RecommendedList groundTruthList, RecommendedList recommendedList) {
        this.conf = conf;
        this.topN = conf != null ? conf.getInt("rec.recommender.ranking.topn", -1) : -1;
        RecommendedList[] lists = groundTruthList.joinTransform(recommendedList, this.topN);
        return this.evaluate(lists[0], lists[1]);
    }

    @Override
    public void setTopN(int topN) {
        this.topN = topN;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setDataModel(DataModel dataModel) {
        this.dataModel = dataModel;
    }

    @Override
    public DataModel getDataModel() {
        return this.dataModel;
    }
}

