/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval;

import java.util.ArrayList;
import java.util.List;
import net.librec.eval.RecommenderEvaluator;
import net.librec.eval.fairness.CStatisticalParityEvaluator;
import net.librec.eval.fairness.DiscountedProportionalCFairnessEvaluator;
import net.librec.eval.fairness.DiscountedProportionalPFairnessEvaluator;
import net.librec.eval.fairness.MiscalibrationEvaluator;
import net.librec.eval.fairness.NonParityUnfairnessEvaluator;
import net.librec.eval.fairness.OverestimationUnfairnessEvaluator;
import net.librec.eval.fairness.PPercentRuleEvaluator;
import net.librec.eval.fairness.PStatisticalParityEvaluator;
import net.librec.eval.fairness.UnderestimationUnfairnessEvaluator;
import net.librec.eval.fairness.ValueUnfairnessEvaluator;
import net.librec.eval.ranking.AUCEvaluator;
import net.librec.eval.ranking.AveragePrecisionEvaluator;
import net.librec.eval.ranking.DiversityByFeaturesEvaluator;
import net.librec.eval.ranking.DiversityEvaluator;
import net.librec.eval.ranking.EntropyEvaluator;
import net.librec.eval.ranking.GiniIndexEvaluator;
import net.librec.eval.ranking.IdealDCGEvaluator;
import net.librec.eval.ranking.ItemCoverageEvaluator;
import net.librec.eval.ranking.NormalizedDCGEvaluator;
import net.librec.eval.ranking.NoveltyEvaluator;
import net.librec.eval.ranking.PrecisionEvaluator;
import net.librec.eval.ranking.RecallEvaluator;
import net.librec.eval.ranking.ReciprocalRankEvaluator;
import net.librec.eval.rating.MAEEvaluator;
import net.librec.eval.rating.MPEEvaluator;
import net.librec.eval.rating.MSEEvaluator;
import net.librec.eval.rating.RMSEEvaluator;

public enum Measure {
    AUC(AUCEvaluator.class),
    AP(AveragePrecisionEvaluator.class),
    IDCG(IdealDCGEvaluator.class),
    NDCG(NormalizedDCGEvaluator.class),
    PRECISION(PrecisionEvaluator.class),
    RECALL(RecallEvaluator.class),
    RR(ReciprocalRankEvaluator.class),
    Novelty(NoveltyEvaluator.class),
    Entropy(EntropyEvaluator.class),
    GiniIndex(GiniIndexEvaluator.class),
    Diversity(DiversityEvaluator.class),
    FeatureDiversity(DiversityByFeaturesEvaluator.class),
    ICOV(ItemCoverageEvaluator.class),
    RMSE(RMSEEvaluator.class),
    MSE(MSEEvaluator.class),
    MAE(MAEEvaluator.class),
    MPE(MPEEvaluator.class),
    PSP(PStatisticalParityEvaluator.class),
    CSP(CStatisticalParityEvaluator.class),
    PPR(PPercentRuleEvaluator.class),
    MISCALIB(MiscalibrationEvaluator.class),
    DPCF(DiscountedProportionalCFairnessEvaluator.class),
    DPPF(DiscountedProportionalPFairnessEvaluator.class),
    NONPAR(NonParityUnfairnessEvaluator.class),
    VALUNFAIRNESS(ValueUnfairnessEvaluator.class),
    ABSUNFAIRNESS(ValueUnfairnessEvaluator.class),
    OVERESTIMATE(OverestimationUnfairnessEvaluator.class),
    UNDERESTIMATE(UnderestimationUnfairnessEvaluator.class);

    private Class<? extends RecommenderEvaluator> evaluatorClass;

    private Measure(Class<? extends RecommenderEvaluator> evaluatorClass) {
        this.evaluatorClass = evaluatorClass;
    }

    public static List<MeasureValue> getMeasureEnumList(boolean isRanking, int topN) {
        if (isRanking) {
            return Measure.getRankingEnumList(topN);
        }
        return Measure.getRatingEnumList();
    }

    private static List<MeasureValue> getRankingEnumList(int topN) {
        ArrayList<MeasureValue> rankingEnumList = new ArrayList<MeasureValue>(10);
        if (topN <= 0) {
            rankingEnumList.add(new MeasureValue(PRECISION, 5));
            rankingEnumList.add(new MeasureValue(PRECISION, 10));
            rankingEnumList.add(new MeasureValue(RECALL, 5));
            rankingEnumList.add(new MeasureValue(RECALL, 10));
            rankingEnumList.add(new MeasureValue(AUC, 10));
            rankingEnumList.add(new MeasureValue(AP, 10));
            rankingEnumList.add(new MeasureValue(NDCG, 10));
            rankingEnumList.add(new MeasureValue(RR, 10));
            rankingEnumList.add(new MeasureValue(Diversity, 10));
            rankingEnumList.add(new MeasureValue(FeatureDiversity, 10));
            rankingEnumList.add(new MeasureValue(RR, 10));
            rankingEnumList.add(new MeasureValue(Novelty, 10));
            rankingEnumList.add(new MeasureValue(Entropy, 10));
            rankingEnumList.add(new MeasureValue(GiniIndex, 10));
            rankingEnumList.add(new MeasureValue(ICOV, 10));
            rankingEnumList.add(new MeasureValue(PSP, 10));
            rankingEnumList.add(new MeasureValue(CSP, 10));
            rankingEnumList.add(new MeasureValue(PPR, 10));
            rankingEnumList.add(new MeasureValue(MISCALIB, 10));
            rankingEnumList.add(new MeasureValue(DPCF, 10));
            rankingEnumList.add(new MeasureValue(DPPF, 10));
            rankingEnumList.add(new MeasureValue(NONPAR, 10));
        } else {
            rankingEnumList.add(new MeasureValue(PRECISION, topN));
            rankingEnumList.add(new MeasureValue(RECALL, topN));
            rankingEnumList.add(new MeasureValue(AUC, topN));
            rankingEnumList.add(new MeasureValue(AP, topN));
            rankingEnumList.add(new MeasureValue(NDCG, topN));
            rankingEnumList.add(new MeasureValue(RR, topN));
            rankingEnumList.add(new MeasureValue(Diversity, topN));
            rankingEnumList.add(new MeasureValue(FeatureDiversity, topN));
            rankingEnumList.add(new MeasureValue(Novelty, topN));
            rankingEnumList.add(new MeasureValue(Entropy, topN));
            rankingEnumList.add(new MeasureValue(GiniIndex, topN));
            rankingEnumList.add(new MeasureValue(ICOV, topN));
            rankingEnumList.add(new MeasureValue(PSP, topN));
            rankingEnumList.add(new MeasureValue(CSP, topN));
            rankingEnumList.add(new MeasureValue(PPR, topN));
            rankingEnumList.add(new MeasureValue(MISCALIB, topN));
            rankingEnumList.add(new MeasureValue(DPCF, topN));
            rankingEnumList.add(new MeasureValue(DPPF, topN));
            rankingEnumList.add(new MeasureValue(NONPAR, topN));
        }
        return rankingEnumList;
    }

    private static List<MeasureValue> getRatingEnumList() {
        ArrayList<MeasureValue> ratingEnumList = new ArrayList<MeasureValue>(4);
        ratingEnumList.add(new MeasureValue(RMSE));
        ratingEnumList.add(new MeasureValue(MSE));
        ratingEnumList.add(new MeasureValue(MAE));
        ratingEnumList.add(new MeasureValue(MPE));
        ratingEnumList.add(new MeasureValue(VALUNFAIRNESS));
        ratingEnumList.add(new MeasureValue(ABSUNFAIRNESS));
        ratingEnumList.add(new MeasureValue(OVERESTIMATE));
        ratingEnumList.add(new MeasureValue(UNDERESTIMATE));
        return ratingEnumList;
    }

    public Class<? extends RecommenderEvaluator> getEvaluatorClass() {
        return this.evaluatorClass;
    }

    public static class MeasureValue {
        private Measure measure;
        private Integer topN;

        public MeasureValue(Measure measure) {
            this.measure = measure;
        }

        public MeasureValue(Measure measure, Integer topN) {
            this.measure = measure;
            this.topN = topN;
        }

        public Measure getMeasure() {
            return this.measure;
        }

        public void setMeasure(Measure measure) {
            this.measure = measure;
        }

        public Integer getTopN() {
            return this.topN;
        }

        public void setTopN(Integer topN) {
            this.topN = topN;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.measure == null ? 0 : this.measure.hashCode());
            result = 31 * result + (this.topN == null ? 0 : this.topN.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MeasureValue other = (MeasureValue)obj;
            if (this.measure != other.measure) {
                return false;
            }
            return !(this.topN == null ? other.topN != null : !this.topN.equals(other.topN));
        }
    }
}

