/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.fairness;

import com.google.common.collect.BiMap;
import java.util.List;
import java.util.Set;
import net.librec.data.DataModel;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.math.structure.SequentialAccessSparseMatrix;
import net.librec.recommender.item.KeyValue;
import net.librec.recommender.item.RecommendedList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CStatisticalParityEvaluator
extends AbstractRecommenderEvaluator {
    protected final Log LOG = LogFactory.getLog(this.getClass());
    protected SequentialAccessSparseMatrix userFeatureMatrix;

    @Override
    public void setDataModel(DataModel datamodel) {
        super.setDataModel(datamodel);
    }

    @Override
    public double evaluate(RecommendedList groundTruthList, RecommendedList recommendedList) {
        this.userFeatureMatrix = this.getDataModel().getFeatureAppender().getUserFeatures();
        BiMap<String, Integer> featureIdMapping = this.getDataModel().getFeatureAppender().getUserFeatureMap();
        int numUsers = groundTruthList.size();
        int numFeatures = this.userFeatureMatrix.columnSize();
        int proAttId = 0;
        String protectedAttribute = "";
        if (this.conf == null || !StringUtils.isNotBlank(this.conf.get("data.protected.feature"))) {
            return 0.0;
        }
        protectedAttribute = this.conf.get("data.protected.feature");
        proAttId = (Integer)featureIdMapping.get(protectedAttribute);
        double protectedSize = 0.0;
        double unprotectedSize = 0.0;
        double totalPrecisionPro = 0.0;
        double totalPrecisionUnpro = 0.0;
        for (int userID = 0; userID < numUsers; ++userID) {
            double userPrecision = 0.0;
            Set<Integer> testSetByUser = groundTruthList.getKeySetByContext(userID);
            if (testSetByUser.size() <= 0) continue;
            List<KeyValue<Integer, Double>> recommendListByUser = recommendedList.getKeyValueListByContext(userID);
            int numHits = 0;
            int topK = this.topN <= recommendListByUser.size() ? this.topN : recommendListByUser.size();
            for (int indexOfItem = 0; indexOfItem < topK; ++indexOfItem) {
                int itemID = recommendListByUser.get(indexOfItem).getKey();
                if (!testSetByUser.contains(itemID)) continue;
                ++numHits;
            }
            userPrecision = (double)numHits / ((double)this.topN + 0.0);
            if (this.userFeatureMatrix.get(userID, proAttId) == 1.0) {
                totalPrecisionPro += userPrecision;
                protectedSize += 1.0;
                continue;
            }
            totalPrecisionUnpro += userPrecision;
            unprotectedSize += 1.0;
        }
        double res = 0.0;
        if (protectedSize == 0.0 && unprotectedSize == 0.0) {
            res = 0.0;
        }
        if (protectedSize == 0.0 && unprotectedSize > 0.0) {
            res = -1.0 * (totalPrecisionUnpro / unprotectedSize);
        }
        if (protectedSize > 0.0 && unprotectedSize == 0.0) {
            res = totalPrecisionPro / protectedSize * 1.0;
        }
        if (protectedSize > 0.0 && unprotectedSize > 0.0) {
            res = (totalPrecisionPro / protectedSize - totalPrecisionUnpro / unprotectedSize) * 1.0;
        }
        return res;
    }
}

