/*
 * Decompiled with CFR 0.152.
 */
package net.librec.eval.fairness;

import com.google.common.collect.BiMap;
import java.util.List;
import java.util.Set;
import net.librec.eval.AbstractRecommenderEvaluator;
import net.librec.math.algorithm.Maths;
import net.librec.math.structure.SequentialAccessSparseMatrix;
import net.librec.recommender.item.KeyValue;
import net.librec.recommender.item.RecommendedList;
import org.apache.commons.lang3.StringUtils;

public class DiscountedProportionalPFairnessEvaluator
extends AbstractRecommenderEvaluator {
    protected SequentialAccessSparseMatrix itemFeatureMatrix;

    @Override
    public double evaluate(RecommendedList groundTruthList, RecommendedList recommendedList) {
        this.itemFeatureMatrix = this.getDataModel().getFeatureAppender().getItemFeatures();
        BiMap<String, Integer> featureIdMapping = this.getDataModel().getFeatureAppender().getItemFeatureMap();
        double minUtility = 1.0 / Maths.log(this.topN + 1, 2);
        int numUsers = groundTruthList.size();
        int numFeatures = this.itemFeatureMatrix.columnSize();
        int numItems = this.itemFeatureMatrix.rowSize();
        int protectedId = 0;
        String protectedAttribute = "";
        if (this.conf == null || !StringUtils.isNotBlank(this.conf.get("data.protected.feature"))) {
            return 0.0;
        }
        protectedAttribute = this.conf.get("data.protected.feature");
        protectedId = (Integer)featureIdMapping.get(protectedAttribute);
        double proDCG = 0.0;
        double unproDCG = 0.0;
        for (int userID = 0; userID < numUsers; ++userID) {
            Set<Integer> testSetByUser = groundTruthList.getKeySetByContext(userID);
            if (testSetByUser.size() <= 0) continue;
            double dcg = 0.0;
            List<KeyValue<Integer, Double>> recommendListByUser = recommendedList.getKeyValueListByContext(userID);
            int topK = this.topN <= recommendListByUser.size() ? this.topN : recommendListByUser.size();
            for (int indexOfItem = 0; indexOfItem < topK; ++indexOfItem) {
                int itemID = recommendListByUser.get(indexOfItem).getKey();
                if (!testSetByUser.contains(itemID)) continue;
                int rank = indexOfItem + 1;
                dcg = 1.0 / Maths.log(rank + 1, 2);
                if (this.itemFeatureMatrix.get(itemID, protectedId) == 1.0) {
                    proDCG += dcg;
                    continue;
                }
                unproDCG += dcg;
            }
        }
        double sumDCG = 0.0;
        if (proDCG == 0.0) {
            proDCG = minUtility;
        }
        if (unproDCG == 0.0) {
            unproDCG = minUtility;
        }
        sumDCG = proDCG + unproDCG;
        double dpf = 0.0;
        dpf = Maths.log(proDCG / sumDCG, 2) + Maths.log(unproDCG / sumDCG, 2);
        return dpf;
    }
}

